/*
 * ChooseHighlightOrKlaxonPanel.java
 *
 * Created on June 13, 2003, 12:18 PM
 */

package cern.laser.guiplatform.windows.alarms;

import javax.swing.JPanel;

import cern.laser.guiplatform.alarms.AlarmConstants;

/**
 *
 * @author  pawlowsk
 */
public class ChooseHighlightOrKlaxonPanel extends JPanel {
    
    /** Creates new form ChooseHighlightOrKlaxonPanel */
    public ChooseHighlightOrKlaxonPanel() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        buttonPanel = new javax.swing.JPanel();
        highlightPanel = new javax.swing.JPanel();
        highlightRadioButton = new javax.swing.JRadioButton();
        highlightLabel = new javax.swing.JLabel();
        klaxonPanel = new javax.swing.JPanel();
        klaxonRadioButton = new javax.swing.JRadioButton();
        klaxonLabel = new javax.swing.JLabel();
        highlightAndKlaxonPanel = new javax.swing.JPanel();
        highKlaxonRadioButton = new javax.swing.JRadioButton();
        highKlaxonLabel = new javax.swing.JLabel();
        titlePanel = new javax.swing.JPanel();
        titleLabel = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        buttonPanel.setLayout(new java.awt.GridBagLayout());

        highlightPanel.setLayout(new java.awt.BorderLayout());

        highlightPanel.setPreferredSize(new java.awt.Dimension(245, 60));
        highlightRadioButton.setSelected(true);
        highlightRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                highlightRadioButtonActionPerformed(evt);
            }
        });

        highlightPanel.add(highlightRadioButton, java.awt.BorderLayout.WEST);

        highlightLabel.setText(java.util.ResourceBundle.getBundle("cern/laser/guiplatform/windows/alarms/Bundle").getString("LBL_Alarm_highlited_only"));
        highlightPanel.add(highlightLabel, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 12, 3, 14);
        buttonPanel.add(highlightPanel, gridBagConstraints);

        klaxonPanel.setLayout(new java.awt.BorderLayout());

        klaxonPanel.setPreferredSize(new java.awt.Dimension(245, 60));
        klaxonRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                klaxonRadioButtonActionPerformed(evt);
            }
        });

        klaxonPanel.add(klaxonRadioButton, java.awt.BorderLayout.WEST);

        klaxonLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cern/laser/guiplatform/images/klaxon.png")));
        klaxonLabel.setText(java.util.ResourceBundle.getBundle("cern/laser/guiplatform/windows/alarms/Bundle").getString("LBL_Alarm_klaxon_only"));
        klaxonLabel.setIconTextGap(10);
        klaxonLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        klaxonPanel.add(klaxonLabel, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 12, 3, 14);
        buttonPanel.add(klaxonPanel, gridBagConstraints);

        highlightAndKlaxonPanel.setLayout(new java.awt.BorderLayout());

        highlightAndKlaxonPanel.setPreferredSize(new java.awt.Dimension(245, 60));
        highKlaxonRadioButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                highKlaxonRadioButtonActionPerformed(evt);
            }
        });

        highlightAndKlaxonPanel.add(highKlaxonRadioButton, java.awt.BorderLayout.WEST);

        highKlaxonLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/cern/laser/guiplatform/images/klaxon.png")));
        highKlaxonLabel.setText(java.util.ResourceBundle.getBundle("cern/laser/guiplatform/windows/alarms/Bundle").getString("LBL_Alarm_highlighted_and_klaxon"));
        highKlaxonLabel.setIconTextGap(10);
        highKlaxonLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        highlightAndKlaxonPanel.add(highKlaxonLabel, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(2, 12, 8, 14);
        buttonPanel.add(highlightAndKlaxonPanel, gridBagConstraints);

        add(buttonPanel, java.awt.BorderLayout.CENTER);

        titleLabel.setText("When alarm arrives");
        titlePanel.add(titleLabel);

        add(titlePanel, java.awt.BorderLayout.NORTH);

    }//GEN-END:initComponents

    private void highKlaxonRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_highKlaxonRadioButtonActionPerformed
        // Add your handling code here:
        highlightRadioButton.setSelected(false);
        klaxonRadioButton.setSelected(false);
    }//GEN-LAST:event_highKlaxonRadioButtonActionPerformed

    private void klaxonRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_klaxonRadioButtonActionPerformed
        // Add your handling code here:
        highKlaxonRadioButton.setSelected(false);
        highlightRadioButton.setSelected(false);
    }//GEN-LAST:event_klaxonRadioButtonActionPerformed

    private void highlightRadioButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_highlightRadioButtonActionPerformed
        // Add your handling code here:
        highKlaxonRadioButton.setSelected(false);
        klaxonRadioButton.setSelected(false);
    }//GEN-LAST:event_highlightRadioButtonActionPerformed
   
    /**
     * return int (AlarmConstants.HIGHLIGHTED_AND_KLAXON, etc, 
     * This indicates whether alarm should be only highlighted or should have 
     * klason or both
     */ 
    public int getHighlightedOrKlaxon() {
        if ( highKlaxonRadioButton.isSelected() )   // highlight and klaxon
           return AlarmConstants.HIGHLIGHTED_AND_KLAXON;
        else if ( klaxonRadioButton.isSelected() )
            return AlarmConstants.KLAXON_ONLY;

           return AlarmConstants.HIGHLIGHTED_ONLY; 
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JLabel highKlaxonLabel;
    private javax.swing.JRadioButton highKlaxonRadioButton;
    private javax.swing.JPanel highlightAndKlaxonPanel;
    private javax.swing.JLabel highlightLabel;
    private javax.swing.JPanel highlightPanel;
    private javax.swing.JRadioButton highlightRadioButton;
    private javax.swing.JLabel klaxonLabel;
    private javax.swing.JPanel klaxonPanel;
    private javax.swing.JRadioButton klaxonRadioButton;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JPanel titlePanel;
    // End of variables declaration//GEN-END:variables
    
}
