package cern.laser.guiplatform.windows.alarms;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

import cern.laser.client.data.Category;
import cern.laser.guiplatform.alarms.AlarmBean;
import cern.laser.guiplatform.util.LabelValueBean;
import cern.laser.guiplatform.util.LogFactory;

// As needed:
/*
import java.io.*;
import java.net.*;
import org.openide.ErrorManager;
import org.openide.actions.*;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.*;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.*;
 */

/** An openable window available to the IDE's window manager.
 *
 * @author pawlowsk
 */
public class AlarmDetailsPanel extends TopComponent /* or CloneableTopComponent */ {
    
    // REMEMBER: You should have a public default constructor!
    // This is for externalization. If you have a nondefault
    // constructor for normal creation of the component, leave
    // in a default constructor that will put the component into
    // a consistent but unconfigured state, and make sure readExternal
    // initializes it properly. Or, be creative with writeReplace().
    public AlarmDetailsPanel(AlarmBean alarm) {
        initComponents();
        setCloseOperation(CLOSE_LAST); // or CLOSE_EACH
        // Display name of this window (not needed if you use the DataObject constructor):
        setName(NbBundle.getMessage(AlarmDetailsPanel.class, 
                    "LBL_ALARM_DETAILS_PANEL_component_name"));
        // You may set the icon, but often it is better to set the icon for an associated mode instead:
        // setIcon(Utilities.loadImage("cern/laser/guiplatform/windows/alarms/AlarmDetailsPanelIcon.gif", true));
        // Use the Component Inspector to set tool-tip text. This will be saved
        // automatically. Other JComponent properties you may need to save yuorself.
        // At any time you can affect the node selection:
        // setActivatedNodes(new Node[] {...});


        putClientProperty("PersistenceType", "Never");
        putClientProperty("TabPolicy", "HideWhenAlone");

        this.alarm = alarm;
        postInitComponents();
    }
    
    /*
    public HelpCtx getHelpCtx() {
        return new HelpCtx(AlarmDetailsPanel.class);
    }
     */
    
    /*
    // If you are using CloneableTopComponent, probably you should override:
    protected CloneableTopComponent createClonedObject() {
        return new AlarmDetailsPanel();
    }
    protected boolean closeLast() {
        // You might want to prompt the user first and maybe return false:
        return true;
    }
     */
    
    // APPEARANCE
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        headerScrollPane = new javax.swing.JScrollPane();
        headerPanel = new javax.swing.JPanel();
        systemNameLabel = new javax.swing.JLabel();
        systemNameValLabel = new javax.swing.JLabel();
        identifierLabel = new javax.swing.JLabel();
        identifierValLabel = new javax.swing.JLabel();
        probDescLabel = new javax.swing.JLabel();
        probDescValLabel = new javax.swing.JLabel();
        buttonPanel = new javax.swing.JPanel();
        allFieldsButton = new javax.swing.JButton();
        closeButton = new javax.swing.JButton();
        helpButton = new javax.swing.JButton();
        middlePanel = new javax.swing.JPanel();
        dynamicFieldsScrollPane = new javax.swing.JScrollPane();
        dynamicFieldsTable = new javax.swing.JTable();
        staticFieldsScrollPane = new javax.swing.JScrollPane();
        staticFieldsTable = new javax.swing.JTable();
        categoryFieldsScrollPane = new javax.swing.JScrollPane();
        categoryFieldsTable = new javax.swing.JTable();

        setLayout(new java.awt.BorderLayout());

        headerPanel.setLayout(new java.awt.GridBagLayout());

        headerPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.LOWERED));
        systemNameLabel.setText("System Name:");
        systemNameLabel.setPreferredSize(null);
        systemNameLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 8, 0, 0);
        headerPanel.add(systemNameLabel, gridBagConstraints);

        systemNameValLabel.setText("SPS_MSE_SEPTA ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 10, 0, 5);
        headerPanel.add(systemNameValLabel, gridBagConstraints);

        identifierLabel.setText("Idetifier:");
        identifierLabel.setPreferredSize(null);
        identifierLabel.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 0, 0);
        headerPanel.add(identifierLabel, gridBagConstraints);

        identifierValLabel.setText("LSS6f");
        identifierValLabel.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 5);
        headerPanel.add(identifierValLabel, gridBagConstraints);

        probDescLabel.setText("Problem Description:");
        probDescLabel.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 8, 3, 0);
        headerPanel.add(probDescLabel, gridBagConstraints);

        probDescValLabel.setText("This is problem description");
        probDescValLabel.setPreferredSize(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 3, 4);
        headerPanel.add(probDescValLabel, gridBagConstraints);

        headerScrollPane.setViewportView(headerPanel);

        add(headerScrollPane, java.awt.BorderLayout.NORTH);

        allFieldsButton.setText("Not Empty Fields");
        allFieldsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                allFieldsButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(allFieldsButton);

        closeButton.setText("Close");
        closeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                closeButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(closeButton);

        helpButton.setText("Help");
        helpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(helpButton);

        add(buttonPanel, java.awt.BorderLayout.SOUTH);

        middlePanel.setLayout(new java.awt.GridLayout(3, 0));

        dynamicFieldsScrollPane.setBorder(new javax.swing.border.TitledBorder("Dynamic fileds"));
        dynamicFieldsScrollPane.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                dynamicFieldsScrollPaneComponentResized(evt);
            }
        });

        dynamicFieldsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null},
                {null, null},
                {null, null},
                {null, null}
            },
            new String [] {
                "Title 1", "Title 2"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        dynamicFieldsTable.setPreferredSize(null);
        //dynamicFieldsTable.setTableHeader(null);
        dynamicFieldsScrollPane.setViewportView(dynamicFieldsTable);

        middlePanel.add(dynamicFieldsScrollPane);

        staticFieldsScrollPane.setBorder(new javax.swing.border.TitledBorder("Static fields"));
        staticFieldsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null},
                {null, null},
                {null, null},
                {null, null}
            },
            new String [] {
                "Title 1", "Title 2"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        staticFieldsTable.setPreferredSize(null);
        //staticFieldsTable.setTableHeader(null);
        staticFieldsScrollPane.setViewportView(staticFieldsTable);

        middlePanel.add(staticFieldsScrollPane);

        categoryFieldsScrollPane.setBorder(new javax.swing.border.TitledBorder("Alarm belongs to these categories"));
        categoryFieldsTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null},
                {null, null}
            },
            new String [] {
                "Category Name", "Category Description"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        categoryFieldsScrollPane.setViewportView(categoryFieldsTable);

        middlePanel.add(categoryFieldsScrollPane);

        add(middlePanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void helpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_helpButtonActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_helpButtonActionPerformed

    private void allFieldsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_allFieldsButtonActionPerformed
        // Add your handling code here:
        
        if ( allFields ) {
            allFieldsButton.setText("All Fields");
            allFields = false;
            /*
            AlarmPropertiesModel staticPropModel = 
                new AlarmPropertiesModel(alarm.getStaticInfo(allFields));
            staticFieldsTable.setModel(staticPropModel);
            initColumnSizes(staticFieldsTable, 
                        (AlarmPropertiesModel) staticFieldsTable.getModel());
            setAutoResizeMode(staticFieldsTable, staticFieldsScrollPane);
            */
        } else {
            allFieldsButton.setText("Not Empty Fields");
            allFields = true;
            /*
            AlarmPropertiesModel staticPropModel = 
                new AlarmPropertiesModel(alarm.getStaticInfo(allFields));
            staticFieldsTable.setModel(staticPropModel);
            initColumnSizes(staticFieldsTable, 
                        (AlarmPropertiesModel) staticFieldsTable.getModel());
            setAutoResizeMode(staticFieldsTable, staticFieldsScrollPane);
            */
        }
        setAllTableModels();


    }//GEN-LAST:event_allFieldsButtonActionPerformed

    private void closeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_closeButtonActionPerformed
        // Add your handling code here:
        close();
    }//GEN-LAST:event_closeButtonActionPerformed

    /** this method add scroll panes to tables if needed */
    private void dynamicFieldsScrollPaneComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_dynamicFieldsScrollPaneComponentResized
        // Add your handling code here:

        setAutoResizeMode(dynamicFieldsTable, dynamicFieldsScrollPane);
        setAutoResizeMode(staticFieldsTable, staticFieldsScrollPane);
        setAutoResizeMode(categoryFieldsTable, categoryFieldsScrollPane);


    }//GEN-LAST:event_dynamicFieldsScrollPaneComponentResized
    
    /**
     * This method sets appropriate autorezise mode for table and scrollPane
     * @param table
     * @pram scrollPane
     */
    private void setAutoResizeMode(JTable table, JScrollPane scrollPane) {
        Dimension scrollDim = scrollPane.getSize();
        Dimension tablePrefDim = table.getPreferredSize();
        
        if ( scrollDim.width >= tablePrefDim.width ) 
            table.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        else
            table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
    }
   

    /**
     * This method updates panel using new alarm
     * @param alarm
     */
    public void updatePanel(AlarmBean _alarm) {
        this.alarm = _alarm;
        allFields = true;
        systemNameValLabel.setText(alarm.getSystemName());
        identifierValLabel.setText(alarm.getIdentifier());
        probDescValLabel.setText(alarm.getProblemDescription());
        setAllTableModels(); 
        
    }

    /** post init components */
    private void postInitComponents() {
        //systemNameValLabel.setText(alarm.getFaultFamily() + " " +
        //        alarm.getFaultMember());

        probDescValLabel.setText(alarm.getProblemDescription());
        systemNameValLabel.setText(alarm.getSystemName());
        identifierValLabel.setText(alarm.getIdentifier());


        dynamicFieldsTable.setTableHeader(null);
        staticFieldsTable.setTableHeader(null);
        setAllTableModels();
        /*
        AlarmPropertiesModel dynPropModel = 
            new AlarmPropertiesModel(alarm.getDynamicInfo(allFields));
        dynamicFieldsTable.setModel(dynPropModel);
        
        initColumnSizes(dynamicFieldsTable, 
                        (AlarmPropertiesModel) dynamicFieldsTable.getModel());
        setAutoResizeMode(dynamicFieldsTable, dynamicFieldsScrollPane);
        
        AlarmPropertiesModel staticPropModel = 
            new AlarmPropertiesModel(alarm.getStaticInfo(allFields));
        staticFieldsTable.setModel(staticPropModel);
        initColumnSizes(staticFieldsTable, 
                        (AlarmPropertiesModel) staticFieldsTable.getModel());
        setAutoResizeMode(staticFieldsTable, staticFieldsScrollPane);

        // prepare jtable model for category fields
        List modelList = new ArrayList();
        for (Iterator listIter = alarm.getCategories().iterator(); listIter.hasNext();) {
            Category category = (Category) listIter.next();
            modelList.add(new LabelValueBean(category.getName(), 
                                             category.getDescription()));
        }
        AlarmPropertiesModel categoryModel = 
            new AlarmPropertiesModel(modelList, 
                    new String[] {
                        NbBundle.getMessage(AlarmDetailsPanel.class, 
                            "LBL_ALARM_DETAILS_PANEL_CATEGORY_NAME_column_name"),
                        NbBundle.getMessage(AlarmDetailsPanel.class, 
                            "LBL_ALARM_DETAILS_PANEL_CATEGORY_DESC_column_name"),
                    });
        categoryFieldsTable.setModel(categoryModel);
        initColumnSizes(categoryFieldsTable, 
                        (AlarmPropertiesModel) categoryFieldsTable.getModel());
        setAutoResizeMode(categoryFieldsTable, categoryFieldsScrollPane);
        */       
    }
    /**
     *
     */
    private void setAllTableModels() {
        AlarmPropertiesModel dynPropModel = 
            new AlarmPropertiesModel(alarm.getDynamicInfo(allFields));
        dynamicFieldsTable.setModel(dynPropModel);
        
        initColumnSizes(dynamicFieldsTable, 
                        (AlarmPropertiesModel) dynamicFieldsTable.getModel());
        setAutoResizeMode(dynamicFieldsTable, dynamicFieldsScrollPane);
        
        AlarmPropertiesModel staticPropModel = 
            new AlarmPropertiesModel(alarm.getStaticInfo(allFields));
        staticFieldsTable.setModel(staticPropModel);
        initColumnSizes(staticFieldsTable, 
                        (AlarmPropertiesModel) staticFieldsTable.getModel());
        setAutoResizeMode(staticFieldsTable, staticFieldsScrollPane);

        // prepare jtable model for category fields
        List modelList = new ArrayList();
        for (Iterator listIter = alarm.getCategories().iterator(); listIter.hasNext();) {
            Category category = (Category) listIter.next();
            modelList.add(new LabelValueBean(category.getName(), 
                                             category.getDescription()));
        }
        AlarmPropertiesModel categoryModel = 
            new AlarmPropertiesModel(modelList, 
                    new String[] {
                        NbBundle.getMessage(AlarmDetailsPanel.class, 
                            "LBL_ALARM_DETAILS_PANEL_CATEGORY_NAME_column_name"),
                        NbBundle.getMessage(AlarmDetailsPanel.class, 
                            "LBL_ALARM_DETAILS_PANEL_CATEGORY_DESC_column_name"),
                    });
        categoryFieldsTable.setModel(categoryModel);
        initColumnSizes(categoryFieldsTable, 
                        (AlarmPropertiesModel) categoryFieldsTable.getModel());
        setAutoResizeMode(categoryFieldsTable, categoryFieldsScrollPane);
    }
   /*
     * This method picks good column sizes.
     * If all column heads are wider than the column's cells' 
     * contents, then you can just use column.sizeWidthToFit().
     */
    private void initColumnSizes(JTable table, AlarmPropertiesModel model) {
        TableColumn column = null;
        Component comp = null;
        int headerWidth = 0;
        int cellWidth = 0;
        int additionalSpace = 30;       // without this it does not work, and I 
                                        // do not have enough time to check why
                                        // I spent one on it, 
        Object[] longValues = 
            new String[] { model.getLongestLabel(), model.getLongestValue()};
        for (int i = 0; i < longValues.length; i++) {
            column = table.getColumnModel().getColumn(i);
            
            comp = table.getDefaultRenderer(model.getColumnClass(i)).
                             getTableCellRendererComponent(
                                 table, longValues[i],
                                 false, false, 0, i);
            cellWidth = comp.getPreferredSize().width;


            //XXX: Before Swing 1.1 Beta 2, use setMinWidth instead.
            //logger.debug(longValues[i] + " width: " + Math.max(headerWidth, cellWidth));
            column.setPreferredWidth(Math.max(headerWidth, cellWidth) + additionalSpace); 
        }
    } 
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton allFieldsButton;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JScrollPane categoryFieldsScrollPane;
    private javax.swing.JTable categoryFieldsTable;
    private javax.swing.JButton closeButton;
    private javax.swing.JScrollPane dynamicFieldsScrollPane;
    private javax.swing.JTable dynamicFieldsTable;
    private javax.swing.JPanel headerPanel;
    private javax.swing.JScrollPane headerScrollPane;
    private javax.swing.JButton helpButton;
    private javax.swing.JLabel identifierLabel;
    private javax.swing.JLabel identifierValLabel;
    private javax.swing.JPanel middlePanel;
    private javax.swing.JLabel probDescLabel;
    private javax.swing.JLabel probDescValLabel;
    private javax.swing.JScrollPane staticFieldsScrollPane;
    private javax.swing.JTable staticFieldsTable;
    private javax.swing.JLabel systemNameLabel;
    private javax.swing.JLabel systemNameValLabel;
    // End of variables declaration//GEN-END:variables
  
    //  alarm 
    private AlarmBean alarm = null;
   
    /** default dimension */ 
    private final static Dimension defaultDimension = new Dimension(
            WindowManager.getDefault().getCurrentWorkspace().getBounds().width / 3,  
            WindowManager.getDefault().getCurrentWorkspace().getBounds().height);

    /** all fields */
    private boolean allFields = true;


    /** logger */
    private static final Logger logger = 
        LogFactory.getLogger(AlarmDetailsPanel.class.getName());

    //
    // -
    //


    // MODES AND WORKSPACES
    
    /*
    // If you want it to open in a specific mode:
    public static final String AlarmDetailsPanel_MODE = "AlarmDetailsPanel";
    public void open(Workspace ws) {
        super.open(ws);
        if (ws == null) ws = WindowManager.getDefault().getCurrentWorkspace();
        Mode m = ws.findMode(AlarmDetailsPanel_MODE);
        if (m == null) {
            try {
                m = ws.createMode(AlarmDetailsPanel_MODE, // code name
                                   NbBundle.getMessage(AlarmDetailsPanel.class, "LBL_mode_name"), // display name
                                   new URL("nbresloc:/cern/laser/guiplatform/windows/alarms/AlarmDetailsPanelIcon.gif"));
            } catch (MalformedURLException mfue) {
                ErrorManager.getDefault().notify(mfue);
                return;
            }
            // If you want it in a specific position:
            // m.setBounds(...ws.getBounds()...);
        }
        m.dockInto(this);
    }
     */
    
    
    // If you are not specifying a mode you may wish to use:
    public Dimension getPreferredSize() {
        return defaultDimension;
    }
    
    
    /*
    // If you want it to open on a specific workspace:
    public static final String AlarmDetailsPanel_WORKSPACE = NbBundle.getMessage(AlarmDetailsPanel.class, "LBL_workspace_name");
    public void open() {
        WindowManager wm = WindowManager.getDefault();
        Workspace ws = wm.findWorkspace(AlarmDetailsPanel_WORKSPACE);
        if (ws == null)
            ws = wm.createWorkspace(AlarmDetailsPanel_WORKSPACE);
        open(ws);
        ws.activate();
    }
     */
    
    // PERSISTENCE
    
    private static final long serialVersionUID = 1L;
    
    /*
    // If you wish to keep any state between IDE restarts, put it here:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        setSomeState((SomeType)in.readObject());
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(getSomeState());
    }
     */
    
    /*
    // The above assumes that the SomeType is safely serializable, e.g. String or Date.
    // If it is some class of your own that might change incompatibly, use e.g.:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        NbMarshalledObject read = (NbMarshalledObject)in.readObject();
        if (read != null) {
            try {
                setSomeState((SomeType)read.get());
            } catch (Exception e) {
                ErrorManager.getDefault().notify(e);
                // If the problem would make this component inconsistent, use:
                // throw new SafeException(e);
            }
        }
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Object toWrite;
        try {
            toWrite = new NbMarshalledObject(getSomeState());
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            toWrite = null;
            // Again you may prefer to use:
            // throw new SafeException(e);
        }
        out.writeObject(toWrite);
    }
     */
    
    /*
    // Use this to discard the component after restarts (make it nonpersistent):
    private Object readResolve() throws ObjectStreamException {
        return null;
        // If you wish to conditionally discard it, make readExternal set
        // or clear some flag acc. to the condition, then use:
        // return discardFlag ? null : this;
        // Singleton component using private static AlarmDetailsPanel theInstance:
        // if (theInstance == null) theInstance = this;
        // return theInstance;
    }
     */
    
    // ACTIONS
    
    /*
    // If you wish to have extra actions appear in the window's
    // popup menu, they can go here:
    public SystemAction[] getSystemActions() {
        SystemAction[] supe = super.getSystemActions();
        SystemAction[] mine = new SystemAction[supe.length + 1];
        System.arraycopy(supe, 0, mine, 0, supe.length);
        mine[supe.length] = SystemAction.get(SomeActionOfMine.class);
        return mine;
    }
     */
    
    /*
    // Associate implementations with copying, searching, etc.:
    protected void componentActivated() {
        ((CallbackSystemAction)SystemAction.get(FindAction.class)).setActionPerformer(new ActionPerformer() {
                public void performAction(SystemAction action) {
                    // search this component somehow
                }
            });
        // similar for CopyAction, CutAction, DeleteAction, GotoAction, ReplaceAction, etc.
        // for PasteAction, use:
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(new PasteType[] {...});
    }
    protected void componentDeactivated() {
        // FindAction will be turned off by itself
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(null);
    }
     */
    
    /*
    // If you want UndoAction and RedoAction to be enabled on this component:
    public UndoRedo getUndoRedo() {
        return new MyUndoRedo(this);
    }
     */
    
    // Printing, saving, compiling, etc.: use cookies on some appropriate node and
    // use this node as the node selection.

    private class AlarmPropertiesModel extends AbstractTableModel {
      
        //private static final Object [] defaultColumnNames = {"col1", "col2"}; 
        /** logger */
        private final Logger logger = 
            LogFactory.getLogger(AlarmPropertiesModel.class.getName());

        /** properties to be displayed */
        private List properties = null; 
        
        /** max first column length */
        private int maxLabelLength = 0;
        /** */
        private String longestLabel = null;
        /** max second column lenght */
        private int maxValueLength = 0;
        /** */
        private String longestValue = null;

        /** */
        private Object [] columnNames = null;

        public AlarmPropertiesModel(List properties, Object[] columnNames) {
            this.properties = properties;
            this.columnNames = columnNames;
            calculateMaxColumnLenghts();
        }
        
        /**
         * @param properties <code>List</code> with <code>LabelValueBean</code>
         * objects
         */
        //public AlarmPropertiesModel(LabelValueBean [] properties) {
        public AlarmPropertiesModel(List properties) {
            //this.properties = properties;
            //calculateMaxColumnLenghts();
            this(properties, new String [] {"col1", "col2"});
        }
        
        public int getColumnCount() {
            return 2;   // name and value
        }
        
        public int getRowCount() {
            return properties.size();
        }
        
        public Object getValueAt(int rowIndex, int columnIndex) {
            LabelValueBean bean = (LabelValueBean) properties.get(rowIndex);
            
            if ( columnIndex == 0 )  //label
                return bean.getLabel();
             else 
                return bean.getValue(); 
        }
        
        public String getColumnName(int column) {
            return (String) columnNames[column];
        }
        
        
        /** This method calculates first and second columns max length */
        private void calculateMaxColumnLenghts() {
            for (Iterator listIter = properties.iterator(); listIter.hasNext();) {
                LabelValueBean bean = (LabelValueBean) listIter.next();
                int tempLength = 0;
                if ( (tempLength = bean.getLabel().length()) > maxLabelLength ) {
                    maxLabelLength = tempLength;
                    longestLabel = bean.getLabel();
                }
               
                if ( bean.getValue() != null ) 
                if ( (tempLength = bean.getValue().length()) > maxValueLength ) {
                    maxValueLength = tempLength;
                    longestValue = bean.getValue();
                }
            }
        }
        
        /**
         * @return string length, not pixel length
         */
        public int getMaxLabelLength() {
            return maxLabelLength;
        }
        
        /** 
         * @return string length, not pixel length*/
        public int getMaxValueLength() {
            return maxValueLength;
        }
        
        /**
         * @return longest label
         */
        public String getLongestLabel() {
            return longestLabel;
        }
        /**
         * @return longest value 
         */
        public String getLongestValue() {
            return longestValue;
        }
    }
}

