/*
 * PrintDialog.java
 *
 * Created on April 19, 2004, 4:03 PM
 */

package cern.laser.guiplatform.printing;

import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
/**
 *
 * @author  woloszyn
 */
public class PrintDialog extends javax.swing.JDialog {
    boolean settingsCorrect;
    File fileToPrint;
    
    /** Creates new form PrintDialog */
    public PrintDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        settingsCorrect = false;
        fileToPrint = null;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        rangesGroup = new javax.swing.ButtonGroup();
        directionGroup = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        buildingNumber = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        printersCombo = new javax.swing.JComboBox();
        refreshButton = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        numberOfCopies = new javax.swing.JSpinner();
        printTwoSided = new javax.swing.JCheckBox();
        jLabel4 = new javax.swing.JLabel();
        rangeFrom = new javax.swing.JTextField();
        printAll = new javax.swing.JRadioButton();
        printRange = new javax.swing.JRadioButton();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        rangeTo = new javax.swing.JTextField();
        printButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        printToFile = new javax.swing.JCheckBox();
        jLabel7 = new javax.swing.JLabel();
        directionLandscape = new javax.swing.JRadioButton();
        directionPortrait = new javax.swing.JRadioButton();

        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        setTitle("Print");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBorder(new javax.swing.border.TitledBorder(null, "", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        jPanel1.setName("");
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel1.setText("Building number");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 20, 120, 30));

        buildingNumber.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                buildingNumberKeyReleased(evt);
            }
        });

        jPanel1.add(buildingNumber, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 20, 80, 30));

        jLabel2.setText("Printers");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 60, 100, 30));

        printersCombo.setEditable(true);
        jPanel1.add(printersCombo, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 60, 220, -1));

        refreshButton.setText("Refresh printers");
        refreshButton.setBorder(new javax.swing.border.EtchedBorder());
        refreshButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshButtonActionPerformed(evt);
            }
        });

        jPanel1.add(refreshButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(240, 20, 110, 30));

        jLabel3.setText("Number of copies:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 180, -1, 40));

        numberOfCopies.setName("");
        numberOfCopies.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                numberOfCopiesStateChanged(evt);
            }
        });

        jPanel1.add(numberOfCopies, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 190, 60, 20));

        printTwoSided.setSelected(true);
        printTwoSided.setText("Print two sided    ");
        printTwoSided.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        jPanel1.add(printTwoSided, new org.netbeans.lib.awtextra.AbsoluteConstraints(220, 180, 160, 40));

        jLabel4.setText("Print pages");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 230, -1, 20));

        rangeFrom.setEditable(false);
        jPanel1.add(rangeFrom, new org.netbeans.lib.awtextra.AbsoluteConstraints(240, 260, 40, -1));

        printAll.setSelected(true);
        printAll.setText("All");
        rangesGroup.add(printAll);
        printAll.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                printAllStateChanged(evt);
            }
        });

        jPanel1.add(printAll, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 230, -1, -1));

        printRange.setText("Pages");
        rangesGroup.add(printRange);
        jPanel1.add(printRange, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 260, -1, -1));

        jLabel5.setText("from:");
        jPanel1.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(200, 260, -1, 20));

        jLabel6.setText("to:");
        jPanel1.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(290, 260, -1, 20));

        rangeTo.setEditable(false);
        jPanel1.add(rangeTo, new org.netbeans.lib.awtextra.AbsoluteConstraints(310, 260, 40, -1));

        printButton.setText("Print");
        printButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                printButtonActionPerformed(evt);
            }
        });

        jPanel1.add(printButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(80, 300, -1, -1));

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jPanel1.add(cancelButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(230, 300, -1, -1));

        printToFile.setText("Print to file     ");
        printToFile.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
        jPanel1.add(printToFile, new org.netbeans.lib.awtextra.AbsoluteConstraints(240, 100, 120, 40));

        jLabel7.setText("Direction :");
        jPanel1.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 100, -1, 40));

        directionLandscape.setText("Landscape");
        directionGroup.add(directionLandscape);
        jPanel1.add(directionLandscape, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 110, -1, -1));

        directionPortrait.setSelected(true);
        directionPortrait.setText("Portrait");
        directionGroup.add(directionPortrait);
        jPanel1.add(directionPortrait, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 140, -1, -1));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, -10, 380, 340));

        pack();
    }//GEN-END:initComponents
    
    private void printButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_printButtonActionPerformed
        // checking if printer exists in cern network
        
        String printerName = getPrinterName();
        
        if ( printerName.compareTo("") == 0 && isPrintToFile()==false ) {
            settingsCorrect = false;
            JOptionPane.showMessageDialog(null,
            "Printer name cannot be empty",
            "Error",
            JOptionPane.ERROR_MESSAGE);
            return;
        }
        if ( ! PrintUtil.checkPrinter( printerName) && isPrintToFile()==false ) {
            settingsCorrect = false;
            JOptionPane.showMessageDialog(null,
            "Printer does not exist",
            "Error",
            JOptionPane.ERROR_MESSAGE);
            return;
        }
        if ( ! isAllPagePrint() ) {
            if ( rangeFrom.getText().compareTo("")==0 || rangeTo.getText().compareTo("")==0 ) {
                settingsCorrect = false;
                JOptionPane.showMessageDialog(null,
                "Page range cannot be empty",
                "Error",
                JOptionPane.ERROR_MESSAGE);
                return;
            }
            try {
                int from = getRangeFrom();
                int to = getRangeTo();
                
                if (  from<1 || to<1 || from>to ) {
                    settingsCorrect = false;
                    JOptionPane.showMessageDialog(null,
                    "Page range is not correct",
                    "Error",
                    JOptionPane.ERROR_MESSAGE);
                    return;
                }
            }
            catch( NumberFormatException nfe){
                settingsCorrect = false;
                JOptionPane.showMessageDialog(null,
                "Page range is not correct",
                "Error",
                JOptionPane.ERROR_MESSAGE);
                return;
                
            }
        }
        if ( isPrintToFile() ) {
            // get file name
            //Create a file chooser
            JFileChooser fc = new JFileChooser();

            //In response to a button click:
            int returnVal = fc.showSaveDialog(this);
            
            if ( returnVal == JFileChooser.APPROVE_OPTION ) {
                    fileToPrint = fc.getSelectedFile();
            }
            else {
                settingsCorrect = false;
                return;
            }
                    
        }
        
        settingsCorrect = true;
        closeDialog(null);
    }//GEN-LAST:event_printButtonActionPerformed
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        closeDialog(null);
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void numberOfCopiesStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_numberOfCopiesStateChanged
        if ( ((Integer) numberOfCopies.getValue()).intValue() < 1 ) {
            numberOfCopies.setValue( new Integer(1) );
        }
    }//GEN-LAST:event_numberOfCopiesStateChanged
    
    private void printAllStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_printAllStateChanged
        if ( printAll.isSelected() ) {
            rangeFrom.setEditable( false );
            rangeTo.setEditable( false );
        }
        else {
            rangeFrom.setEditable( true );
            rangeTo.setEditable( true );
        }
    }//GEN-LAST:event_printAllStateChanged
    
    private void buildingNumberKeyReleased(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_buildingNumberKeyReleased
        // Add your handling code here:
        refreshButtonActionPerformed(null);
    }//GEN-LAST:event_buildingNumberKeyReleased
    
    private void refreshButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refreshButtonActionPerformed
        // Add your handling code here:
        try {
        	String defaultPrinterName = DefaultPrinterDialog.getDefaultPrinterName();
            String [] printers = PrintUtil.getPrintersInBuilding(buildingNumber.getText());
            printersCombo.removeAllItems();
            boolean defaultWasThere = (defaultPrinterName == null);
            if (defaultPrinterName != null) 
            	defaultPrinterName = defaultPrinterName.toLowerCase();
            for (int i=0; i<printers.length; i++) {
                printersCombo.addItem( printers[i] );
                if (!defaultWasThere && printers[i].equals(defaultPrinterName)) {
                	printersCombo.setSelectedItem(printers[i]);
                	defaultWasThere = true;
                }
            }
            if (!defaultWasThere && (defaultPrinterName != null)) {
            	printersCombo.addItem(defaultPrinterName);
            	printersCombo.setSelectedItem(defaultPrinterName);
            }
        }   catch ( Exception e) {
            System.out.println("Problem with obtaining printers!");
        }
    }//GEN-LAST:event_refreshButtonActionPerformed
    
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        // Add your handling code here:
    	String defaultPrinterName = DefaultPrinterDialog.getDefaultPrinterName();
    	String thisBuilding = PrintUtil.getBuildingNumber();
        buildingNumber.setText( thisBuilding );
        boolean defaultWasThere = (defaultPrinterName == null);
        if (defaultPrinterName != null) 
        	defaultPrinterName = defaultPrinterName.toLowerCase();
        try {
            String [] printers = PrintUtil.getPrintersInThisBuilding();
            for(int i=0; i<printers.length; i++) {
                printersCombo.addItem( printers[i] );
                if (!defaultWasThere && printers[i].equals(defaultPrinterName)) {
                	printersCombo.setSelectedItem(printers[i]);
                	defaultWasThere = true;
                }
            }
            if (!defaultWasThere && (defaultPrinterName != null)) {
            	printersCombo.addItem(defaultPrinterName);
            	printersCombo.setSelectedItem(defaultPrinterName);
            }
        }   catch ( Exception e) {
            System.out.println("Problem with obtaining printers!");
        }
        numberOfCopies.setValue( new Integer(1) );
    }//GEN-LAST:event_formWindowOpened
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    public String getPrinterName() {
        return printersCombo.getSelectedItem().toString();
    }
    
    public int getNumberOfCopies() {
        return new Integer( numberOfCopies.getValue().toString() ).intValue();
    }
    
    public boolean isTwoSidedPrint() {
        return printTwoSided.isSelected();
    }
    
    public boolean isAllPagePrint() {
        return printAll.isSelected();
    }

    public boolean isRangePagePrint() {
        return printRange.isSelected();
    }

    public int getRangeFrom() {
        if ( rangeFrom.getText().compareTo("")==0 ) {
            return -1;
        }
        else {
            return new Integer( rangeFrom.getText() ).intValue();
        }
    }
    
    public int getRangeTo() {
        if ( rangeTo.getText().compareTo("")==0 ) {
            return -1;
        }
        else {
            return new Integer( rangeTo.getText() ).intValue();
        }
    }
    
    public boolean isPrintToFile() {    
        return printToFile.isSelected();
    }
    
    public File getFileToPrint() {
        return fileToPrint;
    }
    public boolean areSettingsOK() {
        return settingsCorrect;
    }
    
    public boolean isLandscape () {
        return directionLandscape.isSelected();
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new PrintDialog(new javax.swing.JFrame(), true).show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField buildingNumber;
    private javax.swing.JButton cancelButton;
    private javax.swing.ButtonGroup directionGroup;
    private javax.swing.JRadioButton directionLandscape;
    private javax.swing.JRadioButton directionPortrait;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSpinner numberOfCopies;
    private javax.swing.JRadioButton printAll;
    private javax.swing.JButton printButton;
    private javax.swing.JRadioButton printRange;
    private javax.swing.JCheckBox printToFile;
    private javax.swing.JCheckBox printTwoSided;
    private javax.swing.JComboBox printersCombo;
    private javax.swing.JTextField rangeFrom;
    private javax.swing.JTextField rangeTo;
    private javax.swing.ButtonGroup rangesGroup;
    private javax.swing.JButton refreshButton;
    // End of variables declaration//GEN-END:variables
    
}
