/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/

package org.openorb.compiler.idl.parser;

import org.openorb.compiler.object.*;
import org.openorb.compiler.parser.*;

/**
 * This class is the org.openorb Parser that builds internal IDL object graph and returns an enumeration
 * 
 * @author Jerome Daniel
 * @version $Revision: 1.4 $ $Date: 2002/08/21 08:19:20 $ 
 */

public class idlParser
{
    /**
     * Compilation Graph
     */
    IdlObject CompilationGraph = null;

    /**
     * Args
     */
    String[] args;

    /**
     * Constructor
     * 
     * @param args the compiler arguments ( the same options as on command line )
     */
    public idlParser( String [] args )
    {

        this.args = args;

    }

    /**
     * Run parser
     */
    public int compile( java.io.PrintStream error_output )
    {

        IdlParser Parser = org.openorb.compiler.IdlCompiler.createIDLParser( args );

        Parser.error_output = error_output;

        try
        {
            for ( int i = 0; i < org.openorb.compiler.IdlCompiler.idl_file_name.length; i++ )
                CompilationGraph = Parser.compile_idl( org.openorb.compiler.IdlCompiler.idl_file_name[ i ] );
        }
        catch ( java.lang.Throwable ex )
        { }

        return Parser.totalError;
    }

    /**
     * Return the compilation graph content
     */
    public java.util.Enumeration content()
    {
        return CompilationGraph.content();
    }
}
