/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.CORBA.dynany;

import org.apache.avalon.framework.logger.Logger;

/**
 * This class provides the DynAny Factory
 *
 * @author Jerome Daniel
 * @version $Revision: 1.6 $ $Date: 2002/07/16 11:40:23 $ 
 */
public class DynAnyFactoryImpl
    extends org.omg.CORBA.LocalObject
    implements org.omg.DynamicAny.DynAnyFactory
{
    public DynAnyFactoryImpl( org.omg.CORBA.ORB orb )
    {
        m_orb = orb;
    }

    private org.omg.CORBA.ORB m_orb;
    private Logger m_logger;

    /**
     * Operation create_dyn_any
     */
    public org.omg.DynamicAny.DynAny create_dyn_any( org.omg.CORBA.Any value )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynAny dany = null;

        dany = create_dyn_any_from_type_code( value.type() );

        try
        {
            dany.from_any( value );
        }
        catch ( org.omg.DynamicAny.DynAnyPackage.TypeMismatch ex )
        {
            if ( getLogger().isErrorEnabled() )
                getLogger().error( "Any types do not match.", ex );

            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();
        }
        catch ( org.omg.DynamicAny.DynAnyPackage.InvalidValue ex )
        {
            if ( getLogger().isErrorEnabled() )
                getLogger().error( "Any value is not valid.", ex );

            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();
        }

        return dany;
    }

    /**
     * Operation create_dyn_any_from_type_code
     */
    public org.omg.DynamicAny.DynAny create_dyn_any_from_type_code( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynAny dany;

        switch ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value() )
        {

        case org.omg.CORBA.TCKind._tk_null :

        case org.omg.CORBA.TCKind._tk_void :

        case org.omg.CORBA.TCKind._tk_short :

        case org.omg.CORBA.TCKind._tk_long :

        case org.omg.CORBA.TCKind._tk_longlong :

        case org.omg.CORBA.TCKind._tk_ushort :

        case org.omg.CORBA.TCKind._tk_ulong :

        case org.omg.CORBA.TCKind._tk_ulonglong :

        case org.omg.CORBA.TCKind._tk_float :

        case org.omg.CORBA.TCKind._tk_double :

        case org.omg.CORBA.TCKind._tk_longdouble :

        case org.omg.CORBA.TCKind._tk_boolean :

        case org.omg.CORBA.TCKind._tk_char :

        case org.omg.CORBA.TCKind._tk_wchar :

        case org.omg.CORBA.TCKind._tk_octet :

        case org.omg.CORBA.TCKind._tk_any :

        case org.omg.CORBA.TCKind._tk_TypeCode :

        case org.omg.CORBA.TCKind._tk_string :

        case org.omg.CORBA.TCKind._tk_wstring :

        case org.omg.CORBA.TCKind._tk_objref :
            dany = new org.openorb.CORBA.dynany.DynBasicImpl( this,
                  m_orb, type, m_orb.create_any() );
            break;

        case org.omg.CORBA.TCKind._tk_except :

        case org.omg.CORBA.TCKind._tk_struct :
            dany = create_dyn_struct( type );
            break;

        case org.omg.CORBA.TCKind._tk_sequence :
            dany = create_dyn_sequence( type );
            break;

        case org.omg.CORBA.TCKind._tk_union :
            dany = create_dyn_union( type );
            break;

        case org.omg.CORBA.TCKind._tk_enum :
            dany = create_dyn_enum( type );
            break;

        case org.omg.CORBA.TCKind._tk_fixed :
            dany = create_dyn_fixed( type );
            break;

        case org.omg.CORBA.TCKind._tk_array :
            dany = create_dyn_array( type );
            break;

        case org.omg.CORBA.TCKind._tk_value :
            dany = create_dyn_value( type );
            break;

        case org.omg.CORBA.TCKind._tk_value_box :
            dany = create_dyn_value_box( type );
            break;

        default :
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();
        }

        return dany;
    }

    // Create a dyn value
    private org.omg.DynamicAny.DynValue create_dyn_value( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynValue dany;

        if ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_value )
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();

        dany = new org.openorb.CORBA.dynany.DynValueImpl( this, m_orb, type );

        return dany;
    }

    // Create a dyn value box
    private org.omg.DynamicAny.DynValueBox create_dyn_value_box( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynValueBox dany;

        if ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_value_box )
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();

        dany = new org.openorb.CORBA.dynany.DynValueBoxImpl( this, m_orb, type );

        return dany;
    }

    // Create a dyn struct
    private org.omg.DynamicAny.DynStruct create_dyn_struct( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynStruct dany;

        if ( ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_struct )
              && ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_except ) )
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();

        dany = new org.openorb.CORBA.dynany.DynStructImpl( this, m_orb, type );

        return dany;
    }

    // Create a dyn fixed
    private org.omg.DynamicAny.DynFixed create_dyn_fixed( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynFixed dany;

        if ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_fixed )
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();

        dany = new org.openorb.CORBA.dynany.DynFixedImpl( this, m_orb, type );

        return dany;
    }

    // Create a dyn sequence
    private org.omg.DynamicAny.DynSequence create_dyn_sequence( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynSequence dany;

        if ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_sequence )
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();

        dany = new org.openorb.CORBA.dynany.DynSequenceImpl( this, m_orb, type );

        return dany;
    }

    // Create a dyn array
    public org.omg.DynamicAny.DynArray create_dyn_array( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynArray dany;

        if ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_array )
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();

        return new org.openorb.CORBA.dynany.DynArrayImpl( this, m_orb, type );
    }

    // Create a dyn union
    private org.omg.DynamicAny.DynUnion create_dyn_union( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynUnion dany;

        if ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_union )
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();

        return new org.openorb.CORBA.dynany.DynUnionImpl( this, m_orb, type );
    }

    // Create a dyn enum
    private org.omg.DynamicAny.DynEnum create_dyn_enum( org.omg.CORBA.TypeCode type )
        throws org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode
    {
        org.omg.DynamicAny.DynEnum dany;

        if ( ( ( org.openorb.CORBA.typecode.TypeCodeBase ) type )._base_type().kind().value()
              != org.omg.CORBA.TCKind._tk_enum )
            throw new org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode();

        return new org.openorb.CORBA.dynany.DynEnumImpl( this, m_orb, type, 0 );
    }

    private Logger getLogger()
    {
        if ( null == m_logger )
        {
            m_logger = ( ( org.openorb.CORBA.ORBSingleton) m_orb ).getLogger();
        }
        return m_logger;
    }
}

