package org.omg.CORBA;

/**
 * This exception is raised if communication is lost while an
 * operation is in progress, after the request was sent by the
 * client, but before the reply from the server has been returned to
 * the client.
 */

public class COMM_FAILURE extends org.omg.CORBA.SystemException
{
    //
    // Default constructor
    //
    public COMM_FAILURE()
    {
        super( null, 0, CompletionStatus.COMPLETED_MAYBE );
    }

    //
    // Constructor with reason string
    //
    public COMM_FAILURE( String orb_reason )
    {
        super( orb_reason, 0, CompletionStatus.COMPLETED_MAYBE );
    }

    //
    // Constructor with fields initialization
    // @param minor minor exception member
    // @param completed completed exception member
    //
    public COMM_FAILURE( int minor, org.omg.CORBA.CompletionStatus completed )
    {
        super( null, minor, completed );
    }

    //
    // Full constructor with fields initialization
    // @param minor minor exception member
    // @param completed completed exception member
    //
    public COMM_FAILURE( String orb_reason, int minor, org.omg.CORBA.CompletionStatus completed )
    {
        super( orb_reason, minor, completed );
    }
}
