/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakValueHashMap
extends AbstractMap
implements Map {
    private Map m_hash;
    private ReferenceQueue m_queue = new ReferenceQueue();
    private Set m_entrySet = null;

    public WeakValueHashMap(int initialCapacity, float loadFactor) {
        this.m_hash = new HashMap(initialCapacity, loadFactor);
    }

    public WeakValueHashMap(int initialCapacity) {
        this.m_hash = new HashMap(initialCapacity);
    }

    public WeakValueHashMap() {
        this.m_hash = new HashMap();
    }

    public WeakValueHashMap(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    /*
     * WARNING - void declaration
     */
    private void processQueue() {
        WeakValue wv;
        while ((wv = (WeakValue)this.m_queue.poll()) != null) {
            void var1_1;
            this.m_hash.remove(var1_1.getKey());
        }
    }

    public Set entrySet() {
        if (this.m_entrySet == null) {
            this.m_entrySet = new EntrySet();
        }
        return this.m_entrySet;
    }

    public boolean containsKey(Object key) {
        return this.m_hash.containsKey(key);
    }

    public Object get(Object key) {
        WeakValue val = (WeakValue)this.m_hash.get(key);
        if (val == null) {
            return null;
        }
        return val.get();
    }

    public Object put(Object key, Object value) {
        this.processQueue();
        return this.m_hash.put(key, new WeakValue(key, value, this.m_queue));
    }

    public Object remove(Object key) {
        this.processQueue();
        return this.m_hash.remove(key);
    }

    public void clear() {
        this.processQueue();
        this.m_hash.clear();
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private class EntrySet
    extends AbstractSet {
        private Set m_hashEntrySet;

        private EntrySet() {
            this.m_hashEntrySet = WeakValueHashMap.this.m_hash.entrySet();
        }

        public Set getEntrySet() {
            return this.m_hashEntrySet;
        }

        public Iterator iterator() {
            return new Iterator(){
                Iterator hashIterator;
                Entry next;
                {
                    this.hashIterator = this.getEntrySet().iterator();
                    this.next = null;
                }

                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = (Map.Entry)this.hashIterator.next();
                        WeakValue wv = (WeakValue)ent.getValue();
                        Object v = null;
                        if (wv != null) {
                            Object t = wv.get();
                            v = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, v);
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        public boolean remove(Object o) {
            WeakValueHashMap.this.processQueue();
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object ek = e.getKey();
            WeakValue wv = (WeakValue)WeakValueHashMap.this.m_hash.get(ek);
            if (wv == null ? WeakValueHashMap.this.m_hash.containsKey(ek) : wv.get() != null) {
                WeakValueHashMap.this.m_hash.remove(ek);
                return true;
            }
            return false;
        }

        public int hashCode() {
            int h = 0;
            Iterator i = this.getEntrySet().iterator();
            while (i.hasNext()) {
                Object v;
                Map.Entry ent = (Map.Entry)i.next();
                Object k = ent.getKey();
                if (k == null) continue;
                WeakValue wv = (WeakValue)ent.getValue();
                h += k.hashCode() ^ (wv == null || (v = wv.get()) == null ? 0 : v.hashCode());
            }
            return h;
        }
    }

    private class Entry
    implements Map.Entry {
        private Map.Entry m_ent;
        private Object m_value;

        Entry(Map.Entry ent, Object value) {
            this.m_ent = ent;
            this.m_value = value;
        }

        public Object getKey() {
            return this.m_ent.getKey();
        }

        public Object getValue() {
            return this.m_value;
        }

        public Object setValue(Object value) {
            this.m_value = value;
            return this.m_ent.setValue(new WeakValue(this.m_ent.getKey(), value, WeakValueHashMap.this.m_queue));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return WeakValueHashMap.valEquals(this.getKey(), e.getKey()) && WeakValueHashMap.valEquals(this.m_value, e.getValue());
        }

        public int hashCode() {
            Object k = this.getKey();
            return (k == null ? 0 : k.hashCode()) ^ (this.m_value == null ? 0 : this.m_value.hashCode());
        }
    }

    private static class WeakValue
    extends WeakReference {
        private Object m_key;

        public WeakValue(Object k, Object val, ReferenceQueue q) {
            super(val, q);
            this.m_key = k;
        }

        public Object getKey() {
            return this.m_key;
        }
    }
}

