/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.io;

import java.util.EventListener;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.SystemException;
import org.openorb.io.Scrap;
import org.openorb.io.StorageBuffer;

public class MarshalBuffer {
    private SystemException m_cancel_exception = null;
    private Scrap m_head = this.m_tail = new Scrap();
    private Scrap m_tail;
    private OctetSeqHolder m_last_buffer = null;
    private boolean m_allow_fragment = false;
    private boolean m_in_fragment = false;
    private boolean m_header_fragment = true;
    private HeaderData m_last_header = null;
    private boolean m_block_fragment = true;
    private BlockData m_last_block = null;
    private Listener m_listener = null;
    private Object m_listener_cookie = null;
    private boolean m_in_listener = false;
    private byte[] m_ignore_buffer = null;

    public MarshalBuffer() {
        this.m_tail.fBuffer = new byte[2048];
        this.m_tail.fOffset = 0;
        this.m_tail.fLength = 0;
        this.m_tail.fMode = 0;
        this.m_tail.fPosition = 0;
    }

    public MarshalBuffer(Listener listener, Object listenerCookie) {
        this();
        this.m_listener = listener;
        this.m_listener_cookie = listenerCookie;
    }

    public boolean isStandalone() {
        return this.m_listener == null;
    }

    public int size() {
        if (!this.prealloc()) {
            return -1;
        }
        return this.m_tail.fPosition;
    }

    public int available() {
        if (!this.prealloc()) {
            return -1;
        }
        return this.m_tail.fPosition - this.m_head.fPosition + this.m_head.fLength;
    }

    public void setAllowFragment(boolean allowFragment) {
        this.m_allow_fragment = allowFragment;
    }

    public boolean getAllowFragment() {
        return this.m_allow_fragment && this.m_header_fragment && this.m_block_fragment && !this.m_in_fragment;
    }

    public void alloc(OctetSeqHolder buf, IntHolder off, int len) {
        if (!this.prealloc()) {
            if (this.m_ignore_buffer == null || this.m_ignore_buffer.length < len) {
                this.m_ignore_buffer = new byte[len];
            }
            buf.value = this.m_ignore_buffer;
            off.value = 0;
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (this.m_tail.fBuffer.length - this.m_tail.fLength - this.m_tail.fOffset >= len) {
            buf.value = this.m_tail.fBuffer;
            off.value = this.m_tail.fOffset + this.m_tail.fLength;
            this.m_tail.fLength += len;
            this.m_tail.fPosition += len;
        } else {
            Scrap nex = new Scrap();
            nex.fBuffer = len > 2048 ? new byte[len] : new byte[2048];
            nex.fOffset = 0;
            nex.fLength = len;
            nex.fMode = 0;
            nex.fPosition = this.m_tail.fPosition + len;
            buf.value = nex.fBuffer;
            off.value = 0;
            this.m_tail.fNext = nex;
            this.m_tail = nex;
        }
        this.m_last_buffer = buf;
    }

    public void append(byte[] buf, int off, int len) {
        if (!this.prealloc()) {
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (len == 0) {
            return;
        }
        if (len < 2048) {
            if (this.m_tail.fBuffer.length - this.m_tail.fLength - this.m_tail.fOffset >= len) {
                System.arraycopy(buf, off, this.m_tail.fBuffer, this.m_tail.fOffset + this.m_tail.fLength, len);
                this.m_tail.fLength += len;
                this.m_tail.fPosition += len;
            } else {
                int rem = this.m_tail.fBuffer.length - this.m_tail.fLength - this.m_tail.fOffset;
                System.arraycopy(buf, off, this.m_tail.fBuffer, this.m_tail.fOffset + this.m_tail.fLength, rem);
                this.m_tail.fLength += rem;
                this.m_tail.fPosition += rem;
                Scrap nex = new Scrap();
                nex.fBuffer = new byte[2048];
                nex.fOffset = 0;
                nex.fLength = len - rem;
                nex.fMode = 0;
                nex.fPosition = this.m_tail.fPosition + len - rem;
                System.arraycopy(buf, off + rem, nex.fBuffer, 0, len - rem);
                this.m_tail.fNext = nex;
                this.m_tail = nex;
            }
            return;
        }
        if (this.m_tail.fLength == 0) {
            Scrap nex = new Scrap();
            nex.fBuffer = this.m_tail.fBuffer;
            nex.fOffset = this.m_tail.fOffset;
            nex.fLength = 0;
            nex.fMode = 0;
            nex.fPosition = this.m_tail.fPosition + len;
            this.m_tail.fBuffer = buf;
            this.m_tail.fOffset = off;
            this.m_tail.fLength = len;
            this.m_tail.fMode = 3;
            this.m_tail.fPosition = nex.fPosition;
            this.m_tail.fNext = nex;
            this.m_tail = nex;
        } else {
            this.m_tail.fMode = 1;
            Scrap ro = new Scrap();
            ro.fBuffer = buf;
            ro.fOffset = off;
            ro.fLength = len;
            ro.fMode = 3;
            ro.fPosition = this.m_tail.fPosition + len;
            Scrap nex = new Scrap();
            nex.fBuffer = this.m_tail.fBuffer;
            nex.fOffset = this.m_tail.fOffset + this.m_tail.fLength;
            nex.fLength = 0;
            nex.fPosition = ro.fPosition;
            nex.fMode = 0;
            this.m_tail.fNext = ro;
            ro.fNext = nex;
            this.m_tail = nex;
        }
        this.postalloc();
    }

    public void pad(int len) {
        if (!this.prealloc()) {
            return;
        }
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (len == 0) {
            return;
        }
        int rem = this.m_tail.fBuffer.length - this.m_tail.fLength - this.m_tail.fOffset;
        if (rem >= len) {
            this.m_tail.fLength += len;
            this.m_tail.fPosition += len;
        } else {
            this.m_tail.fLength += rem;
            this.m_tail.fPosition += rem;
            Scrap nex = new Scrap();
            nex.fBuffer = new byte[2048];
            nex.fOffset = 0;
            nex.fLength = len - rem;
            nex.fMode = 0;
            nex.fPosition = this.m_tail.fPosition + nex.fLength;
            this.m_tail.fNext = nex;
            this.m_tail = nex;
        }
        this.postalloc();
    }

    public void addHeader(HeaderGenerator gen, int len, boolean frag, Object cookie) {
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (gen == null) {
            throw new NullPointerException();
        }
        if (!this.prealloc()) {
            return;
        }
        HeaderData hd = new HeaderData();
        hd.fPrevious = this.m_last_header;
        this.m_last_header = hd;
        hd.fLastHeaderFragment = this.m_header_fragment;
        hd.fPosition = this.size();
        hd.fGenerator = gen;
        hd.fCookie = cookie;
        if (len != 0) {
            this.m_header_fragment = false;
            OctetSeqHolder bufh = new OctetSeqHolder();
            IntHolder offh = new IntHolder();
            this.alloc(bufh, offh, len);
            hd.fBuffer = bufh.value;
            hd.fOffset = offh.value;
            hd.fLength = len;
        }
        this.m_header_fragment = hd.fLastHeaderFragment && frag;
    }

    public void beginBlock(BlockGenerator gen, int len, boolean frag, Object cookie) {
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (gen == null) {
            throw new NullPointerException();
        }
        if (!this.prealloc()) {
            return;
        }
        BlockData bd = new BlockData();
        bd.fPrevious = this.m_last_block;
        bd.fIsFragment = this.m_last_block == null ? frag : false;
        this.m_last_block = bd;
        bd.fPosition = this.size();
        bd.fGenerator = gen;
        bd.fCookie = cookie;
        if (len != 0) {
            this.m_block_fragment = false;
            OctetSeqHolder bufh = new OctetSeqHolder();
            IntHolder offh = new IntHolder();
            this.alloc(bufh, offh, len);
            bd.fBuffer = bufh.value;
            bd.fOffset = offh.value;
            bd.fLength = len;
        }
        this.m_block_fragment = bd.fIsFragment;
    }

    public void endBlock() {
        if (this.m_in_listener && !this.m_in_fragment) {
            throw new IllegalStateException("Cannot modify buffer while calling listener");
        }
        if (this.m_last_block == null) {
            throw new IllegalStateException("End block without begin block");
        }
        this.m_last_block.fGenerator.endBlock(this.m_last_block.fBuffer, this.m_last_block.fOffset, this.m_last_block.fLength, this.size() - this.m_last_block.fPosition, this.m_last_block.fCookie);
        this.m_last_block = this.m_last_block.fPrevious;
        this.m_block_fragment = this.m_last_block == null ? true : this.m_last_block.fIsFragment;
    }

    public void close() {
        if (this.m_in_listener) {
            throw new IllegalStateException("Cannot close buffer while calling listener.");
        }
        if (this.m_last_block != null) {
            throw new IllegalStateException("All blocks must be closed before closing buffer");
        }
        if (!this.prealloc()) {
            return;
        }
        if (this.m_listener != null) {
            this.m_in_listener = true;
            this.m_listener.bufferClosed(this, this.m_tail.fPosition, this.m_listener_cookie);
            this.m_in_listener = false;
        }
        this.m_tail = null;
        this.m_head = null;
        this.m_last_header = null;
    }

    public void cancel(SystemException ex) {
        if (!this.prealloc()) {
            return;
        }
        if (this.m_listener != null) {
            this.m_in_listener = true;
            try {
                this.m_listener.bufferCanceled(this, ex, this.m_listener_cookie);
            }
            catch (SystemException sex) {
                this.m_cancel_exception = sex;
            }
            this.m_in_listener = false;
        } else {
            this.m_cancel_exception = ex;
        }
        this.m_tail = null;
        this.m_head = null;
        this.m_last_header = null;
        this.m_last_block = null;
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
    }

    public StorageBuffer fragment(int len) {
        Scrap nexthead;
        Scrap mid;
        if (!this.prealloc()) {
            return null;
        }
        if (this.m_listener != null && !this.m_in_listener) {
            throw new IllegalStateException("Operation disallowed, must be called from listener");
        }
        if (!this.getAllowFragment()) {
            throw new IllegalStateException("Buffer cannot currently be fragmented");
        }
        if (len > this.m_tail.fPosition - this.m_head.fPosition + this.m_head.fLength) {
            throw new IndexOutOfBoundsException();
        }
        this.m_in_fragment = true;
        if (this.m_last_block != null) {
            BlockData bd = this.m_last_block;
            this.m_last_block = null;
            bd.fGenerator.fragmentBlock(bd.fBuffer, bd.fOffset, bd.fLength, this.size() - bd.fPosition, this, bd.fCookie);
        }
        int endpos = len + this.m_head.fPosition - this.m_head.fLength;
        HeaderData firstHeader = null;
        while (this.m_last_header != null) {
            this.m_last_header.fGenerator.endMessage(this.m_last_header.fBuffer, this.m_last_header.fOffset, this.m_last_header.fLength, true, endpos - this.m_last_header.fPosition, this.m_last_header.fCookie);
            HeaderData tmp = this.m_last_header.fPrevious;
            this.m_last_header.fPrevious = firstHeader;
            firstHeader = this.m_last_header;
            this.m_last_header = tmp;
        }
        if (this.m_tail.fPosition - this.m_tail.fLength < endpos) {
            mid = this.m_tail;
        } else {
            mid = this.m_head;
            while (mid.fPosition < endpos) {
                mid = mid.fNext;
            }
        }
        if (mid.fPosition == endpos) {
            nexthead = mid.fNext;
            mid.fNext = null;
        } else {
            int olap = mid.fPosition - endpos;
            nexthead = new Scrap();
            nexthead.fMode = 1 | mid.fMode;
            nexthead.fBuffer = mid.fBuffer;
            nexthead.fPosition = mid.fPosition;
            nexthead.fOffset = mid.fOffset + mid.fLength - olap;
            nexthead.fLength = olap;
            nexthead.fNext = mid.fNext;
            mid.fLength -= olap;
            mid.fPosition = endpos;
            mid.fNext = null;
            mid.fMode = 1 | mid.fMode;
        }
        mid = null;
        StorageBuffer fragment = new StorageBuffer(this.m_head, len);
        this.m_head = this.m_tail = new Scrap();
        this.m_tail.fBuffer = new byte[2048];
        this.m_tail.fOffset = 0;
        this.m_tail.fLength = 0;
        this.m_tail.fMode = 0;
        this.m_tail.fPosition = endpos;
        while (firstHeader != null) {
            firstHeader.fGenerator.beginMessage(this, firstHeader.fCookie);
            firstHeader = firstHeader.fPrevious;
        }
        this.prealloc();
        int addHeader = 0;
        if (nexthead != null) {
            addHeader = this.m_tail.fPosition + nexthead.fLength - nexthead.fPosition;
            if (this.m_tail.fLength == 0) {
                this.m_tail.fBuffer = nexthead.fBuffer;
                this.m_tail.fLength = nexthead.fLength;
                this.m_tail.fOffset = nexthead.fOffset;
                this.m_tail.fMode = nexthead.fMode;
                this.m_tail.fNext = nexthead.fNext;
                this.m_tail.fPosition += nexthead.fLength;
                nexthead = nexthead.fNext;
            } else {
                this.m_tail.fNext = nexthead;
            }
            while (nexthead != null) {
                nexthead.fPosition += addHeader;
                this.m_tail = nexthead;
                nexthead = nexthead.fNext;
            }
        }
        BlockData bd = this.m_last_block;
        while (bd != null) {
            bd.fPosition += addHeader;
            bd = bd.fPrevious;
        }
        this.m_in_fragment = false;
        return fragment;
    }

    /*
     * Unable to fully structure code
     */
    public StorageBuffer lastFragment() {
        if (!this.prealloc()) {
            return null;
        }
        if (this.m_listener != null && !this.m_in_listener) {
            throw new IllegalStateException("Operation disallowed, must be called from listener. Call close operation");
        }
        if (this.m_last_block == null) ** GOTO lbl9
        throw new IllegalStateException("Attempt to close buffer without closing all blocks");
lbl-1000:
        // 1 sources

        {
            this.m_last_header.fGenerator.endMessage(this.m_last_header.fBuffer, this.m_last_header.fOffset, this.m_last_header.fLength, false, this.m_tail.fPosition - this.m_last_header.fPosition, this.m_last_header.fCookie);
            this.m_last_header = this.m_last_header.fPrevious;
lbl9:
            // 2 sources

            ** while (this.m_last_header != null)
        }
lbl10:
        // 1 sources

        msghead = this.m_head;
        len = this.m_tail.fPosition;
        this.m_tail = null;
        this.m_head = null;
        return new StorageBuffer(msghead, len);
    }

    private boolean prealloc() {
        if (this.m_cancel_exception != null) {
            throw this.m_cancel_exception;
        }
        if (this.m_head == null) {
            return false;
        }
        if (this.m_last_buffer != null) {
            this.m_last_buffer.value = null;
            this.m_last_buffer = null;
            this.postalloc();
        }
        return true;
    }

    private void postalloc() {
        if (this.m_listener != null && this.m_allow_fragment && this.m_header_fragment && this.m_block_fragment && !this.m_in_fragment) {
            this.m_in_listener = true;
            this.m_listener.availIncreaced(this, this.m_tail.fPosition - this.m_head.fPosition + this.m_head.fLength, this.m_listener_cookie);
            this.m_in_listener = false;
        }
    }

    public static void main(String[] args) {
        MarshalBuffer mbuf = new MarshalBuffer();
        OctetSeqHolder buf = new OctetSeqHolder();
        IntHolder pos = new IntHolder();
        int len = 1;
        int i = 0;
        while (i < 3000) {
            mbuf.alloc(buf, pos, len);
            int j = 0;
            while (j < len) {
                buf.value[pos.value + j] = (byte)((i + j) % 121);
                ++j;
            }
            i += len;
        }
        StorageBuffer sbuf = mbuf.lastFragment();
        System.out.println("available = " + sbuf.available());
        System.out.println("available = " + sbuf.available());
        byte[] lin = sbuf.linearize();
        int i2 = 0;
        while (i2 < lin.length) {
            if (lin[i2] != (byte)(i2 % 121)) {
                System.out.println("Error at index " + i2);
            }
            ++i2;
        }
    }

    private static class BlockData {
        public BlockData fPrevious;
        public boolean fIsFragment;
        public int fPosition;
        public BlockGenerator fGenerator;
        public Object fCookie;
        public byte[] fBuffer;
        public int fOffset;
        public int fLength;

        private BlockData() {
        }
    }

    private static class HeaderData {
        public HeaderData fPrevious;
        public boolean fLastHeaderFragment;
        public int fPosition;
        public HeaderGenerator fGenerator;
        public Object fCookie;
        public byte[] fBuffer;
        public int fOffset;
        public int fLength;

        private HeaderData() {
        }
    }

    public static interface Listener
    extends EventListener {
        public void availIncreaced(MarshalBuffer var1, int var2, Object var3);

        public void bufferClosed(MarshalBuffer var1, int var2, Object var3);

        public void bufferCanceled(MarshalBuffer var1, SystemException var2, Object var3);
    }

    public static interface BlockGenerator {
        public void endBlock(byte[] var1, int var2, int var3, int var4, Object var5);

        public void fragmentBlock(byte[] var1, int var2, int var3, int var4, MarshalBuffer var5, Object var6);
    }

    public static interface HeaderGenerator {
        public void endMessage(byte[] var1, int var2, int var3, boolean var4, int var5, Object var6);

        public void beginMessage(MarshalBuffer var1, Object var2);
    }
}

