/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.poa;

import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableServer.CurrentPackage.NoContext;
import org.omg.PortableServer.Servant;
import org.openorb.adapter.TargetInfo;
import org.openorb.adapter.poa.AOMEntry;
import org.openorb.adapter.poa.CurrentImpl;
import org.openorb.adapter.poa.POA;
import org.openorb.util.ExceptionTool;

class DispatchState
extends ServantObject
implements TargetInfo {
    private POA m_poa;
    private AOMEntry m_aom_entry;
    private Servant m_local_servant;
    private byte[] m_object_id;
    private CurrentImpl m_poa_current;
    private Object m_cookie;
    private String m_operation;
    private Thread m_work_thread;
    private boolean m_canceled;

    DispatchState(POA poa, AOMEntry aom_entry, CurrentImpl poaCurrent) {
        this.m_poa = poa;
        this.m_object_id = aom_entry.getObjectId();
        this.m_aom_entry = aom_entry;
        this.m_poa_current = poaCurrent;
        this.servant = aom_entry.getServant();
    }

    DispatchState(POA poa, Object servant, byte[] object_id, CurrentImpl poaCurrent) {
        this.m_poa = poa;
        this.m_object_id = object_id;
        this.m_poa_current = poaCurrent;
        this.servant = servant;
    }

    DispatchState(POA poa, Object servant, Servant local_servant, byte[] object_id, CurrentImpl poaCurrent) {
        this.m_poa = poa;
        this.m_local_servant = local_servant;
        this.m_object_id = object_id;
        this.m_poa_current = poaCurrent;
        this.servant = servant;
    }

    public String getRepositoryID() {
        return this.getServant()._all_interfaces(this.m_poa, this.m_object_id)[0];
    }

    public byte[] getAdapterID() {
        return this.m_poa.getAid();
    }

    public byte[] getObjectID() {
        if (this.m_aom_entry != null) {
            return this.m_aom_entry.getObjectId();
        }
        return this.m_object_id;
    }

    public Servant getServant() {
        return (Servant)(this.m_local_servant != null ? this.m_local_servant : this.servant);
    }

    public Object getCookie() {
        return this.m_cookie;
    }

    public void setCookie(Object cookie) {
        this.m_cookie = cookie;
    }

    public String getOperation() {
        return this.m_operation;
    }

    public void setOperation(String operation) {
        this.m_operation = operation;
    }

    public Thread getWorkThread() {
        return this.m_work_thread;
    }

    public void setWorkThread(Thread thread) {
        this.m_work_thread = thread;
    }

    public POA getPoa() {
        return this.m_poa;
    }

    public boolean isCanceled() {
        return this.m_canceled;
    }

    public void cancel() {
        this.m_canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean targetIsA(String id) {
        this.m_poa_current.push(this);
        try {
            boolean bl = this.getServant()._is_a(id);
            return bl;
        }
        finally {
            try {
                this.m_poa_current.pop();
            }
            catch (NoContext ex) {
                this.m_poa.getLogger().error("No Context available.", ex);
                throw ExceptionTool.initCause(new INTERNAL("No Context available (" + ex + ")"), (Throwable)ex);
            }
        }
    }
}

