/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.fwd;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagersListHelper;
import org.omg.CORBA.INTF_REPOS;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CORBA.RepositoryHelper;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.adapter.TargetInfo;
import org.openorb.corbaloc.CorbalocServiceHelper;
import org.openorb.corbaloc.CorbalocServiceOperations;
import org.openorb.net.Address;
import org.openorb.net.ServerManager;
import org.openorb.net.ServerRequest;
import org.openorb.util.ExceptionTool;

public class ForwardAdapter
implements ObjectAdapter,
CorbalocServiceOperations {
    public static final byte[] JDK_ID = "INIT".getBytes();
    public static final String CORBALOC_SVC_NAME = "CorbalocService";
    public static final byte[] CORBALOC_SVC_ID = "CorbalocService".getBytes();
    private static final byte[] NO_ADAPTER_ID = new byte[0];
    private static final Policy[] NO_POLICIES = new Policy[0];
    private Map m_target_map = new HashMap();
    private Object m_forwardIDef = null;
    private ORB m_orb;
    private Logger m_logger;
    private static final TargetInfo FORWARD_TI_JDK = new TargetInfo(){

        public byte[] getAdapterID() {
            return NO_ADAPTER_ID;
        }

        public String getRepositoryID() {
            return CorbalocServiceHelper.id();
        }

        public byte[] getObjectID() {
            return JDK_ID;
        }

        public boolean targetIsA(String id) {
            if (id.startsWith("IDL:omg.orb/CORBA/Object:1.")) {
                return true;
            }
            return id.equals(CorbalocServiceHelper.id());
        }
    };
    private static final TargetInfo FORWARD_TI_INIT = new TargetInfo(){

        public byte[] getAdapterID() {
            return NO_ADAPTER_ID;
        }

        public String getRepositoryID() {
            return CorbalocServiceHelper.id();
        }

        public byte[] getObjectID() {
            return CORBALOC_SVC_ID;
        }

        public boolean targetIsA(String id) {
            if (id.startsWith("IDL:omg.orb/CORBA/Object:1.")) {
                return true;
            }
            return id.equals(CorbalocServiceHelper.id());
        }
    };

    public ForwardAdapter(ServerManager server_manager) {
        server_manager.register_adapter(NO_ADAPTER_ID, this);
        this.m_orb = server_manager.orb();
    }

    public Object get(String initRef) {
        return this.resolve(initRef.getBytes());
    }

    public void put(String initRef, Object obj) {
        this.register(initRef.getBytes(), obj);
    }

    public Object resolve(byte[] key) {
        Target target = this.getTarget(key);
        if (target == null) {
            throw new BAD_PARAM("No target registered", 0, CompletionStatus.COMPLETED_NO);
        }
        return target.getDest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(byte[] oid, Object obj) {
        if (obj == null) {
            Target target = new Target(oid);
            Map map = this.m_target_map;
            synchronized (map) {
                this.m_target_map.remove(target);
            }
        }
        Target target = new Target(oid, obj);
        Map map = this.m_target_map;
        synchronized (map) {
            this.m_target_map.put(target, target);
        }
    }

    public String put_object(Object object, String path) {
        if (object == null) {
            throw new BAD_PARAM("Null object argument.");
        }
        org.openorb.CORBA.Delegate delegate = (org.openorb.CORBA.Delegate)((ObjectImpl)object)._get_delegate();
        Address[] address = delegate.getAddresses(object);
        String endpoint = null;
        int i = 0;
        while (i < address.length) {
            if (address[i].getProtocol().equals("iiop")) {
                endpoint = address[i].getEndpointString();
                break;
            }
            ++i;
        }
        if (endpoint == null) {
            endpoint = address[0].getEndpointString();
        }
        String name = path;
        name = path.startsWith("/") ? path.substring(1, path.length()) : path;
        this.put(name, object);
        return "corbaloc:" + endpoint + "/" + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Target getTarget(byte[] object_key) {
        Map map = this.m_target_map;
        synchronized (map) {
            return (Target)this.m_target_map.get(new Target(object_key));
        }
    }

    public int cache_priority() {
        return 0;
    }

    public boolean single_threaded() {
        return false;
    }

    public void etherealize(boolean cleanup_in_progress) {
    }

    public ServerManager.AdapterManager getAdapterManager() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectAdapter find_adapter(byte[] object_key) throws AdapterDestroyedException {
        Map map = this.m_target_map;
        synchronized (map) {
            if (this.m_target_map.containsKey(new Target(object_key))) {
                return this;
            }
        }
        if (Arrays.equals(object_key, JDK_ID) || Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return this;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] adapter_id(byte[] object_key) {
        Map map = this.m_target_map;
        synchronized (map) {
            if (this.m_target_map.containsKey(new Target(object_key))) {
                return NO_ADAPTER_ID;
            }
        }
        if (Arrays.equals(object_key, JDK_ID) || Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return NO_ADAPTER_ID;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] object_id(byte[] object_key) {
        Map map = this.m_target_map;
        synchronized (map) {
            if (this.m_target_map.containsKey(new Target(object_key))) {
                return object_key;
            }
        }
        if (Arrays.equals(object_key, JDK_ID) || Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return object_key;
        }
        return null;
    }

    public Policy[] get_server_policies(int[] ts) {
        return NO_POLICIES;
    }

    public boolean forced_marshal(byte[] object_key) throws AdapterDestroyedException {
        return false;
    }

    public ServantObject servant_preinvoke(byte[] object_key, String operation, Class expectedType) throws ForwardRequest, AdapterDestroyedException {
        if (!this.locate(object_key)) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        ServantObject ret = new ServantObject();
        ret.servant = this;
        return ret;
    }

    public void servant_postinvoke(byte[] object_key, ServantObject srvObject) {
    }

    public boolean locate(byte[] object_key) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(object_key, JDK_ID) || Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return true;
        }
        Target target = this.getTarget(object_key);
        if (target == null) {
            return false;
        }
        throw new ForwardRequest(target.getDest());
    }

    public boolean is_a(byte[] object_key, String repository_id) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(object_key, JDK_ID) || Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return repository_id.equals(CorbalocServiceHelper.id());
        }
        Target target = this.getTarget(object_key);
        if (target == null) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        return target.getDest()._is_a(repository_id);
    }

    public Object get_interface_def(byte[] object_key) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(object_key, JDK_ID) || Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return this.get_interface_def();
        }
        Target target = this.getTarget(object_key);
        if (target == null) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        return target.getDest()._get_interface_def();
    }

    private Object get_interface_def() {
        if (this.m_forwardIDef == null) {
            Repository rep;
            Object obj;
            try {
                obj = this.m_orb.resolve_initial_references("InterfaceRepository");
            }
            catch (InvalidName ex) {
                this.getLogger().error("Could not resolve InterfaceRepository.", ex);
                throw ExceptionTool.initCause(new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            if (obj._non_existent()) {
                throw new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO);
            }
            try {
                rep = RepositoryHelper.narrow(obj);
            }
            catch (BAD_PARAM ex) {
                this.getLogger().error("Could not narrow obj to type Repository.", ex);
                throw ExceptionTool.initCause(new INTF_REPOS(1146056719, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            this.m_forwardIDef = rep.lookup_id(CorbalocServiceHelper.id());
            if (this.m_forwardIDef == null) {
                throw new INTF_REPOS(1146056720, CompletionStatus.COMPLETED_NO);
            }
        }
        return this.m_forwardIDef;
    }

    public DomainManager[] get_domain_managers(byte[] object_key) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(object_key, JDK_ID) || Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return new DomainManager[0];
        }
        Target target = this.getTarget(object_key);
        if (target == null) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        return target.getDest()._get_domain_managers();
    }

    public Object get_component(byte[] object_key) throws ForwardRequest, AdapterDestroyedException {
        if (Arrays.equals(object_key, JDK_ID) || Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return null;
        }
        Target target = this.getTarget(object_key);
        if (target == null) {
            throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
        }
        Object obj = target.getDest();
        if (!(obj instanceof ObjectImpl)) {
            throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_NO);
        }
        Delegate deleg = ((ObjectImpl)obj)._get_delegate();
        if (!(deleg instanceof org.openorb.CORBA.Delegate)) {
            throw new BAD_OPERATION(0, CompletionStatus.COMPLETED_NO);
        }
        return ((org.openorb.CORBA.Delegate)deleg).get_component(obj);
    }

    public TargetInfo predispatch(ServerRequest req) throws ForwardRequest, AdapterDestroyedException {
        byte[] object_key = req.object_key();
        this.locate(object_key);
        if (Arrays.equals(object_key, JDK_ID)) {
            return FORWARD_TI_JDK;
        }
        if (Arrays.equals(object_key, CORBALOC_SVC_ID)) {
            return FORWARD_TI_INIT;
        }
        throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
    }

    public void dispatch(ServerRequest req, TargetInfo ti) {
        String opName = req.operation();
        InputStream is = req.argument_stream();
        if (opName.charAt(0) == '_') {
            if (opName.equals("_is_a")) {
                String repo_id = is.read_string();
                req.createReply().write_boolean(repo_id.equals(CorbalocServiceHelper.id()));
                return;
            }
            if (opName.equals("_get_domain_managers")) {
                DomainManagersListHelper.write(req.createReply(), new DomainManager[0]);
                return;
            }
            if (opName.equals("_interface")) {
                Object ret = this.get_interface_def();
                req.createReply().write_Object(ret);
                return;
            }
            if (opName.equals("_non_existent") || opName.equals("_not_existent")) {
                req.createReply().write_boolean(false);
                return;
            }
            if (opName.equals("_component")) {
                req.createReply().write_Object(null);
                return;
            }
        }
        if (opName.equals("get")) {
            String arg0_in = is.read_string();
            Object _arg_result = this.get(arg0_in);
            OutputStream os = req.createReply();
            os.write_Object(_arg_result);
        } else if (opName.equals("put")) {
            String arg0_in = is.read_string();
            Object arg1_in = is.read_Object();
            this.put(arg0_in, arg1_in);
            req.createReply();
        } else if (opName.equals("resolve")) {
            byte[] arg0_in = OctetSeqHelper.read(is);
            Object _arg_result = this.resolve(arg0_in);
            OutputStream os = req.createReply();
            os.write_Object(_arg_result);
        } else if (opName.equals("register")) {
            byte[] arg0_in = OctetSeqHelper.read(is);
            Object arg1_in = is.read_Object();
            this.register(arg0_in, arg1_in);
            req.createReply();
        } else {
            throw new BAD_OPERATION();
        }
    }

    public void cancel_dispatch(ServerRequest req, TargetInfo target) {
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    private static class Target {
        private Object m_dest;
        private byte[] m_key;
        private int m_hash;

        public Target(byte[] key) {
            this(key, null);
        }

        public Target(byte[] key, Object target) {
            this.m_key = key;
            this.m_dest = target;
            this.m_hash = 0;
            int i = 0;
            while (i < key.length) {
                this.m_hash = 31 * this.m_hash + (key[i] & 0xFF);
                ++i;
            }
        }

        public int hashCode() {
            return this.m_hash;
        }

        public Object getDest() {
            return this.m_dest;
        }

        public byte[] getKey() {
            return this.m_key;
        }

        public boolean equals(java.lang.Object obj) {
            if (!(obj instanceof Target)) {
                return false;
            }
            Target t2 = (Target)obj;
            if (this.m_hash != t2.m_hash || this.m_key.length != t2.m_key.length) {
                return false;
            }
            int i = 0;
            while (i < this.m_key.length) {
                if (this.m_key[i] != t2.m_key[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

