/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.UIManager;
import org.netbeans.core.windows.WorkspaceImpl;
import org.netbeans.core.windows.frames.LayoutResource;
import org.netbeans.core.windows.frames.LayoutResourceManager;

public class PerimeterLayout
implements LayoutManager,
LayoutResourceManager {
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    public static final String EAST = "EAST";
    public static final String WEST = "WEST";
    public static final String CENTER = "CENTER";
    public static final int FIRST_DOMINANT = 0;
    public static final int LAST_DOMINANT = 1;
    private static final int NORTHINDEX = 0;
    private static final int SOUTHINDEX = 1;
    private static final int EASTINDEX = 2;
    private static final int WESTINDEX = 3;
    private static final int CENTERINDEX = 4;
    static final ArrayList sideNames = new ArrayList(5);
    private int gap;
    private int minBreadth = 50;
    private Rectangle centerRect = null;
    private ArrayList sides = new ArrayList(5);
    private ArrayList dominance;
    private int dominancePolicy;

    public PerimeterLayout() {
        this.sides.add(null);
        this.sides.add(null);
        this.sides.add(null);
        this.sides.add(null);
        this.sides.add(null);
        this.dominance = new ArrayList(4);
        this.dominancePolicy = 0;
        this.gap = UIManager.getInt("nb.perimeter.gap");
        if (this.gap == 0) {
            this.gap = 4;
        }
    }

    public PerimeterLayout(int gap) {
        this();
        this.gap = gap;
    }

    public void addLayoutComponent(String sideName, Component comp) {
        int side = sideNames.indexOf(sideName);
        if (side != -1) {
            Object obj = this.sides.get(side);
            if (obj != null) {
                throw new IllegalArgumentException("Adding new component->" + comp + " at side->" + side + " which already contains->" + obj);
            }
            this.sides.set(side, comp);
            if (side != 4 && !this.dominance.contains(comp)) {
                switch (this.dominancePolicy) {
                    case 1: {
                        this.dominance.add(0, comp);
                        break;
                    }
                    case 0: {
                        this.dominance.add(comp);
                    }
                }
            }
            Dimension curSize = comp.getSize();
            if (curSize.width <= 0 || curSize.height <= 0) {
                comp.setSize(comp.getPreferredSize());
            }
        } else {
            throw new IllegalArgumentException("invalid constraint: " + sideName + " " + side);
        }
    }

    public void removeLayoutComponent(Component comp) {
        int side = this.sides.indexOf(comp);
        if (side != -1) {
            this.sides.set(side, null);
            ((AbstractCollection)this.dominance).remove(comp);
        }
    }

    public Dimension preferredLayoutSize(Container cont) {
        return cont.getSize();
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimMin;
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            Component component = null;
            component = this.getChild(4);
            if (component != null) {
                Dimension dimCenter = component.getMinimumSize();
                dimension.width += dimCenter.width;
                dimension.height += dimCenter.height;
            }
            if ((component = this.getChild(2)) != null) {
                Dimension dimEast = component.getMinimumSize();
                dimension.width += dimEast.width + this.gap;
                dimension.height = Math.max(dimEast.height, dimension.height);
            }
            if ((component = this.getChild(3)) != null) {
                Dimension dimWest = component.getMinimumSize();
                dimension.width += dimWest.width + this.gap;
                dimension.height = Math.max(dimWest.height, dimension.height);
            }
            if ((component = this.getChild(0)) != null) {
                Dimension dimNorth = component.getMinimumSize();
                dimension.width = Math.max(dimNorth.width, dimension.width);
                dimension.height += dimNorth.height + this.gap;
            }
            if ((component = this.getChild(1)) != null) {
                Dimension dimSouth = component.getMinimumSize();
                dimension.width = Math.max(dimSouth.width, dimension.width);
                dimension.height += dimSouth.height + this.gap;
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            dimMin = dimension;
        }
        return dimMin;
    }

    private Component getChild(int index) {
        return (Component)this.sides.get(index);
    }

    public Rectangle getPossibleBounds(Container cont, int sideAt, Rectangle originalBounds) {
        this.centerRect = cont.getBounds();
        this.centerRect.setLocation(0, 0);
        Insets insets = cont.getInsets();
        this.centerRect.x -= insets.top;
        this.centerRect.y -= insets.left;
        this.centerRect.width -= insets.left + insets.right;
        this.centerRect.height -= insets.top + insets.bottom;
        Rectangle contRect = (Rectangle)this.centerRect.clone();
        if (this.dominancePolicy == 1 && sideAt != 4) {
            return this.getBoundsOfSide(sideAt, contRect, originalBounds);
        }
        int i = 0;
        while (i < this.dominance.size()) {
            int side = this.sides.indexOf(this.dominance.get(i));
            Rectangle r = this.getBoundsOfSide(side, contRect, null);
            ++i;
        }
        if (this.dominancePolicy == 0 && sideAt != 4) {
            return this.getBoundsOfSide(sideAt, contRect, originalBounds);
        }
        Component centerComp = (Component)this.sides.get(4);
        if (centerComp != null) {
            return this.centerRect;
        }
        if (!this.dominance.isEmpty()) {
            centerComp = (Component)this.dominance.get(this.dominance.size() - 1);
            return centerComp.getBounds().union(this.centerRect);
        }
        return null;
    }

    private Rectangle getBoundsOfSide(int side, Rectangle contRect, Rectangle original) {
        Rectangle compRect;
        boolean btmRght;
        boolean vertical = side == 3 || side == 2;
        boolean bl = btmRght = side == 1 || side == 2;
        if (original == null) {
            Component comp = (Component)this.sides.get(side);
            compRect = comp.getBounds();
        } else {
            compRect = original;
        }
        if (vertical) {
            this.flip(compRect);
            this.flip(this.centerRect);
            this.flip(contRect);
        }
        compRect.x = this.centerRect.x;
        compRect.width = this.centerRect.width;
        int max = this.centerRect.height;
        int min = this.minBreadth + this.gap;
        max -= this.dominance.size() > 1 ? min : 0;
        if ((max -= this.sides.get(4) == null ? 0 : min) < min) {
            max = min;
        }
        if (compRect.height > max) {
            compRect.height = max;
        } else if (compRect.height < min) {
            compRect.height = min;
        }
        compRect.y = btmRght ? contRect.height - compRect.height : 0;
        if (!btmRght) {
            this.centerRect.y = compRect.height + this.gap;
        }
        this.centerRect.height -= compRect.height + this.gap;
        if (vertical) {
            this.flip(compRect);
            this.flip(this.centerRect);
            this.flip(contRect);
        }
        return compRect;
    }

    public void layoutContainer(Container cont) {
        this.centerRect = cont.getBounds();
        this.centerRect.setLocation(0, 0);
        Insets insets = cont.getInsets();
        this.centerRect.x -= insets.top;
        this.centerRect.y -= insets.left;
        this.centerRect.width -= insets.left + insets.right;
        this.centerRect.height -= insets.top + insets.bottom;
        Rectangle contRect = (Rectangle)this.centerRect.clone();
        int i = 0;
        while (i < this.dominance.size()) {
            int side = this.sides.indexOf(this.dominance.get(i));
            this.setPeriCompBounds(this.centerRect, contRect, side);
            ++i;
        }
        Component centerComp = (Component)this.sides.get(4);
        if (centerComp != null) {
            centerComp.setBounds(this.centerRect);
        } else if (!this.dominance.isEmpty()) {
            centerComp = (Component)this.dominance.get(this.dominance.size() - 1);
            centerComp.setBounds(centerComp.getBounds().union(this.centerRect));
        }
        this.relayout(0, 0);
    }

    private void setPeriCompBounds(Rectangle remaining, Rectangle container, int side) {
        Rectangle orig;
        boolean vertical = side == 3 || side == 2;
        boolean btmRght = side == 1 || side == 2;
        Component comp = (Component)this.sides.get(side);
        Rectangle compRect = comp.getBounds();
        if (vertical) {
            this.flip(compRect);
            this.flip(remaining);
            this.flip(container);
        }
        compRect.x = remaining.x;
        compRect.width = remaining.width;
        int max = remaining.height;
        int min = this.minBreadth + this.gap;
        max -= this.dominance.size() > 1 ? min : 0;
        compRect.height = compRect.height > (max -= this.sides.get(4) == null ? 0 : min) ? max : compRect.height;
        compRect.height = compRect.height < min ? min : compRect.height;
        compRect.y = btmRght ? container.height - compRect.height : 0;
        remaining.y = btmRght ? remaining.y : compRect.height + this.gap;
        remaining.height -= compRect.height + this.gap;
        if (vertical) {
            this.flip(compRect);
            this.flip(remaining);
            this.flip(container);
        }
        if (!(orig = comp.getBounds()).equals(compRect)) {
            comp.setBounds(compRect);
        }
    }

    private void flip(Rectangle rect) {
        int x = rect.x;
        int y = rect.y;
        int height = rect.height;
        int width = rect.width;
        rect.setSize(height, width);
        rect.setLocation(y, x);
    }

    public int getGap() {
        return this.gap;
    }

    public void setGap(int g) {
        this.gap = g;
    }

    public int getMinimumBreadth() {
        return this.minBreadth;
    }

    public void setMinimumBreadth(int d) {
        this.minBreadth = d;
    }

    public void setDominant(Component comp) {
        if (this.dominance.contains(comp)) {
            this.dominance.add(0, this.dominance.remove(this.dominance.indexOf(comp)));
        }
    }

    public void setDominant(String sideName) {
        int side = sideNames.indexOf(sideName);
        if (side > -1 && side < 4) {
            Component comp = (Component)this.sides.get(side);
            if (comp != null) {
                ((AbstractCollection)this.dominance).remove(comp);
                this.dominance.add(0, comp);
            }
        } else {
            throw new IllegalArgumentException("unknown constraint: " + side);
        }
    }

    public String getDominant() {
        int side = 0;
        Component dominant = (Component)this.dominance.get(0);
        side = 0;
        while (side < this.sides.size()) {
            if (this.sides.get(side) == dominant) {
                return (String)sideNames.get(side);
            }
            ++side;
        }
        return CENTER;
    }

    public void setDominancePolicy(int dominancePolicy) {
        if (dominancePolicy != 0 && dominancePolicy != 1) {
            throw new IllegalArgumentException("invalid dominance policy " + dominancePolicy);
        }
        this.dominancePolicy = dominancePolicy;
    }

    public int getDominancePolicy() {
        return this.dominancePolicy;
    }

    public List getDominance() {
        ArrayList result = new ArrayList(this.dominance.size());
        PerimeterLayout perimeterLayout = this;
        synchronized (perimeterLayout) {
            int curIndex = -1;
            Iterator iter = ((AbstractList)this.dominance).iterator();
            while (iter.hasNext()) {
                curIndex = this.sides.indexOf(iter.next());
                result.add(sideNames.get(curIndex));
            }
        }
        return result;
    }

    public void relayout(int width, int height) {
        if (this.sides.get(4) != null) {
            PerimeterLayout.relayoutWithGap(width, height, this.sides.toArray(new Component[this.sides.size()]), this.getGap());
        }
    }

    private static void relayoutWithGap(int width, int height, Component[] compos, int gap) {
        width += compos[3] == null ? 0 : gap;
        height += compos[0] == null ? 0 : gap;
        PerimeterLayout.relayoutComponent(width += compos[2] == null ? 0 : gap, height += compos[1] == null ? 0 : gap, compos[4]);
    }

    static void relayoutImpl(int width, int height, Component[] compos) {
        if (compos == null || compos.length == 0) {
            return;
        }
        int i = 0;
        while (i < compos.length) {
            PerimeterLayout.relayoutComponent(width, height, compos[i]);
            ++i;
        }
    }

    private static void relayoutComponent(int width, int height, Component c) {
        if (c instanceof LayoutResourceManager) {
            LayoutResourceManager lrm = (LayoutResourceManager)((Object)c);
            lrm.relayout(width, height);
        } else if (c instanceof LayoutResource) {
            LayoutResource lr = (LayoutResource)((Object)c);
            Rectangle relBounds = lr.getRelativeBounds();
            Rectangle bounds = c.getBounds();
            if (relBounds != null && bounds.equals(PerimeterLayout.computeBounds(relBounds, 0, 0, c))) {
                c.setBounds(PerimeterLayout.computeBounds(relBounds, width, height, c));
            }
        } else if (c instanceof Container) {
            PerimeterLayout.relayoutImpl(width, height, ((Container)c).getComponents());
        }
    }

    private static Rectangle computeBounds(Rectangle relBounds, int width, int height, Component c) {
        Rectangle wsBounds = PerimeterLayout.getWorkspaceBounds(c);
        Rectangle bounds = new Rectangle();
        bounds.x = wsBounds.width * relBounds.x / 100 + wsBounds.x;
        bounds.y = wsBounds.height * relBounds.y / 100 + wsBounds.y;
        bounds.width = wsBounds.width * relBounds.width / 100;
        bounds.height = wsBounds.height * relBounds.height / 100;
        bounds.width -= width;
        bounds.height -= height;
        bounds.width = Math.max(bounds.width, 0);
        bounds.height = Math.max(bounds.height, 0);
        return bounds;
    }

    private static Rectangle getWorkspaceBounds(Component c) {
        WorkspaceImpl ret = (WorkspaceImpl)((LayoutResource)((Object)c)).getWorkspace();
        return ret.getWorkingSpaceBounds();
    }

    static {
        sideNames.add(0, NORTH);
        sideNames.add(1, SOUTH);
        sideNames.add(2, EAST);
        sideNames.add(3, WEST);
        sideNames.add(4, CENTER);
    }
}

