/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.metal.MetalInternalFrameUI;

public class NbInternalFrameUI
extends MetalInternalFrameUI {
    BasicInternalFrameTitlePane titlePane = null;
    private static final JLabel renderer = new JLabel();

    public NbInternalFrameUI(JInternalFrame jf) {
        super(jf);
    }

    protected JComponent createNorthPane(JInternalFrame w) {
        this.titlePane = new NbTitlePane(w);
        return this.titlePane;
    }

    public JComponent getTitlePane() {
        return this.titlePane;
    }

    public class NbTitlePane
    extends BasicInternalFrameTitlePane {
        Font font = null;

        public NbTitlePane(JInternalFrame f) {
            super(f);
        }

        public void addNotify() {
            this.setLayout(new BasicInternalFrameTitlePane.TitlePaneLayout(this));
            super.addNotify();
        }

        public void paintBorder(Graphics g) {
            Border b = this.getBorder();
            if (b == null) {
                return;
            }
            Rectangle r = g.getClipRect();
            Rectangle backup = g.getClipRect();
            Insets i = b.getBorderInsets(this);
            r.height -= i.bottom;
            g.setClip(r);
            super.paintBorder(g);
            g.setClip(r);
        }

        public Font getFont() {
            if (this.font == null) {
                this.font = (Font)UIManager.get("windowTitleFont");
                if (this.font == null) {
                    this.font = (Font)UIManager.get("InternalFrame.titleFont");
                }
                if (this.font == null) {
                    this.font = super.getFont();
                }
            }
            return this.font;
        }

        public void paintComponent(Graphics g) {
            boolean sel = this.frame.isSelected();
            Color bg = sel ? this.selectedTitleColor : this.notSelectedTitleColor;
            Color fg = sel ? this.selectedTextColor : this.notSelectedTextColor;
            this.iconButton.setBackground(bg);
            this.maxButton.setBackground(bg);
            this.closeButton.setBackground(bg);
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Icon ic = this.frame.getFrameIcon();
            int h = ic.getIconHeight();
            int iconX = (this.getHeight() - h) / 2 - 1;
            renderer.setForeground(fg);
            renderer.setText(this.frame.getTitle());
            renderer.setIcon(this.frame.getFrameIcon());
            renderer.setFont(this.getFont());
            SwingUtilities.paintComponent(g, renderer, this, 2, iconX, this.getWidth() - 3, this.getHeight() - iconX);
            this.paintBorder(g);
            this.paintChildren(g);
        }

        public void paintChildren(Graphics g) {
            Boolean active = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            this.iconButton.putClientProperty("paintActive", active);
            this.maxButton.putClientProperty("paintActive", active);
            this.closeButton.putClientProperty("paintActive", active);
            super.paintChildren(g);
        }

        protected void addSubComponents() {
            this.add(this.iconButton);
            this.add(this.maxButton);
            this.add(this.closeButton);
        }

        protected void assembleSystemMenu() {
            this.menuBar = new JMenuBar();
        }

        protected void addSystemMenuItems(JMenu menu) {
        }

        protected void createButtons() {
            super.createButtons();
            this.iconButton.setBorder(null);
            this.maxButton.setBorder(null);
            this.closeButton.setBorder(null);
            Boolean paintActive = this.frame.isSelected() ? Boolean.TRUE : Boolean.FALSE;
            this.iconButton.putClientProperty("paintActive", paintActive);
            this.iconButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
            this.maxButton.putClientProperty("paintActive", paintActive);
            this.maxButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
            this.closeButton.putClientProperty("paintActive", paintActive);
            this.closeButton.getAccessibleContext().setAccessibleName(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        }
    }
}

