/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.frames;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import org.netbeans.core.ui.ArrowsTabbedPaneUI;
import org.netbeans.core.ui.PopupTabbedPaneUI;
import org.netbeans.core.windows.TabbedContainerUIManager;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.dnd.TopComponentDragSupport;
import org.netbeans.core.windows.dnd.WindowDnDManager;
import org.netbeans.core.windows.frames.CloseButtonTabbedPane;
import org.netbeans.core.windows.frames.DefaultContainerImpl;
import org.netbeans.core.windows.frames.NbFocusManager;
import org.netbeans.core.windows.frames.SplitContainerImpl;
import org.netbeans.core.windows.frames.TCCTabbedAreaImpl;
import org.netbeans.core.windows.frames.TabHandlePopupListener;
import org.netbeans.core.windows.frames.TopComponentContainer;
import org.netbeans.core.windows.util.DefaultReplacer;
import org.openide.actions.NextTabAction;
import org.openide.actions.PreviousTabAction;
import org.openide.modules.Dependency;
import org.openide.modules.SpecificationVersion;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class MultiTabbedContainerImpl
extends DefaultContainerImpl
implements ChangeListener {
    static final int NAME_CHANGE_DELTA = 1000;
    private CloseButtonTabbedPane tabc;
    private TopComponent wasSelected;
    private int tabPlacement;
    private int maxCount = 0;
    private int innerStatus = 0;
    private static final int EMPTY = 0;
    private static final int SINGLE = 1;
    private static final int MULTI = 2;
    private ArrayList areas = new ArrayList(1);
    private final Object COMPONENT_LOCK = new Object();
    static /* synthetic */ Class class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl;

    public MultiTabbedContainerImpl() {
        this((DefaultContainerImpl.SerializedData)null);
        this.areas.add(new TCCTabbedAreaImpl("CENTER"));
    }

    private MultiTabbedContainerImpl(DefaultContainerImpl.SerializedData serData) {
        super(serData);
        this.initGui();
        this.initListeners();
        NbFocusManager.install();
    }

    private void initGui() {
        this.tabc = new CloseButtonTabbedPane();
        if (WindowManagerImpl.isWindowDnDEnabled()) {
            WindowDnDManager.getDefault().getWindowDragSource().createDefaultDragGestureRecognizer(this.tabc, 3, TopComponentDragSupport.getDefault());
        }
        this.tabc.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl == null ? (class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl = MultiTabbedContainerImpl.class$("org.netbeans.core.windows.frames.MultiTabbedContainerImpl")) : class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl), (String)"ACSN_TabbedContainer"));
        this.tabc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl == null ? (class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl = MultiTabbedContainerImpl.class$("org.netbeans.core.windows.frames.MultiTabbedContainerImpl")) : class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl), (String)"ACSD_TabbedContainer"));
        this.changeUI();
        if (!Boolean.getBoolean("netbeans.windows.tabs_on_top")) {
            this.tabc.setTabPlacement(3);
        }
        this.setLayout(new BorderLayout());
    }

    private void initListeners() {
        this.tabc.addChangeListener(this);
        TabHandlePopupListener.install();
    }

    protected void attachComponents() {
        if (this.innerStatus == 2) {
            TopComponent[] curComps = this.getTopComponents();
            int i = 0;
            while (i < curComps.length) {
                TopComponent curComp = curComps[i];
                Image icon = curComp.getIcon();
                this.tabc.removeChangeListener(this);
                this.tabc.addTab(curComp.getName() + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE, icon == null ? null : new ImageIcon(icon), (Component)curComp, curComp.getToolTipText());
                this.tabc.addChangeListener(this);
                ++i;
            }
            if (this.wasSelected != null) {
                if (!this.containsTopComponent(this.wasSelected)) {
                    TopComponent[] tcs = this.getTopComponents();
                    this.wasSelected = tcs.length <= 0 ? null : tcs[tcs.length - 1];
                }
                if (this.wasSelected != null) {
                    this.tabc.setSelectedComponent((Component)this.wasSelected);
                }
                if (this.wasSelected != null && !this.wasSelected.isVisible()) {
                    this.wasSelected.setVisible(true);
                }
                this.setSelectedTopComponent(this.wasSelected);
            }
            if (this.getComponentCount() <= 0) {
                this.add(this.tabc);
            }
            this.tabc.validate();
        } else if (this.innerStatus == 1) {
            TopComponent selected = this.getSelectedTopComponent();
            this.add((Component)selected);
            if (!selected.isVisible()) {
                selected.setVisible(true);
            }
            this.invalidate();
            this.validate();
        }
    }

    protected void detachComponents() {
        if (this.innerStatus == 2) {
            this.wasSelected = (TopComponent)this.tabc.getSelectedComponent();
            this.tabc.removeChangeListener(this);
            this.tabc.removeAll();
            this.tabc.addChangeListener(this);
        } else if (this.innerStatus == 1) {
            this.remove((Component)this.getSelectedTopComponent());
        }
    }

    protected void componentAdded(TopComponent tc, Object constr, int orderWeight, TopComponentContainer.Area area) {
        this.doComponentAdded(tc, this.findPosition(orderWeight, constr));
    }

    protected void componentAdded(TopComponent tc) {
        this.doComponentAdded(tc, this.tabc.getTabCount());
    }

    private void doComponentAdded(TopComponent tc, int position) {
        Image icon = tc.getIcon();
        TopComponent current = this.getSelectedTopComponent();
        TopComponentContainer.Area curArea = (TopComponentContainer.Area)this.areas.get(0);
        Object object = this.COMPONENT_LOCK;
        synchronized (object) {
            curArea.getComponentsList().add(position, tc);
            switch (this.innerStatus) {
                case 0: {
                    if (SplitContainerImpl.hasAlonePolicy(tc)) {
                        this.innerStatus = 1;
                        this.setSelectedTopComponent(tc);
                        if (!this.isAttached()) break;
                        this.add((Component)tc);
                        break;
                    }
                }
                case 1: {
                    this.innerStatus = 2;
                    if (SplitContainerImpl.hasAlonePolicy(current)) {
                        if (current.equals(TopComponent.getRegistry().getActivated())) {
                            this.doActivateComponent(null);
                        }
                        this.removeAll();
                        this.add((Component)this.tabc, "Center");
                        Image currIcon = current.getIcon();
                        if (this.isAttached()) {
                            this.tabc.addTab(current.getName() + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE, currIcon == null ? null : new ImageIcon(currIcon), (Component)current, current.getToolTipText());
                        }
                    }
                }
                case 2: {
                    if (!this.isAttached()) break;
                    int tabCount = this.tabc.getTabCount();
                    if (position > tabCount) {
                        position = tabCount;
                    }
                    this.tabc.insertTab(tc.getName() + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE, icon == null ? null : new ImageIcon(icon), (Component)tc, tc.getToolTipText(), position);
                }
            }
            this.refreshAfterAdding(tc);
        }
    }

    protected void componentRemoved(TopComponent tc) {
        int count = -1;
        Object object = this.COMPONENT_LOCK;
        synchronized (object) {
            TopComponent[] tcs = this.getTopComponents();
            switch (this.innerStatus) {
                case 1: {
                    this.innerStatus = 0;
                    this.removeFromArea(tc);
                    this.doActivateComponent(null);
                    this.remove((Component)tc);
                    break;
                }
                case 2: {
                    if (tcs.length == 1 && SplitContainerImpl.hasAlonePolicy(tcs[0])) {
                        this.innerStatus = 1;
                        this.removeFromArea(tc);
                        this.tabc.removeChangeListener(this);
                        this.tabc.removeAll();
                        this.tabc.addChangeListener(this);
                        tc.getAccessibleContext().setAccessibleParent(null);
                        this.remove(this.tabc);
                        if (!this.isAttached()) break;
                        final TopComponent singleTc = tcs[0];
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                singleTc.setVisible(true);
                                if (MultiTabbedContainerImpl.this.mode != null) {
                                    MultiTabbedContainerImpl.this.mode.updateTitle();
                                }
                            }
                        });
                        this.add((Component)singleTc);
                        this.setSelectedTopComponent(singleTc);
                        this.reactivateSelectedComponent();
                        break;
                    }
                    int index = this.tabc.indexOfComponent((Component)tc);
                    this.removeFromArea(tc);
                    if (index != -1) {
                        this.tabc.removeChangeListener(this);
                        this.tabc.removeTabAt(index);
                        this.tabc.addChangeListener(this);
                        tc.getAccessibleContext().setAccessibleParent(null);
                        this.setSelectedTopComponent((TopComponent)this.tabc.getSelectedComponent());
                        this.reactivateSelectedComponent();
                    }
                    this.tabc.invalidate();
                    this.tabc.validate();
                    this.tabc.repaint();
                }
            }
        }
    }

    private void removeFromArea(TopComponent tc) {
        List compList = ((TopComponentContainer.Area)this.areas.get(0)).getComponentsList();
        compList.remove(tc);
    }

    public void requestVisible(TopComponent tc) {
        if (this.isActivated()) {
            tc.requestFocus();
        } else if (this.innerStatus == 2 && this.tabc.indexOfComponent((Component)tc) >= 0) {
            this.tabc.removeChangeListener(this);
            this.setSelectedTopComponent(tc);
            this.tabc.addChangeListener(this);
        }
    }

    public boolean canAdd(TopComponent[] tc) {
        int newSize = this.getTopComponents().length + (tc == null ? 0 : tc.length);
        return this.maxCount <= 0 || newSize <= this.maxCount;
    }

    public Object getConstraints(TopComponent tc) {
        return "CENTER";
    }

    public void destroy() {
        this.tabc.removeChangeListener(this);
        this.remove(this.tabc);
    }

    public List getConstraintsOrder() {
        return null;
    }

    public void setConstraintsOrder(List constraints) {
    }

    public List getAreas() {
        return this.areas;
    }

    public TopComponentContainer.Area getArea(Object constraint) {
        if ("CENTER".equals(constraint)) {
            return (TopComponentContainer.Area)this.areas.get(0);
        }
        return null;
    }

    public void setMaxCount(int maxCount) {
        this.maxCount = maxCount;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    protected void componentNameChanged(TopComponent component) {
        if (!this.containsTopComponent(component)) {
            return;
        }
        String newName = component.getName();
        int compIndex = this.tabc.indexOfComponent((Component)component);
        if (compIndex < 0) {
            return;
        }
        this.tabc.setTitleAt(compIndex, newName + CloseButtonTabbedPane.TAB_NAME_TRAILING_SPACE);
        this.tabc.invalidate();
        this.tabc.validate();
        this.tabc.repaint();
        this.fireNameChange(newName);
    }

    protected void componentIconChanged(TopComponent component, Image icon) {
        if (!this.containsTopComponent(component)) {
            return;
        }
        if (this.innerStatus == 2) {
            int compIndex = this.tabc.indexOfComponent((Component)component);
            if (compIndex < 0) {
                return;
            }
            this.tabc.setIconAt(compIndex, new ImageIcon(icon));
            if (this.isAttached()) {
                this.tabc.revalidate();
                this.tabc.repaint();
            }
        }
    }

    protected void actionPerformed(TopComponent selected, SystemAction action, boolean processed) {
        if (processed) {
            return;
        }
        if (action instanceof NextTabAction || action instanceof PreviousTabAction) {
            int count = this.tabc.getTabCount();
            int index = this.tabc.indexOfComponent((Component)selected);
            if (count <= 1 || index == -1) {
                return;
            }
            int delta = action instanceof NextTabAction ? 1 : -1;
            int newIndex = (index + delta + count) % count;
            this.tabc.setSelectedIndex(newIndex);
        }
    }

    protected void refreshAfterAdding(TopComponent tc) {
        if (this.isAttached() && this.innerStatus == 2) {
            this.componentSelected(tc);
            if (!tc.isVisible()) {
                tc.setVisible(true);
            }
            this.tabc.invalidate();
            this.tabc.validate();
            this.tabc.repaint();
        }
    }

    protected void componentSelected(TopComponent tc) {
        if (this.innerStatus == 2 && this.tabc.indexOfComponent((Component)tc) >= 0) {
            this.tabc.setSelectedComponent((Component)tc);
        }
    }

    protected List getHiddingComponents(Set shownTcs, TopComponent showing) {
        List<TopComponent> hidding = null;
        Iterator it = shownTcs.iterator();
        while (it.hasNext()) {
            TopComponent tc = (TopComponent)it.next();
            if (!this.containsTopComponent(tc)) continue;
            it.remove();
            hidding = Collections.singletonList(tc);
            break;
        }
        return hidding;
    }

    public void checkShownComponents() {
        TopComponent sel = this.getSelectedTopComponent();
        if (sel != null) {
            this.updateShownComponents(sel);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl == null ? (class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl = MultiTabbedContainerImpl.class$("org.netbeans.core.windows.frames.MultiTabbedContainerImpl")) : class$org$netbeans$core$windows$frames$MultiTabbedContainerImpl);
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.isVisible() || !this.isShowing() || this.tabc.getTabCount() <= 0 || this.innerStatus != 2) {
            return;
        }
        int index = this.tabc.getSelectedIndex();
        TopComponent current = index < 0 ? null : (TopComponent)this.tabc.getSelectedComponent();
        this.setSelectedTopComponent(current);
        this.reactivateSelectedComponent();
    }

    public void setTabPlacement(int tabPlacement) {
        if (this.tabPlacement == tabPlacement) {
            return;
        }
        this.tabPlacement = tabPlacement;
        this.tabc.setTabPlacement(tabPlacement);
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void validateData() {
        super.validateData();
        TopComponent[] tcs = this.getTopComponents();
        this.innerStatus = tcs.length <= 0 ? 0 : (tcs.length == 1 && SplitContainerImpl.hasAlonePolicy(tcs[0]) ? 1 : 2);
        this.wasSelected = this.getSelectedTopComponent();
        List areaCompList = ((TopComponentContainer.Area)this.areas.get(0)).getComponentsList();
        int i = 0;
        while (i < tcs.length) {
            TopComponent curTc = tcs[i];
            if (!areaCompList.contains(curTc)) {
                this.componentAdded(curTc, "CENTER", Integer.MAX_VALUE, null);
            }
            ++i;
        }
    }

    public void changeUI() {
        boolean jdk14 = Dependency.JAVA_SPEC.compareTo((Object)new SpecificationVersion("1.4")) >= 0;
        switch (TabbedContainerUIManager.getDefault().getTabbedContainerUI()) {
            case 1: {
                if (jdk14) {
                    MultiTabbedContainerImpl.setTabLayoutPolicyForPane(0, this.tabc);
                    break;
                }
                if (this.tabc.getUI() instanceof BasicTabbedPaneUI) break;
                MultiTabbedContainerImpl.updateUITypeForTab(this.tabc, 0);
                break;
            }
            case 2: {
                if (jdk14) {
                    MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabc);
                    break;
                }
                if (this.tabc.getUI() instanceof ArrowsTabbedPaneUI) break;
                MultiTabbedContainerImpl.updateUITypeForTab(this.tabc, 1);
                break;
            }
            case 3: {
                if (jdk14) {
                    MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabc);
                    break;
                }
                if (this.tabc.getUI() instanceof PopupTabbedPaneUI) break;
                MultiTabbedContainerImpl.updateUITypeForTab(this.tabc, 2);
                break;
            }
            case 4: {
                if (jdk14) {
                    MultiTabbedContainerImpl.setTabLayoutPolicyForPane(1, this.tabc);
                    break;
                }
                if (this.tabc.getUI() instanceof ArrowsTabbedPaneUI) break;
                MultiTabbedContainerImpl.updateUITypeForTab(this.tabc, 1);
            }
        }
    }

    static void setTabLayoutPolicyForPane(int policy, JTabbedPane pane) {
        Integer param = policy == 0 ? new Integer(0) : new Integer(1);
        try {
            Method method = pane.getClass().getMethod("setTabLayoutPolicy", Integer.TYPE);
            method.invoke((Object)pane, param);
        }
        catch (NoSuchMethodException nme) {
        }
        catch (SecurityException se) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (IllegalArgumentException iare) {
        }
        catch (InvocationTargetException ite) {
            // empty catch block
        }
    }

    private void fireNameChange(String newName) {
        this.firePropertyChange("name", null, newName);
    }

    private static void updateUITypeForTab(CloseButtonTabbedPane dynUITab, int uiType) {
        dynUITab.setUIType(uiType);
        SwingUtilities.updateComponentTreeUI(dynUITab);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this);
    }

    public static DefaultReplacer.ResVersionable getOldSerializator() {
        return new Version1();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Version1
    implements DefaultReplacer.ResVersionable {
        public static final String NAME = "Version_1.0";
        int innerStatus;
        String workspaceName;
        String modeName;
        Rectangle bounds;
        ArrayList tcManagers;
        WindowManagerImpl.TopComponentManager currentTcm;

        Version1() {
        }

        public String getName() {
            return NAME;
        }

        public void readData(ObjectInput in) throws IOException, ClassNotFoundException {
            this.innerStatus = (Integer)in.readObject();
            this.workspaceName = (String)in.readObject();
            this.modeName = (String)in.readObject();
            this.bounds = (Rectangle)in.readObject();
            this.tcManagers = (ArrayList)in.readObject();
            WindowManagerImpl.TopComponentManager[] tcmArray = this.tcManagers.toArray(new WindowManagerImpl.TopComponentManager[this.tcManagers.size()]);
            int i = tcmArray.length - 1;
            while (i >= 0) {
                if (tcmArray[i] == null) {
                    this.tcManagers.remove(i);
                }
                --i;
            }
            Object temp = in.readObject();
            this.currentTcm = (WindowManagerImpl.TopComponentManager)temp;
        }

        public void writeData(ObjectOutput out) throws IOException {
            throw new InternalError();
        }

        public Object resolveData() throws ObjectStreamException {
            MultiTabbedContainerImpl result = new MultiTabbedContainerImpl();
            result.innerStatus = this.innerStatus;
            DefaultContainerImpl.SerializedData oldSerData = new DefaultContainerImpl.SerializedData(result, this.modeName, this.workspaceName, this.tcManagers, this.currentTcm);
            result.attachData(oldSerData);
            return result;
        }
    }

    private static final class SerializationReplacer
    implements Serializable {
        static final long serialVersionUID = 2202987849834763838L;
        private MultiTabbedContainerImpl source;
        public static final String DEFAULT_CONTAINER = "defaultContainer";
        private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("defaultContainer", class$org$netbeans$core$windows$frames$DefaultContainerImpl == null ? (class$org$netbeans$core$windows$frames$DefaultContainerImpl = SerializationReplacer.class$("org.netbeans.core.windows.frames.DefaultContainerImpl")) : class$org$netbeans$core$windows$frames$DefaultContainerImpl)};
        static /* synthetic */ Class class$org$netbeans$core$windows$frames$DefaultContainerImpl;

        SerializationReplacer(MultiTabbedContainerImpl source) {
            this.source = source;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            ObjectOutputStream.PutField pf = oos.putFields();
            pf.put(DEFAULT_CONTAINER, new DefaultContainerImpl.SerializedData(this.source));
            oos.writeFields();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.source = new MultiTabbedContainerImpl();
            ObjectInputStream.GetField gf = ois.readFields();
            this.source.attachData((DefaultContainerImpl.SerializedData)gf.get(DEFAULT_CONTAINER, null));
        }

        private synchronized Object readResolve() throws ObjectStreamException {
            return this.source;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

