/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.windows.SelectedNodesChangedEvent;
import org.netbeans.core.windows.StateManager;
import org.netbeans.core.windows.TopComponentChangedEvent;
import org.netbeans.core.windows.TopComponentListener;
import org.netbeans.core.windows.WindowManagerImpl;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class RegistryImpl
implements TopComponent.Registry,
TopComponentListener,
StateManager.StateListener {
    private TopComponent activatedTopComponent;
    private HashSet openSet;
    private Node[] current;
    private Node[] activated;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean listenerInited;

    public RegistryImpl() {
        this.openSet = new HashSet(30);
        this.activated = new Node[0];
        WindowManagerImpl.getInstance().addTopComponentListener(this);
    }

    public synchronized Set getOpened() {
        return Collections.unmodifiableSet(this.openSet);
    }

    public TopComponent getActivated() {
        return this.activatedTopComponent;
    }

    public Node[] getCurrentNodes() {
        if (this.activatedTopComponent == null) {
            return NbTopManager.getUninitialized().getDefaultNodes(false);
        }
        return this.current;
    }

    public Node[] getActivatedNodes() {
        if (this.activatedTopComponent == null) {
            return NbTopManager.getUninitialized().getDefaultNodes(true);
        }
        return this.activated;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public void topComponentActivated(TopComponentChangedEvent ev) {
        TopComponent old = this.activatedTopComponent;
        this.activatedTopComponent = ev.topComponent;
        Window w = ev.topComponent == null ? null : SwingUtilities.windowForComponent((Component)ev.topComponent);
        RegistryImpl.cancelMenu(w);
        if (old == this.activatedTopComponent) {
            return;
        }
        this.support.firePropertyChange("activated", old, this.activatedTopComponent);
        if (old == null && this.activatedTopComponent != null) {
            this.support.firePropertyChange("activatedNodes", new Node[0], this.activated);
        } else if (old != null && this.activatedTopComponent == null) {
            this.support.firePropertyChange("activatedNodes", this.activated, new Node[0]);
        }
    }

    public synchronized void topComponentOpened(TopComponentChangedEvent ev) {
        if (this.openSet.contains(ev.topComponent)) {
            return;
        }
        Set old = (Set)this.openSet.clone();
        this.openSet.add(ev.topComponent);
        this.support.firePropertyChange("opened", old, this.openSet);
    }

    public synchronized void topComponentClosed(TopComponentChangedEvent ev) {
        if (!this.openSet.contains(ev.topComponent)) {
            return;
        }
        WindowManagerImpl wm = (WindowManagerImpl)WindowManager.getDefault();
        Workspace[] workspaces = wm.getWorkspaces();
        int i = 0;
        while (i < workspaces.length) {
            if (WindowManagerImpl.findManager(ev.topComponent).isOpened(workspaces[i])) {
                return;
            }
            ++i;
        }
        Set old = (Set)this.openSet.clone();
        this.openSet.remove(ev.topComponent);
        this.support.firePropertyChange("opened", old, this.openSet);
    }

    public void selectedNodesChanged(SelectedNodesChangedEvent ev) {
        Object[] old = this.current;
        Object[] c = ev.getSelectedNodes();
        if (this.activatedTopComponent != null && !this.activatedTopComponent.equals(ev.topComponent)) {
            return;
        }
        if (Arrays.equals(old, c)) {
            return;
        }
        if (!this.listenerInited) {
            this.listenerInited = true;
            StateManager.getDefault().addStateListener(this);
        }
        this.current = c == null ? null : (Node[])c.clone();
        this.tryFireChanges(StateManager.getDefault().getState(), (Node[])old, this.current);
    }

    public void stateChanged(int state) {
        this.tryFireChanges(state, null, this.current);
    }

    static void cancelMenu(Window window) {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        MenuElement[] path = msm.getSelectedPath();
        int i = 0;
        while (i < path.length) {
            Window w = SwingUtilities.windowForComponent(path[i].getComponent());
            if (w != null && (w == window || w.getOwner() == window)) {
                return;
            }
            ++i;
        }
        msm.clearSelectedPath();
    }

    private void tryFireChanges(int state, Node[] oldNodes, Node[] newNodes) {
        if (state == 33) {
            this.support.firePropertyChange("currentNodes", oldNodes, newNodes);
            if (newNodes != null) {
                oldNodes = this.activated;
                this.activated = newNodes;
                this.support.firePropertyChange("activatedNodes", oldNodes, this.activated);
            }
        }
    }
}

