/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.netbeans.core.ui.CleanTabbedPaneUI;
import org.openide.awt.JPopupMenuPlus;

public class PopupTabbedPaneUI
extends CleanTabbedPaneUI {
    public static final int TAB_LIST_INDICATE_NONE = 0;
    public static final int TAB_LIST_INDICATE_CHECKBOX = 1;
    public static final int TAB_LIST_INDICATE_CHECKBOXALL = 2;
    public static final int TAB_LIST_INDICATE_RADIOBUTTON = 3;
    public static final int TAB_LIST_INDICATE_RADIOBUTTONALL = 4;
    private static final int TAB_LIST_INDICATE_DEFAULT = 3;
    private static final int TAB_LIST_INDICATE_MIN = 0;
    private static final int TAB_LIST_INDICATE_MAX = 4;
    private static final boolean SORT_TABLIST_DEFAULT = false;
    private static final String SORT_TEXT_DEFAULT = null;
    private static final int SIZE_MINIMUM = 1;
    private static final int SIZE_MAXIMUM = 2;
    private static final int SIZE_PREFERRED = 3;
    private static final int TAB_SPACE_LEFT = 2;
    private static final int TAB_SPACE_RIGHT = 3;
    private static final int TAB_SPACE_TOP = 2;
    private static final int TAB_SPACE_BOTTOM = 3;
    private static final int TAB_SPACE_MIDDLE = 3;
    private static final int TAB_SPACE_LINE_STRAIGHT = 3;
    private static final int TAB_SPACE_LINE_ASKEW = 3;
    private static final int TAB_SPACE_LINE_LENGTH = 10;
    private static final int TAB_SPACE_LINE_WIDTH = 6;
    private static final int TAB_SPACE_LEFTRIGHT = 5;
    private static final int TAB_SPACE_LEFTRIGHTMIDDLE = 8;
    private static final int TAB_SPACE_LEFTMIDDLELINE = 11;
    private static final int TAB_SPACE_LEFTRIGHTMIDDLELINE = 14;
    private static final int TAB_SPACE_RIGHTLINE = 9;
    private static final int TAB_SPACE_TOPBOTTOM = 5;
    private static final int TAB_SPACE_TOPBOTTOMMIDDLE = 8;
    private static final int TAB_SPACE_TOPMIDDLELINE = 11;
    private static final int TAB_SPACE_TOPBOTTOMMIDDLELINE = 14;
    private static final int TAB_SPACE_BOTTOMLINE = 9;
    private static final Color COLOR_LINE = UIManager.getColor("TabbedPane.darkShadow");
    private boolean sorttabslist = false;
    private int listtabindicate = 3;
    private String sorttext = SORT_TEXT_DEFAULT;
    private JTabbedPane tabbedpane = null;
    private JPopupMenuPlus popupmenu = null;
    private LayoutManager layoutmanager = null;
    private Rectangle tabbounds = new Rectangle(0, 0, 0, 0);
    private ChangeListener changeListener = new TabbedPabeChangeListener();
    private TabbedPaneMouseListener mouselistener = new TabbedPaneMouseListener();
    private MenuItemComparator comparator = null;

    public PopupTabbedPaneUI() {
        this(false, 3, SORT_TEXT_DEFAULT);
    }

    public PopupTabbedPaneUI(boolean sorttabslist) {
        this(sorttabslist, 3, SORT_TEXT_DEFAULT);
    }

    public PopupTabbedPaneUI(int listtabindicate) {
        this(false, listtabindicate, SORT_TEXT_DEFAULT);
    }

    public PopupTabbedPaneUI(String sorttext) {
        this(false, 3, sorttext);
    }

    public PopupTabbedPaneUI(boolean sorttabslist, int listtabindicate) {
        this(sorttabslist, listtabindicate, SORT_TEXT_DEFAULT);
    }

    public PopupTabbedPaneUI(boolean sorttabslist, String sorttext) {
        this(sorttabslist, 3, sorttext);
    }

    public PopupTabbedPaneUI(int listtabindicate, String sorttext) {
        this(false, listtabindicate, sorttext);
    }

    public PopupTabbedPaneUI(boolean sorttabslist, int listtabindicate, String sorttext) {
        this.setSortTabsList(sorttabslist);
        this.setListTabIndicate(listtabindicate);
        this.setSortText(sorttext);
    }

    public int tabForCoordinate(JTabbedPane tabbedpane, int x, int y) {
        return this.tabbedpane.getSelectedIndex();
    }

    public Rectangle getTabBounds(JTabbedPane tabbedpane, int index) {
        return null;
    }

    public int getTabRunCount(JTabbedPane tabbedpane) {
        return 0;
    }

    public static ComponentUI createUI(JComponent component) {
        return new PopupTabbedPaneUI();
    }

    public void installUI(JComponent component) {
        this.tabbedpane = (JTabbedPane)component;
        this.layoutmanager = this.tabbedpane.getLayout();
        this.tabbedpane.setLayout(this.createLayoutManager());
        this.installListeners();
    }

    public void uninstallUI(JComponent component) {
        this.tabbedpane.setLayout(this.layoutmanager);
        this.uninstallListeners();
        if (this.popupmenu != null) {
            this.popupmenu.setVisible(false);
        }
        this.tabbedpane = null;
    }

    public void paint(Graphics graphics, JComponent component) {
        this.paintTabs(graphics);
        this.paintBorder(graphics);
    }

    public void setSortTabsList(boolean sorttabslist) {
        this.sorttabslist = sorttabslist;
    }

    public boolean getSortTabsList() {
        return this.sorttabslist;
    }

    private void changeSortTabsList(int popupmenux, int popupmenuy) {
        this.sorttabslist = !this.sorttabslist;
        this.displayTabList(popupmenux, popupmenuy);
    }

    public boolean setListTabIndicate(int listtabindicate) {
        if (listtabindicate < 0 || listtabindicate > 4) {
            return false;
        }
        this.listtabindicate = listtabindicate;
        return true;
    }

    public int getListTabIndicate() {
        return this.listtabindicate;
    }

    public void setSortText(String sorttext) {
        this.sorttext = sorttext;
    }

    public String getSortText() {
        return this.sorttext;
    }

    protected LayoutManager createLayoutManager() {
        return new TabbedPaneLayout();
    }

    protected void installListeners() {
        this.tabbedpane.addChangeListener(this.changeListener);
        this.tabbedpane.addMouseListener(this.mouselistener);
    }

    protected void uninstallListeners() {
        this.tabbedpane.removeChangeListener(this.changeListener);
        this.tabbedpane.removeMouseListener(this.mouselistener);
    }

    private void paintTabs(Graphics graphics) {
        int length;
        int placement = this.tabbedpane.getTabPlacement();
        int width = this.tabbedpane.getWidth();
        int height = this.tabbedpane.getHeight();
        Insets insets = this.tabbedpane.getInsets();
        int n = length = placement == 1 || placement == 3 ? width - insets.left - insets.right - 5 : height - insets.top - insets.bottom - 5;
        if (length > 0) {
            int count = length / 10;
            Point position = new Point(placement == 4 ? width - insets.right - 9 : insets.left + 2, placement == 3 ? height - insets.bottom - 9 : insets.top + 2);
            this.tabbounds.setBounds(position.x, position.y, 0, 0);
            if (count == 0) {
                this.paintTab(graphics, position, length, placement);
            } else {
                int i = 0;
                while (i < count) {
                    this.paintTab(graphics, position, 10, placement);
                    ++i;
                }
            }
            this.tabbounds.setSize(placement == 1 || placement == 3 ? length : 6, placement == 2 || placement == 4 ? length : 6);
        } else {
            this.tabbounds.setBounds(0, 0, 0, 0);
        }
    }

    private void paintTab(Graphics graphics, Point position, int length, int placement) {
        Color color = graphics.getColor();
        graphics.setColor(COLOR_LINE);
        switch (placement) {
            case 3: {
                graphics.drawLine(position.x, position.y, position.x + length, position.y);
                graphics.drawLine(position.x, position.y, position.x, position.y + 3);
                graphics.drawLine(position.x, position.y + 3, position.x + 3, position.y + 6);
                graphics.drawLine(position.x + 3, position.y + 6, position.x + length, position.y + 6);
                graphics.drawLine(position.x + length, position.y, position.x + length, position.y + 6);
                position.x += length;
                break;
            }
            case 2: {
                graphics.drawLine(position.x + 6, position.y, position.x + 6, position.y + length);
                graphics.drawLine(position.x + 6, position.y, position.x + 3, position.y);
                graphics.drawLine(position.x + 3, position.y, position.x, position.y + 3);
                graphics.drawLine(position.x, position.y + 3, position.x, position.y + length);
                graphics.drawLine(position.x + 6, position.y + length, position.x, position.y + length);
                position.y += length;
                break;
            }
            case 4: {
                graphics.drawLine(position.x, position.y, position.x, position.y + length);
                graphics.drawLine(position.x, position.y, position.x + 3, position.y);
                graphics.drawLine(position.x + 3, position.y, position.x + 6, position.y + 3);
                graphics.drawLine(position.x + 6, position.y + 3, position.x + 6, position.y + length);
                graphics.drawLine(position.x, position.y + length, position.x + 6, position.y + length);
                position.y += length;
                break;
            }
            default: {
                graphics.drawLine(position.x, position.y + 6, position.x + length, position.y + 6);
                graphics.drawLine(position.x, position.y + 6, position.x, position.y + 3);
                graphics.drawLine(position.x, position.y + 3, position.x + 3, position.y);
                graphics.drawLine(position.x + 3, position.y, position.x + length, position.y);
                graphics.drawLine(position.x + length, position.y, position.x + length, position.y + 6);
                position.x += length;
            }
        }
        graphics.setColor(color);
    }

    private void paintBorder(Graphics graphics) {
    }

    private Dimension calculateSize(int sizetype) {
        int count = this.tabbedpane.getTabCount();
        int placement = this.tabbedpane.getTabPlacement();
        Dimension dimension = new Dimension(0, 0);
        Insets insets = this.tabbedpane.getInsets();
        int i = 0;
        while (i < count) {
            Dimension dimensioncomponent = this.getComponentSize(this.tabbedpane.getComponent(i), sizetype);
            if (dimensioncomponent.width > dimension.width) {
                dimension.width = dimensioncomponent.width;
            }
            if (dimensioncomponent.height > dimension.height) {
                dimension.height = dimensioncomponent.height;
            }
            ++i;
        }
        dimension.width = dimension.width + ((placement == 2 || placement == 4 ? 8 : 5) + insets.left + insets.right);
        dimension.height = dimension.height + ((placement == 1 || placement == 3 ? 8 : 5) + insets.top + insets.bottom);
        return dimension;
    }

    private Dimension getComponentSize(Component component, int sizetype) {
        switch (sizetype) {
            case 1: {
                return component.getMinimumSize();
            }
            case 2: {
                return component.getMaximumSize();
            }
        }
        return component.getPreferredSize();
    }

    private void initPopupMenu() {
        if (this.popupmenu == null) {
            this.popupmenu = new JPopupMenuPlus();
        } else {
            this.popupmenu.removeAll();
        }
    }

    private Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new MenuItemComparator();
        }
        return this.comparator;
    }

    private void displayTabList(int x, int y) {
        JCheckBoxMenuItem menuitem;
        int count = this.tabbedpane.getTabCount();
        int actual = this.tabbedpane.getSelectedIndex();
        Object[] items = this.sorttabslist ? new Object[count] : null;
        this.initPopupMenu();
        if (this.sorttext != null) {
            menuitem = new JCheckBoxMenuItem(this.sorttext, this.sorttabslist);
            final int positionX = x;
            final int positionY = y;
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PopupTabbedPaneUI.this.changeSortTabsList(positionX, positionY);
                }
            });
            this.popupmenu.add(menuitem);
            this.popupmenu.add(new JSeparator());
        }
        int i = 0;
        while (i < count) {
            final int index = i;
            menuitem = this.listtabindicate == 2 || this.listtabindicate == 1 && i == actual ? new JCheckBoxMenuItem(this.tabbedpane.getTitleAt(i), i == actual) : (this.listtabindicate == 4 || this.listtabindicate == 3 && i == actual ? new JRadioButtonMenuItem(this.tabbedpane.getTitleAt(i), i == actual) : new JMenuItem(this.tabbedpane.getTitleAt(i)));
            menuitem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PopupTabbedPaneUI.this.popupmenu.setVisible(false);
                    PopupTabbedPaneUI.this.tabbedpane.setSelectedIndex(index);
                    PopupTabbedPaneUI.this.tabbedpane.revalidate();
                    PopupTabbedPaneUI.this.tabbedpane.repaint();
                }
            });
            if (this.sorttabslist) {
                items[i] = menuitem;
            } else {
                this.popupmenu.add(menuitem);
            }
            ++i;
        }
        if (this.sorttabslist) {
            Arrays.sort(items, this.getComparator());
            int i2 = 0;
            while (i2 < count) {
                this.popupmenu.add((JMenuItem)items[i2]);
                ++i2;
            }
        }
        try {
            this.popupmenu.show((Component)this.tabbedpane, x, y);
        }
        catch (Exception exception) {
            this.popupmenu.setLocation(x, y);
            this.popupmenu.setVisible(true);
        }
    }

    private class MenuItemComparator
    implements Comparator {
        MenuItemComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            return ((JMenuItem)obj1).getText().toUpperCase().compareTo(((JMenuItem)obj2).getText().toUpperCase());
        }
    }

    private class TabbedPabeChangeListener
    implements ChangeListener {
        TabbedPabeChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            PopupTabbedPaneUI.this.tabbedpane.revalidate();
            PopupTabbedPaneUI.this.tabbedpane.repaint();
        }
    }

    private class TabbedPaneMouseListener
    extends MouseAdapter {
        TabbedPaneMouseListener() {
        }

        public void mouseClicked(MouseEvent event) {
            if ((event.getModifiers() & 0x10) > 0) {
                int x = event.getX();
                int y = event.getY();
                if (PopupTabbedPaneUI.this.tabbounds.contains(x, y)) {
                    PopupTabbedPaneUI.this.tabbedpane.requestFocus();
                    PopupTabbedPaneUI.this.displayTabList(x, y);
                }
            }
        }
    }

    private class TabbedPaneLayout
    implements LayoutManager {
        private TabbedPaneLayout() {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return PopupTabbedPaneUI.this.calculateSize(1);
        }

        public Dimension maximumLayoutSize(Container container) {
            return PopupTabbedPaneUI.this.calculateSize(2);
        }

        public Dimension preferredLayoutSize(Container container) {
            return PopupTabbedPaneUI.this.calculateSize(3);
        }

        public void layoutContainer(Container container) {
            int count = PopupTabbedPaneUI.this.tabbedpane.getTabCount();
            int placement = PopupTabbedPaneUI.this.tabbedpane.getTabPlacement();
            int width = PopupTabbedPaneUI.this.tabbedpane.getWidth();
            int height = PopupTabbedPaneUI.this.tabbedpane.getHeight();
            Rectangle bounds = new Rectangle();
            Insets insets = PopupTabbedPaneUI.this.tabbedpane.getInsets();
            int i = 0;
            while (i < count) {
                PopupTabbedPaneUI.this.tabbedpane.getComponent(i).setVisible(false);
                ++i;
            }
            Component component = PopupTabbedPaneUI.this.tabbedpane.getSelectedComponent();
            if (component != null) {
                component.setBounds(insets.left + (placement == 2 ? 11 : 2), insets.top + (placement == 1 ? 11 : 2), width - insets.left - insets.right - (placement == 2 || placement == 4 ? 14 : 5), height - insets.top - insets.bottom - (placement == 1 || placement == 3 ? 14 : 5));
                component.setVisible(true);
            }
        }
    }
}

