/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.projects;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.core.projects.FixedFileSystem;
import org.netbeans.core.projects.XMLSettingsSupport;
import org.openide.ErrorManager;
import org.openide.ServiceType;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.InstanceDataObject;
import org.openide.modules.ModuleInfo;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;

public final class XMLSettingsHandler {
    private static final String XML_EXT = "settings";
    private static final String SHADOW_EXT = "shadow";
    private static final String UNCATEGORIZED_FOLDER = "UI/Services/Uncategorized";
    private static HashMap loadedOptions = new HashMap();
    private static HashMap loadedServices = new HashMap();
    private static final String GLOBAL_METHOD_NAME = "isGlobal";
    private static final String GLOBAL_BEANINFO = "global";
    static /* synthetic */ Class class$org$netbeans$core$projects$XMLSettingsHandler;
    static /* synthetic */ Class class$org$openide$ServiceType;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie$Of;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$filesystems$FileSystem;

    private XMLSettingsHandler() {
    }

    private static FixedFileSystem.Instance createXMLClassInstance(Class clazz, String displayName, ModuleInfo mi) throws InstantiationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(800);
        OutputStreamWriter w = new OutputStreamWriter(baos);
        try {
            XMLSettingsSupport.storeToXML10(clazz, (Writer)w, mi);
        }
        catch (IOException ioe) {
            throw (InstantiationException)ErrorManager.getDefault().annotate((Throwable)new InstantiationException(clazz.getName()), (Throwable)ioe);
        }
        return new FixedFileSystem.Instance(false, null, baos.toByteArray(), displayName, (String)null);
    }

    private static FixedFileSystem.Instance createXMLClassInstance(Object instance, String displayName, ModuleInfo mi) throws InstantiationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(800);
        OutputStreamWriter w = new OutputStreamWriter(baos);
        try {
            XMLSettingsSupport.storeToXML10(instance, (Writer)w, mi);
        }
        catch (IOException ioe) {
            throw (InstantiationException)ErrorManager.getDefault().annotate((Throwable)new InstantiationException(instance.getClass().getName()), (Throwable)ioe);
        }
        return new FixedFileSystem.Instance(false, null, baos.toByteArray(), displayName, (String)null);
    }

    public static void loadOption(Class clazz, ModuleInfo mi) throws InstantiationException {
        String originName = clazz.getName();
        String folder = "Services/";
        String fileName = originName.replace('.', '-');
        String filePath = new StringBuffer(folder.length() + fileName.length() + XML_EXT.length() + 1).append(folder).append(fileName).append('.').append(XML_EXT).toString();
        BeanDescriptor desc = null;
        try {
            BeanInfo info = Utilities.getBeanInfo((Class)clazz);
            desc = info.getBeanDescriptor();
        }
        catch (IntrospectionException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        FixedFileSystem.Instance inst = XMLSettingsHandler.createXMLClassInstance(clazz, null, mi);
        if (desc != null && desc.isHidden()) {
            inst.writeAttribute("hidden", Boolean.TRUE);
        } else {
            XMLSettingsHandler.addUncategorizedFolder();
            FixedFileSystem.getDefault().add(XMLSettingsHandler.getShadowFileName(fileName), XMLSettingsHandler.createShadow(filePath));
        }
        XMLSettingsHandler.setProjectLayer(inst, SharedClassObject.findObject((Class)clazz, (boolean)true));
        FixedFileSystem.getDefault().add(filePath, inst);
        loadedOptions.put(clazz, mi);
    }

    private static String getShadowFileName(String origFileName) {
        String folder = UNCATEGORIZED_FOLDER;
        return new StringBuffer(folder.length() + origFileName.length() + SHADOW_EXT.length() + 2).append(folder).append('/').append(origFileName).append('.').append(SHADOW_EXT).toString();
    }

    private static FixedFileSystem.Instance createShadow(String origFile) {
        String content = origFile + '\n' + Repository.getDefault().getDefaultFileSystem().getSystemName() + '\n';
        return new FixedFileSystem.Instance(false, null, content.getBytes(), null, (String)null);
    }

    private static void addUncategorizedFolder() {
        String folderPath;
        FixedFileSystem fs = FixedFileSystem.getDefault();
        FileSystem defFS = Repository.getDefault().getDefaultFileSystem();
        FileObject foFolder = defFS.findResource(folderPath = UNCATEGORIZED_FOLDER);
        if (foFolder == null) {
            FixedFileSystem.Instance inst = new FixedFileSystem.Instance(true, null, null, NbBundle.getMessage((Class)(class$org$netbeans$core$projects$XMLSettingsHandler == null ? (class$org$netbeans$core$projects$XMLSettingsHandler = XMLSettingsHandler.class$("org.netbeans.core.projects.XMLSettingsHandler")) : class$org$netbeans$core$projects$XMLSettingsHandler), (String)"LBL_uncategorized_folder"), (String)null);
            fs.add(folderPath, inst);
            foFolder = defFS.findResource(folderPath);
            if (foFolder == null) {
                StringBuffer sb = new StringBuffer(255);
                sb.append("This bug is caused by wrong implementation of MultiFileSystem, see ");
                sb.append("http://www.netbeans.org/issues/show_bug.cgi?id=14596");
                sb.append("\nfolder: \"");
                sb.append(folderPath).append('\"');
                sb.append("\n Was found on FixedFileSystem: ");
                sb.append(fs.findResource(folderPath) != null);
                throw new IllegalStateException(sb.toString());
            }
        }
    }

    public static void unloadOption(Class option) {
        String originName = option.getName();
        String folder = "Services/";
        String fileName = originName.replace('.', '-');
        String filePath = new StringBuffer(folder.length() + fileName.length() + XML_EXT.length() + 1).append(folder).append(fileName).append('.').append(XML_EXT).toString();
        FixedFileSystem.getDefault().remove(filePath);
        FixedFileSystem.getDefault().remove(fileName);
        loadedOptions.remove(option);
    }

    /*
     * Unable to fully structure code
     */
    private static Class getServiceTypeClass(Class type) {
        if ((XMLSettingsHandler.class$org$openide$ServiceType == null ? (XMLSettingsHandler.class$org$openide$ServiceType = XMLSettingsHandler.class$("org.openide.ServiceType")) : XMLSettingsHandler.class$org$openide$ServiceType).isAssignableFrom(type)) ** GOTO lbl4
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            type = type.getSuperclass();
lbl4:
            // 2 sources

            ** while (type.getSuperclass() != (XMLSettingsHandler.class$org$openide$ServiceType == null ? XMLSettingsHandler.class$((String)"org.openide.ServiceType") : XMLSettingsHandler.class$org$openide$ServiceType))
        }
lbl5:
        // 1 sources

        return type;
    }

    public static void loadService(Object service, ModuleInfo mi, boolean defaultSrv) throws InstantiationException {
        Class<?> clazz = service.getClass();
        String originName = clazz.getName();
        try {
            String shadowPath;
            FixedFileSystem.Instance inst;
            Class stype = XMLSettingsHandler.getServiceTypeClass(clazz);
            BeanInfo info = Utilities.getBeanInfo((Class)stype);
            String folder = Utilities.getShortClassName((Class)stype);
            FixedFileSystem fs = FixedFileSystem.getDefault();
            FileSystem defFS = Repository.getDefault().getDefaultFileSystem();
            String servicepath = new StringBuffer(folder.length() + 9).append("Services/").append(folder).toString();
            FileObject foFolder = defFS.findResource(servicepath);
            if (foFolder == null) {
                inst = new FixedFileSystem.Instance(true, null, null, info.getBeanDescriptor().getDisplayName(), stype.getName());
                fs.add(servicepath, inst);
                foFolder = defFS.findResource(servicepath);
                if (foFolder == null) {
                    StringBuffer sb = new StringBuffer(255);
                    sb.append("This bug is caused by wrong implementation of MultiFileSystem, see ");
                    sb.append("http://www.netbeans.org/issues/show_bug.cgi?id=14596");
                    sb.append("\nfolder: \"");
                    sb.append(servicepath).append('\"');
                    sb.append("\n Was found on FixedFileSystem: ");
                    sb.append(fs.findResource(servicepath) != null);
                    throw new IllegalStateException(sb.toString());
                }
            }
            String originFileName = originName.replace('.', '-');
            String fileName = FileUtil.findFreeFileName((FileObject)foFolder, (String)originFileName, (String)XML_EXT);
            String filePath = new StringBuffer(folder.length() + fileName.length() + XML_EXT.length() + 11).append("Services/").append(folder).append('/').append(fileName).append('.').append(XML_EXT).toString();
            boolean isHidden = false;
            ServiceType st = (ServiceType)service;
            inst = XMLSettingsHandler.createXMLClassInstance(service, st.getName(), mi);
            try {
                info = Utilities.getBeanInfo(clazz);
                BeanDescriptor desc = info.getBeanDescriptor();
                if (desc != null && desc.isHidden()) {
                    isHidden = true;
                    inst.writeAttribute("hidden", Boolean.TRUE);
                }
            }
            catch (IntrospectionException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            XMLSettingsHandler.setProjectLayer(inst, service);
            XMLSettingsHandler.setProjectLayer(fs.get(servicepath), service);
            fs.add(filePath, inst);
            if (defaultSrv) {
                fs.addDefault(servicepath, fileName + '.' + XML_EXT);
            }
            if (fileName.equals(originFileName)) {
                inst = XMLSettingsHandler.createXMLClassInstance(clazz, st.getName(), mi);
                inst.writeAttribute("template", Boolean.TRUE);
                fs.add(new StringBuffer(10 + filePath.length()).append("Templates/").append(filePath).toString(), inst);
            } else {
                XMLSettingsHandler.addService(originFileName, fileName);
            }
            if (!isHidden && defFS.findResource(shadowPath = XMLSettingsHandler.getShadowFileName(folder)) == null) {
                XMLSettingsHandler.addUncategorizedFolder();
                FixedFileSystem.getDefault().add(shadowPath, XMLSettingsHandler.createShadow(servicepath));
            }
        }
        catch (InstantiationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            InstantiationException iex = new InstantiationException(originName);
            ErrorManager.getDefault().annotate((Throwable)iex, (Throwable)ex);
            throw iex;
        }
    }

    public static void unloadService(Class clazz) {
        String originName = clazz.getName();
        Class stype = XMLSettingsHandler.getServiceTypeClass(clazz);
        String folder = Utilities.getShortClassName((Class)stype);
        String fileName = originName.replace('.', '-');
        String filePath = new StringBuffer(folder.length() + fileName.length() + XML_EXT.length() + 11).append("Services/").append(folder).append('/').append(fileName).append('.').append(XML_EXT).toString();
        FixedFileSystem fs = FixedFileSystem.getDefault();
        fs.remove(filePath);
        HashSet others = (HashSet)loadedServices.get(fileName);
        if (others != null) {
            Iterator it = others.iterator();
            while (it.hasNext()) {
                String removeFile = (String)it.next();
                String removePath = new StringBuffer(folder.length() + removeFile.length() + XML_EXT.length() + 11).append("Services/").append(folder).append('/').append(removeFile).append('.').append(XML_EXT).toString();
                fs.remove(removePath);
            }
        }
        fs.remove(new StringBuffer(10 + filePath.length()).append("Templates/").append(filePath).toString());
        String servicepath = new StringBuffer(folder.length() + 9).append("Services/").append(folder).toString();
        FileObject folderObj = fs.findResource(servicepath);
        if (folderObj != null && folderObj.getChildren().length == 0) {
            fs.remove(servicepath);
        }
    }

    public static void loadFS(Object fs, ModuleInfo mi) throws InstantiationException {
        String originName = fs.getClass().getName();
        String folder = "Templates/Mount/";
        String fileName = originName.replace('.', '-');
        String filePath = new StringBuffer(folder.length() + fileName.length() + XML_EXT.length() + 1).append(folder).append(fileName).append('.').append(XML_EXT).toString();
        String displayName = null;
        try {
            BeanInfo info = Utilities.getBeanInfo(fs.getClass());
            BeanDescriptor desc = info.getBeanDescriptor();
            displayName = desc.getDisplayName();
        }
        catch (IntrospectionException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        FixedFileSystem.Instance inst = XMLSettingsHandler.createXMLClassInstance(fs.getClass(), displayName, mi);
        inst.writeAttribute("template", Boolean.TRUE);
        XMLSettingsHandler.setProjectLayer(inst, fs);
        FixedFileSystem.getDefault().add(filePath, inst);
    }

    public static void unloadFS(Class option) {
        String originName = option.getName();
        String folder = "Templates/Mount/";
        String fileName = originName.replace('.', '-');
        String filePath = new StringBuffer(folder.length() + fileName.length() + XML_EXT.length() + 1).append(folder).append(fileName).append('.').append(XML_EXT).toString();
        FixedFileSystem.getDefault().remove(filePath);
    }

    private static void addService(String filename, String extFilename) {
        HashMap hashMap = loadedServices;
        synchronized (hashMap) {
            HashSet<String> files = (HashSet<String>)loadedServices.get(filename);
            if (files == null) {
                files = new HashSet<String>();
                loadedServices.put(filename, files);
            }
            files.add(extFilename);
        }
    }

    public static void openOptions() {
        Iterator it = loadedOptions.keySet().iterator();
        while (it.hasNext()) {
            Class clazz = (Class)it.next();
            SharedClassObject.findObject((Class)clazz, (boolean)true);
        }
    }

    public static void saveOptions() {
        FileObject servicesFO = Repository.getDefault().findResource("Services");
        if (servicesFO == null) {
            return;
        }
        XMLSettingsHandler.searchFolder(servicesFO);
    }

    private static boolean searchFolder(FileObject folder) {
        FileObject[] fobjs = folder.getChildren();
        ArrayList<FileObject> subfolders = null;
        int i = 0;
        while (i < fobjs.length) {
            if (fobjs[i].isValid()) {
                if (fobjs[i].isFolder()) {
                    if (subfolders == null) {
                        subfolders = new ArrayList<FileObject>();
                    }
                    subfolders.add(fobjs[i]);
                } else {
                    try {
                        DataObject dobj = DataObject.find((FileObject)fobjs[i]);
                        InstanceCookie inst = (InstanceCookie)dobj.getCookie(class$org$openide$cookies$InstanceCookie$Of == null ? XMLSettingsHandler.class$("org.openide.cookies.InstanceCookie$Of") : class$org$openide$cookies$InstanceCookie$Of);
                        if (inst != null || (inst = (InstanceCookie)dobj.getCookie(class$org$openide$cookies$InstanceCookie == null ? XMLSettingsHandler.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie)) != null) {
                            ArrayList<SystemOption> clear = new ArrayList<SystemOption>();
                            Iterator<Object> it = loadedOptions.keySet().iterator();
                            while (it.hasNext()) {
                                Class optionClass = (Class)it.next();
                                SystemOption option = (SystemOption)SharedClassObject.findObject((Class)optionClass, (boolean)true);
                                if (!XMLSettingsHandler.instanceOf(inst, option)) continue;
                                XMLSettingsHandler.saveOption(fobjs[i], option);
                                clear.add(option);
                                break;
                            }
                            if (clear.size() > 0) {
                                it = ((AbstractList)clear).iterator();
                                while (it.hasNext()) {
                                    loadedOptions.remove(it.next());
                                }
                                if (loadedOptions.size() == 0) {
                                    return true;
                                }
                            }
                        }
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
            }
            ++i;
        }
        if (subfolders != null) {
            Iterator it = ((AbstractList)subfolders).iterator();
            while (it.hasNext()) {
                if (!XMLSettingsHandler.searchFolder((FileObject)it.next())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean instanceOf(InstanceCookie inst, Object obj) {
        if (inst instanceof InstanceCookie.Of) {
            return ((InstanceCookie.Of)inst).instanceOf(obj.getClass());
        }
        try {
            return inst.instanceClass().isInstance(obj);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return false;
        }
    }

    private static void saveOption(FileObject file, SystemOption option) {
        try {
            InstanceDataObject.create((DataFolder)DataFolder.findFolder((FileObject)file.getParent()), (String)file.getName(), (Object)option, null);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private static void setProjectLayer(FixedFileSystem.Instance inst, Object obj) {
        if (inst != null && obj != null && XMLSettingsHandler.isProjectObject(obj)) {
            inst.writeAttribute("SystemFileSystem.layer", "project");
        }
    }

    public static boolean isProjectObject(Object obj) {
        Class<?> clazz = obj.getClass();
        try {
            if (XMLSettingsHandler.hasGlobalAtrributeInBeanInfo(clazz)) {
                return !XMLSettingsHandler.isGlobalFromBeanInfo(clazz);
            }
            Method m = clazz.getMethod(GLOBAL_METHOD_NAME, new Class[0]);
            if (m != null) {
                ((AccessibleObject)m).setAccessible(true);
                Boolean b = (Boolean)m.invoke(obj, new Object[0]);
                return b == false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (class$org$openide$ServiceType == null ? (class$org$openide$ServiceType = XMLSettingsHandler.class$("org.openide.ServiceType")) : class$org$openide$ServiceType).isAssignableFrom(clazz) || (class$org$openide$filesystems$FileSystem == null ? (class$org$openide$filesystems$FileSystem = XMLSettingsHandler.class$("org.openide.filesystems.FileSystem")) : class$org$openide$filesystems$FileSystem).isAssignableFrom(clazz);
    }

    private static boolean hasGlobalAtrributeInBeanInfo(Class clazz) {
        try {
            BeanInfo b = Utilities.getBeanInfo((Class)clazz);
            if (b != null) {
                Object v;
                BeanDescriptor bd = b.getBeanDescriptor();
                if (bd != null && (v = bd.getValue(GLOBAL_BEANINFO)) != null) {
                    return true;
                }
                BeanInfo[] infos = b.getAdditionalBeanInfo();
                if (infos != null) {
                    int i = 0;
                    while (i < infos.length) {
                        Object v2;
                        BeanDescriptor bd1 = infos[i].getBeanDescriptor();
                        if (bd1 != null && (v2 = bd1.getValue(GLOBAL_BEANINFO)) != null) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isGlobalFromBeanInfo(Class clazz) {
        try {
            BeanInfo b = Utilities.getBeanInfo((Class)clazz);
            if (b != null) {
                Object v;
                BeanDescriptor bd = b.getBeanDescriptor();
                if (bd != null && (v = bd.getValue(GLOBAL_BEANINFO)) instanceof Boolean) {
                    return (Boolean)v;
                }
                BeanInfo[] infos = b.getAdditionalBeanInfo();
                if (infos != null) {
                    int i = 0;
                    while (i < infos.length) {
                        Object v2;
                        BeanDescriptor bd1 = infos[i].getBeanDescriptor();
                        if (bd1 != null && (v2 = bd1.getValue(GLOBAL_BEANINFO)) instanceof Boolean) {
                            return (Boolean)v2;
                        }
                        ++i;
                    }
                }
            }
        }
        catch (IntrospectionException ie) {
            ErrorManager.getDefault().notify(4096, (Throwable)ie);
        }
        throw new IllegalArgumentException("Trying to get a value from beaninfo but the value is not there");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

