/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.awt;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.netbeans.core.awt.ButtonBarButton;
import org.openide.util.NbBundle;

public class ButtonBar
extends JPanel {
    static final long serialVersionUID = -5909692079369563652L;
    public static final int EMPTY = 0;
    public static final int OK_CANCEL = 1;
    public static final int CLOSE = 2;
    public static final int YES_NO = 3;
    public static final int YES_NO_CANCEL = 4;
    public static final int DETAILS_CLOSE = 5;
    public static final Color DEFAULT_FOREGROUND = new Color(200, 200, 255);
    public static final Color DEFAULT_BACKGROUND = Color.blue.darker().darker();
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 18);
    public static final int SINGLE_RIGHT = 0;
    public static final int SINGLE_LEFT = 1;
    public static final int SINGLE_CENTER = 2;
    public static final int BUTTONS_GAP = 6;
    public static final int SECTIONS_GAP = 40;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private ButtonBarButton defaultButton;
    private boolean peerExist;
    private int orientation;
    private ButtonBarButton[] rightButtons;
    private ButtonBarButton[] leftButtons;
    private int singleMode = 0;
    private Vector listeners = new Vector();
    static /* synthetic */ Class class$org$netbeans$core$awt$ButtonBar;

    public ButtonBar() {
        this(0);
    }

    public ButtonBar(int preset) {
        this(preset, 0);
    }

    public ButtonBar(int preset, int orientation) {
        this.orientation = orientation;
        String[] left = null;
        String[] right = null;
        String def = "";
        ResourceBundle bundle = NbBundle.getBundle((Class)(class$org$netbeans$core$awt$ButtonBar == null ? (class$org$netbeans$core$awt$ButtonBar = ButtonBar.class$("org.netbeans.core.awt.ButtonBar")) : class$org$netbeans$core$awt$ButtonBar));
        switch (preset) {
            case 1: {
                right = new String[]{bundle.getString("OKButton"), bundle.getString("CancelButton")};
                def = right[0];
                break;
            }
            case 2: {
                right = new String[]{bundle.getString("CloseButton")};
                def = right[0];
                break;
            }
            case 3: {
                right = new String[]{bundle.getString("YesButton"), bundle.getString("NoButton")};
                def = right[0];
                break;
            }
            case 4: {
                right = new String[]{bundle.getString("YesButton"), bundle.getString("NoButton"), bundle.getString("CancelButton")};
                def = right[0];
                break;
            }
            case 5: {
                left = new String[]{bundle.getString("DetailsButton")};
                right = new String[]{bundle.getString("CloseButton")};
                def = right[0];
                break;
            }
        }
        this.initButtons(left, right, def);
    }

    public ButtonBar(String[] left, String[] right) {
        this(left, right, "", 0);
    }

    public ButtonBar(String[] left, String[] right, String defaultButton) {
        this(left, right, defaultButton, 0);
    }

    public ButtonBar(String[] left, String[] right, String defaultButton, int orientation) {
        this.orientation = orientation;
        this.initButtons(left, right, defaultButton);
    }

    public ButtonBar(ButtonBarButton[] left, ButtonBarButton[] right) {
        this(left, right, 0);
    }

    public ButtonBar(ButtonBarButton[] left, ButtonBarButton[] right, int orientation) {
        this.orientation = orientation;
        this.initButtons(left, right);
    }

    public ButtonBar(ButtonBarButton[] right) {
        this(null, right, 0);
    }

    private void initButtons(String[] left, String[] right, String defaultButton) {
        int i;
        ButtonBarButton[] lefts = null;
        ButtonBarButton[] rights = null;
        if (left != null) {
            lefts = new ButtonBarButton[left.length];
            i = 0;
            while (i < left.length) {
                lefts[i] = new ButtonBarButton(left[i]);
                if (left[i].equals(defaultButton)) {
                    this.setDefaultButton(lefts[i]);
                }
                ++i;
            }
        }
        if (right != null) {
            rights = new ButtonBarButton[right.length];
            i = 0;
            while (i < right.length) {
                rights[i] = new ButtonBarButton(right[i]);
                if (right[i].equals(defaultButton)) {
                    this.setDefaultButton(rights[i]);
                }
                ++i;
            }
        }
        this.initButtons(lefts, rights);
    }

    private void initButtons(ButtonBarButton[] left, ButtonBarButton[] right) {
        int i;
        this.setBorder(new EmptyBorder(17, 12, 11, 11));
        this.setLayout(new BorderLayout());
        JPanel inside = new JPanel();
        inside.setLayout(new ButtonBarLayout());
        if (left == null || left.length == 0) {
            this.leftButtons = new ButtonBarButton[0];
        } else {
            this.leftButtons = new ButtonBarButton[left.length];
            i = 0;
            while (i < left.length) {
                this.leftButtons[i] = left[i];
                this.leftButtons[i].attachButton(this);
                inside.add(this.leftButtons[i]);
                ++i;
            }
        }
        if (right == null || right.length == 0) {
            this.rightButtons = new ButtonBarButton[0];
        } else {
            this.rightButtons = new ButtonBarButton[right.length];
            i = 0;
            while (i < right.length) {
                this.rightButtons[i] = right[i];
                this.rightButtons[i].attachButton(this);
                inside.add(this.rightButtons[i]);
                ++i;
            }
        }
        this.add((Component)inside, "Center");
    }

    public void setButtons(ButtonBarButton[] left, ButtonBarButton[] right) {
        this.setButtons(left, right, 0);
    }

    public void setButtons(ButtonBarButton[] left, ButtonBarButton[] right, int orientation) {
        this.orientation = orientation;
        this.initButtons(left, right);
        this.invalidate();
        this.repaint();
    }

    public void setButtons(String[] left, String[] right) {
        this.setButtons(left, right, 0);
    }

    public void setButtons(String[] left, String[] right, int orientation) {
        this.orientation = orientation;
        this.initButtons(left, right, "");
        this.invalidate();
        this.repaint();
    }

    public synchronized void addButtonBarListener(ButtonBarListener l) {
        this.listeners.addElement(l);
    }

    public synchronized void removeButtonBarListener(ButtonBarListener l) {
        this.listeners.removeElement(l);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, d.width, d.height);
        super.paint(g);
    }

    public int getButtonIndex(ButtonBarButton button) {
        if (button == null) {
            return -1;
        }
        int i = 0;
        while (i < this.leftButtons.length) {
            if (this.leftButtons[i].equals(button)) {
                return i;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.rightButtons.length) {
            if (this.rightButtons[i2].equals(button)) {
                return this.leftButtons.length + i2;
            }
            ++i2;
        }
        return -1;
    }

    public ButtonBarButton getButton(int index) {
        if (index < 0 || index >= this.leftButtons.length + this.rightButtons.length) {
            return null;
        }
        return index >= this.leftButtons.length ? this.rightButtons[index - this.leftButtons.length] : this.leftButtons[index];
    }

    public void setDefaultButton(int index) {
        this.setDefaultButton(this.getButton(index));
    }

    public void setDefaultButton(final ButtonBarButton button) {
        if (!this.peerExist) {
            this.defaultButton = button;
            return;
        }
        if (this.defaultButton != button) {
            ButtonBarButton oldDefault = this.defaultButton;
            this.defaultButton = button;
            Container c = this.getParent();
            while (c != null) {
                if (c instanceof JRootPane) {
                    ((JRootPane)c).setDefaultButton(button);
                    break;
                }
                c = c.getParent();
            }
            if (c == null) {
                c = this;
            }
            if (oldDefault != null) {
                ((JComponent)c).unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, true));
                ((JComponent)c).unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            }
            if (button != null) {
                final boolean[] acceptKeys = new boolean[]{true};
                ((JComponent)c).registerKeyboardAction(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        if (button.isEnabled() && acceptKeys[0]) {
                            ButtonBar.this.buttonPressed(button, 0);
                        }
                    }
                }, KeyStroke.getKeyStroke(10, 0, true), 2);
            }
            this.repaint();
        }
    }

    protected void buttonPressed(ButtonBarButton button, int modifiers) {
        Vector listeners2;
        ButtonBarEvent evt = new ButtonBarEvent(this, button, 1001, button.getText(), modifiers);
        ButtonBar buttonBar = this;
        synchronized (buttonBar) {
            listeners2 = (Vector)this.listeners.clone();
        }
        int length = listeners2.size();
        int i = 0;
        while (i < length) {
            ((ButtonBarListener)listeners2.elementAt(i)).buttonPressed(evt);
            ++i;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.peerExist = true;
        if (this.defaultButton != null) {
            ButtonBarButton b = this.defaultButton;
            this.defaultButton = null;
            this.setDefaultButton(b);
        }
    }

    public void removeNotify() {
        if (this.defaultButton != null) {
            ButtonBarButton oldDefault = this.defaultButton;
            this.setDefaultButton(null);
            this.defaultButton = oldDefault;
        }
        super.removeNotify();
        this.peerExist = false;
    }

    public final int getOrientation() {
        return this.orientation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ButtonBarEvent
    extends ActionEvent {
        static final long serialVersionUID = 5361326502523278662L;
        private ButtonBarButton sourceButton;

        public ButtonBarEvent(ButtonBar source, ButtonBarButton button, int id, String command, int modifiers) {
            super(source, id, command, modifiers);
            this.sourceButton = button;
        }

        public ButtonBarButton getButton() {
            return this.sourceButton;
        }
    }

    public static interface ButtonBarListener {
        public void buttonPressed(ButtonBarEvent var1);
    }

    class ButtonBarLayout
    implements LayoutManager {
        ButtonBarLayout() {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = new Dimension(0, 0);
            if (ButtonBar.this.leftButtons.length == 0 && ButtonBar.this.rightButtons.length == 0) {
                return d;
            }
            Dimension maxButton = this.countMaxSize(ButtonBar.this.leftButtons, ButtonBar.this.rightButtons);
            if (ButtonBar.this.orientation == 0) {
                d.height = maxButton.height;
                d.width += maxButton.width * (ButtonBar.this.leftButtons.length + ButtonBar.this.rightButtons.length);
                if (ButtonBar.this.leftButtons.length > 0 && ButtonBar.this.rightButtons.length > 0) {
                    d.width += 40;
                }
                if (ButtonBar.this.leftButtons.length > 1) {
                    d.width += 6 * (ButtonBar.this.leftButtons.length - 1);
                }
                if (ButtonBar.this.rightButtons.length > 1) {
                    d.width += 6 * (ButtonBar.this.rightButtons.length - 1);
                }
            } else {
                d.height = maxButton.height * (ButtonBar.this.leftButtons.length + ButtonBar.this.rightButtons.length);
                d.width += maxButton.width;
                if (ButtonBar.this.leftButtons.length > 0 && ButtonBar.this.rightButtons.length > 0) {
                    d.height += 40;
                }
                if (ButtonBar.this.rightButtons.length > 1) {
                    d.height += 6 * (ButtonBar.this.rightButtons.length - 1);
                }
                if (ButtonBar.this.leftButtons.length > 1) {
                    d.height += 6 * (ButtonBar.this.leftButtons.length - 1);
                }
            }
            return d;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        public void layoutContainer(Container parent) {
            if (ButtonBar.this.leftButtons.length == 0 && ButtonBar.this.rightButtons.length == 0) {
                return;
            }
            Dimension size = parent.getSize();
            Dimension maxButton = this.countMaxSize(ButtonBar.this.leftButtons, ButtonBar.this.rightButtons);
            int buttonsCount = ButtonBar.this.leftButtons.length + ButtonBar.this.rightButtons.length;
            if (ButtonBar.this.orientation == 0) {
                if (maxButton.width * buttonsCount + 6 * (buttonsCount - 1) > size.width) {
                    maxButton.width = (size.width - 6 * (buttonsCount - 1)) / buttonsCount;
                }
            } else if (maxButton.height * buttonsCount + 6 * (buttonsCount - 1) > size.height) {
                maxButton.height = (size.height - 6 * (buttonsCount - 1)) / buttonsCount;
            }
            int butDelta = 6 + (ButtonBar.this.orientation == 0 ? maxButton.width : maxButton.height);
            if (ButtonBar.this.leftButtons.length > 0 && ButtonBar.this.rightButtons.length > 0) {
                if (ButtonBar.this.orientation == 0) {
                    int x = 0;
                    int i = 0;
                    while (i < ButtonBar.this.leftButtons.length) {
                        ButtonBar.this.leftButtons[i].setBounds(new Rectangle(x, 0, maxButton.width, maxButton.height));
                        ButtonBar.this.leftButtons[i].setSize(maxButton);
                        x += butDelta;
                        ++i;
                    }
                    x = size.width - maxButton.width;
                    int i2 = ButtonBar.this.rightButtons.length - 1;
                    while (i2 >= 0) {
                        ButtonBar.this.rightButtons[i2].setBounds(new Rectangle(x, 0, maxButton.width, maxButton.height));
                        ButtonBar.this.rightButtons[i2].setSize(maxButton);
                        x -= butDelta;
                        --i2;
                    }
                } else {
                    int y = 0;
                    int i = 0;
                    while (i < ButtonBar.this.rightButtons.length) {
                        ButtonBar.this.rightButtons[i].setBounds(new Rectangle(0, y, maxButton.width, maxButton.height));
                        ButtonBar.this.rightButtons[i].setSize(maxButton);
                        y += butDelta;
                        ++i;
                    }
                    y = size.height - maxButton.height;
                    int i3 = ButtonBar.this.leftButtons.length - 1;
                    while (i3 >= 0) {
                        ButtonBar.this.leftButtons[i3].setBounds(new Rectangle(0, y, maxButton.width, maxButton.height));
                        ButtonBar.this.leftButtons[i3].setSize(maxButton);
                        y -= butDelta;
                        --i3;
                    }
                }
            } else {
                ButtonBarButton[] buts;
                ButtonBarButton[] buttonBarButtonArray = buts = ButtonBar.this.leftButtons.length > 0 ? ButtonBar.this.leftButtons : ButtonBar.this.rightButtons;
                if (ButtonBar.this.singleMode == 2) {
                    if (ButtonBar.this.orientation == 0) {
                        int x = (size.width - (butDelta * buts.length - 6)) / 2;
                        int i = 0;
                        while (i < buts.length) {
                            buts[i].setBounds(new Rectangle(x, 0, maxButton.width, maxButton.height));
                            x += butDelta;
                            ++i;
                        }
                    } else {
                        int y = (size.height - (butDelta * buts.length - 6)) / 2;
                        int i = 0;
                        while (i < buts.length) {
                            buts[i].setBounds(new Rectangle(0, y, maxButton.width, maxButton.height));
                            y += butDelta;
                            ++i;
                        }
                    }
                } else if (ButtonBar.this.singleMode == 1) {
                    if (ButtonBar.this.orientation == 0) {
                        int x = 0;
                        int i = 0;
                        while (i < buts.length) {
                            buts[i].setBounds(new Rectangle(x, 0, maxButton.width, maxButton.height));
                            buts[i].setSize(maxButton);
                            x += butDelta;
                            ++i;
                        }
                    } else {
                        int y = size.height - maxButton.height;
                        int i = buts.length - 1;
                        while (i >= 0) {
                            buts[i].setBounds(new Rectangle(0, y, maxButton.width, maxButton.height));
                            buts[i].setSize(maxButton);
                            y -= butDelta;
                            --i;
                        }
                    }
                } else if (ButtonBar.this.orientation == 0) {
                    int x = size.width - maxButton.width;
                    int i = buts.length - 1;
                    while (i >= 0) {
                        buts[i].setBounds(new Rectangle(x, 0, maxButton.width, maxButton.height));
                        buts[i].setSize(maxButton);
                        x -= butDelta;
                        --i;
                    }
                } else {
                    int y = 0;
                    int i = 0;
                    while (i < buts.length) {
                        buts[i].setBounds(new Rectangle(0, y, maxButton.width, maxButton.height));
                        buts[i].setSize(maxButton);
                        y += butDelta;
                        ++i;
                    }
                }
            }
        }

        private Dimension countMaxSize(ButtonBarButton[] left, ButtonBarButton[] right) {
            Dimension d1 = this.countMaxSize(left);
            Dimension d2 = this.countMaxSize(right);
            return new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height));
        }

        private Dimension countMaxSize(ButtonBarButton[] buttons) {
            Dimension d = new Dimension(0, 0);
            int i = 0;
            while (i < buttons.length) {
                Dimension d2 = buttons[i].getPreferredSize();
                d.width = Math.max(d.width, d2.width);
                d.height = Math.max(d.height, d2.height);
                ++i;
            }
            return d;
        }
    }
}

