/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.openide.awt.Actions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public class MemoryMeterAction
extends CallableSystemAction {
    static final long serialVersionUID = -3365766607488098102L;
    private MemoryMeterPresenter presenter = null;
    private long mark = -1L;
    static /* synthetic */ Class class$org$netbeans$core$actions$MemoryMeterAction;

    public String getName() {
        return NbBundle.getBundle((Class)(class$org$netbeans$core$actions$MemoryMeterAction == null ? (class$org$netbeans$core$actions$MemoryMeterAction = MemoryMeterAction.class$("org.netbeans.core.actions.MemoryMeterAction")) : class$org$netbeans$core$actions$MemoryMeterAction)).getString("CTL_MemoryMeterAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$netbeans$core$actions$MemoryMeterAction == null ? (class$org$netbeans$core$actions$MemoryMeterAction = MemoryMeterAction.class$("org.netbeans.core.actions.MemoryMeterAction")) : class$org$netbeans$core$actions$MemoryMeterAction);
    }

    public void performAction() {
        this.mark = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public Component getToolbarPresenter() {
        if (this.presenter == null) {
            this.presenter = new MemoryMeterPresenter(this);
            return this.presenter;
        }
        return this.presenter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MemoryMeterPresenter
    extends Actions.ToolbarButton {
        private static final int UPDATE_TIME = 1000;
        private Timer timer = new Timer(1000, new ActionListener(this){
            private final /* synthetic */ MemoryMeterPresenter this$0;
            {
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent ev) {
                MemoryMeterPresenter.access$000(this.this$0);
            }
        });
        private Dimension prefSize;
        private MemoryMeterAction action;
        private static Color nbBlue = new Color(153, 153, 204);

        public MemoryMeterPresenter(MemoryMeterAction a) {
            super((SystemAction)a);
            this.action = a;
        }

        public void paint(Graphics g) {
            Dimension size = ((Component)((Object)this)).getSize();
            int width = size.width - 16;
            int height = size.height - 12;
            long allocated = Runtime.getRuntime().totalMemory();
            long taken = allocated - Runtime.getRuntime().freeMemory();
            g.clearRect(0, 0, size.width, size.width);
            g.setColor(UIManager.getDefaults().getColor("Button.background"));
            g.draw3DRect(7, 5, width + 1, height + 1, false);
            if (((AbstractButton)((Object)this)).isBorderPainted()) {
                ((AbstractButton)((Object)this)).paintBorder(g);
            }
            double ratio = (double)taken / (double)allocated;
            g.setColor(nbBlue);
            g.fillRect(8, 6, (int)((double)width * ratio), height);
            if (this.action.mark != -1L) {
                g.setColor(Color.black);
                ratio = (double)this.action.mark / (double)allocated;
                g.drawLine(8 + (int)((double)width * ratio), 6, 8 + (int)((double)width * ratio), 5 + height);
                g.setColor(Color.darkGray.darker());
                g.drawLine(8 + (int)((double)width * ratio), 5, 8 + (int)((double)width * ratio), 5);
                g.drawLine(8 + (int)((double)width * ratio) - 1, 4, 8 + (int)((double)width * ratio) + 1, 4);
                g.drawLine(8 + (int)((double)width * ratio) - 2, 3, 8 + (int)((double)width * ratio) + 2, 3);
                g.drawLine(8 + (int)((double)width * ratio), 6 + height, 8 + (int)((double)width * ratio), 6 + height);
                g.drawLine(8 + (int)((double)width * ratio) - 1, 7 + height, 8 + (int)((double)width * ratio) + 1, 7 + height);
                g.drawLine(8 + (int)((double)width * ratio) - 2, 8 + height, 8 + (int)((double)width * ratio) + 2, 8 + height);
            }
        }

        public Dimension getPreferredSize() {
            if (this.prefSize == null) {
                this.prefSize = new Dimension(72, super.getPreferredSize().height);
            }
            return this.prefSize;
        }

        public String getToolTipText(MouseEvent e) {
            if (e.isShiftDown()) {
                return this.getToolTipText(false);
            }
            return this.getToolTipText(true);
        }

        private String getToolTipText(boolean kilos) {
            long allocated = Runtime.getRuntime().totalMemory();
            long taken = allocated - Runtime.getRuntime().freeMemory();
            if (kilos) {
                return " " + taken / 1024L + "K / " + allocated / 1024L + "K ";
            }
            return " " + taken + " / " + allocated + " ";
        }

        private void updateStatus() {
            ((Container)((Object)this)).invalidate();
            ((Container)((Object)this)).validate();
            ((Component)((Object)this)).repaint();
        }

        public void addNotify() {
            super.addNotify();
            if (((Component)((Object)this)).getParent().isVisible()) {
                this.timer.start();
            } else {
                this.timer.stop();
            }
        }

        public void removeNotify() {
            super.removeNotify();
            this.timer.stop();
        }

        static /* synthetic */ void access$000(MemoryMeterPresenter x0) {
            x0.updateStatus();
        }
    }
}

