/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.metal.MetalTheme;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.xml.XMLUtil;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLReaderAdapter;

public class NbTheme
extends MetalTheme
implements DocumentHandler {
    public static final String THEMEFILE_NAME = "themes.xml";
    private static final String THEMESET_TAG = "themeset";
    private static final String ACTIVE_ATTR = "active";
    private static final String THEME_TAG = "theme";
    private static final String BOOL_TAG = "boolean";
    private static final String DIM_TAG = "dimension";
    private static final String FONT_TAG = "font";
    private static final String INSETS_TAG = "insets";
    private static final String ETCHEDBORDER_TAG = "etchedborder";
    private static final String EMPTYBORDER_TAG = "emptyborder";
    private static final String BEVELBORDER_TAG = "bevelborder";
    private static final String LINEBORDER_TAG = "lineborder";
    private static final String COLOR_ATTR = "color";
    private static final String KEY_ATTR = "key";
    private static final String METRIC_TAG = "metric";
    private static final String STRING_TAG = "string";
    private static final String NAME_ATTR = "name";
    private static final String FONTSTYLE_ATTR = "style";
    private static final String FONTSIZE_ATTR = "size";
    private static final String VALUE_ATTR = "value";
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";
    private static final String RED_ATTR = "r";
    private static final String GREEN_ATTR = "g";
    private static final String BLUE_ATTR = "b";
    private static final String LEFT_ATTR = "left";
    private static final String TOP_ATTR = "top";
    private static final String RIGHT_ATTR = "right";
    private static final String BOTTOM_ATTR = "bottom";
    private static final String TYPE_ATTR = "type";
    private static final String FONTSTYLE_BOLD = "bold";
    private static final String FONTSTYLE_ITALIC = "italic";
    private static final String TYPE_LOWERED = "lowered";
    private static final String CONTROLFONT = "controlFont";
    private static final String SYSTEMFONT = "systemFont";
    private static final String USERFONT = "userFont";
    private static final String MENUFONT = "menuFont";
    private static final String WINDOWTITLEFONT = "windowTitleFont";
    private static final String SUBFONT = "subFont";
    private static final String PRIMARY1 = "primary1";
    private static final String PRIMARY2 = "primary2";
    private static final String PRIMARY3 = "primary3";
    private static final String SECONDARY1 = "secondary1";
    private static final String SECONDARY2 = "secondary2";
    private static final String SECONDARY3 = "secondary3";
    private static final String WHITE = "white";
    private static final String BLACK = "black";
    public static final String BORDER_PERIMITERPANE = "nb.PerimiterPane.border";
    public static final String BORDER_SPLITCHILD = "nb.splitChildBorder";
    public static final String BORDER_MAXFRAME_ACTIVE = "nb.maxFrameActiveBorder";
    public static final String BORDER_MAXFRAME_INACTIVE = "nb.maxFrameInactiveBorder";
    public static final String BORDER_DEFAULT_CONTAINER = "nb.defaultContainerBorder";
    public static final String BORDER_MINISTATUSBAR = "nb.MiniStatusBar.border";
    public static final String BORDER_TOPCOMPONENT = "nb.TopComponent.border";
    public static final String INSETS_SPLITCHILD = "nb.SplitChildInsets";
    public static final String UI_PROPERTYSHEETTABPANE = "nb.propSheetTabUI";
    public static final String COLOR_MINISTATUSBAR_BG = "nb.MiniStatusBar.foreground";
    public static final String COLOR_MINISTATUSBAR_FG = "nb.MiniStatusBar.background";
    public static final String BORDER_DESKTOPPANE = "DesktopPane.border";
    public static final String PERIMETER_GAP = "nb.perimeter.gap";
    public static final String BG_PERIMETERPANE = "nb.PerimeterPane.background";
    public static final String INSETS_CLOSEBUTTONTABPANE = "nb.CloseButtonTabPane.Insets";
    public static final String USE_BORDERPOLICY = "nb.useBorderPolicy";
    private HashSet activeThemes = null;
    private boolean inActiveTheme = false;
    private UIDefaults defaults = UIManager.getDefaults();

    public String getName() {
        return "NetBeans XML Theme";
    }

    public NbTheme() {
        this.addCustomDefaults();
        this.parseTheme();
    }

    private void addCustomDefaults() {
        this.defaults.put(PRIMARY1, new ColorUIResource(102, 102, 153));
        this.defaults.put(PRIMARY2, new ColorUIResource(153, 153, 204));
        this.defaults.put(PRIMARY3, new ColorUIResource(204, 204, 255));
        this.defaults.put(SECONDARY1, new ColorUIResource(102, 102, 102));
        this.defaults.put(SECONDARY2, new ColorUIResource(153, 153, 153));
        this.defaults.put(SECONDARY3, new ColorUIResource(204, 204, 204));
        this.defaults.put(WHITE, new ColorUIResource(255, 255, 255));
        this.defaults.put(BLACK, new ColorUIResource(0, 0, 0));
        FontUIResource controlFont = new FontUIResource(new Font("Dialog", 0, 11));
        this.defaults.put(CONTROLFONT, controlFont);
        this.defaults.put(SYSTEMFONT, controlFont);
        this.defaults.put(USERFONT, controlFont);
        this.defaults.put(MENUFONT, controlFont);
        this.defaults.put(WINDOWTITLEFONT, controlFont);
        this.defaults.put("List.font", controlFont);
        this.defaults.put("Tree.font", controlFont);
        this.defaults.put("Panel.font", controlFont);
        this.defaults.put("nb.errorForeground", new ColorUIResource(89, 79, 191));
        this.defaults.put(SUBFONT, new FontUIResource(new Font("Dialog", 0, 10)));
    }

    private void parseTheme() {
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(THEMEFILE_NAME);
        if (fo == null) {
            return;
        }
        try {
            XMLReaderAdapter p = new XMLReaderAdapter(XMLUtil.createXMLReader());
            p.setDocumentHandler(this);
            InputSource is = new InputSource(fo.getInputStream());
            is.setSystemId(fo.getURL().toExternalForm());
            p.parse(is);
            this.activeThemes = null;
        }
        catch (IOException ie) {
            ErrorManager.getDefault().notify(1, (Throwable)ie);
        }
        catch (SAXException se) {
            ErrorManager.getDefault().annotate((Throwable)se, 0, "Error parsing theme file", null, null, null);
            ErrorManager.getDefault().notify(1, (Throwable)se);
        }
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String p1, AttributeList atts) throws SAXException {
        if (p1.equals(THEMESET_TAG)) {
            String themes = atts.getValue(ACTIVE_ATTR);
            if (themes != null) {
                StringTokenizer tok = new StringTokenizer(themes, ",");
                this.activeThemes = new HashSet(tok.countTokens() + 1);
                while (tok.hasMoreTokens()) {
                    this.activeThemes.add(tok.nextToken().trim());
                }
            }
        } else if (p1.equals(THEME_TAG) && this.activeThemes != null) {
            String themeName = atts.getValue(NAME_ATTR);
            this.inActiveTheme = this.activeThemes.contains(themeName);
        } else if (this.inActiveTheme) {
            if (p1.equals(COLOR_ATTR)) {
                this.handleColor(atts);
                return;
            }
            if (p1.equals(FONT_TAG)) {
                this.handleFont(atts);
                return;
            }
            if (p1.equals(EMPTYBORDER_TAG)) {
                this.handleEmptyBorder(atts);
                return;
            }
            if (p1.equals(METRIC_TAG)) {
                this.handleMetric(atts);
                return;
            }
            if (p1.equals(STRING_TAG)) {
                this.handleString(atts);
                return;
            }
            if (p1.equals(INSETS_TAG)) {
                this.handleInsets(atts);
                return;
            }
            if (p1.equals(BOOL_TAG)) {
                this.handleBool(atts);
                return;
            }
            if (p1.equals(DIM_TAG)) {
                this.handleDim(atts);
                return;
            }
            if (p1.equals(ETCHEDBORDER_TAG)) {
                this.handleEtchedBorder(atts);
                return;
            }
            if (p1.equals(LINEBORDER_TAG)) {
                this.handleLineBorder(atts);
                return;
            }
            if (p1.equals(BEVELBORDER_TAG)) {
                this.handleBevelBorder(atts);
                return;
            }
            ErrorManager.getDefault().log(1, "UNRECOGNIZED THEME ENTRY " + p1 + "\" " + atts.toString());
        }
    }

    private final void handleFont(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        String fontname = atts.getValue(NAME_ATTR);
        String fontstylename = atts.getValue(FONTSTYLE_ATTR);
        int fontsize = this.intFromAttr(atts, FONTSIZE_ATTR);
        int fontstyle = 0;
        if (fontstylename.equals(FONTSTYLE_BOLD)) {
            fontstyle = 1;
        } else if (fontstylename.equals(FONTSTYLE_ITALIC)) {
            fontstyle = 2;
        }
        FontUIResource resource = new FontUIResource(fontname, fontstyle, fontsize);
        this.defaults.put(key, resource);
    }

    private final void handleColor(AttributeList atts) {
        int r = this.intFromAttr(atts, RED_ATTR);
        int g = this.intFromAttr(atts, GREEN_ATTR);
        int b = this.intFromAttr(atts, BLUE_ATTR);
        String key = atts.getValue(KEY_ATTR);
        ColorUIResource resource = new ColorUIResource(r, g, b);
        this.defaults.put(key, resource);
    }

    private final void handleMetric(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        Integer resource = Integer.valueOf(atts.getValue(VALUE_ATTR));
        this.defaults.put(key, resource);
    }

    private final void handleString(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        String resource = atts.getValue(VALUE_ATTR);
        this.defaults.put(key, resource);
    }

    private final void handleBool(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        Boolean resource = Boolean.valueOf(key);
        this.defaults.put(key, resource);
    }

    private final void handleDim(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        int width = this.intFromAttr(atts, WIDTH_ATTR);
        int height = this.intFromAttr(atts, HEIGHT_ATTR);
        DimensionUIResource resource = new DimensionUIResource(width, height);
        this.defaults.put(key, resource);
    }

    private final void handleInsets(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        int top = this.intFromAttr(atts, TOP_ATTR);
        int left = this.intFromAttr(atts, LEFT_ATTR);
        int bottom = this.intFromAttr(atts, BOTTOM_ATTR);
        int right = this.intFromAttr(atts, RIGHT_ATTR);
        InsetsUIResource resource = new InsetsUIResource(top, left, bottom, right);
        this.defaults.put(key, resource);
    }

    private final void handleEtchedBorder(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        int i = 1;
        String type = atts.getValue(TYPE_ATTR);
        if (type != null) {
            i = type.equals(TYPE_LOWERED) ? 1 : 0;
        }
        BorderUIResource.EtchedBorderUIResource resource = new BorderUIResource.EtchedBorderUIResource(i);
        this.defaults.put(key, resource);
    }

    private final void handleBevelBorder(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        int i = 1;
        String type = atts.getValue(TYPE_ATTR);
        if (type != null) {
            i = type.equals(TYPE_LOWERED) ? 1 : 0;
        }
        BorderUIResource.BevelBorderUIResource resource = new BorderUIResource.BevelBorderUIResource(i);
        this.defaults.put(key, resource);
    }

    private final void handleEmptyBorder(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        int top = this.intFromAttr(atts, TOP_ATTR);
        int left = this.intFromAttr(atts, LEFT_ATTR);
        int bottom = this.intFromAttr(atts, BOTTOM_ATTR);
        int right = this.intFromAttr(atts, RIGHT_ATTR);
        BorderUIResource.EmptyBorderUIResource resource = new BorderUIResource.EmptyBorderUIResource(top, left, bottom, right);
        this.defaults.put(key, resource);
    }

    private final void handleLineBorder(AttributeList atts) {
        String key = atts.getValue(KEY_ATTR);
        int r = this.intFromAttr(atts, RED_ATTR);
        int g = this.intFromAttr(atts, GREEN_ATTR);
        int b = this.intFromAttr(atts, BLUE_ATTR);
        int width = 1;
        if (atts.getValue(WIDTH_ATTR) != null) {
            width = this.intFromAttr(atts, WIDTH_ATTR);
        }
        Color c = new Color(r, g, b);
        BorderUIResource.LineBorderUIResource resource = new BorderUIResource.LineBorderUIResource(c);
        this.defaults.put(key, resource);
    }

    private final int intFromAttr(AttributeList atts, String key) {
        try {
            return Integer.valueOf(atts.getValue(key));
        }
        catch (NumberFormatException nfe) {
            ErrorManager.getDefault().notify(1, (Throwable)nfe);
            return 0;
        }
    }

    public void characters(char[] p1, int p2, int p3) throws SAXException {
    }

    public void setDocumentLocator(Locator p1) {
    }

    public void endElement(String p1) throws SAXException {
        if (p1.equals(THEME_TAG)) {
            this.inActiveTheme = false;
        }
    }

    public void ignorableWhitespace(char[] p1, int p2, int p3) throws SAXException {
    }

    public void processingInstruction(String p1, String p2) throws SAXException {
    }

    private final ColorUIResource getColor(String key) {
        return (ColorUIResource)this.defaults.get(key);
    }

    private final FontUIResource getFont(String key) {
        return (FontUIResource)this.defaults.get(key);
    }

    public FontUIResource getControlTextFont() {
        return this.getFont(CONTROLFONT);
    }

    public FontUIResource getSystemTextFont() {
        return this.getFont(SYSTEMFONT);
    }

    public FontUIResource getUserTextFont() {
        return this.getFont(USERFONT);
    }

    public FontUIResource getMenuTextFont() {
        return this.getFont(MENUFONT);
    }

    public FontUIResource getWindowTitleFont() {
        return this.getFont(WINDOWTITLEFONT);
    }

    public FontUIResource getSubTextFont() {
        return this.getFont(SUBFONT);
    }

    protected ColorUIResource getPrimary1() {
        return this.getColor(PRIMARY1);
    }

    protected ColorUIResource getPrimary2() {
        return this.getColor(PRIMARY2);
    }

    protected ColorUIResource getPrimary3() {
        return this.getColor(PRIMARY3);
    }

    protected ColorUIResource getSecondary1() {
        return this.getColor(SECONDARY1);
    }

    protected ColorUIResource getSecondary2() {
        return this.getColor(SECONDARY2);
    }

    protected ColorUIResource getSecondary3() {
        return this.getColor(SECONDARY3);
    }

    protected ColorUIResource getWhite() {
        return this.getColor(WHITE);
    }

    protected ColorUIResource getBlack() {
        return this.getColor(BLACK);
    }
}

