/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JPopupMenu;
import org.openide.ErrorManager;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class NodeOp {
    private static SystemAction[] defaultActions;
    static /* synthetic */ Class class$org$openide$ErrorManager;

    private NodeOp() {
    }

    public static SystemAction[] getDefaultActions() {
        if (defaultActions == null) {
            defaultActions = NodeOp.createFromNames(new String[]{"Tools", "Properties"});
        }
        return defaultActions;
    }

    public static void setDefaultActions(SystemAction[] def) {
        throw new SecurityException();
    }

    public static JPopupMenu findContextMenu(Node[] nodes) {
        return NodeOp.findContextMenuImpl(nodes, null);
    }

    static JPopupMenu findContextMenuImpl(Node[] nodes, ActionMap actionMap) {
        Action[] arr = NodeOp.findActions(nodes);
        ArrayList<Lookup> allLookups = new ArrayList<Lookup>();
        int i = 0;
        while (i < nodes.length) {
            allLookups.add(nodes[i].getLookup());
            ++i;
        }
        if (actionMap != null) {
            allLookups.add(Lookups.singleton(actionMap));
        }
        ProxyLookup lookup = new ProxyLookup(allLookups.toArray(new Lookup[0]));
        return Utilities.actionsToPopup(arr, lookup);
    }

    public static Action[] findActions(Node[] nodes) {
        Action[] arr;
        HashMap<Action, Integer> actions = new HashMap<Action, Integer>();
        int n = 0;
        while (n < nodes.length) {
            arr = nodes[n].getActions(false);
            if (arr == null) {
                arr = defaultActions;
            }
            HashSet<Action> counted = new HashSet<Action>();
            int i = 0;
            while (i < arr.length) {
                if (arr[i] != null && !counted.contains(arr[i])) {
                    counted.add(arr[i]);
                    Integer cntInt = (Integer)actions.get(arr[i]);
                    int cnt = cntInt == null ? 0 : cntInt;
                    actions.put(arr[i], new Integer(cnt + 1));
                }
                ++i;
            }
            ++n;
        }
        if (!actions.isEmpty()) {
            arr = nodes[0].getActions(false);
            if (arr == null) {
                arr = defaultActions;
            }
            ArrayList<Action> result = new ArrayList<Action>();
            HashSet<Action> counted = new HashSet<Action>();
            int i = 0;
            while (i < arr.length) {
                Action action = arr[i];
                if (action != null) {
                    if (!counted.contains(action)) {
                        int cnt;
                        counted.add(action);
                        Integer cntInt = (Integer)actions.get(action);
                        int n2 = cnt = cntInt == null ? 0 : cntInt;
                        if (cnt == nodes.length) {
                            result.add(action);
                        }
                    }
                } else {
                    result.add(null);
                }
                ++i;
            }
            return result.toArray(new Action[0]);
        }
        return new Action[0];
    }

    public static boolean isSon(Node parent, Node son) {
        return son.getParentNode() == parent;
    }

    public static String[] createPath(Node node, Node parent) {
        LinkedList<String> ar = new LinkedList<String>();
        while (node != null && node != parent) {
            if (node.getName() == null) {
                boolean isFilter = false;
                if (node instanceof FilterNode) {
                    isFilter = true;
                }
                throw new IllegalArgumentException("Node:" + node.getClass() + "[" + node.getDisplayName() + "]" + (isFilter ? " of original:" + ((FilterNode)node).getOriginal().getClass() : "") + " gets null name!");
            }
            ar.addFirst(node.getName());
            node = node.getParentNode();
        }
        String[] res = new String[ar.size()];
        ar.toArray(res);
        return res;
    }

    public static Node findChild(Node node, String name) {
        return node.getChildren().findChild(name);
    }

    public static Node findPath(Node start, Enumeration names) throws NodeNotFoundException {
        int depth = 0;
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Node next = NodeOp.findChild(start, name);
            if (next == null) {
                throw new NodeNotFoundException(start, name, depth);
            }
            start = next;
            ++depth;
        }
        return start;
    }

    public static Node findPath(Node start, String[] names) throws NodeNotFoundException {
        return NodeOp.findPath(start, new ArrayEnumeration(names));
    }

    public static Node findRoot(Node node) {
        Node parent;
        while ((parent = node.getParentNode()) != null) {
            node = parent;
        }
        return node;
    }

    public static int[] computePermutation(Node[] arr1, Node[] arr2) throws IllegalArgumentException {
        if (arr1.length != arr2.length) {
            int max = Math.max(arr1.length, arr2.length);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < max) {
                sb.append(i + " ");
                if (i < arr1.length) {
                    sb.append(arr1[i].getName());
                } else {
                    sb.append("---");
                }
                sb.append(" = ");
                if (i < arr2.length) {
                    sb.append(arr2[i].getName());
                } else {
                    sb.append("---");
                }
                sb.append('\n');
                ++i;
            }
            throw new IllegalArgumentException(sb.toString());
        }
        HashMap<Node, Integer> map = new HashMap<Node, Integer>();
        int i = 0;
        while (i < arr2.length) {
            map.put(arr2[i], new Integer(i));
            ++i;
        }
        int[] perm = new int[arr1.length];
        int diff = 0;
        int i2 = 0;
        while (i2 < arr1.length) {
            Integer newPos = (Integer)map.get(arr1[i2]);
            if (newPos == null) {
                throw new IllegalArgumentException("Missing permutation index " + i2);
            }
            perm[i2] = newPos;
            if (perm[i2] != i2) {
                ++diff;
            }
            ++i2;
        }
        return diff == 0 ? null : perm;
    }

    public static Node.Handle[] toHandles(Node[] nodes) {
        LinkedList<Node.Handle> ll = new LinkedList<Node.Handle>();
        int i = 0;
        while (i < nodes.length) {
            Node.Handle h = nodes[i].getHandle();
            if (h != null) {
                ll.add(h);
            }
            ++i;
        }
        return ll.toArray(new Node.Handle[ll.size()]);
    }

    public static Node[] fromHandles(Node.Handle[] handles) throws IOException {
        Node[] arr = new Node[handles.length];
        int i = 0;
        while (i < handles.length) {
            arr[i] = handles[i].getNode();
            ++i;
        }
        return arr;
    }

    static SystemAction[] createFromNames(String[] arr) {
        ErrorManager err = (ErrorManager)Lookup.getDefault().lookup(class$org$openide$ErrorManager == null ? (class$org$openide$ErrorManager = NodeOp.class$("org.openide.ErrorManager")) : class$org$openide$ErrorManager);
        LinkedList<SystemAction> ll = new LinkedList<SystemAction>();
        int i = 0;
        while (i < arr.length) {
            block5: {
                if (arr[i] == null) {
                    ll.add(null);
                } else {
                    String name = "org.openide.actions." + arr[i] + "Action";
                    try {
                        Class<?> c = Class.forName(name);
                        ll.add(SystemAction.get(c));
                    }
                    catch (ClassNotFoundException ex) {
                        if (err == null) break block5;
                        err.log(1, "NodeOp.java: Missing class " + name);
                    }
                }
            }
            ++i;
        }
        return ll.toArray(new SystemAction[ll.size()]);
    }

    static void exception(Throwable ex) {
        ErrorManager.getDefault().notify(1, ex);
    }

    static void warning(Throwable ex) {
        ErrorManager.getDefault().notify(16, ex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

