/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.DefaultPropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

final class TemplateWizard2
extends JPanel
implements DocumentListener {
    private ChangeListener listener;
    private static final String PROP_LOCATION_FOLDER = "locationFolder";
    private DataFolder locationFolder;
    private Reference fileSystemRef = new WeakReference<Object>(null);
    private DefaultPropertyModel locationFolderModel;
    private String extension;
    private JTextField newObjectName;
    private JLabel jLabel1;
    private JPanel namePanel;
    private PropertyPanel dataFolderPanel;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard2;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public TemplateWizard2() {
        this.initLocationFolder();
        this.initComponents();
        this.setName(DataObject.getString("LAB_TargetLocationPanelName"));
        ResourceBundle bundle = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = TemplateWizard2.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2);
        this.newObjectName.getDocument().addDocumentListener(this);
        this.newObjectName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.newObjectName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_NewObjectName"));
    }

    private void initLocationFolder() {
        PropertyDescriptor pd = null;
        try {
            Method getterMethod = this.getClass().getDeclaredMethod("getLocationFolder", new Class[0]);
            ((AccessibleObject)getterMethod).setAccessible(true);
            Method setterMethod = this.getClass().getDeclaredMethod("setLocationFolder", class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
            ((AccessibleObject)setterMethod).setAccessible(true);
            pd = new PropertyDescriptor(PROP_LOCATION_FOLDER, getterMethod, setterMethod);
        }
        catch (IntrospectionException ie) {
            ErrorManager.getDefault().notify(ie);
        }
        catch (NoSuchMethodException nsme) {
            ErrorManager.getDefault().notify(nsme);
        }
        this.locationFolderModel = new DefaultPropertyModel((Object)this, pd);
    }

    private static String defaultNewObjectName() {
        return DataObject.getString("FMT_DefaultNewObjectName");
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.newObjectName = new JTextField();
        this.dataFolderPanel = this.dataFolderPanel = new PropertyPanel(this.locationFolderModel, 2);
        this.setLayout(new BorderLayout());
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_NewObjectName_Mnemonic").charAt(0));
        this.jLabel1.setLabelFor(this.newObjectName);
        this.jLabel1.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_NewObjectName"));
        this.namePanel.add((Component)this.jLabel1, "West");
        this.newObjectName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                TemplateWizard2.this.newObjectNameFocusGained(evt);
            }
        });
        this.namePanel.add((Component)this.newObjectName, "Center");
        this.add((Component)this.namePanel, "North");
        this.add((Component)this.dataFolderPanel, "Center");
    }

    private void newObjectNameFocusGained(FocusEvent evt) {
        this.newObjectName.selectAll();
    }

    void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    public void addNotify() {
        super.addNotify();
        this.newObjectName.requestFocus();
    }

    void implReadSettings(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        DataObject template = wizard.getTemplate();
        if (template != null) {
            this.extension = template.getPrimaryFile().getExt();
        }
        this.setNewObjectName(wizard.getTargetName());
        try {
            this.setLocationFolder(wizard.getTargetFolder());
        }
        catch (IOException ioe) {
            this.setLocationFolder(null);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    void implStoreSettings(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        wizard.setTargetFolder(this.locationFolder);
        String name = this.newObjectName.getText();
        if (name.equals(TemplateWizard2.defaultNewObjectName())) {
            name = null;
        }
        wizard.setTargetName(name);
    }

    String implIsValid() {
        FileObject f;
        FileSystem fs = (FileSystem)this.fileSystemRef.get();
        if (this.locationFolder == null || fs == null) {
            return NbBundle.getMessage(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = TemplateWizard2.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2, "MSG_fs_or_folder_does_not_exist");
        }
        if (((FileSystem)this.fileSystemRef.get()).isReadOnly()) {
            return NbBundle.getMessage(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = TemplateWizard2.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2, "MSG_fs_is_readonly");
        }
        if (this.locationFolder == null) {
            this.locationFolder = DataFolder.findFolder(fs.getRoot());
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.locationFolder.getPrimaryFile().getPath());
        sb.append("/");
        sb.append(this.newObjectName.getText());
        if ("" != this.extension) {
            sb.append('.');
            sb.append(this.extension);
        }
        if ((f = fs.findResource(sb.toString())) != null) {
            return NbBundle.getMessage(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = TemplateWizard2.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2, "MSG_file_already_exist", sb.toString());
        }
        return null;
    }

    public void changedUpdate(DocumentEvent e) {
        if (e.getDocument() == this.newObjectName.getDocument()) {
            SwingUtilities.invokeLater(new Updater());
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument() == this.newObjectName.getDocument()) {
            SwingUtilities.invokeLater(new Updater());
        }
    }

    public void requestFocus() {
        this.newObjectName.requestFocus();
        this.newObjectName.selectAll();
    }

    private void setNewObjectName(String name) {
        String n = name;
        if (name == null || name.length() == 0) {
            n = TemplateWizard2.defaultNewObjectName();
        }
        this.newObjectName.getDocument().removeDocumentListener(this);
        this.newObjectName.setText(n);
        this.newObjectName.getDocument().addDocumentListener(this);
        if (name == null || name.length() == 0) {
            this.newObjectName.selectAll();
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void setLocationFolder(DataFolder fd) {
        if (this.locationFolder == fd) {
            return;
        }
        if (this.locationFolder != null && this.locationFolder.equals(fd)) {
            return;
        }
        DataFolder oldLocation = this.locationFolder;
        this.locationFolder = fd;
        this.firePropertyChange(PROP_LOCATION_FOLDER, oldLocation, this.locationFolder);
        if (fd != null) {
            try {
                this.fileSystemRef = new WeakReference<FileSystem>(fd.getPrimaryFile().getFileSystem());
            }
            catch (FileStateInvalidException fsie) {
                this.fileSystemRef = new WeakReference<Object>(null);
            }
        }
        this.fireStateChanged();
    }

    public DataFolder getLocationFolder() {
        return this.locationFolder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Updater
    implements Runnable {
        Updater() {
        }

        public void run() {
            if (TemplateWizard2.this.newObjectName.getText().equals("")) {
                TemplateWizard2.this.setNewObjectName("");
            }
            TemplateWizard2.this.fireStateChanged();
        }
    }
}

