/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.openide.awt.HtmlBrowser;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class TemplateWizard1
extends JPanel
implements DataFilter,
ExplorerManager.Provider,
PropertyChangeListener {
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private ChangeListener listener;
    private DataObject template;
    private DataFolder templatesRoot;
    private ExplorerManager manager;
    private boolean firstPaint = true;
    private JLabel browserLabel;
    private JLabel templatesLabel;
    private JLabel noBrowser;
    private JPanel browserPanel;
    private TemplatesTreeView treeView;
    private HtmlBrowser browser;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard1;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;

    public TemplateWizard1() {
        this.initComponents();
        this.treeView = new TemplatesTreeView();
        this.treeView.setDefaultActionAllowed(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setSelectionMode(1);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.insets = new Insets(0, 0, 11, 0);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints1);
        ResourceBundle bundle = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = TemplateWizard1.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1);
        this.setName(bundle.getString("LAB_TemplateChooserPanelName"));
        this.putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
        this.putClientProperty(PROP_CONTENT_DATA, new String[]{this.getName(), "..."});
        this.putClientProperty("LAB_SelectTemplateBorder", bundle.getString("LAB_SelectTemplateBorder"));
        this.putClientProperty("LAB_SelectTemplateBorder_Mnemonic", bundle.getString("LAB_SelectTemplateBorder_Mnemonic"));
        this.putClientProperty("LAB_TemplateDescriptionBorder", bundle.getString("LAB_TemplateDescriptionBorder"));
        this.putClientProperty("LAB_TemplateDescriptionBorder_Mnemonic", bundle.getString("LAB_TemplateDescriptionBorder_Mnemonic"));
        this.putClientProperty("ACSD_TemplatesTree", bundle.getString("ACSD_TemplatesTree"));
        this.putClientProperty("ACSD_TemplateWizard1", bundle.getString("ACSD_TemplateWizard1"));
        this.updateRootNode(null);
        this.templatesLabel.setLabelFor(this.treeView);
        this.noBrowser.setText(bundle.getString("MSG_InitDescription"));
        CardLayout card = (CardLayout)this.browserPanel.getLayout();
        card.show(this.browserPanel, "noBrowser");
    }

    public void addNotify() {
        this.templatesLabel.setText((String)this.getClientProperty("LAB_SelectTemplateBorder"));
        this.templatesLabel.setDisplayedMnemonic(((String)this.getClientProperty("LAB_SelectTemplateBorder_Mnemonic")).charAt(0));
        this.browserLabel.setText((String)this.getClientProperty("LAB_TemplateDescriptionBorder"));
        this.browserLabel.setDisplayedMnemonic(((String)this.getClientProperty("LAB_TemplateDescriptionBorder_Mnemonic")).charAt(0));
        this.treeView.getAccessibleContext().setAccessibleDescription((String)this.getClientProperty("ACSD_TemplatesTree"));
        this.getAccessibleContext().setAccessibleDescription((String)this.getClientProperty("ACSD_TemplateWizard1"));
        super.addNotify();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
            this.manager.addPropertyChangeListener(this);
        }
        return this.manager;
    }

    public boolean requestDefaultFocus() {
        return this.treeView.requestDefaultFocus();
    }

    public Dimension getPreferredSize() {
        return TemplateWizard.PREF_DIM;
    }

    private void updateRootNode(DataFolder root) {
        FileObject fo;
        if (root == null && (fo = Repository.getDefault().getDefaultFileSystem().findResource("/Templates")) != null && fo.isFolder()) {
            root = DataFolder.findFolder(fo);
        }
        if (root.equals(this.templatesRoot)) {
            return;
        }
        this.templatesRoot = root;
        DataShadowFilterChildren ch = new DataShadowFilterChildren(root.getNodeDelegate());
        this.getExplorerManager().setRootContext(new DataShadowFilterNode(root.getNodeDelegate(), ch, root.getNodeDelegate().getDisplayName()));
    }

    private void updateDescription(DataObject obj) {
        URL url = null;
        if (obj != null) {
            url = TemplateWizard.getDescription(obj);
        }
        CardLayout card = (CardLayout)this.browserPanel.getLayout();
        if (url != null && this.getExplorerManager().getSelectedNodes().length != 0) {
            if (this.browser != null) {
                this.browser.setURL(url);
                if (!this.browser.isVisible()) {
                    card.show(this.browserPanel, "browser");
                }
            }
        } else {
            card.show(this.browserPanel, "noBrowser");
        }
    }

    private void initComponents() {
        this.browserPanel = new JPanel();
        this.noBrowser = new JLabel();
        this.templatesLabel = new JLabel();
        this.browserLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(0, 0));
        this.browserPanel.setLayout(new CardLayout());
        this.noBrowser.setBackground((Color)UIManager.getDefaults().get("EditorPane.background"));
        this.noBrowser.setHorizontalAlignment(0);
        this.noBrowser.setMinimumSize(new Dimension(0, 25));
        this.noBrowser.setOpaque(true);
        this.browserPanel.add((Component)this.noBrowser, "noBrowser");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.5;
        this.add((Component)this.browserPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.templatesLabel, gridBagConstraints);
        this.browserLabel.setLabelFor(this.browser);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.browserLabel, gridBagConstraints);
    }

    private void nameFocusGained(FocusEvent evt) {
    }

    private void templatesTreeValueChanged(TreeSelectionEvent evt) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "selectedNodes" && this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
            this.updateDescription(this.template);
        }
    }

    private void packagesListValueChanged(ListSelectionEvent evt) {
    }

    public boolean acceptDataObject(DataObject obj) {
        if (obj instanceof DataFolder) {
            Object o = obj.getPrimaryFile().getAttribute("simple");
            return o == null || Boolean.TRUE.equals(o);
        }
        return obj.isTemplate();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint) {
            this.firstPaint = false;
            RequestProcessor.getDefault().post(new BrowserLoader(), 1);
        }
    }

    void implReadSettings(Object settings) {
        TemplateWizard wizard = (TemplateWizard)settings;
        wizard.setTitle(NbBundle.getBundle(class$org$openide$loaders$TemplateWizard == null ? (class$org$openide$loaders$TemplateWizard = TemplateWizard1.class$("org.openide.loaders.TemplateWizard")) : class$org$openide$loaders$TemplateWizard).getString("CTL_TemplateTitle"));
        this.updateRootNode(wizard.getTemplatesFolder());
        this.template = wizard.getTemplate();
        if (this.template != null && !this.template.isValid()) {
            this.template = null;
        }
        DataFolder stop = wizard.getTemplatesFolder();
        final LinkedList<String> ll = new LinkedList<String>();
        for (DataObject obj = this.template; obj != null && obj != stop; obj = obj.getFolder()) {
            String key = obj.getNodeDelegate().getName();
            ll.addFirst(key);
        }
        RequestProcessor.getDefault().post(new Runnable(){
            private Node selection;

            public void run() {
                if (this.selection == null) {
                    Node node = TemplateWizard1.this.getExplorerManager().getRootContext();
                    ListIterator it = ll.listIterator();
                    while (it.hasNext()) {
                        String name = (String)it.next();
                        if ((node = node.getChildren().findChild(name)) != null) continue;
                        node = TemplateWizard1.this.getExplorerManager().getRootContext();
                        break;
                    }
                    this.selection = node;
                    SwingUtilities.invokeLater(this);
                } else {
                    try {
                        TemplateWizard1.this.getExplorerManager().setSelectedNodes(new Node[]{this.selection});
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }, 300, 1);
    }

    void implStoreSettings(Object settings) {
        if (this.template != null) {
            TemplateWizard wizard = (TemplateWizard)settings;
            if (wizard.getTemplate() != this.template) {
                Component c = wizard.targetChooser().getComponent();
                if (c instanceof JComponent) {
                    ((JComponent)c).putClientProperty(PROP_CONTENT_DATA, new String[]{c.getName()});
                    ((JComponent)c).putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
                }
            } else {
                Component c = wizard.targetChooser().getComponent();
                if (c instanceof JComponent && ((JComponent)c).getClientProperty(PROP_CONTENT_DATA) == null) {
                    ((JComponent)c).putClientProperty(PROP_CONTENT_DATA, new String[]{c.getName()});
                    ((JComponent)c).putClientProperty(PROP_CONTENT_SELECTED_INDEX, new Integer(0));
                }
            }
            wizard.setTemplateImpl(this.template, false);
        }
    }

    boolean implIsValid() {
        boolean enable = false;
        Node[] n = this.getExplorerManager().getSelectedNodes();
        if (n.length == 1) {
            this.template = (DataObject)n[0].getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateWizard1.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            enable = this.template != null && this.template.isTemplate();
        }
        return enable;
    }

    void addChangeListener(ChangeListener l) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    void removeChangeListener(ChangeListener l) {
        this.listener = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class TemplatesTreeView
    extends BeanTreeView {
        TemplatesTreeView() {
            this.tree.setEditable(false);
        }

        protected NodeTreeModel createModel() {
            return new TemplatesModel();
        }
    }

    private static final class TemplatesModel
    extends NodeTreeModel {
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        TemplatesModel() {
        }

        public int getChildCount(Object o) {
            Node n = Visualizer.findNode(o);
            DataObject obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplatesModel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return obj == null || obj.isTemplate() ? 0 : super.getChildCount(o);
        }

        public boolean isLeaf(Object o) {
            Node n = Visualizer.findNode(o);
            DataObject obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplatesModel.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            return obj == null || obj.isTemplate();
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private final class BrowserLoader
    implements Runnable {
        private boolean loadStage = true;
        private HtmlBrowser localBrowser;
        private String noDescMsg;
        private Border noDescBorder;
        static /* synthetic */ Class class$org$openide$loaders$TemplateWizard1;

        BrowserLoader() {
        }

        public void run() {
            if (this.loadStage) {
                this.loadStage = false;
                this.localBrowser = new HtmlBrowser(false, false);
                this.localBrowser.setName("browser");
                this.noDescMsg = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard1 == null ? (class$org$openide$loaders$TemplateWizard1 = BrowserLoader.class$("org.openide.loaders.TemplateWizard1")) : class$org$openide$loaders$TemplateWizard1).getString("MSG_NoDescription");
                this.noDescBorder = new EtchedBorder();
                SwingUtilities.invokeLater(this);
            } else {
                TemplateWizard1.this.browser = this.localBrowser;
                TemplateWizard1.this.browserLabel.setLabelFor(TemplateWizard1.this.browser);
                TemplateWizard1.this.browser.getAccessibleContext().setAccessibleName(TemplateWizard1.this.browserLabel.getText());
                TemplateWizard1.this.browserPanel.add((Component)TemplateWizard1.this.browser, "browser");
                TemplateWizard1.this.updateDescription(TemplateWizard1.this.template);
                TemplateWizard1.this.noBrowser.setText(this.noDescMsg);
                TemplateWizard1.this.noBrowser.setBorder(this.noDescBorder);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class DataShadowFilterNode
    extends FilterNode {
        private String name;

        public DataShadowFilterNode(Node or, Children children, String name) {
            super(or, children);
            this.name = name;
            this.disableDelegation(4);
        }

        public String getDisplayName() {
            return this.name;
        }

        public boolean canRename() {
            return false;
        }
    }

    private class DataShadowFilterChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public DataShadowFilterChildren(Node or) {
            super(or);
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            String nodeName = n.getDisplayName();
            DataObject obj = null;
            DataShadow shadow = (DataShadow)n.getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = DataShadowFilterChildren.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
            if (shadow != null) {
                DataNode dn = new DataNode(shadow, Children.LEAF);
                nodeName = dn.getDisplayName();
                obj = shadow.getOriginal();
                n = obj.getNodeDelegate();
            }
            if (obj == null) {
                obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = DataShadowFilterChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            }
            if (obj != null) {
                if (obj.isTemplate()) {
                    return new Node[]{new DataShadowFilterNode(n, Children.LEAF, nodeName)};
                }
                if (TemplateWizard1.this.acceptDataObject(obj)) {
                    return new Node[]{new DataShadowFilterNode(n, new DataShadowFilterChildren(n), nodeName)};
                }
            }
            return new Node[0];
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

