/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.IOException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;

class SettingsEntry
extends FileEntry {
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public SettingsEntry(MultiDataObject obj, FileObject file) {
        super(obj, file);
    }

    public FileObject copy(FileObject f, String suffix) throws IOException {
        return this.copy_internal(f, suffix);
    }

    public FileObject move(FileObject f, String suffix) throws IOException {
        FileObject nue = this.copy_internal(f, suffix);
        super.delete();
        return nue;
    }

    public FileObject createFromTemplate(FileObject f, String name) throws IOException {
        String ext = this.getExt(this.getFile());
        String newName = ext == null ? name : name + "." + ext;
        FileObject nue = FileUtil.createFolder(f, newName);
        DataObject[] children = null;
        try {
            children = DataFolder.findContainer(this.getFile()).getChildren();
        }
        catch (Exception e) {
            children = null;
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                DataFolder data = (DataFolder)children[i].getCookie(class$org$openide$loaders$DataFolder == null ? SettingsEntry.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                if (data != null) {
                    FileObject dataf = FileUtil.createFolder(nue, data.getPrimaryFile().getName());
                    this.createFromTemplate_datafolder(data, DataFolder.findFolder(dataf));
                }
                ++i;
            }
        }
        return nue;
    }

    public FileObject rename(String name) throws IOException {
        String ext = this.getExt(this.getFile());
        String newName = ext == null ? name : name + "." + ext;
        boolean locked = this.isLocked();
        FileLock lock = this.takeLock();
        try {
            this.getFile().rename(lock, newName, this.getFile().getExt());
            Object var7_6 = null;
            if (!locked) {
                lock.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!locked) {
                lock.releaseLock();
            }
            throw throwable;
        }
        return this.getFile();
    }

    private FileObject copy_internal(FileObject f, String suffix) throws IOException {
        FileObject orig = this.getFile();
        FileObject nue = FileUtil.createFolder(f, orig.getName() + suffix);
        DataObject[] children = null;
        try {
            children = DataFolder.findContainer(orig).getChildren();
        }
        catch (Exception e) {
            children = null;
        }
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                DataFolder data = (DataFolder)children[i].getCookie(class$org$openide$loaders$DataFolder == null ? SettingsEntry.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
                if (data != null) {
                    FileObject dataf = FileUtil.createFolder(nue, data.getPrimaryFile().getName());
                    this.copy_datafolder(data, DataFolder.findFolder(dataf));
                }
                ++i;
            }
        }
        return nue;
    }

    private void copy_datafolder(DataFolder src, DataFolder trg) throws IOException {
        DataObject[] children = src.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].copy(trg);
                ++i;
            }
        }
    }

    private void createFromTemplate_datafolder(DataFolder src, DataFolder trg) throws IOException {
        DataObject[] children = src.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].createFromTemplate(trg);
                ++i;
            }
        }
    }

    private String getExt(FileObject f) {
        String name = f.getNameExt();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        return name.substring(i + 1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

