/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

final class FilesSet
implements Set {
    private Object primaryFile;
    private HashMap secondary;
    private TreeSet delegate;

    public FilesSet(Object primaryFile, HashMap secondary) {
        this.primaryFile = primaryFile;
        this.secondary = secondary;
    }

    private Set getDelegate() {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            if (this.delegate == null) {
                this.delegate = new TreeSet(new FilesComparator());
                this.delegate.add(this.primaryFile);
                this.delegate.addAll(this.secondary.keySet());
            }
        }
        return this.delegate;
    }

    public boolean add(Object obj) {
        return this.getDelegate().add(obj);
    }

    public boolean addAll(Collection collection) {
        return this.getDelegate().addAll(collection);
    }

    public void clear() {
        this.getDelegate().clear();
    }

    public boolean contains(Object obj) {
        return this.getDelegate().contains(obj);
    }

    public boolean containsAll(Collection collection) {
        return this.getDelegate().containsAll(collection);
    }

    public boolean isEmpty() {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            boolean bl = this.delegate == null ? false : this.delegate.isEmpty();
            return bl;
        }
    }

    public Iterator iterator() {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            Iterator iterator = this.delegate == null ? new FilesIterator() : this.delegate.iterator();
            return iterator;
        }
    }

    public boolean remove(Object obj) {
        return this.getDelegate().remove(obj);
    }

    public boolean removeAll(Collection collection) {
        return this.getDelegate().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getDelegate().retainAll(collection);
    }

    public int size() {
        HashMap hashMap = this.secondary;
        synchronized (hashMap) {
            int n = this.delegate == null ? this.secondary.size() + 1 : this.delegate.size();
            return n;
        }
    }

    public Object[] toArray() {
        return this.getDelegate().toArray();
    }

    public Object[] toArray(Object[] obj) {
        return this.getDelegate().toArray(obj);
    }

    private final class FilesComparator
    implements Comparator {
        FilesComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == obj2) {
                return 0;
            }
            if (obj1 == FilesSet.this.primaryFile) {
                return -1;
            }
            if (obj2 == FilesSet.this.primaryFile) {
                return 1;
            }
            FileObject f1 = (FileObject)obj1;
            FileObject f2 = (FileObject)obj2;
            int res = f1.getNameExt().compareTo(f2.getNameExt());
            if (res == 0) {
                try {
                    if (f1.getFileSystem() == f2.getFileSystem()) {
                        return 0;
                    }
                    return f1.getFileSystem().getSystemName().compareTo(f2.getFileSystem().getSystemName());
                }
                catch (FileStateInvalidException fsie) {
                    return 0;
                }
            }
            return res;
        }
    }

    private final class FilesIterator
    implements Iterator {
        private boolean first = true;
        private Iterator itDelegate = null;

        FilesIterator() {
        }

        public boolean hasNext() {
            return this.first ? true : this.getIteratorDelegate().hasNext();
        }

        public Object next() {
            if (this.first) {
                this.first = false;
                return FilesSet.this.primaryFile;
            }
            return this.getIteratorDelegate().next();
        }

        public void remove() {
            this.getIteratorDelegate().remove();
        }

        private Iterator getIteratorDelegate() {
            if (this.itDelegate == null) {
                this.itDelegate = FilesSet.this.getDelegate().iterator();
                this.itDelegate.next();
            }
            return this.itDelegate;
        }
    }
}

