/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XpandFacade {
    private XpandExecutionContext ctx = null;

    @Deprecated
    public XpandFacade(XpandExecutionContext ctx) {
        this.ctx = ctx;
    }

    public void evaluate(String definitionName, Object targetObject, Object ... params) {
        this.evaluate2(definitionName, targetObject, params != null ? Arrays.asList(params) : null);
    }

    public void evaluate2(String definitionName, Object targetObject, List<Object> paramList) {
        if (paramList == null) {
            paramList = Collections.emptyList();
        }
        Type targetType = this.ctx.getType(targetObject);
        Type[] paramTypes = new Type[paramList.size()];
        int i = 0;
        while (i < paramTypes.length) {
            Object obj = paramList.get(i);
            paramTypes[i] = this.ctx.getType(obj);
            ++i;
        }
        XpandDefinition def = this.ctx.findDefinition(definitionName, targetType, paramTypes);
        if (def == null) {
            throw new EvaluationException("No Definition " + definitionName + this.getParamString(paramTypes) + " for " + targetType.getName() + " could be found!", null, (ExecutionContext)this.ctx);
        }
        this.ctx = (XpandExecutionContext)this.ctx.cloneWithVariable(new Variable("this", targetObject));
        int i2 = 0;
        while (i2 < paramList.size()) {
            Variable v = new Variable(def.getParams()[i2].getName().getValue(), paramList.get(i2));
            this.ctx = (XpandExecutionContext)this.ctx.cloneWithVariable(v);
            ++i2;
        }
        this.ctx = (XpandExecutionContext)this.ctx.cloneWithResource(def.getOwner());
        def.evaluate(this.ctx);
    }

    private String getParamString(Type[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            Type t = paramTypes[i];
            buff.append(t.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(",");
            }
            ++i;
        }
        buff.append(")");
        return buff.toString();
    }

    public AnalysationIssue[] analyze(String templateName) {
        HashSet issues = new HashSet();
        XpandResource tpl = this.ctx.findTemplate(templateName);
        tpl.analyze(this.ctx, issues);
        return issues.toArray(new AnalysationIssue[issues.size()]);
    }

    public static XpandFacade create(XpandExecutionContext execCtx) {
        return new XpandFacade(execCtx);
    }
}

