/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

public class BindKey {
    private String type;
    private boolean isSingleton = false;
    private boolean isEagerSingleton = false;

    public String toString() {
        if (this.isSingleton) {
            return "singleton " + this.type;
        }
        if (this.isEagerSingleton) {
            return "eagerSingleton " + this.type;
        }
        return this.type;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSingleton() {
        return this.isSingleton;
    }

    public boolean isEagerSingleton() {
        return this.isEagerSingleton;
    }

    private BindKey(String type, boolean isSingleton, boolean isEagerSingleton) {
        this.type = type;
        this.isSingleton = isSingleton;
        this.isEagerSingleton = isEagerSingleton;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BindKey other = (BindKey)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public static BindKey type(String name) {
        return new BindKey(name, false, false);
    }

    public static BindKey eagerSingleton(String name) {
        return new BindKey(name, true, true);
    }

    public static BindKey singleton(String name) {
        return new BindKey(name, true, false);
    }
}

