/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Microscope
extends JPanel {
    static boolean DETERMINISTIC = false;
    static int nprocs;
    static int lookAheads;
    static boolean autostart;
    Board board = new Board();
    Player player = Player.Blue;
    final AutoMover auto;
    final User user;
    Mover mover = null;
    Vector history = new Vector();
    boolean demoMode = true;
    final BoardPanel boardPanel = new BoardPanel();
    JLabel scoreLabel = new JLabel("Score:   0 ");
    JButton autoButton = new JButton(" Start ");
    JButton undoButton = new JButton("Undo");
    JButton modeButton = new JButton("Demo mode");
    JSlider levelSlider = new JSlider(1, 2, 6, lookAheads);
    static final int CELL_SIZE = 40;
    static final Color paleGreen;
    static final Color darkGreen;
    static final Color possibleMoveColor;

    static {
        lookAheads = 3;
        autostart = false;
        paleGreen = new Color(152, 251, 152);
        darkGreen = new Color(60, 179, 113);
        possibleMoveColor = Color.yellow;
    }

    public static void main(String[] args) {
        try {
            nprocs = Integer.parseInt(args[0]);
            if (args.length > 1) {
                autostart = true;
                lookAheads = Integer.parseInt(args[1]);
                DETERMINISTIC = true;
            }
        }
        catch (Exception e) {
            System.out.println("Usage: java Microscope <threads> [<level>]");
            return;
        }
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Microscope t = new Microscope();
        ((Component)frame).setSize(new Dimension(400, 400));
        frame.getContentPane().add(t);
        ((Component)frame).setVisible(true);
        t.init();
    }

    synchronized Board getBoard() {
        return this.board;
    }

    synchronized void setBoard(Board b) {
        this.board = b;
        this.boardPanel.repaint();
    }

    synchronized Player getPlayer() {
        return this.player;
    }

    synchronized void setPlayer(Player p) {
        this.player = p;
    }

    synchronized Mover getMover() {
        return this.mover;
    }

    synchronized void setMover(Mover m) {
        this.mover = m;
    }

    synchronized boolean isMoving() {
        return this.mover != null;
    }

    synchronized boolean getDemoMode() {
        return this.demoMode;
    }

    synchronized void setDemoMode(boolean b) {
        this.demoMode = b;
    }

    synchronized boolean toggleDemoMode() {
        this.demoMode = !this.demoMode;
        return this.demoMode;
    }

    public Microscope() {
        this.auto = new AutoMover(this);
        this.user = new User(this);
        JPanel topPanel = new JPanel();
        this.autoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!Microscope.this.isMoving()) {
                    Microscope.this.startMover(Microscope.this.auto);
                    Microscope.this.autoButton.setText("Cancel");
                } else {
                    Microscope.this.stopMover();
                    if (Microscope.this.getDemoMode()) {
                        Microscope.this.autoButton.setText(" Start ");
                    } else {
                        Microscope.this.autoButton.setText(" Find ");
                    }
                }
            }
        });
        this.modeButton.addActionListener(new ActionListener(){

            public synchronized void actionPerformed(ActionEvent e) {
                Microscope.this.toggleDemoMode();
                Microscope.this.updateStatus();
            }
        });
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Microscope.this.undo();
            }
        });
        this.levelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Microscope.this.setLevel(((JSlider)e.getSource()).getValue());
            }
        });
        Dimension labDim = new Dimension(72, 24);
        this.scoreLabel.setMinimumSize(labDim);
        this.scoreLabel.setPreferredSize(labDim);
        topPanel.add(this.autoButton);
        topPanel.add(this.modeButton);
        topPanel.add(this.undoButton);
        topPanel.add(this.scoreLabel);
        this.add(topPanel);
        this.levelSlider.setLabelTable(this.levelSlider.createStandardLabels(1));
        this.levelSlider.setPaintLabels(true);
        JPanel botPanel = new JPanel();
        botPanel.add(this.boardPanel);
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
        sliderPanel.add(this.levelSlider);
        sliderPanel.add(new JLabel("Level"));
        botPanel.add(sliderPanel);
        this.add(botPanel);
    }

    void initializeBoard() {
        this.board.reset();
        this.board.occupy(Player.Blue, 0, 0);
        this.board.occupy(Player.Blue, 6, 6);
        this.board.occupy(Player.Green, 0, 6);
        this.board.occupy(Player.Green, 6, 0);
        this.setPlayer(Player.Blue);
        this.boardPanel.repaint();
    }

    public void init() {
        this.initializeBoard();
        if (autostart) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                return;
            }
            this.startMover(this.auto);
        }
    }

    synchronized void setLevel(int l) {
        lookAheads = l;
        if (lookAheads <= 1) {
            lookAheads = 2;
        }
    }

    public int level() {
        return lookAheads;
    }

    public void move(Move m, Mover mvr) {
        if (mvr != this.mover || m == null || mvr == this.user && !m.isLegal()) {
            this.setMover(null);
            if (mvr == this.auto && autostart) {
                this.auto.stats();
                System.exit(0);
            }
        } else {
            m.commit();
            this.setBoard(m.board());
            this.setPlayer(m.player().opponent());
            this.history.addElement(m);
            if (mvr == this.auto && this.getDemoMode() && !m.isPass()) {
                if (this.getBoard().gameOver()) {
                    if (autostart) {
                        this.auto.stats();
                        System.exit(0);
                    } else {
                        this.setMover(null);
                    }
                } else {
                    this.auto.startTurn(new Board(this.getBoard()), this.getPlayer());
                }
            } else {
                this.setMover(null);
            }
        }
    }

    void startMover(Mover m) {
        Mover mvr = this.getMover();
        if (mvr == null) {
            this.setMover(m);
            m.startTurn(new Board(this.getBoard()), this.player);
        }
    }

    void stopMover() {
        Mover mvr = this.getMover();
        if (mvr != null) {
            this.setMover(null);
            mvr.cancel();
        }
    }

    synchronized void undo() {
        if (this.mover == null) {
            if (this.history.size() > 1) {
                this.history.removeElementAt(this.history.size() - 1);
                Move m = (Move)this.history.lastElement();
                this.setPlayer(m.player().opponent());
                this.setBoard(m.board());
            } else if (this.history.size() == 1) {
                this.history.removeAllElements();
                this.initializeBoard();
            }
        }
    }

    void userMove(int row, int col) {
        this.startMover(this.user);
        this.user.choose(row, col);
    }

    void updateStatus() {
        Player p = this.getPlayer();
        int s = this.getBoard().score(p);
        this.scoreLabel.setForeground(Microscope.displayColor(p));
        this.scoreLabel.setText("Score: " + s);
        if (this.getDemoMode()) {
            this.modeButton.setText("Demo  mode");
        } else if (this.getPlayer().isBlue()) {
            this.modeButton.setText("Blue  turn");
        } else {
            this.modeButton.setText("Green turn");
        }
        if (!autostart) {
            this.auto.stats();
        }
    }

    public static Color displayColor(Player pl) {
        if (pl.isBlue()) {
            return Color.blue;
        }
        if (pl.isGreen()) {
            return darkGreen;
        }
        return Color.white;
    }

    public static Color lightDisplayColor(Player pl) {
        if (pl.isBlue()) {
            return Color.cyan;
        }
        if (pl.isGreen()) {
            return paleGreen;
        }
        return Color.gray;
    }

    class BoardPanel
    extends Canvas
    implements MouseListener {
        BoardPanel() {
            this.setSize(new Dimension(285, 285));
            this.addMouseListener(this);
        }

        public void paint(Graphics g) {
            Board b = Microscope.this.getBoard();
            Player p = Microscope.this.getPlayer();
            int row = 0;
            while (row < 7) {
                int col = 0;
                while (col < 7) {
                    if (Microscope.this.user.placing()) {
                        if (Microscope.this.user.hasMovedFrom(row, col)) {
                            g.setColor(Microscope.lightDisplayColor(p));
                        } else if (Microscope.this.user.canMoveTo(row, col)) {
                            g.setColor(possibleMoveColor);
                        } else {
                            g.setColor(Microscope.displayColor(b.occupant(row, col)));
                        }
                    } else {
                        g.setColor(Microscope.displayColor(b.occupant(row, col)));
                    }
                    g.fillRect(row * 40, col * 40, 40, 40);
                    ++col;
                }
                ++row;
            }
            g.setColor(Color.black);
            int i = 0;
            while (i <= 7) {
                g.drawLine(0, i * 40, 280, i * 40);
                g.drawLine(i * 40, 0, i * 40, 280);
                ++i;
            }
            Microscope.this.updateStatus();
        }

        public void mouseReleased(MouseEvent evt) {
            int y;
            int col;
            int x = evt.getX();
            int row = x / 40;
            if (Board.inBounds(row, col = (y = evt.getY()) / 40)) {
                Microscope.this.userMove(row, col);
                this.repaint();
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }
    }

    static final class Player {
        public static final int EMPTY = 0;
        public static final int BLUE = 1;
        public static final int GREEN = 2;
        public static final int ILLEGAL_PLAYER_VALUE = 3;
        public static final Player Empty = new Player(0);
        public static final Player Blue = new Player(1);
        public static final Player Green = new Player(2);
        public static final Player Illegal = new Player(3);
        int code_;

        public Player(int code) {
            this.code_ = code;
        }

        public Player(Player p) {
            this.code_ = p.code_;
        }

        public boolean same(Player p) {
            return this.code_ == p.code_;
        }

        public boolean isEmpty() {
            return this.code_ == 0;
        }

        public boolean isBlue() {
            return this.code_ == 1;
        }

        public boolean isGreen() {
            return this.code_ == 2;
        }

        public boolean isLegal() {
            return this.code_ <= 2;
        }

        public Player opponent() {
            if (this.code_ == 2) {
                return Blue;
            }
            if (this.code_ == 1) {
                return Green;
            }
            return Illegal;
        }
    }

    static final class Board {
        public static final int RANKS = 7;
        public static final int CELLS = 49;
        static final long FULL = 0x1FFFFFFFFFFFFL;
        static final long BLUEBIT = 0x2000000000000L;
        static final long[] adjacentMasks = new long[49];
        static final long[] cellBits = new long[49];
        static final byte[][] jumpDestinations = new byte[49][];
        long blue_;
        long green_;

        static {
            byte[] dests = new byte[49];
            int j = 0;
            while (j < 7) {
                int i = 0;
                while (i < 7) {
                    int k = i + j * 7;
                    long nmask = 0L;
                    int jumpCount = 0;
                    int c = j - 2;
                    while (c <= j + 2) {
                        int r = i - 2;
                        while (r <= i + 2) {
                            if (c >= 0 && c < 7 && r >= 0 && r < 7) {
                                int cellIndex = r + c * 7;
                                if (r == i - 2 || r == i + 2 || c == j - 2 || c == j + 2) {
                                    dests[jumpCount++] = (byte)cellIndex;
                                } else if (r != i || c != j) {
                                    nmask |= 1L << cellIndex;
                                }
                            }
                            ++r;
                        }
                        ++c;
                    }
                    Board.adjacentMasks[k] = nmask;
                    Board.cellBits[k] = 1L << k;
                    Board.jumpDestinations[k] = new byte[jumpCount];
                    int l = 0;
                    while (l < jumpCount) {
                        Board.jumpDestinations[k][l] = dests[l];
                        ++l;
                    }
                    ++i;
                }
                ++j;
            }
        }

        public static boolean inBounds(int row, int col) {
            return row >= 0 && row < 7 && col >= 0 && col < 7;
        }

        public Board() {
            this.blue_ = 0L;
            this.green_ = 0L;
        }

        public Board(Board b) {
            this.blue_ = b.blue_;
            this.green_ = b.green_;
        }

        public Board(long b, long g) {
            this.blue_ = b;
            this.green_ = g;
        }

        public void copyState(Board b) {
            this.blue_ = b.blue_;
            this.green_ = b.green_;
        }

        void reset() {
            this.blue_ = 0L;
            this.green_ = 0L;
        }

        long getBlue() {
            return this.blue_;
        }

        long getGreen() {
            return this.green_;
        }

        public Player occupant(int row, int col) {
            if (row >= 0 && row < 7 && col >= 0 && col < 7) {
                long m = 1L << row + col * 7;
                if ((this.blue_ & m) != 0L) {
                    return Player.Blue;
                }
                if ((this.green_ & m) != 0L) {
                    return Player.Green;
                }
                return Player.Empty;
            }
            return Player.Illegal;
        }

        public void occupy(Player player, int row, int col) {
            long m = 1L << row + col * 7;
            long nm = m ^ 0xFFFFFFFFFFFFFFFFL;
            if (player.code_ == 1) {
                this.blue_ |= m;
                this.green_ &= nm;
            } else if (player.code_ == 2) {
                this.blue_ &= nm;
                this.green_ |= m;
            } else {
                this.blue_ &= nm;
                this.green_ &= nm;
            }
        }

        public void unoccupy(int row, int col) {
            long nm = 1L << row + col * 7 ^ 0xFFFFFFFFFFFFFFFFL;
            this.blue_ &= nm;
            this.green_ &= nm;
        }

        public void take(Player player, int row, int col) {
            int k = row + col * 7;
            long dest = 1L << k;
            long nbrMask = adjacentMasks[k];
            long sourceBlue = this.blue_;
            long sourceGreen = this.green_;
            if (player.code_ == 1) {
                this.blue_ = sourceBlue | dest | sourceGreen & nbrMask;
                this.green_ = sourceGreen & (sourceGreen & nbrMask ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.blue_ = sourceBlue & (sourceBlue & nbrMask ^ 0xFFFFFFFFFFFFFFFFL);
                this.green_ = sourceGreen | dest | sourceBlue & nbrMask;
            }
        }

        public boolean gameOver() {
            return ((this.blue_ | this.green_) & 0x1FFFFFFFFFFFFL) == 0x1FFFFFFFFFFFFL || (this.blue_ & 0xFFFDFFFFFFFFFFFFL) == 0L || (this.green_ & 0xFFFDFFFFFFFFFFFFL) == 0L;
        }

        public int score(Player player) {
            if (player.isBlue()) {
                return Board.score(this.blue_, this.green_);
            }
            return Board.score(this.green_, this.blue_);
        }

        static int score(long b, long g) {
            int lb = (int)(b & 0xFFFFFFFFL);
            int hb = (int)(b >>> 32) & 0x1FFFF;
            lb -= (0xAAAAAAAA & lb) >>> 1;
            lb = (lb & 0x33333333) + (lb >>> 2 & 0x33333333);
            lb = lb + (lb >>> 4) & 0xF0F0F0F;
            lb += lb >>> 8;
            lb += lb >>> 16;
            hb -= (0xAAAAAAAA & hb) >>> 1;
            hb = (hb & 0x33333333) + (hb >>> 2 & 0x33333333);
            hb = hb + (hb >>> 4) & 0xF0F0F0F;
            hb += hb >>> 8;
            hb += hb >>> 16;
            hb = lb + hb & 0xFF;
            int lg = (int)(g & 0xFFFFFFFFL);
            int hg = (int)(g >>> 32) & 0x1FFFF;
            lg -= (0xAAAAAAAA & lg) >>> 1;
            lg = (lg & 0x33333333) + (lg >>> 2 & 0x33333333);
            lg = lg + (lg >>> 4) & 0xF0F0F0F;
            lg += lg >>> 8;
            lg += lg >>> 16;
            hg -= (0xAAAAAAAA & hg) >>> 1;
            hg = (hg & 0x33333333) + (hg >>> 2 & 0x33333333);
            hg = hg + (hg >>> 4) & 0xF0F0F0F;
            hg += hg >>> 8;
            hg += hg >>> 16;
            return hb - (lg + hg & 0xFF);
        }

        static int slowscore(long b, long g) {
            int score = 0;
            int l = 0;
            while (l < 49) {
                score += (int)(b & 1L);
                b >>>= 1;
                score -= (int)(g & 1L);
                g >>>= 1;
                ++l;
            }
            return score;
        }
    }

    static final class Move {
        static final int NO_VALUE = -1;
        static final int PASS_VALUE = -2;
        int fromRow = -1;
        int fromCol = -1;
        int toRow = -1;
        int toCol = -1;
        Player player_;
        Board board_;
        boolean committed = false;

        public static boolean twoFrom(int a, int b) {
            return a - b == 2 || b - a == 2;
        }

        public static boolean withinTwo(int a, int b) {
            int diff = a - b;
            return -2 <= diff && diff <= 2;
        }

        public Move(Player turn, Board board) {
            this.player_ = turn;
            this.board_ = board;
        }

        public Move(Player turn, Board board, boolean isCommitted) {
            this.player_ = turn;
            this.board_ = board;
            this.committed = isCommitted;
        }

        synchronized void reset() {
            this.fromRow = -1;
            this.fromCol = -1;
            this.toRow = -1;
            this.toCol = -1;
        }

        synchronized void player(Player p) {
            this.player_ = p;
        }

        synchronized void board(Board b) {
            this.board_ = b;
        }

        synchronized void from(int sr, int sc) {
            this.fromRow = sr;
            this.fromCol = sc;
        }

        synchronized void to(int dr, int dc) {
            this.toRow = dr;
            this.toCol = dc;
        }

        synchronized boolean isFrom(int r, int c) {
            return this.fromRow == r && this.fromCol == c;
        }

        synchronized boolean isTo(int r, int c) {
            return this.toRow == r && this.toCol == c;
        }

        synchronized Board board() {
            return this.board_;
        }

        synchronized Player player() {
            return this.player_;
        }

        synchronized boolean isPass() {
            return this.toRow == -2 || this.fromRow == -2;
        }

        synchronized boolean isJump() {
            return this.fromRow - this.toRow == 2 || this.toRow - this.fromRow == 2 || this.fromCol - this.toCol == 2 || this.toCol - this.fromCol == 2;
        }

        synchronized boolean hasFrom() {
            return this.fromRow != -1 && this.fromCol != -1;
        }

        synchronized boolean hasTo() {
            return this.toRow != -1 && this.toCol != -1;
        }

        synchronized boolean possibleTo(int r, int c) {
            return this.hasFrom() && Move.withinTwo(this.fromRow, r) && Move.withinTwo(this.fromCol, c) && this.board_.occupant(r, c).isEmpty();
        }

        synchronized boolean isLegal() {
            if (this.isPass()) {
                return true;
            }
            if (!this.board_.occupant(this.toRow, this.toCol).isEmpty()) {
                return false;
            }
            if (!this.board_.occupant(this.fromRow, this.fromCol).same(this.player_)) {
                return false;
            }
            return Move.withinTwo(this.fromRow, this.toRow) && Move.withinTwo(this.fromCol, this.toCol);
        }

        synchronized void commit() {
            if (!this.committed) {
                this.committed = true;
                if (this.isLegal() && !this.isPass()) {
                    if (this.isJump()) {
                        this.board_.occupy(Player.Empty, this.fromRow, this.fromCol);
                    }
                    this.board_.take(this.player_, this.toRow, this.toCol);
                }
            }
        }
    }

    static abstract class Mover {
        protected Microscope game;

        protected Mover(Microscope ap) {
            this.game = ap;
        }

        public abstract void startTurn(Board var1, Player var2);

        public abstract void cancel();

        public abstract boolean placing();
    }

    static class User
    extends Mover {
        private Move current = null;

        public User(Microscope ap) {
            super(ap);
        }

        public synchronized void startTurn(Board b, Player p) {
            this.current = new Move(p, b);
        }

        public boolean placing() {
            return this.current != null && this.current.hasFrom() && !this.current.hasTo();
        }

        public synchronized void cancel() {
            if (this.current != null) {
                this.current.reset();
                this.current = null;
            }
        }

        public synchronized void choose(int row, int col) {
            if (this.current != null) {
                if (row == -2) {
                    this.current.from(row, col);
                    this.game.move(this.current, this);
                    this.current = null;
                } else if (!this.current.hasFrom()) {
                    if (this.current.board().occupant(row, col).same(this.current.player())) {
                        this.current.from(row, col);
                    }
                } else {
                    this.current.to(row, col);
                    this.game.move(this.current, this);
                    this.current = null;
                }
            }
        }

        public synchronized boolean canMoveTo(int row, int col) {
            return this.placing() && this.current.possibleTo(row, col);
        }

        public synchronized boolean hasMovedFrom(int row, int col) {
            return this.current != null && this.current.isFrom(row, col);
        }
    }

    static class AutoMover
    extends Mover {
        FJTaskRunnerGroup group = null;
        boolean cancelled = false;
        RootFinder currentFinder = null;

        public AutoMover(Microscope ap) {
            super(ap);
        }

        public synchronized boolean placing() {
            return this.currentFinder != null;
        }

        synchronized void stopPlacing() {
            this.currentFinder = null;
        }

        public synchronized void cancel() {
            if (this.placing()) {
                this.currentFinder.cancel();
                this.stopPlacing();
            }
        }

        public synchronized void startTurn(Board board, Player player) {
            try {
                if (this.group == null) {
                    this.group = new FJTaskRunnerGroup(nprocs);
                }
                if (!this.placing()) {
                    this.currentFinder = new RootFinder(board, player, lookAheads, this);
                    this.group.execute(this.currentFinder);
                }
            }
            catch (InterruptedException ex) {
                this.stopPlacing();
            }
        }

        public void stats() {
            if (this.group != null) {
                this.group.stats();
            }
        }

        synchronized void relay(Move move) {
            if (this.placing()) {
                this.stopPlacing();
                this.game.move(move, this);
            }
        }
    }

    static class Finder
    extends FJTask {
        static final int NOMOVE = Integer.MIN_VALUE;
        static final int LOSE = -2147483647;
        static final int WIN = Integer.MAX_VALUE;
        final long ours;
        final long theirs;
        final int level;
        final Finder next;
        volatile int bestScore;

        Finder(long ours, long theirs, int level, Finder next) {
            this.ours = ours;
            this.theirs = theirs;
            this.level = level;
            this.next = next;
        }

        public final void run() {
            if ((this.ours & 0xFFFDFFFFFFFFFFFFL) == 0L) {
                this.bestScore = -2147483647;
            } else if ((this.theirs & 0xFFFDFFFFFFFFFFFFL) == 0L) {
                this.bestScore = Integer.MAX_VALUE;
            } else if (((this.ours | this.theirs) & 0x1FFFFFFFFFFFFL) == 0x1FFFFFFFFFFFFL) {
                int score = Board.score(this.ours, this.theirs);
                this.bestScore = score > 0 ? Integer.MAX_VALUE : (score < 0 ? -2147483647 : 0);
            } else {
                this.search();
            }
        }

        final void search() {
            int best = Integer.MIN_VALUE;
            Finder forked = null;
            long open = (this.ours | this.theirs) ^ 0xFFFFFFFFFFFFFFFFL;
            long here = 1L;
            int k = 0;
            while (k < 49) {
                long adjacent;
                if ((here & this.ours) != 0L) {
                    byte[] dests = Board.jumpDestinations[k];
                    int j = 0;
                    while (j < dests.length) {
                        byte d = dests[j];
                        long dest = 1L << d;
                        if ((dest & open) != 0L) {
                            long adjacent2 = Board.adjacentMasks[d];
                            long nTheirs = this.theirs & (adjacent2 ^ 0xFFFFFFFFFFFFFFFFL);
                            long nOurs = this.ours & (here ^ 0xFFFFFFFFFFFFFFFFL) | dest | this.theirs & adjacent2;
                            if (this.level > 1) {
                                forked = new Finder(nTheirs, nOurs, this.level - 1, forked);
                                forked.fork();
                            } else {
                                int sc = Board.score(nOurs, nTheirs);
                                if (sc > best) {
                                    best = sc;
                                }
                            }
                        }
                        ++j;
                    }
                } else if ((here & open) != 0L && (this.ours & (adjacent = Board.adjacentMasks[k])) != 0L) {
                    long nTheirs = this.theirs & (adjacent ^ 0xFFFFFFFFFFFFFFFFL);
                    long nOurs = this.ours | here | this.theirs & adjacent;
                    if (this.level > 1) {
                        forked = new Finder(nTheirs, nOurs, this.level - 1, forked);
                        forked.fork();
                    } else {
                        int sc = Board.score(nOurs, nTheirs);
                        if (sc > best) {
                            best = sc;
                        }
                    }
                }
                ++k;
                here <<= 1;
            }
            if (this.level > 1) {
                this.collect(forked);
            } else {
                this.bestScore = best;
            }
        }

        /*
         * Unable to fully structure code
         */
        void collect(Finder forked) {
            best = -2147483648;
            ** GOTO lbl16
            {
                if (this.isDone()) {
                    this.cancelAll(forked);
                    return;
                }
                FJTask.yield();
                do {
                    if (!forked.isDone()) continue block0;
                    score = -forked.bestScore;
                    if (score > best) {
                        best = score;
                        if (score >= 0x7FFFFFFF) {
                            this.cancelAll(forked.next);
                            break block0;
                        }
                    }
                    forked = forked.next;
lbl16:
                    // 2 sources

                } while (forked != null);
            }
            this.bestScore = best;
        }

        void cancelAll(Finder forked) {
            while (forked != null) {
                forked.cancel();
                forked = forked.next;
            }
        }
    }

    static class RootFinder
    extends Finder {
        final AutoMover automover;
        final Player player;

        RootFinder(Board board, Player p, int level, AutoMover automover) {
            super(p.isBlue() ? board.getBlue() | 0x2000000000000L : board.getGreen(), p.isBlue() ? board.getGreen() : board.getBlue() | 0x2000000000000L, level, null);
            this.player = p;
            this.automover = automover;
        }

        /*
         * Unable to fully structure code
         */
        void collect(Finder forked) {
            best = -2147483648;
            bestFinder = null;
            ** GOTO lbl21
            {
                if (this.isDone()) {
                    this.cancelAll(forked);
                    return;
                }
                FJTask.yield();
                do {
                    if (!forked.isDone()) continue block0;
                    score = -forked.bestScore;
                    if (bestFinder == null || score > best) {
                        best = score;
                        bestFinder = forked;
                        if (score >= 0x7FFFFFFF) {
                            this.cancelAll(forked.next);
                            break block0;
                        }
                    } else if (score == best && !Microscope.DETERMINISTIC && System.identityHashCode(forked) > System.identityHashCode(bestFinder)) {
                        bestFinder = forked;
                    }
                    forked = forked.next;
lbl21:
                    // 2 sources

                } while (forked != null);
            }
            move = null;
            if (bestFinder != null) {
                nextOurs = bestFinder.theirs;
                nextTheirs = bestFinder.ours;
                blue = this.player.isBlue() != false ? nextOurs : nextTheirs;
                green = this.player.isBlue() != false ? nextTheirs : nextOurs;
                move = new Move(this.player, new Board(blue, green), true);
            }
            this.automover.relay(move);
        }
    }
}

