/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public class Jacobi {
    static final int DEFAULT_LEAFCELLS = 1024;
    static final double EPSILON = 0.001;

    public static void main(String[] args) {
        try {
            int steps;
            int n;
            int procs;
            int granularity = 1024;
            try {
                procs = Integer.parseInt(args[0]);
                n = Integer.parseInt(args[1]);
                steps = Integer.parseInt(args[2]);
                if (args.length > 3) {
                    granularity = Integer.parseInt(args[3]);
                }
            }
            catch (Exception e) {
                System.out.println("Usage: java Jacobi <threads> <matrix size> <max steps> [<leafcells>]");
                return;
            }
            double[][] a = new double[n + 2][n + 2];
            double[][] b = new double[n + 2][n + 2];
            int k = 0;
            while (k < n + 2) {
                a[k][0] = 1.0;
                a[k][n + 1] = 1.0;
                a[0][k] = 1.0;
                a[n + 1][k] = 1.0;
                b[k][0] = 1.0;
                b[k][n + 1] = 1.0;
                b[0][k] = 1.0;
                b[n + 1][k] = 1.0;
                ++k;
            }
            Driver driver = new Driver(a, b, 1, n, 1, n, steps, granularity);
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            g.invoke(driver);
            g.stats();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static abstract class MatrixTree
    extends FJTask {
        volatile double maxDiff;

        MatrixTree() {
        }
    }

    static class LeafNode
    extends MatrixTree {
        final double[][] A;
        final double[][] B;
        final int loRow;
        final int hiRow;
        final int loCol;
        final int hiCol;
        int steps = 0;

        LeafNode(double[][] A, double[][] B, int loRow, int hiRow, int loCol, int hiCol) {
            this.A = A;
            this.B = B;
            this.loRow = loRow;
            this.hiRow = hiRow;
            this.loCol = loCol;
            this.hiCol = hiCol;
        }

        public synchronized void run() {
            boolean AtoB = this.steps++ % 2 == 0;
            double[][] a = AtoB ? this.A : this.B;
            double[][] b = AtoB ? this.B : this.A;
            double md = 0.0;
            int i = this.loRow;
            while (i <= this.hiRow) {
                int j = this.loCol;
                while (j <= this.hiCol) {
                    double v;
                    b[i][j] = v = 0.25 * (a[i - 1][j] + a[i][j - 1] + a[i + 1][j] + a[i][j + 1]);
                    double diff = v - a[i][j];
                    if (diff < 0.0) {
                        diff = -diff;
                    }
                    if (diff > md) {
                        md = diff;
                    }
                    ++j;
                }
                ++i;
            }
            this.maxDiff = md;
        }
    }

    static class FourNode
    extends MatrixTree {
        final MatrixTree[] quads;

        FourNode(MatrixTree q1, MatrixTree q2, MatrixTree q3, MatrixTree q4) {
            this.quads = new MatrixTree[]{q1, q2, q3, q4};
        }

        public void run() {
            FJTask.coInvoke(this.quads);
            double md = this.quads[0].maxDiff;
            this.quads[0].reset();
            double m = this.quads[1].maxDiff;
            this.quads[1].reset();
            if (m > md) {
                md = m;
            }
            m = this.quads[2].maxDiff;
            this.quads[2].reset();
            if (m > md) {
                md = m;
            }
            m = this.quads[3].maxDiff;
            this.quads[3].reset();
            this.maxDiff = m > md ? m : md;
        }
    }

    static class TwoNode
    extends MatrixTree {
        final MatrixTree q1;
        final MatrixTree q2;

        TwoNode(MatrixTree q1, MatrixTree q2) {
            this.q1 = q1;
            this.q2 = q2;
        }

        public void run() {
            FJTask.coInvoke(this.q1, this.q2);
            double m1 = this.q1.maxDiff;
            double m2 = this.q2.maxDiff;
            this.maxDiff = m1 > m2 ? m1 : m2;
            this.q1.reset();
            this.q2.reset();
        }
    }

    static class Driver
    extends FJTask {
        final MatrixTree mat;
        final int steps;

        Driver(double[][] A, double[][] B, int firstRow, int lastRow, int firstCol, int lastCol, int steps, int leafCells) {
            this.steps = steps;
            this.mat = this.build(A, B, firstRow, lastRow, firstCol, lastCol, leafCells);
        }

        MatrixTree build(double[][] a, double[][] b, int lr, int hr, int lc, int hc, int gran) {
            int rows = hr - lr + 1;
            int cols = hc - lc + 1;
            int mr = (lr + hr) / 2;
            int mc = (lc + hc) / 2;
            int hrows = mr - lr + 1;
            int hcols = mc - lc + 1;
            if (rows * cols <= gran) {
                return new LeafNode(a, b, lr, hr, lc, hc);
            }
            if (hrows * hcols >= gran) {
                return new FourNode(this.build(a, b, lr, mr, lc, mc, gran), this.build(a, b, lr, mr, mc + 1, hc, gran), this.build(a, b, mr + 1, hr, lc, mc, gran), this.build(a, b, mr + 1, hr, mc + 1, hc, gran));
            }
            if (cols >= rows) {
                return new TwoNode(this.build(a, b, lr, hr, lc, mc, gran), this.build(a, b, lr, hr, mc + 1, hc, gran));
            }
            return new TwoNode(this.build(a, b, lr, mr, lc, hc, gran), this.build(a, b, mr + 1, hr, lc, hc, gran));
        }

        public void run() {
            double md = 0.0;
            int i = 1;
            while (i <= this.steps) {
                FJTask.invoke(this.mat);
                md = this.mat.maxDiff;
                if (md < 0.001) {
                    System.out.println("Converged after " + i + " steps");
                    return;
                }
                this.mat.reset();
                ++i;
            }
            System.out.println("max diff after " + this.steps + " steps = " + md);
        }
    }
}

