/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;

public class WaitableRef
extends SynchronizedRef {
    public WaitableRef(Object initialValue) {
        super(initialValue);
    }

    public WaitableRef(Object initialValue, Object lock) {
        super(initialValue, lock);
    }

    public Object set(Object newValue) {
        Object object = this.lock_;
        synchronized (object) {
            this.lock_.notifyAll();
            return super.set(newValue);
        }
    }

    public boolean commit(Object assumedValue, Object newValue) {
        Object object = this.lock_;
        synchronized (object) {
            boolean success = super.commit(assumedValue, newValue);
            if (success) {
                this.lock_.notifyAll();
            }
            return success;
        }
    }

    public void whenNull(Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != null) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotNull(Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == null) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenEqual(Object c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ != c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }

    public void whenNotEqual(Object c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            while (this.value_ == c) {
                this.lock_.wait();
            }
            if (action != null) {
                action.run();
            }
        }
    }
}

