/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentField;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlInclude;
import org.openorb.compiler.object.IdlModule;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlRoot;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.parser.CompilationContext;
import org.openorb.compiler.parser.CompilationException;
import org.openorb.compiler.parser.IdlGrammar;
import org.openorb.compiler.parser.Symbole;
import org.openorb.compiler.parser.SymboleDef;
import org.openorb.compiler.parser.SymboleJava;

public class IdlParser {
    public IdlObject root = new IdlRoot();
    public static IdlObject container = null;
    public static PrintStream error_output = System.out;
    public String[] file_extension = new String[]{".idl"};
    public static int totalError = 0;
    public CompilationContext ctx;
    public Vector StopList = new Vector();
    public static int include_level = 0;
    public static IdlComment idl_comment = null;
    public Vector compilationList = new Vector();
    public Vector idlIncluded = new Vector();
    public int pass = 0;
    public int stop_else = 0;
    public boolean macros_enabled = true;
    private static final int MAX_MACRO = 512;
    private static final int MAX_ERRORS = 10;

    public IdlParser() {
        IdlModule module = new IdlModule(this.root);
        module.name("CORBA");
        module._prefix = "omg.org";
        this.root.addIdlObject(module);
        module.addIdlObject(IdlSimple.typecode_type);
        IdlSimple.typecode_type.name("TypeCode");
        IdlSimple.typecode_type._upper = module;
        module._map = true;
        IdlSimple.typecode_type._map = true;
    }

    public void show_error(String msg) {
        ++this.ctx.nberrors;
        ++totalError;
        error_output.println(this.ctx.name + ":" + this.ctx.line + ": " + msg);
        if (this.ctx.nberrors > 10) {
            error_output.println("Compilation stopped : too many errors");
            throw new CompilationException();
        }
    }

    public void show_internal_error() {
        error_output.println(this.ctx.name + ":" + this.ctx.line + ": Unexpected error");
        throw new CompilationException();
    }

    public static void show_fatal_error(String message) {
        error_output.println("Fatal error : " + message);
        throw new CompilationException();
    }

    public void warning(String msg) {
        error_output.println(this.ctx.name + ":" + this.ctx.line + ": warning: " + msg);
    }

    public boolean is_reserved_word() {
        int i = 0;
        while (i < Symbole.liste_mots_reserves.size()) {
            SymboleDef s = (SymboleDef)Symbole.liste_mots_reserves.elementAt(i);
            if (s.symbole_name.equals(this.ctx.value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean is_java_reserved_word() {
        int i = 0;
        while (i < SymboleJava.liste_mots_reserves.size()) {
            SymboleDef s = (SymboleDef)SymboleJava.liste_mots_reserves.elementAt(i);
            if (s.symbole_name.equals(this.ctx.value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void to_reserved_word() {
        int i = 0;
        while (i < Symbole.liste_mots_reserves.size()) {
            SymboleDef s = (SymboleDef)Symbole.liste_mots_reserves.elementAt(i);
            if (s.symbole_name.equals(this.ctx.value)) {
                this.ctx.symb = s.symbole_token;
                return;
            }
            ++i;
        }
    }

    public CompilationContext new_compilation_context() {
        CompilationContext context = new CompilationContext();
        context.nberrors = 0;
        context.nbwarning = 0;
        context.line = 1;
        context.symb = 59;
        return context;
    }

    public void open_idl_file(String source_name) {
        Reader is;
        URL fileURL;
        block24: {
            if (IdlCompiler.verbose) {
                System.out.println("Trying to open idl file '" + source_name + "'...");
            }
            boolean ready = false;
            int i = 0;
            while (i < this.file_extension.length) {
                if (source_name.endsWith(this.file_extension[i])) {
                    ready = true;
                    break;
                }
                ++i;
            }
            if (!ready) {
                source_name = source_name + this.file_extension[0];
            }
            try {
                URL baseURL;
                File file = new File(source_name);
                if (file.isAbsolute() && file.exists()) {
                    fileURL = file.toURL();
                    is = this.openURL(fileURL);
                    break block24;
                }
                if (include_level == 0) {
                    try {
                        baseURL = new File("").getCanonicalFile().toURL();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        System.exit(0);
                        return;
                    }
                } else {
                    baseURL = this.ctx.sourceURL;
                }
                fileURL = new URL(baseURL, source_name);
                is = this.openURL(fileURL);
                URL incURL = null;
                int i2 = 0;
                while (is == null && i2 < IdlCompiler.includeList.size()) {
                    block26: {
                        Object incObj = IdlCompiler.includeList.elementAt(i2);
                        if (incObj != null) {
                            block25: {
                                if (incObj instanceof String) {
                                    try {
                                        incURL = new URL((String)incObj);
                                        break block25;
                                    }
                                    catch (MalformedURLException ex) {
                                        try {
                                            incURL = new File((String)incObj).toURL();
                                            break block25;
                                        }
                                        catch (MalformedURLException ex1) {
                                            IdlCompiler.includeList.removeElementAt(i2--);
                                            break block26;
                                        }
                                    }
                                }
                                incURL = (URL)incObj;
                            }
                            if (!incURL.equals(baseURL)) {
                                try {
                                    fileURL = new URL(incURL, source_name);
                                    is = this.openURL(fileURL);
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                            if (is == null && incObj instanceof String) {
                                is = this.openResource((String)incObj + "/" + source_name);
                            }
                        }
                    }
                    ++i2;
                }
            }
            catch (MalformedURLException ex) {
                System.out.println("Failed to open idl file: " + source_name + " (" + ex + ")");
                ex.printStackTrace();
                System.exit(0);
                return;
            }
        }
        if (is == null) {
            System.out.println("Failed to open idl file: " + source_name);
            System.exit(0);
        }
        this.ctx = this.new_compilation_context();
        this.ctx.prefix = null;
        this.ctx.is = new PushbackReader(new BufferedReader(is), 512);
        this.ctx.sourceURL = fileURL;
        this.ctx.name = fileURL.toString();
        IdlObject.idlPrefix = null;
        if (IdlCompiler.verbose) {
            System.out.println("Successfully opened idl file '" + source_name + "'.");
        }
    }

    private Reader openURL(URL url) {
        if (IdlCompiler.verbose) {
            System.out.println("Trying to open url '" + url + "'...");
        }
        try {
            URLConnection conn = url.openConnection();
            conn.connect();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hConn = (HttpURLConnection)url.openConnection();
                if (hConn.getResponseCode() != 200) {
                    return null;
                }
            }
            if (IdlCompiler.verbose) {
                System.out.println("Successfully opened url '" + url + "'.");
            }
            return new InputStreamReader(conn.getInputStream());
        }
        catch (IOException ex) {
            if (IdlCompiler.verbose) {
                System.out.println("Failed to open url '" + url + "'.");
            }
            return null;
        }
    }

    private Reader openResource(String url) {
        ClassLoader clzldr;
        if (IdlCompiler.verbose) {
            System.out.println("Trying to open resource url '" + url + "'...");
        }
        if ((clzldr = this.getClass().getClassLoader()) instanceof URLClassLoader) {
            URLClassLoader urlclzldr = (URLClassLoader)clzldr;
            if (IdlCompiler.verbose) {
                URL[] urls = urlclzldr.getURLs();
                System.out.println("Searching in " + urls.length + " URLs:");
                int i = 0;
                while (i < urls.length) {
                    System.out.println(" -> " + urls[i]);
                    ++i;
                }
            }
            URL jarurl = null;
            try {
                jarurl = urlclzldr.findResource(url);
                if (jarurl != null) {
                    URLConnection conn = jarurl.openConnection();
                    conn.connect();
                    if (IdlCompiler.verbose) {
                        System.out.println("Successfully opened resource url '" + url + "'.");
                    }
                    return new InputStreamReader(conn.getInputStream());
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (IdlCompiler.verbose) {
            System.out.println("Failed to open resource url '" + url + "'.");
        }
        return null;
    }

    private boolean isAlsoToCompile(String name) {
        boolean found = false;
        int i = 0;
        while (i < this.file_extension.length) {
            if (name.endsWith(this.file_extension[i])) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            name = name + this.file_extension[0];
        }
        int i2 = 0;
        while (i2 < IdlCompiler.idl_file_name.length) {
            if (name.equals(IdlCompiler.idl_file_name[i2])) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void include_idl() {
        String tmp;
        boolean old_me = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = old_me;
        switch (this.ctx.symb) {
            case 15: {
                tmp = "";
                this.scan();
                while (this.ctx.car != '>') {
                    tmp = tmp + this.ctx.car;
                    if (this.ctx.car == '\u00ff' || this.ctx.car == '\u00fe') {
                        this.show_error("IDL file name expected");
                        this.StopList.removeAllElements();
                        this.StopList.addElement(new Integer(39));
                        this.StopList.addElement(new Integer(37));
                        this.StopList.addElement(new Integer(52));
                        this.StopList.addElement(new Integer(54));
                        this.StopList.addElement(new Integer(49));
                        this.StopList.addElement(new Integer(31));
                        this.StopList.addElement(new Integer(32));
                        this.StopList.addElement(new Integer(27));
                        this.stopAt(this.StopList);
                        return;
                    }
                    this.scan();
                }
                break;
            }
            case 63: {
                tmp = this.ctx.value;
                break;
            }
            default: {
                this.show_error("IDL file name to include expected");
                this.StopList.removeAllElements();
                this.StopList.addElement(new Integer(39));
                this.StopList.addElement(new Integer(37));
                this.StopList.addElement(new Integer(52));
                this.StopList.addElement(new Integer(54));
                this.StopList.addElement(new Integer(49));
                this.StopList.addElement(new Integer(31));
                this.StopList.addElement(new Integer(32));
                this.StopList.addElement(new Integer(27));
                this.stopAt(this.StopList);
                return;
            }
        }
        this.ctx.prefix = IdlObject.idlPrefix;
        this.compilationList.addElement(this.ctx);
        boolean included = false;
        if (!this.isAlsoToCompile(tmp) && !IdlCompiler.map_all) {
            included = true;
            ++include_level;
        }
        if (IdlCompiler.verbose) {
            System.out.println("Include IDL: " + tmp);
        }
        this.compile_idl(tmp, container);
        this.root.addIdlObject(new IdlInclude(this.root, tmp));
        if (include_level == 1) {
            this.idlIncluded.addElement(this.ctx.name);
        }
        if (included) {
            --include_level;
        }
        int err = this.ctx.nberrors;
        this.ctx = (CompilationContext)this.compilationList.lastElement();
        this.compilationList.setSize(this.compilationList.size() - 1);
        this.ctx.nberrors += err;
        IdlObject.idlPrefix = this.ctx.prefix;
        this.symbole();
    }

    public void include_idl_file(String file_name) {
        this.ctx.prefix = IdlObject.idlPrefix;
        if (this.ctx.sourceURL == null) {
            try {
                this.ctx.sourceURL = new File("").getCanonicalFile().toURL();
            }
            catch (IOException ex) {
                ex.printStackTrace();
                System.exit(0);
            }
        }
        this.compilationList.addElement(this.ctx);
        if (!IdlCompiler.map_all) {
            ++include_level;
        }
        if (IdlCompiler.verbose) {
            System.out.println("Include IDL file: " + file_name);
        }
        this.compile_idl(file_name, container);
        this.root.addIdlObject(new IdlInclude(this.root, file_name));
        if (include_level == 1) {
            this.idlIncluded.addElement(this.ctx.name);
        }
        if (!IdlCompiler.map_all) {
            --include_level;
        }
        int err = this.ctx.nberrors;
        this.ctx = (CompilationContext)this.compilationList.lastElement();
        this.compilationList.setSize(this.compilationList.size() - 1);
        this.ctx.nberrors += err;
        IdlObject.idlPrefix = this.ctx.prefix;
    }

    public void precompiler_error() {
        this.scan();
        StringBuffer buf = new StringBuffer();
        while (this.ctx.car != '\u00ff') {
            if (this.ctx.car == '\\') {
                this.scan();
                if (this.ctx.car == '\u00ff') {
                    buf.append(' ');
                    continue;
                }
                buf.append('\\');
                continue;
            }
            buf.append(this.ctx.car);
            this.scan();
        }
        this.show_error("#error" + buf);
        this.symbole();
    }

    public void precompiler_warning() {
        StringBuffer buf = new StringBuffer();
        this.scan();
        while (this.ctx.car != '\u00ff') {
            if (this.ctx.car == '\\') {
                this.scan();
                if (this.ctx.car == '\u00ff') {
                    buf.append(' ');
                    continue;
                }
                buf.append('\\');
                continue;
            }
            buf.append(this.ctx.car);
            this.scan();
        }
        this.warning("#warning" + buf);
        this.symbole();
    }

    public void define_symbole() {
        boolean old_me = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = old_me;
        if (this.ctx.symb != 21) {
            this.show_error("Identifier expected after #define");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            if (IdlCompiler.definedMacros.containsKey(this.ctx.value)) {
                this.warning("'" + this.ctx.value + "' redefined");
            }
            this.scan();
            if (this.ctx.car == '(') {
                this.show_error("Tried to define function macro '" + this.ctx.value + "'. Function macros are not implemented.");
            }
            StringBuffer buf = new StringBuffer();
            buf.append(' ');
            boolean skipWS = true;
            block5: while (this.ctx.car != '\u00ff') {
                switch (this.ctx.car) {
                    case '\t': 
                    case ' ': {
                        if (skipWS) break;
                        skipWS = true;
                        buf.append(' ');
                        break;
                    }
                    case '\\': {
                        this.scan();
                        if (this.ctx.car == '\u00ff') {
                            if (skipWS) break;
                            skipWS = true;
                            buf.append(' ');
                            break;
                        }
                        buf.append('\\');
                        skipWS = false;
                        continue block5;
                    }
                    case '#': {
                        this.scan();
                        if (this.ctx.car == '#') {
                            if (buf.charAt(buf.length() - 1) == ' ') {
                                buf.setLength(buf.length() - 1);
                            }
                            skipWS = true;
                            break;
                        }
                        buf.append('#');
                        skipWS = false;
                        continue block5;
                    }
                    default: {
                        buf.append(this.ctx.car);
                        skipWS = false;
                    }
                }
                this.scan();
            }
            buf.append(' ');
            if (buf.length() > 512) {
                this.show_error("macro length exceeds system limits");
            }
            IdlCompiler.definedMacros.put(this.ctx.value, buf.toString());
            this.symbole();
        }
    }

    public void undefine_symbole() {
        boolean old_me = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = old_me;
        if (this.ctx.symb != 21) {
            this.show_error("Identifier expected after #undef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            if (IdlCompiler.definedMacros.remove(this.ctx.value) != null) {
                this.warning("'" + this.ctx.value + "' was not defined.");
            }
            this.symbole();
        }
    }

    public void ifndef_symbole() {
        boolean old_me = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = old_me;
        if (this.ctx.symb != 21) {
            this.show_error("Identifier expected after #ifndef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            if (IdlCompiler.definedMacros.containsKey(this.ctx.value)) {
                int state = 1;
                int count = 1;
                this.pass = 2;
                while (state != 0) {
                    this.symbole();
                    switch (this.ctx.symb) {
                        case 80: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 2;
                                    --count;
                                    break;
                                }
                                case 3: {
                                    state = 2;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 79: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 3;
                                    --count;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 78: 
                        case 96: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 1;
                                    ++count;
                                    break;
                                }
                                case 3: {
                                    state = 1;
                                    count += 2;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                        }
                    }
                    if (count != 0) continue;
                    state = 0;
                }
            } else {
                this.pass = 0;
                if (this.stop_else == 0) {
                    this.stop_else = 1;
                }
            }
            this.symbole();
        }
    }

    public void ifdef_symbole() {
        boolean old_me = this.macros_enabled;
        this.macros_enabled = false;
        this.symbole();
        this.macros_enabled = old_me;
        if (this.ctx.symb != 21) {
            this.show_error("Identifier expected after #ifdef");
            this.StopList.removeAllElements();
            this.StopList.addElement(new Integer(255));
            this.stopAt(this.StopList);
        } else {
            if (!IdlCompiler.definedMacros.containsKey(this.ctx.value)) {
                int state = 1;
                int count = 1;
                this.pass = 2;
                while (state != 0) {
                    this.symbole();
                    switch (this.ctx.symb) {
                        case 80: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 2;
                                    --count;
                                    break;
                                }
                                case 3: {
                                    state = 2;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 79: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 3;
                                    --count;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                            break;
                        }
                        case 78: 
                        case 96: {
                            switch (state) {
                                case 1: 
                                case 2: {
                                    state = 1;
                                    ++count;
                                    break;
                                }
                                case 3: {
                                    state = 1;
                                    count += 2;
                                }
                            }
                            if (count != 0) break;
                            this.pass = 0;
                        }
                    }
                    if (count != 0) continue;
                    state = 0;
                }
            } else {
                this.pass = 0;
                if (this.stop_else == 0) {
                    this.stop_else = 1;
                }
            }
            this.symbole();
        }
    }

    public boolean read_description() {
        boolean not_end = false;
        boolean end = false;
        Vector<Character> description = new Vector<Character>();
        while (!not_end) {
            this.scan();
            block0 : switch (this.ctx.car) {
                case '@': {
                    not_end = true;
                    break;
                }
                case '*': {
                    this.scan();
                    if (this.ctx.car == '/') {
                        not_end = true;
                        end = true;
                        break;
                    }
                    while (true) {
                        if (this.ctx.car != ' ') {
                            this.unscan();
                            break block0;
                        }
                        this.scan();
                    }
                }
                default: {
                    if (this.ctx.car == '\u00ff') {
                        do {
                            this.scan();
                            if (this.ctx.car != '\u00fe') continue;
                            this.show_error("IDL comment incorrect.");
                            System.exit(0);
                        } while (this.ctx.car != '*');
                        this.unscan();
                        description.addElement(new Character('\n'));
                        break;
                    }
                    description.addElement(new Character(this.ctx.car));
                }
            }
        }
        if (description.size() != 0) {
            char[] text = new char[description.size()];
            int i = 0;
            while (i < description.size()) {
                text[i] = ((Character)description.elementAt(i)).charValue();
                ++i;
            }
            this.ctx.value = new String(text);
        }
        return end;
    }

    public void scan_comment() {
        boolean not_end = false;
        boolean end = false;
        boolean begin = false;
        Vector<Character> comment = new Vector<Character>();
        IdlCommentSection new_section = null;
        idl_comment = new IdlComment();
        do {
            this.scan();
        } while (this.ctx.car != '*');
        this.unscan();
        block5: while (!not_end) {
            switch (this.ctx.car) {
                case '*': {
                    this.scan();
                    if (this.ctx.car == '/') {
                        not_end = true;
                    }
                    while (this.ctx.car == ' ') {
                        this.scan();
                    }
                    continue block5;
                }
                case '@': {
                    this.scan();
                    if (this.macros_enabled) {
                        this.macros_enabled = false;
                        this.read_word();
                        this.macros_enabled = true;
                    } else {
                        this.read_word();
                    }
                    begin = true;
                    if (this.ctx.value.equals("exception")) {
                        new_section = new IdlCommentSection(IdlCommentField.exception_field);
                    } else if (this.ctx.value.equals("author")) {
                        new_section = new IdlCommentSection(IdlCommentField.author_field);
                    } else if (this.ctx.value.equals("version")) {
                        new_section = new IdlCommentSection(IdlCommentField.version_field);
                    } else if (this.ctx.value.equals("param")) {
                        new_section = new IdlCommentSection(IdlCommentField.param_field);
                    } else if (this.ctx.value.equals("return")) {
                        new_section = new IdlCommentSection(IdlCommentField.return_field);
                    } else if (this.ctx.value.equals("deprecated")) {
                        new_section = new IdlCommentSection(IdlCommentField.deprecated_field);
                    } else if (this.ctx.value.equals("see")) {
                        new_section = new IdlCommentSection(IdlCommentField.see_field);
                    } else {
                        new_section = new IdlCommentSection(IdlCommentField.unknown_field);
                        new_section.set_title(this.ctx.value);
                    }
                    end = this.read_description();
                    new_section.add_description(this.ctx.value);
                    idl_comment.add_section(new_section);
                    if (!end) continue block5;
                    not_end = true;
                    break;
                }
                default: {
                    if (this.ctx.car == '\u00ff') {
                        do {
                            this.scan();
                        } while (this.ctx.car != '*');
                        this.unscan();
                        if (!begin) {
                            comment.addElement(new Character('\n'));
                        }
                    } else if (!begin) {
                        comment.addElement(new Character(this.ctx.car));
                    }
                    this.scan();
                }
            }
        }
        if (comment.size() != 0) {
            char[] text = new char[comment.size()];
            int i = 0;
            while (i < comment.size()) {
                text[i] = ((Character)comment.elementAt(i)).charValue();
                ++i;
            }
            idl_comment.add_description(new String(text));
        } else {
            idl_comment = null;
        }
    }

    public void scan() {
        block5: {
            try {
                int c = this.ctx.is.read();
                if (c < 0) {
                    this.ctx.car = (char)254;
                    break block5;
                }
                if (c == 13) {
                    this.scan();
                    break block5;
                }
                if (c == 10) {
                    ++this.ctx.line;
                    this.ctx.car = (char)255;
                    break block5;
                }
                this.ctx.car = (char)c;
            }
            catch (IOException ex) {
                this.show_error("IOException occoured");
            }
        }
    }

    public void unscan() {
        if (this.ctx.car == '\u00ff') {
            this.ctx.car = (char)10;
            --this.ctx.line;
        }
        try {
            this.ctx.is.unread(this.ctx.car);
        }
        catch (IOException ex) {
            this.show_error("IOException occoured");
        }
    }

    public void pre_parse() {
        boolean symb = true;
        int two = 1;
        this.scan();
        this.ctx.symb = 59;
        block0 : switch (this.ctx.car) {
            case '\u00fe': {
                this.ctx.symb = 254;
                this.scan();
                break;
            }
            case '\t': 
            case ' ': 
            case '\u00ff': {
                this.pre_parse();
                break;
            }
            case '#': {
                this.scan();
                while (this.ctx.car == ' ' || this.ctx.car == '\t') {
                    this.scan();
                }
                if (this.macros_enabled) {
                    this.macros_enabled = false;
                    this.read_word();
                    this.macros_enabled = true;
                } else {
                    this.read_word();
                }
                if (this.ctx.value.toUpperCase().equals("ERROR")) {
                    if (this.pass != 0) break;
                    this.precompiler_error();
                    break;
                }
                if (this.ctx.value.toUpperCase().equals("WARNING")) {
                    if (this.pass != 0) break;
                    this.precompiler_warning();
                    break;
                }
                this.to_reserved_word();
                switch (this.ctx.symb) {
                    case 77: {
                        if (this.pass != 0) break block0;
                        this.define_symbole();
                        break block0;
                    }
                    case 96: {
                        if (this.pass != 0) break block0;
                        this.ifdef_symbole();
                        break block0;
                    }
                    case 81: {
                        if (this.pass != 0) break block0;
                        this.undefine_symbole();
                        break block0;
                    }
                    case 78: {
                        if (this.pass != 0) break block0;
                        this.ifndef_symbole();
                        break block0;
                    }
                    case 68: {
                        break block0;
                    }
                    case 69: {
                        if (this.pass != 0) break block0;
                        this.include_idl();
                        break block0;
                    }
                    case 79: {
                        if (this.stop_else == 1 && this.pass == 0) {
                            int state = 1;
                            int count = 1;
                            this.stop_else = -1;
                            this.pass = 2;
                            while (state != 0) {
                                this.symbole();
                                switch (this.ctx.symb) {
                                    case 78: {
                                        switch (state) {
                                            case 1: 
                                            case 2: 
                                            case 3: {
                                                state = 3;
                                                ++count;
                                            }
                                        }
                                        break;
                                    }
                                    case 80: {
                                        switch (state) {
                                            case 1: 
                                            case 2: 
                                            case 3: {
                                                state = 2;
                                                --count;
                                            }
                                        }
                                        break;
                                    }
                                    case 79: {
                                        switch (state) {
                                            case 2: 
                                            case 3: {
                                                state = 1;
                                            }
                                        }
                                    }
                                }
                                if (count != 0) continue;
                                state = 0;
                            }
                            this.stop_else = 0;
                            this.pass = 0;
                        }
                        if (this.pass != 0) break block0;
                        this.symbole();
                        this.pass = 0;
                        break block0;
                    }
                    case 80: {
                        if (this.pass != 0) break block0;
                        this.symbole();
                        this.pass = 0;
                        break block0;
                    }
                }
                this.warning("Compilation flag unknown : " + this.ctx.value);
                break;
            }
            case '/': {
                this.scan();
                if (this.ctx.car == '/') {
                    while (this.ctx.car != '\u00ff' && this.ctx.car != '\u00fe') {
                        this.scan();
                    }
                    this.pre_parse();
                    break;
                }
                if (this.ctx.car == '*') {
                    boolean stop = true;
                    while (stop) {
                        this.scan();
                        if (this.ctx.car == '\u00fe') {
                            this.show_error("Comment end missing '*/'");
                            this.StopList.removeAllElements();
                            this.StopList.addElement(new Integer(255));
                            this.stopAt(this.StopList);
                        }
                        if (this.ctx.car == '*') {
                            ++two;
                            this.scan();
                            if (this.ctx.car == '/') {
                                stop = false;
                            } else {
                                this.unscan();
                            }
                        }
                        if (two != 2 || this.ctx.car != '\u00ff') continue;
                        this.unscan();
                        this.scan_comment();
                        break;
                    }
                    this.pre_parse();
                    break;
                }
                this.ctx.symb = 3;
            }
        }
    }

    public void read_word() {
        String macro_exp;
        StringBuffer tmp = new StringBuffer();
        while (Character.isLetterOrDigit(this.ctx.car) || this.ctx.car == '_') {
            tmp.append(this.ctx.car);
            this.scan();
            if (this.ctx.car == '\u00fe' || this.ctx.car == '\u00ff') break;
        }
        this.ctx.value = tmp.toString();
        this.unscan();
        if (this.macros_enabled && (macro_exp = (String)IdlCompiler.definedMacros.get(this.ctx.value)) != null) {
            try {
                this.ctx.is.unread(macro_exp.toCharArray());
            }
            catch (IOException ex) {
                this.show_error("IOException while expanding macro");
            }
            this.ctx.value = null;
        }
    }

    public void read_number() {
        int base = 0;
        boolean type = false;
        boolean stop = true;
        int index = 0;
        char[] tmp = new char[255];
        while (stop) {
            tmp[index++] = this.ctx.car;
            this.scan();
            if (this.ctx.car == '.') {
                if (!type) {
                    type = true;
                    continue;
                }
                this.show_error("Bad number value");
                continue;
            }
            if (this.ctx.car == 'x' || this.ctx.car == 'X') {
                if (base == 0) {
                    base = 1;
                    continue;
                }
                this.show_error("Bad number value");
                continue;
            }
            if (this.ctx.car == '-') {
                this.show_error("Token '-' misplaced");
                stop = false;
                continue;
            }
            if (Character.isLetter(this.ctx.car)) {
                if (this.ctx.car == ' ' || this.ctx.car == '\u00ff' || this.ctx.car == '\u00fe') {
                    stop = false;
                    this.unscan();
                    continue;
                }
                if (base == 1) continue;
                if (this.ctx.car == 'D' || this.ctx.car == 'd') {
                    stop = false;
                    continue;
                }
                System.out.println("[" + this.ctx.car + "]");
                this.unscan();
                this.show_error("Bad hexadecimal value");
                stop = false;
                continue;
            }
            if (Character.isDigit(this.ctx.car)) continue;
            this.unscan();
            stop = false;
        }
        tmp[index] = '\u0000';
        this.ctx.symb = !type ? 61 : 62;
        this.ctx.value = new String(tmp, 0, index);
        this.ctx.base = base;
    }

    public void parse() {
        this.pre_parse();
        if (this.ctx.symb == 59) {
            switch (this.ctx.car) {
                case '&': {
                    this.ctx.symb = 19;
                    break;
                }
                case '|': {
                    this.ctx.symb = 85;
                    break;
                }
                case '+': {
                    this.ctx.symb = 0;
                    break;
                }
                case '-': {
                    this.ctx.symb = 1;
                    break;
                }
                case '=': {
                    this.ctx.symb = 10;
                    break;
                }
                case '*': {
                    this.ctx.symb = 2;
                    break;
                }
                case '{': {
                    this.ctx.symb = 4;
                    break;
                }
                case '}': {
                    this.ctx.symb = 5;
                    break;
                }
                case '[': {
                    this.ctx.symb = 6;
                    break;
                }
                case ']': {
                    this.ctx.symb = 7;
                    break;
                }
                case '.': {
                    this.ctx.symb = 12;
                    break;
                }
                case '~': {
                    this.ctx.symb = 58;
                    break;
                }
                case '<': {
                    this.ctx.symb = 15;
                    break;
                }
                case '>': {
                    this.ctx.symb = 16;
                    break;
                }
                case '%': {
                    this.ctx.symb = 60;
                    break;
                }
                case '(': {
                    this.ctx.symb = 8;
                    break;
                }
                case ')': {
                    this.ctx.symb = 9;
                    break;
                }
                case ';': {
                    this.ctx.symb = 13;
                    break;
                }
                case ',': {
                    this.ctx.symb = 11;
                    break;
                }
                case ':': {
                    this.scan();
                    if (this.ctx.car == ':') {
                        this.ctx.symb = 56;
                        break;
                    }
                    this.ctx.symb = 14;
                    this.unscan();
                    break;
                }
                case '\"': 
                case '\'': {
                    char stop = this.ctx.car;
                    StringBuffer tab = new StringBuffer();
                    this.scan();
                    while (this.ctx.car != stop) {
                        if (this.ctx.car == '\u00fe') {
                            this.show_error("End of file reached while scanning string");
                            break;
                        }
                        if (this.ctx.car == '\\') {
                            this.scan();
                            if (this.ctx.car == '\u00ff') continue;
                            tab.append('\\');
                        }
                        tab.append(this.ctx.car);
                        this.scan();
                    }
                    this.ctx.value = tab.toString();
                    if (stop == '\"') {
                        this.ctx.symb = 63;
                        break;
                    }
                    this.ctx.symb = 64;
                    break;
                }
                default: {
                    if (Character.isDigit(this.ctx.car)) {
                        this.read_number();
                        break;
                    }
                    if (Character.isLetter(this.ctx.car) || this.ctx.car == '_') {
                        this.read_word();
                        if (this.ctx.value == null) {
                            this.parse();
                            break;
                        }
                        if (this.is_reserved_word()) {
                            this.to_reserved_word();
                            break;
                        }
                        this.ctx.symb = 21;
                        if (!this.is_java_reserved_word()) break;
                        this.ctx.value = "__" + this.ctx.value;
                        break;
                    }
                    char dodgy = this.ctx.car;
                    this.show_error("Undefined character : " + this.ctx.car);
                }
            }
        }
    }

    public void symbole() {
        if (this.ctx.one != 59) {
            this.ctx.symb = this.ctx.one;
            this.ctx.one = 59;
            return;
        }
        this.parse();
        block0 : switch (this.ctx.symb) {
            case 1: {
                this.parse();
                if (this.ctx.symb == 61 || this.ctx.symb == 62) {
                    this.ctx.value = "-" + this.ctx.value;
                    break;
                }
                this.ctx.one = this.ctx.symb;
                this.ctx.symb = 1;
                break;
            }
            case 38: {
                this.parse();
                switch (this.ctx.symb) {
                    case 38: {
                        this.ctx.symb = 73;
                        break block0;
                    }
                    case 30: {
                        this.ctx.symb = 75;
                        break block0;
                    }
                }
                this.ctx.one = this.ctx.symb;
                this.ctx.symb = 38;
                break;
            }
            case 53: {
                this.parse();
                switch (this.ctx.symb) {
                    case 38: {
                        this.parse();
                        if (this.ctx.symb == 38) {
                            this.ctx.symb = 74;
                            break block0;
                        }
                        this.ctx.one = this.ctx.symb;
                        this.ctx.symb = 65;
                        break block0;
                    }
                    case 47: {
                        this.ctx.symb = 66;
                        break block0;
                    }
                }
                this.show_error("Unexpected combinaison type with unsigned");
            }
        }
    }

    public void stopAt(Vector list) {
        while (this.ctx.symb != 254) {
            int i = 0;
            while (i < list.size()) {
                Integer val = (Integer)list.elementAt(i);
                if (val == this.ctx.symb) {
                    return;
                }
                ++i;
            }
            this.symbole();
        }
    }

    public IdlObject compile_idl(String file_name, IdlObject current_root) {
        IdlGrammar grammar = new IdlGrammar(this);
        this.open_idl_file(file_name);
        grammar.idl_specification(current_root);
        return current_root;
    }

    public IdlObject compile_idl(String file_name) {
        IdlGrammar grammar = new IdlGrammar(this);
        container = this.root;
        this.open_idl_file(file_name);
        grammar.idl_specification(this.root);
        return this.root;
    }
}

