/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.netbeans.PatchByteCode;
import org.netbeans.ProxyClassLoader;

public class JarClassLoader
extends ProxyClassLoader {
    private Source[] sources;
    private Set deadJars = null;
    private static final boolean VERBOSE = Boolean.getBoolean("netbeans.classloader.verbose");
    private static Object factory = null;
    private static HashMap fileCache = null;

    public JarClassLoader(List files, ClassLoader[] parents) {
        this(files, parents, true);
    }

    public JarClassLoader(List files, ClassLoader[] parents, boolean transitive) {
        super(parents, transitive);
        this.sources = new Source[files.size()];
        try {
            int i = 0;
            Iterator it = files.iterator();
            while (it.hasNext()) {
                Object act = it.next();
                this.sources[i] = act instanceof File ? new DirSource((File)act) : new JarSource((JarFile)act);
                ++i;
            }
        }
        catch (MalformedURLException exc) {
            throw new IllegalArgumentException(exc.getMessage());
        }
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        return Policy.getPolicy().getPermissions(cs);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        if (man == null) {
            return this.definePackage(name, null, null, null, null, null, null, null);
        }
        String path = name.replace('.', '/').concat("/");
        Attributes spec = man.getAttributes(path);
        Attributes main = man.getMainAttributes();
        String specTitle = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_TITLE);
        String implTitle = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_TITLE);
        String specVersion = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_VERSION);
        String implVersion = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_VERSION);
        String specVendor = JarClassLoader.getAttr(spec, main, Attributes.Name.SPECIFICATION_VENDOR);
        String implVendor = JarClassLoader.getAttr(spec, main, Attributes.Name.IMPLEMENTATION_VENDOR);
        String sealed = JarClassLoader.getAttr(spec, main, Attributes.Name.SEALED);
        URL sealBase = "true".equalsIgnoreCase(sealed) ? url : null;
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private static String getAttr(Attributes spec, Attributes main, Attributes.Name name) {
        String val = null;
        if (spec != null) {
            val = spec.getValue(name);
        }
        if (val == null && main != null) {
            val = main.getValue(name);
        }
        return val;
    }

    protected Class simpleFindClass(String name, String path, String pkgnameSlashes) {
        int i = 0;
        while (i < this.sources.length) {
            Source src = this.sources[i];
            byte[] data = src.getClassData(name, path);
            if (data != null) {
                byte[] d = PatchByteCode.patch(data, name);
                data = d;
                int j = name.lastIndexOf(46);
                String pkgName = name.substring(0, j);
                Package pkg = this.getPackageFast(pkgName, pkgnameSlashes, this.isSpecialResource(pkgnameSlashes));
                if (pkg != null) {
                    if (pkg.isSealed() && !pkg.isSealed(src.getURL())) {
                        throw new SecurityException("sealing violation");
                    }
                } else {
                    Manifest man = src.getManifest();
                    this.definePackage(pkgName, man, src.getURL());
                }
                return this.defineClass(name, data, 0, data.length, src.getProtectionDomain());
            }
            ++i;
        }
        return null;
    }

    protected URL findResource(String name) {
        int i = 0;
        while (i < this.sources.length) {
            URL item = this.sources[i].getResource(name);
            if (item != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected Enumeration simpleFindResources(String name) {
        Vector<URL> v = new Vector<URL>(3);
        int i = 0;
        while (i < this.sources.length) {
            URL item = this.sources[i].getResource(name);
            if (item != null) {
                v.add(item);
            }
            ++i;
        }
        return v.elements();
    }

    /*
     * WARNING - void declaration
     */
    public final void releaseLocks() {
        if (this.deadJars != null) {
            throw new IllegalStateException("Already had dead JARs: " + this.deadJars);
        }
        this.deadJars = new HashSet();
        try {
            int i = 0;
            while (i < this.sources.length) {
                JarFile origJar;
                File orig;
                if (this.sources[i] instanceof JarSource && (orig = new File((origJar = ((JarSource)this.sources[i]).getJarFile()).getName())).isFile()) {
                    Object var16_15;
                    String suffix;
                    String prefix;
                    String name = orig.getName();
                    int idx = name.lastIndexOf(46);
                    if (idx == -1) {
                        prefix = name;
                        suffix = null;
                    } else {
                        prefix = name.substring(0, idx);
                        suffix = name.substring(idx);
                    }
                    while (prefix.length() < 3) {
                        prefix = prefix + "x";
                    }
                    File temp = File.createTempFile(prefix, suffix);
                    temp.deleteOnExit();
                    FileInputStream is = new FileInputStream(orig);
                    try {
                        Object var14_14;
                        FileOutputStream os = new FileOutputStream(temp);
                        try {
                            int j;
                            byte[] buf = new byte[4096];
                            while ((j = ((InputStream)is).read(buf)) != -1) {
                                void var12_13;
                                ((OutputStream)os).write(buf, 0, (int)var12_13);
                            }
                            var14_14 = null;
                        }
                        catch (Throwable throwable) {
                            var14_14 = null;
                            ((OutputStream)os).close();
                            throw throwable;
                        }
                        ((OutputStream)os).close();
                        var16_15 = null;
                    }
                    catch (Throwable throwable) {
                        var16_15 = null;
                        ((InputStream)is).close();
                        throw throwable;
                    }
                    ((InputStream)is).close();
                    JarFile tempJar = new JarFile(temp);
                    origJar.close();
                    JarClassLoader.forceRelease(orig);
                    this.deadJars.add(tempJar);
                    this.sources[i] = new JarSource(tempJar);
                    JarClassLoader.log("#21114: replacing " + orig + " with " + temp);
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            JarClassLoader.notify(0, ioe);
        }
    }

    public void destroy() {
        super.destroy();
        int i = 0;
        while (i < this.sources.length) {
            if (this.sources[i] instanceof JarSource) {
                JarFile j = ((JarSource)this.sources[i]).getJarFile();
                File f = new File(j.getName());
                JarClassLoader.forceRelease(f);
            }
            ++i;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        int i = 0;
        while (i < this.sources.length) {
            if (this.sources[i] instanceof JarSource) {
                JarFile j = ((JarSource)this.sources[i]).getJarFile();
                File f = new File(j.getName());
                j.close();
                JarClassLoader.forceRelease(f);
                if (this.deadJars != null && this.deadJars.contains(j)) {
                    JarClassLoader.log("#21114: closing and deleting temporary JAR " + f);
                    if (f.isFile() && !f.delete()) {
                        JarClassLoader.log("(but failed to delete it)");
                    }
                }
            }
            ++i;
        }
    }

    private static void forceRelease(File f) {
        if (fileCache == null || factory == null) {
            return;
        }
        try {
            Object object = factory;
            synchronized (object) {
                Iterator it = fileCache.values().iterator();
                while (it.hasNext()) {
                    JarFile j = (JarFile)it.next();
                    if (!f.equals(new File(j.getName()))) continue;
                    j.close();
                    it.remove();
                    JarClassLoader.log("Removing jar: cache for " + f + " as workaround for JDK #4646668");
                }
            }
        }
        catch (Exception e) {
            JarClassLoader.annotate(e, 0, "Could not remove jar: cache for " + f, null, null, null);
            JarClassLoader.notify(0, e);
        }
    }

    protected URL fileToURL(File f) throws MalformedURLException {
        return f.toURL();
    }

    static void log(String msg) {
        if ("0".equals(System.getProperty("org.netbeans.core.modules"))) {
            System.err.println(msg);
        }
    }

    static Throwable annotate(Throwable t, int x, String s, Object o1, Object o2, Object o3) {
        System.err.println("annotated: " + t.getMessage() + " - " + s);
        return t;
    }

    static void notify(int x, Throwable t) {
        t.printStackTrace();
    }

    static {
        try {
            Class<?> juc = Class.forName("sun.net.www.protocol.jar.JarURLConnection");
            Field factoryF = juc.getDeclaredField("factory");
            ((AccessibleObject)factoryF).setAccessible(true);
            factory = factoryF.get(null);
            Class<?> jff = Class.forName("sun.net.www.protocol.jar.JarFileFactory");
            if (!jff.isInstance(factory)) {
                throw new ClassCastException(factory.getClass().getName());
            }
            Field fileCacheF = jff.getDeclaredField("fileCache");
            ((AccessibleObject)fileCacheF).setAccessible(true);
            fileCache = Modifier.isStatic(fileCacheF.getModifiers()) ? (HashMap)fileCacheF.get(null) : (HashMap)fileCacheF.get(factory);
            JarClassLoader.log("Workaround for JDK #4646668 active as part of IZ #21114");
        }
        catch (Exception e) {
            JarClassLoader.annotate(e, 0, "Workaround for JDK #4646668 as part of IZ #21114 failed", null, null, null);
            JarClassLoader.notify(0, e);
        }
    }

    class DirSource
    extends Source {
        File dir;

        public DirSource(File file) throws MalformedURLException {
            super(JarClassLoader.this.fileToURL(file));
            this.dir = file;
        }

        protected URL doGetResource(String name) throws MalformedURLException {
            File resFile = new File(this.dir, name);
            return resFile.exists() ? JarClassLoader.this.fileToURL(resFile) : null;
        }

        protected byte[] readClass(String name, String path) throws IOException {
            File clsFile = new File(this.dir, path.replace('/', File.separatorChar));
            if (!clsFile.exists()) {
                return null;
            }
            int len = (int)clsFile.length();
            byte[] data = new byte[len];
            FileInputStream is = new FileInputStream(clsFile);
            int count = 0;
            while (count < len) {
                count += ((InputStream)is).read(data, count, len - count);
            }
            return data;
        }
    }

    class JarSource
    extends Source {
        JarFile src;

        public JarSource(JarFile file) throws MalformedURLException {
            super(JarClassLoader.this.fileToURL(new File(file.getName())));
            this.src = file;
        }

        public Manifest getManifest() {
            try {
                return this.src.getManifest();
            }
            catch (IOException e) {
                return null;
            }
        }

        JarFile getJarFile() {
            return this.src;
        }

        protected URL doGetResource(String name) throws MalformedURLException {
            ZipEntry ze = this.src.getEntry(name);
            if (VERBOSE && ze != null) {
                System.err.println("Loading " + name + " from " + this.src.getName());
            }
            return ze == null ? null : new URL("jar:" + JarClassLoader.this.fileToURL(new File(this.src.getName())).toExternalForm() + "!/" + ze.getName());
        }

        protected byte[] readClass(String name, String path) throws IOException {
            ZipEntry ze = this.src.getEntry(path);
            if (ze == null) {
                return null;
            }
            if (VERBOSE) {
                System.err.println("Loading " + path + " from " + this.src.getName());
            }
            int len = (int)ze.getSize();
            byte[] data = new byte[len];
            InputStream is = this.src.getInputStream(ze);
            int count = 0;
            while (count < len) {
                count += is.read(data, count, len - count);
            }
            return data;
        }
    }

    abstract class Source {
        private URL url;
        private ProtectionDomain pd;

        public Source(URL url) {
            this.url = url;
        }

        public final URL getURL() {
            return this.url;
        }

        public final ProtectionDomain getProtectionDomain() {
            if (this.pd == null) {
                CodeSource cs = new CodeSource(this.url, new Certificate[0]);
                this.pd = new ProtectionDomain(cs, JarClassLoader.this.getPermissions(cs));
            }
            return this.pd;
        }

        public final URL getResource(String name) {
            try {
                return this.doGetResource(name);
            }
            catch (MalformedURLException e) {
                JarClassLoader.log(e.toString());
                return null;
            }
        }

        protected abstract URL doGetResource(String var1) throws MalformedURLException;

        public final byte[] getClassData(String name, String path) {
            try {
                return this.readClass(name, path);
            }
            catch (IOException e) {
                JarClassLoader.log(e.toString());
                return null;
            }
        }

        protected abstract byte[] readClass(String var1, String var2) throws IOException;

        public Manifest getManifest() {
            return null;
        }
    }
}

