/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public final class NumberCache {
    private static final Byte[] BYTE_CACHE;
    private static final Short MIN_SHORT;
    private static final Short MAX_SHORT;
    private static final Short[] SHORT_BLOCK;
    private static final short MIN_SHORT_BLOCK = -2;
    private static final short MAX_SHORT_BLOCK = 100;
    private static final Integer MIN_INTEGER;
    private static final Integer MAX_INTEGER;
    private static final Integer[] INTEGER_BLOCK;
    private static final int MIN_INTEGER_BLOCK = -2;
    private static final int MAX_INTEGER_BLOCK = 100;
    private static final Long MIN_LONG;
    private static final Long MAX_LONG;
    private static final Long[] LONG_BLOCK;
    private static final long MIN_LONG_BLOCK = -2L;
    private static final long MAX_LONG_BLOCK = 100L;
    private static final Float ZERO_FLOAT;
    private static final Float ONE_FLOAT;
    private static final Float NEG_ONE_FLOAT;
    private static final Double ZERO_DOUBLE;
    private static final Double ONE_DOUBLE;
    private static final Double NEG_ONE_DOUBLE;

    private NumberCache() {
    }

    public static Byte getByte(byte value) {
        return BYTE_CACHE[value - -128];
    }

    public static Short getShort(short value) {
        if (-2 <= value && value <= 100) {
            return SHORT_BLOCK[value - -2];
        }
        return Short.MIN_VALUE == value ? MIN_SHORT : (Short.MAX_VALUE == value ? MAX_SHORT : new Short(value));
    }

    public static Integer getInteger(int value) {
        if (-2 <= value && value <= 100) {
            return INTEGER_BLOCK[value - -2];
        }
        return Integer.MIN_VALUE == value ? MIN_INTEGER : (Integer.MAX_VALUE == value ? MAX_INTEGER : new Integer(value));
    }

    public static Long getLong(long value) {
        if (-2L <= value && value <= 100L) {
            return LONG_BLOCK[(int)(value - -2L)];
        }
        return Long.MIN_VALUE == value ? MIN_LONG : (Long.MAX_VALUE == value ? MAX_LONG : new Long(value));
    }

    public static Float getFloat(float value) {
        if (0.0f == value) {
            return ZERO_FLOAT;
        }
        if (1.0f == value) {
            return ONE_FLOAT;
        }
        if (-1.0f == value) {
            return NEG_ONE_FLOAT;
        }
        return new Float(value);
    }

    public static Double getDouble(double value) {
        if (0.0 == value) {
            return ZERO_DOUBLE;
        }
        if (1.0 == value) {
            return ONE_DOUBLE;
        }
        if (-1.0 == value) {
            return NEG_ONE_DOUBLE;
        }
        return new Double(value);
    }

    static {
        MIN_SHORT = new Short(Short.MIN_VALUE);
        MAX_SHORT = new Short(Short.MAX_VALUE);
        MIN_INTEGER = new Integer(Integer.MIN_VALUE);
        MAX_INTEGER = new Integer(Integer.MAX_VALUE);
        MIN_LONG = new Long(Long.MIN_VALUE);
        MAX_LONG = new Long(Long.MAX_VALUE);
        ZERO_FLOAT = new Float(0.0f);
        ONE_FLOAT = new Float(1.0f);
        NEG_ONE_FLOAT = new Float(-1.0f);
        ZERO_DOUBLE = new Double(0.0);
        ONE_DOUBLE = new Double(1.0);
        NEG_ONE_DOUBLE = new Double(-1.0);
        BYTE_CACHE = new Byte[256];
        byte i = -128;
        while (i < 127) {
            NumberCache.BYTE_CACHE[i - -128] = new Byte(i);
            i = (byte)(i + 1);
        }
        NumberCache.BYTE_CACHE[255] = new Byte(127);
        SHORT_BLOCK = new Short[103];
        short i2 = -2;
        while (i2 <= 100) {
            NumberCache.SHORT_BLOCK[i2 - -2] = new Short(i2);
            i2 = (short)(i2 + 1);
        }
        INTEGER_BLOCK = new Integer[103];
        int i3 = -2;
        while (i3 <= 100) {
            NumberCache.INTEGER_BLOCK[i3 - -2] = new Integer(i3);
            ++i3;
        }
        LONG_BLOCK = new Long[103];
        long i4 = -2L;
        while (i4 <= 100L) {
            NumberCache.LONG_BLOCK[(int)(i4 - -2L)] = new Long(i4);
            ++i4;
        }
    }
}

