/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

public final class CharacterCache {
    private static final Character MIN_VALUE = new Character('\u0000');
    private static final Character MAX_VALUE = new Character('\uffff');
    private static final Character[] CACHE_BLOCK = new Character[95];
    private static final char BLOCK_MIN = ' ';
    private static final char BLOCK_MAX = '~';

    private CharacterCache() {
    }

    public static Character getCharacter(char value) {
        if (' ' <= value && value <= '~') {
            return CACHE_BLOCK[value - 32];
        }
        return '\u0000' == value ? MIN_VALUE : ('\uffff' == value ? MAX_VALUE : new Character(value));
    }

    static {
        char value = ' ';
        while (value <= '~') {
            CharacterCache.CACHE_BLOCK[value - 32] = new Character(value);
            value = (char)(value + '\u0001');
        }
    }
}

