/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.net;

import java.util.Comparator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableInterceptor.ForwardRequest;
import org.openorb.adapter.AdapterDestroyedException;
import org.openorb.adapter.ObjectAdapter;
import org.openorb.net.Address;
import org.openorb.net.ClientChannel;
import org.openorb.net.ClientRequest;
import org.openorb.net.RebindChannelException;
import org.openorb.net.ServerManager;

public class ClientBinding {
    public static final int DEAD_PRIORITY = Integer.MAX_VALUE;
    public static final int FORCE_UNSET = -1;
    public static final int FORCE_FALSE = 0;
    public static final int FORCE_TRUE = 1;
    private Address m_address;
    private ClientChannel m_channel;
    private java.lang.Object m_transport_association;
    private ObjectAdapter m_adapter = null;
    private SystemException m_exception;
    private int m_priority = 0;
    private byte[] m_oid = null;
    private int m_forced_marshal;
    private ServerManager m_server_manager;
    public static final int MASK_ADDRESS_PRIORITY = 4095;
    public static final int MASK_PROFILE_PRIORITY = 61440;
    public static final int MASK_IOR_PRIORITY = 0xFF0000;
    public static final Comparator PRIORITY_COMP = new PriorityComparator();

    protected ClientBinding(Address address) {
        this.m_address = address;
        this.m_forced_marshal = -1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, ClientChannel channel, java.lang.Object transportAssociation) {
        this.m_address = address;
        this.m_channel = channel;
        this.m_transport_association = transportAssociation;
        this.m_forced_marshal = 1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, ClientChannel channel, java.lang.Object transportAssociation, ServerManager serverManager) {
        this.m_address = address;
        this.m_channel = channel;
        this.m_transport_association = transportAssociation;
        this.m_server_manager = serverManager;
        this.m_forced_marshal = -1;
        this.m_priority = address.getPriority();
    }

    public ClientBinding(Address address, SystemException ex) {
        this.m_address = address;
        this.m_exception = ex;
        this.m_priority = Integer.MAX_VALUE;
        this.m_forced_marshal = 0;
    }

    public Address getAddress() {
        return this.m_address;
    }

    public ClientChannel getClientChannel() {
        return this.m_channel;
    }

    public ObjectAdapter getObjectAdapter() {
        if (this.m_server_manager == null) {
            return null;
        }
        if (this.m_oid == null) {
            this.m_oid = this.m_address.getTargetAddress((short)0).object_key();
            this.m_adapter = this.m_server_manager.find_adapter(this.m_oid);
        }
        if (this.m_adapter == null) {
            return null;
        }
        this.m_forced_marshal = -1;
        return this.m_adapter;
    }

    public int getPriority() {
        if (this.m_exception != null) {
            return Integer.MAX_VALUE;
        }
        if (this.m_adapter != null) {
            return this.m_priority | this.m_adapter.cache_priority() & 0xFF000000;
        }
        return this.m_priority | this.m_channel.state();
    }

    public void setPriority(int priority) {
        this.m_priority = priority > 0 ? priority & 0xFFF000 | this.m_priority & 0xFF000FFF : priority;
    }

    public int hashCode() {
        return this.m_address.hashCode();
    }

    public boolean equals(java.lang.Object obj) {
        if (!(obj instanceof ClientBinding)) {
            return false;
        }
        return this.m_address.equals(((ClientBinding)obj).m_address);
    }

    public boolean local_invoke() {
        if (this.m_forced_marshal == -1) {
            while (true) {
                this.getObjectAdapter();
                if (this.m_adapter == null) {
                    this.m_forced_marshal = 1;
                    break;
                }
                try {
                    this.m_forced_marshal = this.m_adapter.forced_marshal(this.m_oid) ? 1 : 0;
                }
                catch (AdapterDestroyedException ex) {
                    this.m_adapter = null;
                    continue;
                }
                break;
            }
        }
        return this.m_forced_marshal == 0;
    }

    public ClientRequest create_request(Object target, String operation, boolean response_expected) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        while (this.m_channel != null) {
            try {
                return this.m_channel.create_request(target, this.m_address, this.m_transport_association, operation, response_expected);
            }
            catch (RebindChannelException ex) {
                this.m_channel = ex.getClientChannel();
                this.m_transport_association = ex.getTransportAssociation();
                continue;
            }
            break;
        }
        return null;
    }

    public ClientRequest create_locate_request(Object target) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        while (this.m_channel != null) {
            try {
                return this.m_channel.create_locate_request(target, this.m_address, this.m_transport_association);
            }
            catch (RebindChannelException ex) {
                this.m_channel = ex.getClientChannel();
                this.m_transport_association = ex.getTransportAssociation();
                continue;
            }
            break;
        }
        return null;
    }

    public ServantObject servant_preinvoke(String operation, Class expectedType) throws ForwardRequest {
        ServantObject servObj;
        ObjectAdapter adapter;
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            if ((adapter = this.getObjectAdapter()) == null) {
                return null;
            }
            try {
                servObj = adapter.servant_preinvoke(this.m_oid, operation, expectedType);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
        if (servObj == null) {
            this.m_forced_marshal = -1;
            return null;
        }
        LocalServant ret = new LocalServant();
        ret.fAdapter = adapter;
        ret.fOriginalServant = servObj;
        ret.servant = servObj.servant;
        return ret;
    }

    public void servant_postinvoke(ServantObject srvObject) {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (!(srvObject instanceof LocalServant)) {
            throw new INTERNAL("Servant is not a LocalObject");
        }
        LocalServant sobj = (LocalServant)srvObject;
        sobj.fAdapter.servant_postinvoke(this.m_oid, sobj.fOriginalServant);
    }

    public boolean locate() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        ObjectAdapter adapter;
        while ((adapter = this.getObjectAdapter()) != null) {
            try {
                return adapter.locate(this.m_oid);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
        return false;
    }

    public boolean is_a(String repository_id) throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter adapter;
            if ((adapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return adapter.is_a(this.m_oid, repository_id);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
    }

    public Object get_interface_def() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter adapter;
            if ((adapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return adapter.get_interface_def(this.m_oid);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
    }

    public DomainManager[] get_domain_managers() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter adapter;
            if ((adapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return adapter.get_domain_managers(this.m_oid);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
    }

    public Object get_component() throws ForwardRequest {
        if (this.m_exception != null) {
            throw this.m_exception;
        }
        if (this.m_server_manager == null) {
            throw new INTERNAL("ServerManager unavailable");
        }
        while (true) {
            ObjectAdapter adapter;
            if ((adapter = this.getObjectAdapter()) == null) {
                throw new OBJECT_NOT_EXIST(0, CompletionStatus.COMPLETED_NO);
            }
            try {
                return adapter.get_component(this.m_oid);
            }
            catch (AdapterDestroyedException ex) {
                adapter = null;
                continue;
            }
            break;
        }
    }

    private static class PriorityComparator
    implements Comparator {
        private PriorityComparator() {
        }

        public int compare(java.lang.Object obj1, java.lang.Object obj2) {
            if (obj1 == null) {
                if (obj2 == null) {
                    return 0;
                }
                return 1;
            }
            if (obj2 == null) {
                return -1;
            }
            int pri1 = ((ClientBinding)obj1).getPriority();
            int pri2 = ((ClientBinding)obj2).getPriority();
            if (pri1 < 0) {
                if (pri2 < 0) {
                    return 0;
                }
                return -1;
            }
            if (pri2 < 0) {
                return 1;
            }
            int diff = pri2 - pri1;
            return pri1 > pri2 ? 1 : (pri1 < pri2 ? -1 : 0);
        }

        public boolean equals(java.lang.Object p1) {
            return p1 == this;
        }
    }

    private static class LocalServant
    extends ServantObject {
        public ObjectAdapter fAdapter;
        public ServantObject fOriginalServant;

        private LocalServant() {
        }
    }
}

