/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.PI;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.CurrentOperations;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.SystemExceptionHelper;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.RequestCallback;
import org.openorb.PI.ServerManager;
import org.openorb.util.ExceptionTool;

public class SimpleServerManager
implements ServerManager {
    private ServerRequestInterceptor[] m_list;
    private CurrentImpl m_current;
    public static final int BAD_INTERCEPTOR_RESPONSE = 0;
    private Logger m_logger = null;

    public SimpleServerManager(ServerRequestInterceptor[] list, CurrentImpl current) {
        this.m_list = list;
        this.m_current = current;
        this.m_logger = ((ORB)current._orb()).getLogger();
    }

    public void receive_request_service_contexts(ServerRequestInfo info, RequestCallback cb) {
        int index = 0;
        CurrentOperations table = this.m_current.remove();
        try {
            while (index < this.m_list.length) {
                this.m_list[index].receive_request_service_contexts(info);
                this.m_current.remove();
                ++index;
            }
        }
        catch (SystemException ex) {
            this.m_current.remove();
            if (ex.completed != CompletionStatus.COMPLETED_NO) {
                ex = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            cb.reply_system_exception(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        catch (ForwardRequest ex) {
            this.m_current.remove();
            cb.reply_location_forward(ex.forward, false);
            this.send_other_point(index - 1, info, cb);
        }
        catch (RuntimeException ex) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
            }
            cb.reply_runtime_exception(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        catch (Error ex) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
            }
            cb.reply_error(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        this.m_current.set(table);
    }

    public void receive_request(ServerRequestInfo info, RequestCallback cb) {
        int index = 0;
        CurrentOperations table = this.m_current.remove();
        try {
            while (index < this.m_list.length) {
                this.m_list[index].receive_request(info);
                this.m_current.remove();
                ++index;
            }
        }
        catch (SystemException ex) {
            this.m_current.remove();
            if (ex.completed != CompletionStatus.COMPLETED_NO) {
                ex = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            cb.reply_system_exception(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        catch (ForwardRequest ex) {
            this.m_current.remove();
            cb.reply_location_forward(ex.forward, false);
            this.send_other_point(index - 1, info, cb);
        }
        catch (RuntimeException ex) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
            }
            cb.reply_runtime_exception(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        catch (Error ex) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
            }
            cb.reply_error(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        this.m_current.set(table);
    }

    public void send_reply(ServerRequestInfo info, RequestCallback cb) {
        int index = this.m_list.length - 1;
        CurrentOperations table = this.m_current.remove();
        try {
            while (index >= 0) {
                this.m_list[index].send_reply(info);
                this.m_current.remove();
                --index;
            }
        }
        catch (SystemException ex) {
            this.m_current.remove();
            if (ex.completed != CompletionStatus.COMPLETED_YES) {
                ex = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_YES), (Throwable)ex);
            }
            cb.reply_system_exception(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        catch (RuntimeException ex) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
            }
            cb.reply_runtime_exception(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        catch (Error ex) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
            }
            cb.reply_error(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        this.m_current.set(table);
    }

    public void send_exception(ServerRequestInfo info, RequestCallback cb) {
        CurrentOperations table = this.m_current.remove();
        this.send_exception_point(this.m_list.length - 1, info, cb);
        this.m_current.set(table);
    }

    private void send_exception_point(int index, ServerRequestInfo info, RequestCallback cb) {
        if (index < 0) {
            return;
        }
        CompletionStatus status = info.reply_status() == 1 ? SystemExceptionHelper.extract((Any)info.sending_exception()).completed : CompletionStatus.COMPLETED_YES;
        while (index >= 0) {
            try {
                this.m_list[index].send_exception(info);
                this.m_current.remove();
            }
            catch (SystemException ex) {
                this.m_current.remove();
                if (ex.completed != status) {
                    ex = ExceptionTool.initCause(new INTERNAL(0, status), (Throwable)ex);
                }
                cb.reply_system_exception(ex);
            }
            catch (RuntimeException ex) {
                this.m_current.remove();
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
                }
                cb.reply_runtime_exception(ex);
            }
            catch (Error ex) {
                this.m_current.remove();
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
                }
                cb.reply_error(ex);
            }
            catch (ForwardRequest ex) {
                this.m_current.remove();
                if (status != CompletionStatus.COMPLETED_YES) {
                    cb.reply_system_exception(ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_YES), (Throwable)ex));
                }
                cb.reply_location_forward(ex.forward, false);
                this.send_other_point(index - 1, info, cb);
                return;
            }
            --index;
        }
    }

    public void send_other(ServerRequestInfo info, RequestCallback cb) {
        CurrentOperations table = this.m_current.remove();
        this.send_other_point(this.m_list.length - 1, info, cb);
        this.m_current.set(table);
    }

    private void send_other_point(int index, ServerRequestInfo info, RequestCallback cb) {
        if (index < 0) {
            return;
        }
        try {
            try {
                while (index >= 0) {
                    this.m_list[index].send_other(info);
                    this.m_current.remove();
                    --index;
                }
            }
            catch (ForwardRequest ex) {
                this.m_current.remove();
                cb.reply_location_forward(ex.forward, false);
            }
        }
        catch (SystemException ex) {
            this.m_current.remove();
            if (ex.completed != CompletionStatus.COMPLETED_NO) {
                ex = ExceptionTool.initCause(new INTERNAL(0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
            }
            cb.reply_system_exception(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        catch (RuntimeException ex) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
            }
            cb.reply_runtime_exception(ex);
            this.send_exception_point(index - 1, info, cb);
        }
        catch (Error ex) {
            this.m_current.remove();
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Received an unexcepted exception : ", (Throwable)ex);
            }
            cb.reply_error(ex);
            this.send_exception_point(index - 1, info, cb);
        }
    }

    private Logger getLogger() {
        return this.m_logger;
    }
}

