/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend.contentassist;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.ui.common.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.core.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.core.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtend.AbstractXtendExecutionException;
import org.eclipse.xtext.xtend.NoSuchExtensionException;
import org.eclipse.xtext.xtend.XtendServiceHelper;
import org.eclipse.xtext.xtend.contentassist.ContentAssistHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXtendProposalProvider
extends AbstractContentProposalProvider {
    private static final Logger logger = Logger.getLogger(AbstractXtendProposalProvider.class);
    private XtendServiceHelper helper;

    @Inject
    public void setHelper(XtendServiceHelper helper) {
        this.setHelper(helper);
        helper.setMasterXtendFileName(this.getMasterXtendFileName());
    }

    protected abstract String getMasterXtendFileName();

    public XtendServiceHelper getHelper() {
        return this.helper;
    }

    protected List<ICompletionProposal> invokeExtension(String extensionName, List<?> parameterValues) throws AbstractXtendExecutionException {
        try {
            List proposals = (List)this.helper.invokeExtension(extensionName, parameterValues);
            return proposals;
        }
        catch (NoSuchExtensionException noSuchExtensionException) {
            return null;
        }
        catch (Throwable e) {
            logger.error((Object)("Error invoking extension " + extensionName), e);
            return null;
        }
    }

    public void completeAssignment(Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ParserRule parserRule = GrammarUtil.containingParserRule((EObject)assignment);
        String extensionName = "complete" + Strings.toFirstUpper((String)parserRule.getName()) + "_" + Strings.toFirstUpper((String)assignment.getFeature());
        List<ICompletionProposal> proposals = this.invokeExtension(extensionName, Arrays.asList(context.getCurrentModel(), assignment, context));
        this.addProposals(acceptor, proposals);
    }

    public void completeKeyword(Keyword keyword, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal proposal = ContentAssistHelper.newProposal((AbstractElement)keyword, keyword.getValue(), context);
        acceptor.accept(proposal);
    }

    public void completeRuleCall(RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        AbstractRule calledRule = ruleCall.getRule();
        String extensionName = "complete_" + calledRule.getName();
        List<ICompletionProposal> proposals = this.invokeExtension(extensionName, Arrays.asList(context.getCurrentModel(), ruleCall, context));
        this.addProposals(acceptor, proposals);
    }

    private void addProposals(ICompletionProposalAcceptor acceptor, List<ICompletionProposal> proposals) {
        if (proposals != null) {
            for (ICompletionProposal proposal : proposals) {
                if (!acceptor.canAcceptMoreProposals()) {
                    return;
                }
                acceptor.accept(proposal);
            }
        }
    }
}

