/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtend;

import com.google.common.base.Function;
import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.xtend.expression.ExecutionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionContextAware {
    private Provider<ExecutionContext> execProv;
    private ThreadLocal<ExecutionContext> current = new ThreadLocal();
    private ThreadLocal<Integer> numberOfUsers = new ThreadLocal();

    @Inject
    public ExecutionContextAware(Provider<ExecutionContext> execProv) {
        this.execProv = execProv;
    }

    public <T> T exec(Function<ExecutionContext, T> func) {
        try {
            ExecutionContext ctx = this.getContext();
            Object object = func.apply((Object)ctx);
            return (T)object;
        }
        finally {
            this.dispose();
        }
    }

    private ExecutionContext getContext() {
        if (this.current.get() == null) {
            this.current.set((ExecutionContext)this.execProv.get());
            this.numberOfUsers.set(0);
        }
        this.numberOfUsers.set(this.numberOfUsers.get() + 1);
        return this.current.get();
    }

    private void dispose() {
        Integer integer = this.numberOfUsers.get() - 1;
        if (integer == 0) {
            this.current.set(null);
        } else {
            this.numberOfUsers.set(integer);
        }
    }
}

