/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.xml;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.util.Arrays;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractEventData;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.eventdata.DragEventData;
import junit.extensions.jfcunit.eventdata.JFCEventDataListener;
import junit.extensions.jfcunit.eventdata.JFCEventManager;
import junit.extensions.jfcunit.eventdata.KeyEventData;
import junit.extensions.jfcunit.eventdata.MouseEventData;
import junit.extensions.jfcunit.eventdata.MouseWheelEventData;
import junit.extensions.jfcunit.finder.AbstractButtonFinder;
import junit.extensions.jfcunit.finder.ComponentFinder;
import junit.extensions.jfcunit.finder.Finder;
import junit.extensions.jfcunit.finder.JMenuItemFinder;
import junit.extensions.jfcunit.finder.NamedComponentFinder;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.tools.Operator;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.jfcunit.xml.JFCXMLTestCase;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.SaveTagHandler;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLRecorder
extends SaveTagHandler
implements JFCEventDataListener,
JFCXMLConstants {
    private static boolean s_replay = false;
    private Document m_doc = null;
    private Element m_root = null;
    private String m_indent = null;
    private JFCKeyStroke[] m_terminator = null;
    private volatile boolean m_paused = false;
    private int m_compIndex = -1;

    public XMLRecorder(Element element, IXMLTestCase testCase) {
        super(element, testCase);
        this.m_root = (Element)element.getParentNode();
        this.m_doc = element.getOwnerDocument();
        Node previousSibling = element.getPreviousSibling();
        if (previousSibling.getNodeType() == 3) {
            this.m_indent = previousSibling.getNodeValue();
        }
    }

    public static void setReplay(boolean value) {
        s_replay = value;
    }

    public void setTerminator(JFCKeyStroke[] stroke) {
        this.m_terminator = stroke;
    }

    public JFCKeyStroke[] getTerminator() {
        if (this.m_terminator == null) {
            this.m_terminator = this.getDefaultTerminator();
        }
        return this.m_terminator;
    }

    public String generateFind(Component comp) {
        String name = this.getXMLTestCase().getPropertyName(comp);
        if (name != null && name.length() != 0) {
            return name;
        }
        if (comp instanceof JMenuItem) {
            return this.generateMenuFind(comp);
        }
        Window w = null;
        if (!(comp instanceof Window)) {
            w = SwingUtilities.getWindowAncestor(comp);
        }
        String windowName = this.generateWindowFind(w);
        name = "Component" + this.getComponentIndex();
        String className = comp.getClass().getName();
        String named = comp.getName();
        String finderName = null;
        Finder finder = null;
        String label = null;
        if (named != null) {
            finderName = "NamedComponentFinder";
            finder = new NamedComponentFinder(comp.getClass(), named);
        } else if (comp instanceof AbstractButton && ((AbstractButton)comp).getText() != null) {
            finderName = "AbstractButtonFinder";
            label = ((AbstractButton)comp).getText();
            finder = new AbstractButtonFinder(label);
        } else {
            finderName = "ComponentFinder";
            finder = new ComponentFinder(comp.getClass());
        }
        int index = TestHelper.indexOf(finder, w, comp);
        if (index == -1) {
            windowName = null;
            index = TestHelper.indexOf(finder, null, comp);
        }
        if (index == -1) {
            Comment comment = this.m_doc.createComment("Assuming zero index. Could not find index of: " + comp.getClass());
            this.insertNode(comment);
            index = 0;
        }
        Element e = this.m_doc.createElement("find");
        e.setAttribute("finder", finderName);
        e.setAttribute("id", name);
        if (label != null) {
            e.setAttribute("label", label);
        }
        e.setAttribute("class", className);
        if (named != null) {
            e.setAttribute("name", named);
        }
        e.setAttribute("index", Integer.toString(index));
        e.setAttribute("operation", Operator.Operation.toString(3));
        if (windowName != null) {
            e.setAttribute("container", windowName);
        }
        this.insertNode(e);
        this.getXMLTestCase().addProperty(name, comp);
        return name;
    }

    public void handleEvent(AbstractEventData evtData) {
        Element e;
        String source;
        Object[] strokes;
        Object[] terminator;
        if (evtData.getComponent() == null) {
            return;
        }
        if (evtData instanceof KeyEventData && Arrays.equals(terminator = this.getTerminator(), strokes = ((KeyEventData)evtData).getKeyStrokes())) {
            this.stop();
            System.err.println("Stop recording for test: " + this.getTestCase().getName());
            return;
        }
        if (evtData instanceof DragEventData) {
            DragEventData ded = (DragEventData)evtData;
            Component comp = ded.getSource().getComponent();
            String sourceId = this.generateFind(comp);
            Element src = this.m_doc.createElement("source");
            ded.getSource().populate(src);
            src.setAttribute("refid", sourceId);
            Element e2 = this.m_doc.createElement("drag");
            e2.appendChild(src);
            if (ded.getDest() != null) {
                Element dst = this.m_doc.createElement("destination");
                String destId = this.generateFind(ded.getDest().getComponent());
                ded.getDest().populate(dst);
                dst.setAttribute("refid", destId);
                e2.appendChild(dst);
            }
            if (ded.getPoints() != null) {
                Point[] p = ded.getPoints();
                for (int i = 0; i < p.length; ++i) {
                    Element pnt = this.m_doc.createElement("point");
                    String ref = "" + p[i].x + "," + p[i].y;
                    pnt.setAttribute("reference", ref);
                    e2.appendChild(pnt);
                }
            }
            this.insertNode(e2);
        } else if (evtData instanceof MouseWheelEventData) {
            Element e3 = this.m_doc.createElement("wheel");
            String source2 = this.generateFind(evtData.getComponent());
            e3.setAttribute("refid", source2);
            evtData.populate(e3);
            this.insertNode(e3);
        } else if (evtData instanceof AbstractKeyEventData) {
            source = this.generateFind(evtData.getComponent());
            e = this.m_doc.createElement("key");
            e.setAttribute("refid", source);
            evtData.populate(e);
            this.insertNode(e);
        } else if (evtData instanceof AbstractEventData) {
            source = this.generateFind(evtData.getComponent());
            e = this.m_doc.createElement("click");
            e.setAttribute("refid", source);
            evtData.populate(e);
            this.insertNode(e);
        }
    }

    public void processElement() throws XMLException {
        this.validateElement();
        if (s_replay) {
            return;
        }
        this.record();
        this.pause();
        super.processElement();
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("record");
    }

    protected JFCKeyStroke[] getDefaultTerminator() {
        return TestHelper.getKeyMapping().getKeyStrokes(4);
    }

    private int getComponentIndex() {
        if (this.m_compIndex == -1) {
            int max = 0;
            String[] names = this.getXMLTestCase().getPropertyNames();
            for (int i = 0; i < names.length; ++i) {
                int j;
                for (j = names[i].length() - 1; Character.isDigit(names[i].charAt(j)) && j > 0; --j) {
                }
                if (j >= names[i].length() - 1) continue;
                int number = Integer.parseInt(names[i].substring(j + 1));
                max = Math.max(max, number);
            }
            this.m_compIndex = max + 1;
        }
        return this.m_compIndex++;
    }

    private String generateMenuFind(Component comp) {
        JMenuItem mi = (JMenuItem)comp;
        String label = mi.getText();
        String containerID = null;
        Container parent = mi.getParent();
        if (parent instanceof JPopupMenu) {
            JPopupMenu menu = (JPopupMenu)mi.getParent();
            Component invoker = menu.getInvoker();
            if (invoker instanceof JMenuItem) {
                containerID = this.generateFind(invoker);
                MouseEventData data = new MouseEventData(null, invoker, 0);
                data.setNumberOfClicks(0);
                data.setModifiers(0);
                Element e = this.m_doc.createElement("click");
                e.setAttribute("refid", containerID);
                data.populate(e);
                this.insertNode(e);
                if (invoker instanceof JMenu) {
                    Point popupLoc = ((JMenu)invoker).getPopupMenu().getLocation();
                    Point invokerLoc = invoker.getLocation();
                    int xPercent = 110;
                    if (popupLoc.x < invokerLoc.x) {
                        xPercent = -10;
                    }
                    data.setPosition(13);
                    data.setReferencePoint(new Point(xPercent, 50));
                    Element moveRight = this.m_doc.createElement("click");
                    moveRight.setAttribute("refid", containerID);
                    data.populate(moveRight);
                    this.insertNode(moveRight);
                }
                Element sleep = this.m_doc.createElement("sleep");
                sleep.setAttribute("duration", "500");
                this.insertNode(sleep);
            }
        } else {
            Window w = SwingUtilities.getWindowAncestor(comp);
            containerID = this.generateWindowFind(w);
        }
        String name = "MenuItem" + this.getComponentIndex();
        String className = comp.getClass().getName();
        String named = comp.getName();
        String finderName = "JMenuItemFinder";
        JMenuItemFinder finder = new JMenuItemFinder(label);
        finder.setOperation(3);
        int index = TestHelper.indexOf(finder, null, comp);
        if (index == -1) {
            index = 0;
        }
        Element e = this.m_doc.createElement("find");
        if (containerID != null) {
            e.setAttribute("container", containerID);
        }
        e.setAttribute("finder", finderName);
        e.setAttribute("id", name);
        e.setAttribute("label", label);
        e.setAttribute("index", Integer.toString(index));
        e.setAttribute("operation", Operator.Operation.toString(3));
        this.insertNode(e);
        this.getXMLTestCase().addProperty(name, comp);
        return name;
    }

    private String generateWindowFind(Component w) {
        String name = this.getXMLTestCase().getPropertyName(w);
        String finder = null;
        String title = null;
        if (name != null) {
            return name;
        }
        if (w instanceof JFrame) {
            name = "JFrame" + this.getComponentIndex();
            title = ((JFrame)w).getTitle();
            finder = "FrameFinder";
        } else if (w instanceof JDialog) {
            name = "JDialog" + this.getComponentIndex();
            title = ((JDialog)w).getTitle();
            finder = "DialogFinder";
        }
        if (title == null) {
            title = "";
        }
        if (name != null) {
            this.getXMLTestCase().addProperty(name, w);
            Element find = this.m_doc.createElement("find");
            find.setAttribute("finder", finder);
            find.setAttribute("title", title);
            String operation = Operator.Operation.toString(3);
            find.setAttribute("operation", operation);
            find.setAttribute("id", name);
            find.setAttribute("index", "0");
            this.insertNode(find);
        }
        return name;
    }

    private void insertNode(Node e) {
        Node parent = this.getElement().getParentNode();
        parent.insertBefore(e, this.getElement());
        Text text = this.m_doc.createTextNode(this.m_indent);
        parent.insertBefore(text, this.getElement());
    }

    private void pause() {
        this.m_paused = true;
        while (this.m_paused) {
            try {
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void record() {
        JFCKeyStroke[] strokes = this.getTerminator();
        System.err.println("Start recording for test: " + this.getTestCase().getName());
        System.err.println("Press " + strokes[0].toString() + " to complete the recording.");
        Comment comment = this.m_doc.createComment("started recording " + new Date().toString());
        this.insertNode(comment);
        JFCEventManager.setRecording(true);
        JFCEventManager.getEventManager().addJFCEventDataListener(this);
        ((JFCXMLTestCase)this.getTestCase()).flushAWT();
    }

    private void stop() {
        JFCEventManager.getEventManager().removeJFCEventDataListener(this);
        JFCEventManager.setRecording(false);
        this.m_paused = false;
    }
}

