/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.finder;

import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.Arrays;
import javax.swing.Icon;

public class IconMatcher {
    private Icon m_icon = null;
    private int[] m_iconData = null;
    private int m_ich = 0;
    private int m_icw = 0;
    private int m_incr = 1;
    private int m_size = 0;

    public IconMatcher(Icon icon) throws InterruptedException {
        this.setIcon(icon);
    }

    public final void setIcon(Icon icon) throws InterruptedException {
        this.m_icon = icon;
        if (icon != null) {
            this.m_iconData = this.iconToArray(icon);
            this.m_icw = icon.getIconWidth();
            this.m_ich = icon.getIconHeight();
            this.m_size = this.m_icw * this.m_ich;
            int min = Math.min(this.m_icw, this.m_ich);
            this.m_incr = min > 32 ? min / 8 : min / 4;
        }
    }

    public final Icon getIcon() {
        return this.m_icon;
    }

    public boolean matches(Icon other) {
        if (this.m_icon == null) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.m_icw != other.getIconWidth() || this.m_ich != other.getIconHeight()) {
            return false;
        }
        int[] otherData = null;
        try {
            otherData = this.iconToArray(other);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (otherData == null || this.m_iconData.length != otherData.length) {
            return false;
        }
        for (int i = 0; i < this.m_size; i += this.m_incr) {
            if (this.m_iconData[i] == otherData[i]) continue;
            return false;
        }
        return Arrays.equals(this.m_iconData, otherData);
    }

    private int[] iconToArray(Icon icon) throws InterruptedException {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        if (width < 0) {
            width = 1;
        }
        if (height < 0) {
            height = 1;
        }
        int[] array = new int[width * height];
        BufferedImage bf = new BufferedImage(width, height, 2);
        icon.paintIcon(null, bf.getGraphics(), 0, 0);
        PixelGrabber grab = new PixelGrabber(bf, 0, 0, width, height, array, 0, width);
        grab.grabPixels();
        return array;
    }
}

