/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.finder;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import junit.extensions.jfcunit.RobotTestHelper;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.WindowMonitor;
import junit.extensions.jfcunit.eventdata.MouseEventData;
import junit.extensions.jfcunit.finder.AbstractWindowFinder;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class Finder {
    private static RobotTestHelper s_robot = null;
    private static boolean s_robotException = false;
    private static final String[] OP_CODE_STRINGS = new String[]{"match", "startswith", "endswith", "equals", "contains"};
    public static final int OP_MATCH = 0;
    public static final int OP_STARTSWITH = 1;
    public static final int OP_ENDSWITH = 2;
    public static final int OP_EQUALS = 3;
    public static final int OP_CONTAINS = 4;
    private RE m_patternMatcher;
    private boolean m_caseIndependent = false;
    private boolean m_debug = false;
    private boolean m_ignoreVisiblity = false;
    private boolean m_showDebug = false;
    private int m_operation = 0;
    private int m_wait = 30;

    public static final int getOperation(String code) {
        for (int i = 0; i < OP_CODE_STRINGS.length; ++i) {
            if (!OP_CODE_STRINGS[i].equalsIgnoreCase(code)) continue;
            return i;
        }
        throw new IllegalArgumentException("Operation not found:" + code);
    }

    public static final String getOperationString(int code) {
        if (code < 0 || code >= OP_CODE_STRINGS.length) {
            throw new IllegalArgumentException("Invalid Operation code:" + code);
        }
        return OP_CODE_STRINGS[code];
    }

    public final boolean getDebug() {
        return this.m_debug;
    }

    public final void setOperation(int operation) {
        this.m_operation = operation;
    }

    public final int getOperation() {
        return this.m_operation;
    }

    public final void setShowDebug(boolean value) {
        if (value && s_robot == null && !s_robotException) {
            try {
                s_robot = new RobotTestHelper();
            }
            catch (AWTException ex) {
                System.err.println("Could not create robot:");
                ex.printStackTrace();
                s_robotException = true;
            }
        }
        this.m_showDebug = value;
    }

    public final boolean getShowDebug() {
        return this.m_showDebug;
    }

    public final void setWait(int wait) {
        this.m_wait = wait;
    }

    public final int getWait() {
        return this.m_wait;
    }

    public final boolean evaluate(String leftside, String rightside) {
        if (leftside == null) {
            return rightside == null;
        }
        if (rightside == null) {
            return false;
        }
        if (this.m_operation == 4) {
            return leftside.indexOf(rightside) >= 0;
        }
        if (this.m_operation == 2) {
            return leftside.endsWith(rightside);
        }
        if (this.m_operation == 1) {
            return leftside.startsWith(rightside);
        }
        if (this.m_operation == 3) {
            return leftside.equals(rightside);
        }
        if (this.m_operation == 0) {
            return this.matchPattern(leftside, rightside);
        }
        throw new IllegalStateException("Invalid operation for finder:" + this.m_operation);
    }

    public void setCaseIndependent(boolean ignoreCase) {
        this.m_caseIndependent = ignoreCase;
    }

    public boolean isCaseIndependent() {
        return this.m_caseIndependent;
    }

    public final void setDebug(boolean value) {
        if (value && s_robot == null && !s_robotException) {
            try {
                s_robot = new RobotTestHelper();
            }
            catch (AWTException ex) {
                System.err.println("Could not create robot:");
                ex.printStackTrace();
                s_robotException = true;
            }
        }
        this.m_debug = value;
    }

    public final void setIgnoreVisibility(boolean value) {
        this.m_ignoreVisiblity = value;
    }

    public abstract boolean testComponent(Component var1);

    protected Component find(Container[] conts, int index) {
        long abortAfter = System.currentTimeMillis() + (long)(this.getWait() * 1000);
        Container[] search = null;
        do {
            int idx = 0;
            search = conts == null ? WindowMonitor.getWindows() : conts;
            if (this instanceof AbstractWindowFinder) {
                Object[] all = ((AbstractWindowFinder)this).findAll().toArray();
                if (all.length <= index) continue;
                return (Component)all[index];
            }
            for (int window = 0; window < search.length; ++window) {
                List comps = Finder.findComponentList(this, search[window], new ArrayList(), index - idx);
                int size = comps.size();
                if (size > 0 && size > index - idx) {
                    Component comp = (Component)comps.get(index - idx);
                    return comp;
                }
                idx += comps.size();
            }
            this.pause(abortAfter);
        } while (System.currentTimeMillis() < abortAfter);
        return null;
    }

    public final Component find(int index) {
        return this.find((Container[])null, index);
    }

    public Component find(Container cont, int index) {
        return this.find(new Container[]{cont}, index);
    }

    public final Component find() {
        return this.find(0);
    }

    public List findAll() {
        return this.findAll((Container[])null);
    }

    public List findAll(Container cont) {
        return this.findAll(new Container[]{cont});
    }

    public List findAll(Container[] cont) {
        return this.findAll(cont, new ArrayList());
    }

    protected List findAll(Container[] cont, List results) {
        Container[] containers = cont;
        if (containers == null) {
            containers = WindowMonitor.getWindows();
        }
        for (int i = 0; i < containers.length; ++i) {
            Finder.findComponentList(this, containers[i], results, Integer.MAX_VALUE);
        }
        return results;
    }

    public static final List findComponentList(Finder finder, Container cont, List pList, int index) {
        ArrayList<Component> outList = pList;
        if (outList == null) {
            outList = new ArrayList<Component>();
        }
        if (cont == null || finder == null) {
            return outList;
        }
        Component[] children = cont.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (finder.testComponent(children[i])) {
                if (finder.getDebug()) {
                    System.err.println("Finder Candidate(" + outList.size() + ") " + children[i].getClass().getName());
                }
                if (finder.getShowDebug() && s_robot != null) {
                    try {
                        s_robot.enterClickAndLeave(new MouseEventData(TestHelper.getCurrentTestCase(), children[i], 0, 0, false));
                        JOptionPane.showMessageDialog(null, "<HTML><BODY>Finder Candidate Index:" + outList.size() + "<p>" + children[i].getClass().getName() + "</BODY></HTML>");
                    }
                    catch (Exception ae) {
                        ae.printStackTrace();
                    }
                }
                if (!outList.contains(children[i])) {
                    outList.add(children[i]);
                }
                if (outList.size() <= index) continue;
                return outList;
            }
            if (!(children[i] instanceof Container)) continue;
            Finder.findComponentList(finder, (Container)children[i], outList, index);
            if (outList.size() <= index) continue;
            return outList;
        }
        return outList;
    }

    protected final boolean isValidForProcessing(Component comp, Class cls) {
        boolean value = comp != null && cls != null && cls.isInstance(comp) && (this.m_ignoreVisiblity || comp.isShowing());
        return value;
    }

    protected void createPatternMatcher(String patternString, boolean caseIndependent) {
        if (this.m_patternMatcher == null) {
            try {
                this.m_patternMatcher = patternString != null ? new RE(patternString) : new RE("");
                if (caseIndependent) {
                    this.m_patternMatcher.setMatchFlags(1);
                }
            }
            catch (RESyntaxException e) {
                this.m_patternMatcher = null;
            }
        }
    }

    protected boolean matchPattern(String componentAttribute, String patternString, boolean caseIndependent) {
        this.createPatternMatcher(patternString, caseIndependent);
        return this.matchPattern(componentAttribute, patternString);
    }

    protected boolean matchPattern(String componentAttribute, String patternString) {
        return this.matchPattern(componentAttribute, patternString, this.m_patternMatcher);
    }

    protected final boolean matchPattern(String componentAttribute, String patternString, RE re) {
        if (patternString == null) {
            return componentAttribute == null;
        }
        return componentAttribute != null && re != null && re.match(componentAttribute);
    }

    protected final void pause(long date) {
        int sleep = 1000;
        if (System.currentTimeMillis() + 3000L < date) {
            sleep = 3000;
        }
        try {
            Thread.currentThread();
            Thread.sleep(sleep);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }
}

