/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.Component;
import java.util.StringTokenizer;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.eventdata.KeyEventData;
import junit.extensions.jfcunit.eventdata.StringEventData;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;

public class KeyTagHandler
extends AbstractTagHandler
implements JFCXMLConstants {
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public KeyTagHandler(Element element, IXMLTestCase testCase) {
        super(element, testCase);
    }

    public void processElement() throws XMLException {
        this.validateElement();
        String refid = this.getRefId();
        Component comp = (Component)this.getXMLTestCase().getProperty(refid);
        if (comp == null) {
            throw new XMLException("Component not found for:" + refid, null, this.getElement(), this.getXMLTestCase().getPropertyCache());
        }
        int modifiers = this.getModifiers();
        long sleepTime = this.getSleepTime();
        String string = this.getString("string");
        AbstractKeyEventData data = null;
        if (string != null) {
            data = new StringEventData((JFCTestCase)this.getTestCase(), comp, string, modifiers, sleepTime);
        } else {
            int character = this.getCharacter();
            data = new KeyEventData((JFCTestCase)this.getTestCase(), comp, character, modifiers, sleepTime);
        }
        ((JFCTestCase)this.getTestCase()).getHelper().sendString(data);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("refid");
        this.checkOneRequiredAttribute(this.getElement(), new String[]{"code", "string"});
    }

    protected int getModifiers(int defaultValue) {
        int modifiers = 0;
        String s = this.getString("modifiers");
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            StringTokenizer tok = new StringTokenizer(s, "+");
            while (tok.hasMoreElements()) {
                String token = tok.nextToken();
                if (token.equalsIgnoreCase(JFCXMLConstants.SHIFT)) {
                    ++modifiers;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.CTRL)) {
                    modifiers += 2;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.ALT)) {
                    modifiers += 8;
                }
                if (token.equalsIgnoreCase(JFCXMLConstants.ALTGR)) {
                    modifiers += 32;
                }
                if (!token.equalsIgnoreCase(JFCXMLConstants.META)) continue;
                modifiers += 4;
            }
            return modifiers;
        }
    }

    protected long getSleepTime() {
        return this.getLong("sleeptime", 300L);
    }

    private int getCharacter() {
        String keyCodeStr = this.getString("code");
        try {
            Object code = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = KeyTagHandler.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField(keyCodeStr).get(null);
            return (Integer)code;
        }
        catch (Exception exception) {
            return Integer.parseInt(keyCodeStr);
        }
    }

    private int getModifiers() {
        return this.getModifiers(0);
    }

    private String getRefId() {
        return this.getString("refid");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

