/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.MouseEventData;
import junit.extensions.jfcunit.eventdata.PathData;
import org.w3c.dom.Element;

public class JMenuMouseEventData
extends AbstractMouseEventData {
    private JComponent m_menu;
    private int[] m_elementIndexes;

    public JMenuMouseEventData() {
        this.setValid(false);
    }

    public JMenuMouseEventData(JFCTestCase testCase, JComponent menu, int[] elementIndexes) {
        this(testCase, menu, elementIndexes, 1, 16, false, 300L);
        this.setValid(true);
    }

    public JMenuMouseEventData(JFCTestCase testCase, JComponent menu, int[] elementIndexes, int numberOfClicks, int modifiers, boolean isPopupTrigger, long sleepTime) {
        this.setTestCase(testCase);
        this.setSource(menu);
        this.setNumberOfClicks(numberOfClicks);
        this.setModifiers(modifiers);
        this.setPopupTrigger(isPopupTrigger);
        this.setElementIndexes(elementIndexes);
        this.setSleepTime(sleepTime);
        this.setValid(true);
    }

    public void setSource(JComponent menu) {
        this.m_menu = menu;
    }

    public final JComponent getSource() {
        return this.m_menu;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public final void setElementIndexes(int[] elementIndexes) {
        this.m_elementIndexes = elementIndexes;
    }

    public final int[] getElementIndexes() {
        return this.m_elementIndexes;
    }

    public boolean canConsume(AWTEvent ae) {
        Object source = ae.getSource();
        return super.canConsume(ae) && (source instanceof JMenuItem || source instanceof JPopupMenu || source instanceof JMenuBar);
    }

    public boolean consume(AWTEvent ae) {
        Object source = ae.getSource();
        if (source instanceof JMenu) {
            return true;
        }
        if (super.consume(ae)) {
            return true;
        }
        JMenuItem item = (JMenuItem)source;
        PathData data = new PathData(item);
        Object root = data.getRoot(item);
        if (root instanceof JMenuBar) {
            JMenuBar bar = (JMenuBar)root;
            this.setSource(bar);
            this.setElementIndexes(data.getIndexes(bar));
        } else if (root instanceof JPopupMenu) {
            JPopupMenu popup = (JPopupMenu)root;
            this.setSource(popup);
            this.setElementIndexes(data.getIndexes(popup));
        }
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setSleepTime(this.getDefaultSleepTime());
        this.setValid(true);
        return true;
    }

    public boolean equals(Object o) {
        if (!(o instanceof JMenuMouseEventData)) {
            return false;
        }
        JMenuMouseEventData data = (JMenuMouseEventData)o;
        return super.equals(o) && data.getSource() == this.getSource() && data.getElementIndexes() == this.getElementIndexes();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void populate(Element e) {
        super.populate(e);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.m_elementIndexes.length; ++i) {
            buf.append(this.m_elementIndexes[i]);
            buf.append(",");
        }
        buf.setLength(buf.length() - 1);
        e.setAttribute("indexes", buf.toString());
        e.setAttribute("type", "JMenuMouseEventData");
    }

    public boolean prepareComponent() {
        JFCTestCase tc = this.getTestCase();
        TestHelper th = tc.getHelper();
        tc.resumeAWT();
        JComponent m = this.m_menu;
        Component comp = m.getComponent(this.m_elementIndexes[0]);
        th.enterClickAndLeave(new MouseEventData(tc, comp, 1));
        for (int i = 1; i < this.m_elementIndexes.length; ++i) {
            if (!(comp instanceof JMenu)) continue;
            JMenu menu = (JMenu)comp;
            comp = menu.getMenuComponent(this.m_elementIndexes[i]);
            th.enterClickAndLeave(new MouseEventData(this.getTestCase(), comp, 0, 0));
            tc.flushAWT();
            if (i == this.m_elementIndexes.length - 1) continue;
            JPopupMenu pm = menu.getPopupMenu();
            int popupLeft = pm.getLocationOnScreen().x;
            int popupRight = popupLeft + pm.getSize().width;
            int popupTop = pm.getLocationOnScreen().y;
            int popupBottom = popupTop + pm.getSize().height;
            int left = menu.getLocationOnScreen().x;
            int right = left + menu.getSize().width;
            int top = menu.getLocationOnScreen().y;
            int bottom = top + menu.getSize().height;
            if (right < popupRight) {
                th.enterClickAndLeave(new MouseEventData(this.getTestCase(), comp, 0, 0, false, 0L, 3));
                continue;
            }
            if (popupLeft < left) {
                th.enterClickAndLeave(new MouseEventData(this.getTestCase(), comp, 0, 0, false, 0L, 7));
                continue;
            }
            if (top < popupTop) {
                th.enterClickAndLeave(new MouseEventData(this.getTestCase(), comp, 0, 0, false, 0L, 5));
                continue;
            }
            if (popupBottom >= bottom) continue;
            th.enterClickAndLeave(new MouseEventData(this.getTestCase(), comp, 0, 0, false, 0L, 1));
        }
        th.enterClickAndLeave(new MouseEventData(this.getTestCase(), comp));
        this.getTestCase().pauseAWT();
        return false;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer buf = new StringBuffer(1000);
        buf.append(super.toString());
        buf.append(" index: " + this.getElementIndexes());
        return buf.toString();
    }
}

