/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.repackage.cglib.asm.attrs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.repackage.cglib.asm.ByteVector;
import org.hibernate.repackage.cglib.asm.ClassReader;
import org.hibernate.repackage.cglib.asm.ClassWriter;
import org.hibernate.repackage.cglib.asm.Label;
import org.hibernate.repackage.cglib.asm.attrs.StackMapType;

public class StackMapFrame {
    public Label label;
    public List locals = new ArrayList();
    public List stack = new ArrayList();

    public int read(ClassReader classReader, int n, char[] cArray, int n2, Label[] labelArray) {
        int n3 = classReader.readUnsignedShort(n);
        n += 2;
        if (labelArray[n3] == null) {
            labelArray[n3] = new Label();
        }
        this.label = labelArray[n3];
        n = this.readTypeInfo(classReader, n, this.locals, labelArray, cArray, classReader.readUnsignedShort(n2 + 2));
        n = this.readTypeInfo(classReader, n, this.stack, labelArray, cArray, classReader.readUnsignedShort(n2));
        return n;
    }

    public void write(ClassWriter classWriter, int n, int n2, ByteVector byteVector) {
        byteVector.putShort(this.label.getOffset());
        this.writeTypeInfo(byteVector, classWriter, this.locals, n2);
        this.writeTypeInfo(byteVector, classWriter, this.stack, n);
    }

    public void getLabels(Set set) {
        set.add(this.label);
        this.getTypeInfoLabels(set, this.locals);
        this.getTypeInfoLabels(set, this.stack);
    }

    private void getTypeInfoLabels(Set set, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StackMapType stackMapType = (StackMapType)iterator.next();
            if (stackMapType.getType() != 8) continue;
            set.add(stackMapType.getLabel());
        }
    }

    private int readTypeInfo(ClassReader classReader, int n, List list, Label[] labelArray, char[] cArray, int n2) {
        int n3 = 0;
        if (n2 > 65535) {
            n3 = classReader.readInt(n);
            n += 4;
        } else {
            n3 = classReader.readUnsignedShort(n);
            n += 2;
        }
        block4: for (int i = 0; i < n3; ++i) {
            int n4 = classReader.readByte(n++);
            StackMapType stackMapType = StackMapType.getTypeInfo(n4);
            list.add(stackMapType);
            switch (n4) {
                case 7: {
                    stackMapType.setObject(classReader.readClass(n, cArray));
                    n += 2;
                    continue block4;
                }
                case 8: {
                    int n5 = classReader.readUnsignedShort(n);
                    n += 2;
                    if (labelArray[n5] == null) {
                        labelArray[n5] = new Label();
                    }
                    stackMapType.setLabel(labelArray[n5]);
                }
            }
        }
        return n;
    }

    private void writeTypeInfo(ByteVector byteVector, ClassWriter classWriter, List list, int n) {
        if (n > 65535) {
            byteVector.putInt(list.size());
        } else {
            byteVector.putShort(list.size());
        }
        block4: for (int i = 0; i < list.size(); ++i) {
            StackMapType stackMapType = (StackMapType)list.get(i);
            byteVector.putByte(stackMapType.getType());
            switch (stackMapType.getType()) {
                case 7: {
                    byteVector.putShort(classWriter.newClass(stackMapType.getObject()));
                    continue block4;
                }
                case 8: {
                    byteVector.putShort(stackMapType.getLabel().getOffset());
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Frame:L");
        stringBuffer.append(System.identityHashCode(this.label));
        stringBuffer.append(" locals").append(this.locals);
        stringBuffer.append(" stack").append(this.stack);
        return stringBuffer.toString();
    }
}

