/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.event.AutoFlushEvent;
import org.hibernate.event.AutoFlushEventListener;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.AbstractFlushingEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAutoFlushEventListener
extends AbstractFlushingEventListener
implements AutoFlushEventListener {
    private static final Logger log = LoggerFactory.getLogger((Class)DefaultAutoFlushEventListener.class);

    public void onAutoFlush(AutoFlushEvent event) throws HibernateException {
        EventSource source = event.getSession();
        if (this.flushMightBeNeeded(source)) {
            int oldSize = source.getActionQueue().numberOfCollectionRemovals();
            this.flushEverythingToExecutions(event);
            if (this.flushIsReallyNeeded(event, source)) {
                log.trace("Need to execute flush");
                this.performExecutions(source);
                this.postFlush(source);
                if (source.getFactory().getStatistics().isStatisticsEnabled()) {
                    source.getFactory().getStatisticsImplementor().flush();
                }
            } else {
                log.trace("Dont need to execute flush");
                source.getActionQueue().clearFromFlushNeededCheck(oldSize);
            }
            event.setFlushRequired(this.flushIsReallyNeeded(event, source));
        }
    }

    private boolean flushIsReallyNeeded(AutoFlushEvent event, EventSource source) {
        return source.getActionQueue().areTablesToBeUpdated(event.getQuerySpaces()) || source.getFlushMode() == FlushMode.ALWAYS;
    }

    private boolean flushMightBeNeeded(EventSource source) {
        return !source.getFlushMode().lessThan(FlushMode.AUTO) && source.getDontFlushFromFind() == 0 && source.getPersistenceContext().hasNonReadOnlyEntities();
    }
}

