/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.parser;

import com.codestreet.selector.parser.IExpression;
import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.NumericValue;
import com.codestreet.selector.parser.Result;
import java.util.Map;

abstract class ArithOpImpl {
    public static final ArithOpImpl PLUS = new ArithOpImpl("+"){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (!(oLhs instanceof Number)) {
                return Result.RESULT_UNKNOWN;
            }
            Number lhsVal = (Number)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (!(oRhs instanceof Number)) {
                return Result.RESULT_UNKNOWN;
            }
            Number rhsVal = (Number)oRhs;
            return new NumericValue(new Double(lhsVal.doubleValue() + rhsVal.doubleValue()));
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue lhsVal = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(lhsVal.doubleValue() + rhsVal.doubleValue()));
        }
    };
    public static final ArithOpImpl MINUS = new ArithOpImpl("-"){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue lhsVal = (NumericValue)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(lhsVal.doubleValue() - rhsVal.doubleValue()));
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue lhsVal = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(lhsVal.doubleValue() - rhsVal.doubleValue()));
        }
    };
    public static final ArithOpImpl MULT = new ArithOpImpl("*"){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue lhsVal = (NumericValue)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(lhsVal.doubleValue() * rhsVal.doubleValue()));
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue lhsVal = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(lhsVal.doubleValue() * rhsVal.doubleValue()));
        }
    };
    public static final ArithOpImpl DIV = new ArithOpImpl("/"){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(identifiers);
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue lhsVal = (NumericValue)oLhs;
            Object oRhs = rhs.eval(identifiers);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(lhsVal.doubleValue() / rhsVal.doubleValue()));
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oLhs = lhs.eval(provider, corr);
            if (!(oLhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue lhsVal = (NumericValue)oLhs;
            Object oRhs = rhs.eval(provider, corr);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(lhsVal.doubleValue() / rhsVal.doubleValue()));
        }
    };
    public static final ArithOpImpl NEG = new ArithOpImpl("-"){

        public Object eval(Map identifiers, IExpression lhs, IExpression rhs) {
            Object oRhs = rhs.eval(identifiers);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(-rhsVal.doubleValue()));
        }

        public Object eval(IValueProvider provider, Object corr, IExpression lhs, IExpression rhs) {
            Object oRhs = rhs.eval(provider, corr);
            if (!(oRhs instanceof NumericValue)) {
                return Result.RESULT_UNKNOWN;
            }
            NumericValue rhsVal = (NumericValue)oRhs;
            return new NumericValue(new Double(-rhsVal.doubleValue()));
        }
    };
    private final String operator_;

    private ArithOpImpl(String operator) {
        this.operator_ = operator;
    }

    public String toString() {
        return this.operator_;
    }

    public abstract Object eval(Map var1, IExpression var2, IExpression var3);

    public abstract Object eval(IValueProvider var1, Object var2, IExpression var3, IExpression var4);
}

