/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

class URLTemplateSource {
    private final URL url;
    private URLConnection conn;
    private InputStream inputStream;

    URLTemplateSource(URL url) throws IOException {
        this.url = url;
        this.conn = url.openConnection();
    }

    public boolean equals(Object o) {
        if (o instanceof URLTemplateSource) {
            return this.url.equals(((URLTemplateSource)o).url);
        }
        return false;
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url.toString();
    }

    long lastModified() {
        long lastModified = this.conn.getLastModified();
        if (lastModified == -1L && this.url.getProtocol().equals("file")) {
            return new File(this.url.getFile()).lastModified();
        }
        return lastModified;
    }

    InputStream getInputStream() throws IOException {
        this.inputStream = this.conn.getInputStream();
        return this.inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        finally {
            this.inputStream = null;
            this.conn = null;
        }
    }
}

