# ./pyxb/bundles/opengis/raw/_nsgroup.py
# PyXB bindings for NamespaceGroupModule
# NGM:31dc9d33ae09dae9cd9938ac948b7eee03f73812
# Incorporated namespaces:
#  http://www.isotc211.org/2005/gss gss
#  http://www.isotc211.org/2005/gco gco
#  http://www.isotc211.org/2005/gts gts
#  http://www.isotc211.org/2005/gmd gmd
#  http://www.opengis.net/gml/3.2 gml
#  http://www.isotc211.org/2005/gsr gsr

import pyxb
import pyxb.binding
import pyxb.utils.utility

# Unique identifier for bindings created at the same time
_GenerationUID = pyxb.utils.utility.UniqueIdentifier('urn:uuid:84943ba0-0c23-11df-a8f2-000c29370554')

# Import bindings for schemas in group
import pyxb.binding.datatypes
import pyxb.bundles.opengis.misc.xlinks

_Namespace_gml = pyxb.namespace.NamespaceForURI(u'http://www.opengis.net/gml/3.2', create_if_missing=True)
_Namespace_gml.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gmd = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gmd', create_if_missing=True)
_Namespace_gmd.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gco = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gco', create_if_missing=True)
_Namespace_gco.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_xlink = pyxb.namespace.NamespaceForURI(u'http://www.w3.org/1999/xlink', create_if_missing=True)
_Namespace_xlink.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gts = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gts', create_if_missing=True)
_Namespace_gts.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gss = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gss', create_if_missing=True)
_Namespace_gss.configureCategories(['typeBinding', 'elementBinding'])
_Namespace_gsr = pyxb.namespace.NamespaceForURI(u'http://www.isotc211.org/2005/gsr', create_if_missing=True)
_Namespace_gsr.configureCategories(['typeBinding', 'elementBinding'])

# Atomic SimpleTypeDefinition
class STD_ANON_1 (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_1._CF_pattern = pyxb.binding.facets.CF_pattern()
STD_ANON_1._CF_pattern.addPattern(pattern=u'other:\\w{2,}')
STD_ANON_1._InitializeFacetMap(STD_ANON_1._CF_pattern)

# Atomic SimpleTypeDefinition
class STD_ANON_2 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_2._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_2, enum_prefix=None)
STD_ANON_2.inapplicable = STD_ANON_2._CF_enumeration.addEnumeration(unicode_value=u'inapplicable')
STD_ANON_2.missing = STD_ANON_2._CF_enumeration.addEnumeration(unicode_value=u'missing')
STD_ANON_2.template = STD_ANON_2._CF_enumeration.addEnumeration(unicode_value=u'template')
STD_ANON_2.unknown = STD_ANON_2._CF_enumeration.addEnumeration(unicode_value=u'unknown')
STD_ANON_2.withheld = STD_ANON_2._CF_enumeration.addEnumeration(unicode_value=u'withheld')
STD_ANON_2._InitializeFacetMap(STD_ANON_2._CF_enumeration)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NilReasonType (pyxb.binding.basis.STD_union):

    """gml:NilReasonType defines a content model that allows recording of an explanation for a void value or other exception.
gml:NilReasonType is a union of the following enumerated values:
-	inapplicable there is no value
-	missing the correct value is not readily available to the sender of this data. Furthermore, a correct value may not exist
-	template the value will be available later
-	unknown the correct value is not known to, and not computable by, the sender of this data. However, a correct value probably exists
-	withheld the value is not divulged
-	other:text other brief explanation, where text is a string of two or more characters with no included spaces
and
-	anyURI which should refer to a resource which describes the reason for the exception
A particular community may choose to assign more detailed semantics to the standard values provided. Alternatively, the URI method enables a specific or more complete explanation for the absence of a value to be provided elsewhere and indicated by-reference in an instance document.
gml:NilReasonType is used as a member of a union in a number of simple content types where it is necessary to permit a value from the NilReasonType union as an alternative to the primary type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NilReasonType')
    _Documentation = u'gml:NilReasonType defines a content model that allows recording of an explanation for a void value or other exception.\ngml:NilReasonType is a union of the following enumerated values:\n-\tinapplicable there is no value\n-\tmissing the correct value is not readily available to the sender of this data. Furthermore, a correct value may not exist\n-\ttemplate the value will be available later\n-\tunknown the correct value is not known to, and not computable by, the sender of this data. However, a correct value probably exists\n-\twithheld the value is not divulged\n-\tother:text other brief explanation, where text is a string of two or more characters with no included spaces\nand\n-\tanyURI which should refer to a resource which describes the reason for the exception\nA particular community may choose to assign more detailed semantics to the standard values provided. Alternatively, the URI method enables a specific or more complete explanation for the absence of a value to be provided elsewhere and indicated by-reference in an instance document.\ngml:NilReasonType is used as a member of a union in a number of simple content types where it is necessary to permit a value from the NilReasonType union as an alternative to the primary type.'

    _MemberTypes = ( STD_ANON_2, STD_ANON_1, pyxb.binding.datatypes.anyURI, )
NilReasonType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NilReasonType)
NilReasonType._CF_pattern = pyxb.binding.facets.CF_pattern()
NilReasonType.inapplicable = u'inapplicable'      # originally STD_ANON_2.inapplicable
NilReasonType.missing = u'missing'                # originally STD_ANON_2.missing
NilReasonType.template = u'template'              # originally STD_ANON_2.template
NilReasonType.unknown = u'unknown'                # originally STD_ANON_2.unknown
NilReasonType.withheld = u'withheld'              # originally STD_ANON_2.withheld
NilReasonType._InitializeFacetMap(NilReasonType._CF_enumeration,
   NilReasonType._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'NilReasonType', NilReasonType)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NCNameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NCNameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.NCName
NCNameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NCNameList', NCNameList)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.double
doubleList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'doubleList', doubleList)

# Atomic SimpleTypeDefinition
class AggregationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AggregationType')
    _Documentation = None
AggregationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=AggregationType, enum_prefix=None)
AggregationType.set = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'set')
AggregationType.bag = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'bag')
AggregationType.sequence = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'sequence')
AggregationType.array = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'array')
AggregationType.record = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'record')
AggregationType.table = AggregationType._CF_enumeration.addEnumeration(unicode_value=u'table')
AggregationType._InitializeFacetMap(AggregationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'AggregationType', AggregationType)

# Atomic SimpleTypeDefinition
class SignType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:SignType is a convenience type with values "+" (plus) and "-" (minus)."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SignType')
    _Documentation = u'gml:SignType is a convenience type with values "+" (plus) and "-" (minus).'
SignType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SignType, enum_prefix=None)
SignType.emptyString = SignType._CF_enumeration.addEnumeration(unicode_value=u'-')
SignType.emptyString_ = SignType._CF_enumeration.addEnumeration(unicode_value=u'+')
SignType._InitializeFacetMap(SignType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SignType', SignType)

# Atomic SimpleTypeDefinition
class STD_ANON_3 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_3._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_3, enum_prefix=None)
STD_ANON_3.year = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'year')
STD_ANON_3.month = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'month')
STD_ANON_3.day = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'day')
STD_ANON_3.hour = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'hour')
STD_ANON_3.minute = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'minute')
STD_ANON_3.second = STD_ANON_3._CF_enumeration.addEnumeration(unicode_value=u'second')
STD_ANON_3._InitializeFacetMap(STD_ANON_3._CF_enumeration)

# Atomic SimpleTypeDefinition
class STD_ANON_4 (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_4._CF_pattern = pyxb.binding.facets.CF_pattern()
STD_ANON_4._CF_pattern.addPattern(pattern=u'other:\\w{2,}')
STD_ANON_4._InitializeFacetMap(STD_ANON_4._CF_pattern)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class TimeUnitType (pyxb.binding.basis.STD_union):

    """Simple type that is a union of STD_ANON_3, STD_ANON_4."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeUnitType')
    _Documentation = None

    _MemberTypes = ( STD_ANON_3, STD_ANON_4, )
TimeUnitType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimeUnitType)
TimeUnitType._CF_pattern = pyxb.binding.facets.CF_pattern()
TimeUnitType.year = u'year'                       # originally STD_ANON_3.year
TimeUnitType.month = u'month'                     # originally STD_ANON_3.month
TimeUnitType.day = u'day'                         # originally STD_ANON_3.day
TimeUnitType.hour = u'hour'                       # originally STD_ANON_3.hour
TimeUnitType.minute = u'minute'                   # originally STD_ANON_3.minute
TimeUnitType.second = u'second'                   # originally STD_ANON_3.second
TimeUnitType._InitializeFacetMap(TimeUnitType._CF_enumeration,
   TimeUnitType._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'TimeUnitType', TimeUnitType)

# Atomic SimpleTypeDefinition
class MD_TopicCategoryCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """High-level geospatial data thematic classification to assist in the grouping and search of available geospatial datasets"""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_TopicCategoryCode_Type')
    _Documentation = u'High-level geospatial data thematic classification to assist in the grouping and search of available geospatial datasets'
MD_TopicCategoryCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_TopicCategoryCode_Type, enum_prefix=None)
MD_TopicCategoryCode_Type.farming = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'farming')
MD_TopicCategoryCode_Type.biota = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'biota')
MD_TopicCategoryCode_Type.boundaries = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'boundaries')
MD_TopicCategoryCode_Type.climatologyMeteorologyAtmosphere = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'climatologyMeteorologyAtmosphere')
MD_TopicCategoryCode_Type.economy = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'economy')
MD_TopicCategoryCode_Type.elevation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'elevation')
MD_TopicCategoryCode_Type.environment = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'environment')
MD_TopicCategoryCode_Type.geoscientificInformation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'geoscientificInformation')
MD_TopicCategoryCode_Type.health = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'health')
MD_TopicCategoryCode_Type.imageryBaseMapsEarthCover = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'imageryBaseMapsEarthCover')
MD_TopicCategoryCode_Type.intelligenceMilitary = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'intelligenceMilitary')
MD_TopicCategoryCode_Type.inlandWaters = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'inlandWaters')
MD_TopicCategoryCode_Type.location = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'location')
MD_TopicCategoryCode_Type.oceans = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'oceans')
MD_TopicCategoryCode_Type.planningCadastre = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'planningCadastre')
MD_TopicCategoryCode_Type.society = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'society')
MD_TopicCategoryCode_Type.structure = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'structure')
MD_TopicCategoryCode_Type.transportation = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'transportation')
MD_TopicCategoryCode_Type.utilitiesCommunication = MD_TopicCategoryCode_Type._CF_enumeration.addEnumeration(unicode_value=u'utilitiesCommunication')
MD_TopicCategoryCode_Type._InitializeFacetMap(MD_TopicCategoryCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_TopicCategoryCode_Type', MD_TopicCategoryCode_Type)

# Atomic SimpleTypeDefinition
class UomURI (pyxb.binding.datatypes.anyURI):

    """This type specifies a URI, restricted such that it must start with one of the following sequences: "#", "./", "../", or a string of characters followed by a ":". These patterns ensure that the most common URI forms are supported, including absolute and relative URIs and URIs that are simple fragment identifiers, but prohibits certain forms of relative URI that could be mistaken for unit of measure symbol . 
NOTE	It is possible to re-write such a relative URI to conform to the restriction (e.g. "./m/s").
In an instance document, on elements of type gml:MeasureType the mandatory uom attribute shall carry a value corresponding to either 
-	a conventional unit of measure symbol,
-	a link to a definition of a unit of measure that does not have a conventional symbol, or when it is desired to indicate a precise or variant definition."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomURI')
    _Documentation = u'This type specifies a URI, restricted such that it must start with one of the following sequences: "#", "./", "../", or a string of characters followed by a ":". These patterns ensure that the most common URI forms are supported, including absolute and relative URIs and URIs that are simple fragment identifiers, but prohibits certain forms of relative URI that could be mistaken for unit of measure symbol . \nNOTE\tIt is possible to re-write such a relative URI to conform to the restriction (e.g. "./m/s").\nIn an instance document, on elements of type gml:MeasureType the mandatory uom attribute shall carry a value corresponding to either \n-\ta conventional unit of measure symbol,\n-\ta link to a definition of a unit of measure that does not have a conventional symbol, or when it is desired to indicate a precise or variant definition.'
UomURI._CF_pattern = pyxb.binding.facets.CF_pattern()
UomURI._CF_pattern.addPattern(pattern=u'([a-zA-Z][a-zA-Z0-9\\-\\+\\.]*:|\\.\\./|\\./|#).*')
UomURI._InitializeFacetMap(UomURI._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'UomURI', UomURI)

# Atomic SimpleTypeDefinition
class UomSymbol (pyxb.binding.datatypes.string):

    """This type specifies a character string of length at least one, and restricted such that it must not contain any of the following characters: ":" (colon), " " (space), (newline), (carriage return), (tab). This allows values corresponding to familiar abbreviations, such as "kg", "m/s", etc. 
It is recommended that the symbol be an identifier for a unit of measure as specified in the "Unified Code of Units of Measure" (UCUM) (http://aurora.regenstrief.org/UCUM). This provides a set of symbols and a grammar for constructing identifiers for units of measure that are unique, and may be easily entered with a keyboard supporting the limited character set known as 7-bit ASCII. ISO 2955 formerly provided a specification with this scope, but was withdrawn in 2001. UCUM largely follows ISO 2955 with modifications to remove ambiguities and other problems."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomSymbol')
    _Documentation = u'This type specifies a character string of length at least one, and restricted such that it must not contain any of the following characters: ":" (colon), " " (space), (newline), (carriage return), (tab). This allows values corresponding to familiar abbreviations, such as "kg", "m/s", etc. \nIt is recommended that the symbol be an identifier for a unit of measure as specified in the "Unified Code of Units of Measure" (UCUM) (http://aurora.regenstrief.org/UCUM). This provides a set of symbols and a grammar for constructing identifiers for units of measure that are unique, and may be easily entered with a keyboard supporting the limited character set known as 7-bit ASCII. ISO 2955 formerly provided a specification with this scope, but was withdrawn in 2001. UCUM largely follows ISO 2955 with modifications to remove ambiguities and other problems.'
UomSymbol._CF_pattern = pyxb.binding.facets.CF_pattern()
UomSymbol._CF_pattern.addPattern(pattern=u'[^: \\n\\r\\t]+')
UomSymbol._InitializeFacetMap(UomSymbol._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'UomSymbol', UomSymbol)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class UomIdentifier (pyxb.binding.basis.STD_union):

    """The simple type gml:UomIdentifer defines the syntax and value space of the unit of measure identifier."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UomIdentifier')
    _Documentation = u'The simple type gml:UomIdentifer defines the syntax and value space of the unit of measure identifier.'

    _MemberTypes = ( UomSymbol, UomURI, )
UomIdentifier._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=UomIdentifier)
UomIdentifier._CF_pattern = pyxb.binding.facets.CF_pattern()
UomIdentifier._InitializeFacetMap(UomIdentifier._CF_enumeration,
   UomIdentifier._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'UomIdentifier', UomIdentifier)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_2, STD_ANON_1, pyxb.binding.datatypes.double, pyxb.binding.datatypes.anyURI, )
doubleOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=doubleOrNilReason)
doubleOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
doubleOrNilReason.inapplicable = u'inapplicable'  # originally STD_ANON_2.inapplicable
doubleOrNilReason.missing = u'missing'            # originally STD_ANON_2.missing
doubleOrNilReason.template = u'template'          # originally STD_ANON_2.template
doubleOrNilReason.unknown = u'unknown'            # originally STD_ANON_2.unknown
doubleOrNilReason.withheld = u'withheld'          # originally STD_ANON_2.withheld
doubleOrNilReason._InitializeFacetMap(doubleOrNilReason._CF_enumeration,
   doubleOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'doubleOrNilReason', doubleOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class doubleOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'doubleOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = doubleOrNilReason
doubleOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'doubleOrNilReasonList', doubleOrNilReasonList)

# Atomic SimpleTypeDefinition
class SuccessionType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SuccessionType')
    _Documentation = ''
SuccessionType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SuccessionType, enum_prefix=None)
SuccessionType.substitution = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'substitution')
SuccessionType.division = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'division')
SuccessionType.fusion = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'fusion')
SuccessionType.initiation = SuccessionType._CF_enumeration.addEnumeration(unicode_value=u'initiation')
SuccessionType._InitializeFacetMap(SuccessionType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SuccessionType', SuccessionType)

# Atomic SimpleTypeDefinition
class TimeIndeterminateValueType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """These values are interpreted as follows: 
-	"unknown" indicates that no specific value for temporal position is provided.
-	"now" indicates that the specified value shall be replaced with the current temporal position whenever the value is accessed.
-	"before" indicates that the actual temporal position is unknown, but it is known to be before the specified value.
-	"after" indicates that the actual temporal position is unknown, but it is known to be after the specified value.
A value for indeterminatePosition may 
-	be used either alone, or 
-	qualify a specific value for temporal position."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeIndeterminateValueType')
    _Documentation = u'These values are interpreted as follows: \n-\t"unknown" indicates that no specific value for temporal position is provided.\n-\t"now" indicates that the specified value shall be replaced with the current temporal position whenever the value is accessed.\n-\t"before" indicates that the actual temporal position is unknown, but it is known to be before the specified value.\n-\t"after" indicates that the actual temporal position is unknown, but it is known to be after the specified value.\nA value for indeterminatePosition may \n-\tbe used either alone, or \n-\tqualify a specific value for temporal position.'
TimeIndeterminateValueType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimeIndeterminateValueType, enum_prefix=None)
TimeIndeterminateValueType.after = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'after')
TimeIndeterminateValueType.before = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'before')
TimeIndeterminateValueType.now = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'now')
TimeIndeterminateValueType.unknown = TimeIndeterminateValueType._CF_enumeration.addEnumeration(unicode_value=u'unknown')
TimeIndeterminateValueType._InitializeFacetMap(TimeIndeterminateValueType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'TimeIndeterminateValueType', TimeIndeterminateValueType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class TimePositionUnion (pyxb.binding.basis.STD_union):

    """The simple type gml:TimePositionUnion is a union of XML Schema simple types which instantiate the subtypes for temporal position described in ISO 19108.
 An ordinal era may be referenced via URI.  A decimal value may be used to indicate the distance from the scale origin .  time is used for a position that recurs daily (see ISO 19108:2002 5.4.4.2).
 Finally, calendar and clock forms that support the representation of time in systems based on years, months, days, hours, minutes and seconds, in a notation following ISO 8601, are assembled by gml:CalDate"""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePositionUnion')
    _Documentation = u'The simple type gml:TimePositionUnion is a union of XML Schema simple types which instantiate the subtypes for temporal position described in ISO 19108.\n An ordinal era may be referenced via URI.  A decimal value may be used to indicate the distance from the scale origin .  time is used for a position that recurs daily (see ISO 19108:2002 5.4.4.2).\n Finally, calendar and clock forms that support the representation of time in systems based on years, months, days, hours, minutes and seconds, in a notation following ISO 8601, are assembled by gml:CalDate'

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, pyxb.binding.datatypes.time, pyxb.binding.datatypes.dateTime, pyxb.binding.datatypes.anyURI, pyxb.binding.datatypes.decimal, )
TimePositionUnion._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=TimePositionUnion)
TimePositionUnion._CF_pattern = pyxb.binding.facets.CF_pattern()
TimePositionUnion._InitializeFacetMap(TimePositionUnion._CF_enumeration,
   TimePositionUnion._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'TimePositionUnion', TimePositionUnion)

# Atomic SimpleTypeDefinition
class MD_ObligationCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ObligationCode_Type')
    _Documentation = None
MD_ObligationCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_ObligationCode_Type, enum_prefix=None)
MD_ObligationCode_Type.mandatory = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'mandatory')
MD_ObligationCode_Type.optional = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'optional')
MD_ObligationCode_Type.conditional = MD_ObligationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'conditional')
MD_ObligationCode_Type._InitializeFacetMap(MD_ObligationCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ObligationCode_Type', MD_ObligationCode_Type)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_2, STD_ANON_1, pyxb.binding.datatypes.Name, pyxb.binding.datatypes.anyURI, )
NameOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NameOrNilReason)
NameOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
NameOrNilReason.inapplicable = u'inapplicable'    # originally STD_ANON_2.inapplicable
NameOrNilReason.missing = u'missing'              # originally STD_ANON_2.missing
NameOrNilReason.template = u'template'            # originally STD_ANON_2.template
NameOrNilReason.unknown = u'unknown'              # originally STD_ANON_2.unknown
NameOrNilReason.withheld = u'withheld'            # originally STD_ANON_2.withheld
NameOrNilReason._InitializeFacetMap(NameOrNilReason._CF_enumeration,
   NameOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'NameOrNilReason', NameOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = NameOrNilReason
NameOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NameOrNilReasonList', NameOrNilReasonList)

# List SimpleTypeDefinition
# superclasses NameOrNilReasonList
class STD_ANON_5 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of NameOrNilReason."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = NameOrNilReason
STD_ANON_5._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
STD_ANON_5._InitializeFacetMap(STD_ANON_5._CF_length)

# Atomic SimpleTypeDefinition
class ArcMinutesType (pyxb.binding.datatypes.nonNegativeInteger):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcMinutesType')
    _Documentation = ''
ArcMinutesType._CF_maxInclusive = pyxb.binding.facets.CF_maxInclusive(value_datatype=ArcMinutesType, value=pyxb.binding.datatypes.nonNegativeInteger(59L))
ArcMinutesType._InitializeFacetMap(ArcMinutesType._CF_maxInclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'ArcMinutesType', ArcMinutesType)

# Atomic SimpleTypeDefinition
class CurveInterpolationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:CurveInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurveInterpolationType')
    _Documentation = u'gml:CurveInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema.'
CurveInterpolationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CurveInterpolationType, enum_prefix=None)
CurveInterpolationType.linear = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'linear')
CurveInterpolationType.geodesic = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'geodesic')
CurveInterpolationType.circularArc3Points = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArc3Points')
CurveInterpolationType.circularArc2PointWithBulge = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArc2PointWithBulge')
CurveInterpolationType.circularArcCenterPointWithRadius = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'circularArcCenterPointWithRadius')
CurveInterpolationType.elliptical = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'elliptical')
CurveInterpolationType.clothoid = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'clothoid')
CurveInterpolationType.conic = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'conic')
CurveInterpolationType.polynomialSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'polynomialSpline')
CurveInterpolationType.cubicSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'cubicSpline')
CurveInterpolationType.rationalSpline = CurveInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'rationalSpline')
CurveInterpolationType._InitializeFacetMap(CurveInterpolationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'CurveInterpolationType', CurveInterpolationType)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.integer
integerList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'integerList', integerList)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.Name
NameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'NameList', NameList)

# Atomic SimpleTypeDefinition
class AxisDirection (pyxb.binding.datatypes.string):

    """The value of a gml:AxisDirection indicates the incrementation order to be used on an axis of the grid."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AxisDirection')
    _Documentation = u'The value of a gml:AxisDirection indicates the incrementation order to be used on an axis of the grid.'
AxisDirection._CF_pattern = pyxb.binding.facets.CF_pattern()
AxisDirection._CF_pattern.addPattern(pattern=u'[\\+\\-][1-9][0-9]*')
AxisDirection._InitializeFacetMap(AxisDirection._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'AxisDirection', AxisDirection)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class AxisDirectionList (pyxb.binding.basis.STD_list):

    """The different values in a gml:AxisDirectionList indicate the incrementation order to be used on all axes of the grid. Each axis shall be mentioned once and only once."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AxisDirectionList')
    _Documentation = u'The different values in a gml:AxisDirectionList indicate the incrementation order to be used on all axes of the grid. Each axis shall be mentioned once and only once.'

    _ItemType = AxisDirection
AxisDirectionList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'AxisDirectionList', AxisDirectionList)

# Atomic SimpleTypeDefinition
class SequenceRuleEnumeration (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SequenceRuleEnumeration')
    _Documentation = None
SequenceRuleEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SequenceRuleEnumeration, enum_prefix=None)
SequenceRuleEnumeration.Linear = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Linear')
SequenceRuleEnumeration.Boustrophedonic = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Boustrophedonic')
SequenceRuleEnumeration.Cantor_diagonal = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Cantor-diagonal')
SequenceRuleEnumeration.Spiral = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Spiral')
SequenceRuleEnumeration.Morton = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Morton')
SequenceRuleEnumeration.Hilbert = SequenceRuleEnumeration._CF_enumeration.addEnumeration(unicode_value=u'Hilbert')
SequenceRuleEnumeration._InitializeFacetMap(SequenceRuleEnumeration._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SequenceRuleEnumeration', SequenceRuleEnumeration)

# Atomic SimpleTypeDefinition
class IncrementOrder (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'IncrementOrder')
    _Documentation = ''
IncrementOrder._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=IncrementOrder, enum_prefix=None)
IncrementOrder.xy = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+x+y')
IncrementOrder.yx = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+y+x')
IncrementOrder.x_y = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'+x-y')
IncrementOrder.x_y_ = IncrementOrder._CF_enumeration.addEnumeration(unicode_value=u'-x-y')
IncrementOrder._InitializeFacetMap(IncrementOrder._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'IncrementOrder', IncrementOrder)

# Atomic SimpleTypeDefinition
class DecimalMinutesType (pyxb.binding.datatypes.decimal):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DecimalMinutesType')
    _Documentation = ''
DecimalMinutesType._CF_minInclusive = pyxb.binding.facets.CF_minInclusive(value_datatype=DecimalMinutesType, value=pyxb.binding.datatypes.decimal(0.0))
DecimalMinutesType._CF_maxExclusive = pyxb.binding.facets.CF_maxExclusive(value_datatype=pyxb.binding.datatypes.decimal, value=pyxb.binding.datatypes.anySimpleType(u'60.00'))
DecimalMinutesType._InitializeFacetMap(DecimalMinutesType._CF_minInclusive,
   DecimalMinutesType._CF_maxExclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'DecimalMinutesType', DecimalMinutesType)

# Atomic SimpleTypeDefinition
class MD_PixelOrientationCode_Type (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_PixelOrientationCode_Type')
    _Documentation = None
MD_PixelOrientationCode_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=MD_PixelOrientationCode_Type, enum_prefix=None)
MD_PixelOrientationCode_Type.center = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'center')
MD_PixelOrientationCode_Type.lowerLeft = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'lowerLeft')
MD_PixelOrientationCode_Type.lowerRight = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'lowerRight')
MD_PixelOrientationCode_Type.upperRight = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'upperRight')
MD_PixelOrientationCode_Type.upperLeft = MD_PixelOrientationCode_Type._CF_enumeration.addEnumeration(unicode_value=u'upperLeft')
MD_PixelOrientationCode_Type._InitializeFacetMap(MD_PixelOrientationCode_Type._CF_enumeration)
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_PixelOrientationCode_Type', MD_PixelOrientationCode_Type)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_2, STD_ANON_1, pyxb.binding.datatypes.boolean, pyxb.binding.datatypes.anyURI, )
booleanOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=booleanOrNilReason)
booleanOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
booleanOrNilReason.inapplicable = u'inapplicable' # originally STD_ANON_2.inapplicable
booleanOrNilReason.missing = u'missing'           # originally STD_ANON_2.missing
booleanOrNilReason.template = u'template'         # originally STD_ANON_2.template
booleanOrNilReason.unknown = u'unknown'           # originally STD_ANON_2.unknown
booleanOrNilReason.withheld = u'withheld'         # originally STD_ANON_2.withheld
booleanOrNilReason._InitializeFacetMap(booleanOrNilReason._CF_enumeration,
   booleanOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'booleanOrNilReason', booleanOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = booleanOrNilReason
booleanOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'booleanOrNilReasonList', booleanOrNilReasonList)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class booleanList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'booleanList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.boolean
booleanList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'booleanList', booleanList)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class Date_Type (pyxb.binding.basis.STD_union):

    """Simple type that is a union of pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Date_Type')
    _Documentation = None

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, )
Date_Type._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=Date_Type)
Date_Type._CF_pattern = pyxb.binding.facets.CF_pattern()
Date_Type._InitializeFacetMap(Date_Type._CF_enumeration,
   Date_Type._CF_pattern)
_Namespace_gco.addCategoryObject('typeBinding', u'Date_Type', Date_Type)

# Atomic SimpleTypeDefinition
class CompassPointEnumeration (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """These directions are necessarily approximate, giving direction with a precision of 22.5&#176;. It is thus generally unnecessary to specify the reference frame, though this may be detailed in the definition of a GML application language."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompassPointEnumeration')
    _Documentation = u'These directions are necessarily approximate, giving direction with a precision of 22.5\xb0. It is thus generally unnecessary to specify the reference frame, though this may be detailed in the definition of a GML application language.'
CompassPointEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CompassPointEnumeration, enum_prefix=None)
CompassPointEnumeration.N = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'N')
CompassPointEnumeration.NNE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NNE')
CompassPointEnumeration.NE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NE')
CompassPointEnumeration.ENE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'ENE')
CompassPointEnumeration.E = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'E')
CompassPointEnumeration.ESE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'ESE')
CompassPointEnumeration.SE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SE')
CompassPointEnumeration.SSE = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SSE')
CompassPointEnumeration.S = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'S')
CompassPointEnumeration.SSW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SSW')
CompassPointEnumeration.SW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'SW')
CompassPointEnumeration.WSW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'WSW')
CompassPointEnumeration.W = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'W')
CompassPointEnumeration.WNW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'WNW')
CompassPointEnumeration.NW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NW')
CompassPointEnumeration.NNW = CompassPointEnumeration._CF_enumeration.addEnumeration(unicode_value=u'NNW')
CompassPointEnumeration._InitializeFacetMap(CompassPointEnumeration._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'CompassPointEnumeration', CompassPointEnumeration)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class NilReasonEnumeration (pyxb.binding.basis.STD_union):

    """Simple type that is a union of STD_ANON_2, STD_ANON_1."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NilReasonEnumeration')
    _Documentation = None

    _MemberTypes = ( STD_ANON_2, STD_ANON_1, )
NilReasonEnumeration._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=NilReasonEnumeration)
NilReasonEnumeration._CF_pattern = pyxb.binding.facets.CF_pattern()
NilReasonEnumeration.inapplicable = u'inapplicable'# originally STD_ANON_2.inapplicable
NilReasonEnumeration.missing = u'missing'         # originally STD_ANON_2.missing
NilReasonEnumeration.template = u'template'       # originally STD_ANON_2.template
NilReasonEnumeration.unknown = u'unknown'         # originally STD_ANON_2.unknown
NilReasonEnumeration.withheld = u'withheld'       # originally STD_ANON_2.withheld
NilReasonEnumeration._InitializeFacetMap(NilReasonEnumeration._CF_enumeration,
   NilReasonEnumeration._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'NilReasonEnumeration', NilReasonEnumeration)

# Atomic SimpleTypeDefinition
class SurfaceInterpolationType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """gml:SurfaceInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfaceInterpolationType')
    _Documentation = u'gml:SurfaceInterpolationType is a list of codes that may be used to identify the interpolation mechanisms specified by an application schema.'
SurfaceInterpolationType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=SurfaceInterpolationType, enum_prefix=None)
SurfaceInterpolationType.none = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'none')
SurfaceInterpolationType.planar = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'planar')
SurfaceInterpolationType.spherical = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'spherical')
SurfaceInterpolationType.elliptical = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'elliptical')
SurfaceInterpolationType.conic = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'conic')
SurfaceInterpolationType.tin = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'tin')
SurfaceInterpolationType.parametricCurve = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'parametricCurve')
SurfaceInterpolationType.polynomialSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'polynomialSpline')
SurfaceInterpolationType.rationalSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'rationalSpline')
SurfaceInterpolationType.triangulatedSpline = SurfaceInterpolationType._CF_enumeration.addEnumeration(unicode_value=u'triangulatedSpline')
SurfaceInterpolationType._InitializeFacetMap(SurfaceInterpolationType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'SurfaceInterpolationType', SurfaceInterpolationType)

# Atomic SimpleTypeDefinition
class STD_ANON_6 (pyxb.binding.datatypes.string):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_6._InitializeFacetMap()

# Atomic SimpleTypeDefinition
class STD_ANON_7 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_7._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_7, enum_prefix=None)
STD_ANON_7.Before = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Before')
STD_ANON_7.After = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'After')
STD_ANON_7.Begins = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Begins')
STD_ANON_7.Ends = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Ends')
STD_ANON_7.During = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'During')
STD_ANON_7.Equals = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Equals')
STD_ANON_7.Contains = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Contains')
STD_ANON_7.Overlaps = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Overlaps')
STD_ANON_7.Meets = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'Meets')
STD_ANON_7.OverlappedBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'OverlappedBy')
STD_ANON_7.MetBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'MetBy')
STD_ANON_7.BegunBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'BegunBy')
STD_ANON_7.EndedBy = STD_ANON_7._CF_enumeration.addEnumeration(unicode_value=u'EndedBy')
STD_ANON_7._InitializeFacetMap(STD_ANON_7._CF_enumeration)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_2, STD_ANON_1, pyxb.binding.datatypes.integer, pyxb.binding.datatypes.anyURI, )
integerOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=integerOrNilReason)
integerOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
integerOrNilReason.inapplicable = u'inapplicable' # originally STD_ANON_2.inapplicable
integerOrNilReason.missing = u'missing'           # originally STD_ANON_2.missing
integerOrNilReason.template = u'template'         # originally STD_ANON_2.template
integerOrNilReason.unknown = u'unknown'           # originally STD_ANON_2.unknown
integerOrNilReason.withheld = u'withheld'         # originally STD_ANON_2.withheld
integerOrNilReason._InitializeFacetMap(integerOrNilReason._CF_enumeration,
   integerOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'integerOrNilReason', integerOrNilReason)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class integerOrNilReasonList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'integerOrNilReasonList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = integerOrNilReason
integerOrNilReasonList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'integerOrNilReasonList', integerOrNilReasonList)

# List SimpleTypeDefinition
# superclasses integerOrNilReasonList
class CountExtentType (pyxb.binding.basis.STD_list):

    """Simple type that is a list of integerOrNilReason."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CountExtentType')
    _Documentation = None

    _ItemType = integerOrNilReason
CountExtentType._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
CountExtentType._InitializeFacetMap(CountExtentType._CF_length)
_Namespace_gml.addCategoryObject('typeBinding', u'CountExtentType', CountExtentType)

# List SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class QNameList (pyxb.binding.basis.STD_list):

    """A type for a list of values of the respective simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'QNameList')
    _Documentation = u'A type for a list of values of the respective simple type.'

    _ItemType = pyxb.binding.datatypes.QName
QNameList._InitializeFacetMap()
_Namespace_gml.addCategoryObject('typeBinding', u'QNameList', QNameList)

# Atomic SimpleTypeDefinition
class ArcSecondsType (pyxb.binding.datatypes.decimal):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArcSecondsType')
    _Documentation = ''
ArcSecondsType._CF_minInclusive = pyxb.binding.facets.CF_minInclusive(value_datatype=ArcSecondsType, value=pyxb.binding.datatypes.decimal(0.0))
ArcSecondsType._CF_maxExclusive = pyxb.binding.facets.CF_maxExclusive(value_datatype=pyxb.binding.datatypes.decimal, value=pyxb.binding.datatypes.anySimpleType(u'60.00'))
ArcSecondsType._InitializeFacetMap(ArcSecondsType._CF_minInclusive,
   ArcSecondsType._CF_maxExclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'ArcSecondsType', ArcSecondsType)

# List SimpleTypeDefinition
# superclasses doubleOrNilReasonList
class STD_ANON_8 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of doubleOrNilReason."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = doubleOrNilReason
STD_ANON_8._CF_length = pyxb.binding.facets.CF_length(value=pyxb.binding.datatypes.nonNegativeInteger(2L))
STD_ANON_8._InitializeFacetMap(STD_ANON_8._CF_length)

# Atomic SimpleTypeDefinition
class KnotTypesType (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """This enumeration type specifies values for the knots' type (see ISO 19107:2003, 6.4.25)."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'KnotTypesType')
    _Documentation = u"This enumeration type specifies values for the knots' type (see ISO 19107:2003, 6.4.25)."
KnotTypesType._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=KnotTypesType, enum_prefix=None)
KnotTypesType.uniform = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'uniform')
KnotTypesType.quasiUniform = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'quasiUniform')
KnotTypesType.piecewiseBezier = KnotTypesType._CF_enumeration.addEnumeration(unicode_value=u'piecewiseBezier')
KnotTypesType._InitializeFacetMap(KnotTypesType._CF_enumeration)
_Namespace_gml.addCategoryObject('typeBinding', u'KnotTypesType', KnotTypesType)

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class CalDate (pyxb.binding.basis.STD_union):

    """Simple type that is a union of pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CalDate')
    _Documentation = None

    _MemberTypes = ( pyxb.binding.datatypes.date, pyxb.binding.datatypes.gYearMonth, pyxb.binding.datatypes.gYear, )
CalDate._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=CalDate)
CalDate._CF_pattern = pyxb.binding.facets.CF_pattern()
CalDate._InitializeFacetMap(CalDate._CF_enumeration,
   CalDate._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'CalDate', CalDate)

# Atomic SimpleTypeDefinition
class STD_ANON_9 (pyxb.binding.datatypes.string, pyxb.binding.basis.enumeration_mixin):

    """An atomic simple type."""

    _ExpandedName = None
    _Documentation = None
STD_ANON_9._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=STD_ANON_9, enum_prefix=None)
STD_ANON_9.N = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'N')
STD_ANON_9.E = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'E')
STD_ANON_9.S = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'S')
STD_ANON_9.W = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'W')
STD_ANON_9.emptyString = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'+')
STD_ANON_9.emptyString_ = STD_ANON_9._CF_enumeration.addEnumeration(unicode_value=u'-')
STD_ANON_9._InitializeFacetMap(STD_ANON_9._CF_enumeration)

# Atomic SimpleTypeDefinition
class DegreeValueType (pyxb.binding.datatypes.nonNegativeInteger):

    """An atomic simple type."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DegreeValueType')
    _Documentation = ''
DegreeValueType._CF_maxInclusive = pyxb.binding.facets.CF_maxInclusive(value_datatype=DegreeValueType, value=pyxb.binding.datatypes.nonNegativeInteger(359L))
DegreeValueType._InitializeFacetMap(DegreeValueType._CF_maxInclusive)
_Namespace_gml.addCategoryObject('typeBinding', u'DegreeValueType', DegreeValueType)

# List SimpleTypeDefinition
# superclasses doubleList
class STD_ANON_10 (pyxb.binding.basis.STD_list):

    """Simple type that is a list of pyxb.binding.datatypes.double."""

    _ExpandedName = None
    _Documentation = None

    _ItemType = pyxb.binding.datatypes.double
STD_ANON_10._InitializeFacetMap()

# Union SimpleTypeDefinition
# superclasses pyxb.binding.datatypes.anySimpleType
class stringOrNilReason (pyxb.binding.basis.STD_union):

    """Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value."""

    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'stringOrNilReason')
    _Documentation = u'Extension to the respective XML Schema built-in simple type to allow a choice of either a value of the built-in simple type or a reason for a nil value.'

    _MemberTypes = ( STD_ANON_2, STD_ANON_1, pyxb.binding.datatypes.string, pyxb.binding.datatypes.anyURI, )
stringOrNilReason._CF_enumeration = pyxb.binding.facets.CF_enumeration(value_datatype=stringOrNilReason)
stringOrNilReason._CF_pattern = pyxb.binding.facets.CF_pattern()
stringOrNilReason.inapplicable = u'inapplicable'  # originally STD_ANON_2.inapplicable
stringOrNilReason.missing = u'missing'            # originally STD_ANON_2.missing
stringOrNilReason.template = u'template'          # originally STD_ANON_2.template
stringOrNilReason.unknown = u'unknown'            # originally STD_ANON_2.unknown
stringOrNilReason.withheld = u'withheld'          # originally STD_ANON_2.withheld
stringOrNilReason._InitializeFacetMap(stringOrNilReason._CF_enumeration,
   stringOrNilReason._CF_pattern)
_Namespace_gml.addCategoryObject('typeBinding', u'stringOrNilReason', stringOrNilReason)

# Complex type EllipsoidPropertyType with content type ELEMENT_ONLY
class EllipsoidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EllipsoidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Ellipsoid uses Python identifier Ellipsoid
    __Ellipsoid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Ellipsoid'), 'Ellipsoid', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_opengis_netgml3_2Ellipsoid', False)

    
    Ellipsoid = property(__Ellipsoid.value, __Ellipsoid.set, None, u'A gml:Ellipsoid is a geometric figure that may be used to describe the approximate shape of the earth. In mathematical terms, it is a surface formed by the rotation of an ellipse about its minor axis.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_EllipsoidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __Ellipsoid.name() : __Ellipsoid
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __role.name() : __role,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EllipsoidPropertyType', EllipsoidPropertyType)


# Complex type AbstractObject_Type with content type EMPTY
class AbstractObject_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'AbstractObject_Type')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute uuid uses Python identifier uuid
    __uuid = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuid'), 'uuid', '__httpwww_isotc211_org2005gco_AbstractObject_Type_uuid', pyxb.binding.datatypes.string)
    
    uuid = property(__uuid.value, __uuid.set, None, None)

    
    # Attribute id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'id'), 'id', '__httpwww_isotc211_org2005gco_AbstractObject_Type_id', pyxb.binding.datatypes.ID)
    
    id = property(__id.value, __id.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uuid.name() : __uuid,
        __id.name() : __id
    }
_Namespace_gco.addCategoryObject('typeBinding', u'AbstractObject_Type', AbstractObject_Type)


# Complex type MD_DigitalTransferOptions_Type with content type ELEMENT_ONLY
class MD_DigitalTransferOptions_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DigitalTransferOptions_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}transferSize uses Python identifier transferSize
    __transferSize = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'transferSize'), 'transferSize', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_Type_httpwww_isotc211_org2005gmdtransferSize', False)

    
    transferSize = property(__transferSize.value, __transferSize.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}onLine uses Python identifier onLine
    __onLine = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'onLine'), 'onLine', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_Type_httpwww_isotc211_org2005gmdonLine', True)

    
    onLine = property(__onLine.value, __onLine.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}offLine uses Python identifier offLine
    __offLine = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'offLine'), 'offLine', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_Type_httpwww_isotc211_org2005gmdoffLine', False)

    
    offLine = property(__offLine.value, __offLine.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}unitsOfDistribution uses Python identifier unitsOfDistribution
    __unitsOfDistribution = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'unitsOfDistribution'), 'unitsOfDistribution', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_Type_httpwww_isotc211_org2005gmdunitsOfDistribution', False)

    
    unitsOfDistribution = property(__unitsOfDistribution.value, __unitsOfDistribution.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __transferSize.name() : __transferSize,
        __onLine.name() : __onLine,
        __offLine.name() : __offLine,
        __unitsOfDistribution.name() : __unitsOfDistribution
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_DigitalTransferOptions_Type', MD_DigitalTransferOptions_Type)


# Complex type PointPropertyType with content type ELEMENT_ONLY
class PointPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PointPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Point uses Python identifier Point
    __Point = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Point'), 'Point', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_opengis_netgml3_2Point', False)

    
    Point = property(__Point.value, __Point.set, None, u'A Point is defined by a single coordinate tuple. The direct position of a point is specified by the pos element which is of type DirectPositionType.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_PointPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_PointPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_PointPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __Point.name() : __Point
    }
    _AttributeMap = {
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'PointPropertyType', PointPropertyType)


# Complex type StringOrRefType with content type SIMPLE
class StringOrRefType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'StringOrRefType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_StringOrRefType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_StringOrRefType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __type.name() : __type,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'StringOrRefType', StringOrRefType)


# Complex type MD_MaintenanceInformation_PropertyType with content type ELEMENT_ONLY
class MD_MaintenanceInformation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_MaintenanceInformation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_MaintenanceInformation uses Python identifier MD_MaintenanceInformation
    __MD_MaintenanceInformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_MaintenanceInformation'), 'MD_MaintenanceInformation', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_isotc211_org2005gmdMD_MaintenanceInformation', False)

    
    MD_MaintenanceInformation = property(__MD_MaintenanceInformation.value, __MD_MaintenanceInformation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __MD_MaintenanceInformation.name() : __MD_MaintenanceInformation
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_MaintenanceInformation_PropertyType', MD_MaintenanceInformation_PropertyType)


# Complex type AbstractGMLType with content type ELEMENT_ONLY
class AbstractGMLType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGMLType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}identifier uses Python identifier identifier
    __identifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'identifier'), 'identifier', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2identifier', False)

    
    identifier = property(__identifier.value, __identifier.set, None, u'Often, a special identifier is assigned to an object by the maintaining authority with the intention that it is used in references to the object For such cases, the codeSpace shall be provided. That identifier is usually unique either globally or within an application domain. gml:identifier is a pre-defined property for such identifiers.')

    
    # Element {http://www.opengis.net/gml/3.2}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'description'), 'description', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2description', False)

    
    description = property(__description.value, __description.set, None, u'The value of this property is a text description of the object. gml:description uses gml:StringOrRefType as its content model, so it may contain a simple text string content, or carry a reference to an external description. The use of gml:description to reference an external description has been deprecated and replaced by the gml:descriptionReference property.')

    
    # Element {http://www.opengis.net/gml/3.2}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'name'), 'name', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2name', True)

    
    name = property(__name.value, __name.set, None, u'The gml:name property provides a label or identifier for the object, commonly a descriptive name. An object may have several names, typically assigned by different authorities. gml:name uses the gml:CodeType content model.  The authority for a name is indicated by the value of its (optional) codeSpace attribute.  The name may or may not be unique, as determined by the rules of the organization responsible for the codeSpace.  In common usage there will be one name per authority, so a processing application may select the name from its preferred codeSpace.')

    
    # Element {http://www.opengis.net/gml/3.2}descriptionReference uses Python identifier descriptionReference
    __descriptionReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'descriptionReference'), 'descriptionReference', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2descriptionReference', False)

    
    descriptionReference = property(__descriptionReference.value, __descriptionReference.set, None, u'The value of this property is a remote text description of the object. The xlink:href attribute of the gml:descriptionReference property references the external description.')

    
    # Element {http://www.opengis.net/gml/3.2}metaDataProperty uses Python identifier metaDataProperty
    __metaDataProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'metaDataProperty'), 'metaDataProperty', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2metaDataProperty', True)

    
    metaDataProperty = property(__metaDataProperty.value, __metaDataProperty.set, None, u'')

    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id = property(__id.value, __id.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = {
        __identifier.name() : __identifier,
        __description.name() : __description,
        __name.name() : __name,
        __descriptionReference.name() : __descriptionReference,
        __metaDataProperty.name() : __metaDataProperty
    }
    _AttributeMap = {
        __id.name() : __id
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGMLType', AbstractGMLType)


# Complex type DefinitionBaseType with content type ELEMENT_ONLY
class DefinitionBaseType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DefinitionBaseType')
    # Base type is AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id
    __id = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id', '__httpwww_opengis_netgml3_2_AbstractGMLType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id = property(__id.value, __id.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        __id.name() : __id
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DefinitionBaseType', DefinitionBaseType)


# Complex type DefinitionType with content type ELEMENT_ONLY
class DefinitionType (DefinitionBaseType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DefinitionType')
    # Base type is DefinitionBaseType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}remarks uses Python identifier remarks
    __remarks = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remarks'), 'remarks', '__httpwww_opengis_netgml3_2_DefinitionType_httpwww_opengis_netgml3_2remarks', False)

    
    remarks = property(__remarks.value, __remarks.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionBaseType._ElementMap.copy()
    _ElementMap.update({
        __remarks.name() : __remarks
    })
    _AttributeMap = DefinitionBaseType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DefinitionType', DefinitionType)


# Complex type IdentifiedObjectType with content type ELEMENT_ONLY
class IdentifiedObjectType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'IdentifiedObjectType')
    # Base type is DefinitionType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'IdentifiedObjectType', IdentifiedObjectType)


# Complex type AbstractCRSType with content type ELEMENT_ONLY
class AbstractCRSType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCRSType')
    # Base type is IdentifiedObjectType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractCRSType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractCRSType_httpwww_opengis_netgml3_2domainOfValidity', True)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __scope.name() : __scope,
        __domainOfValidity.name() : __domainOfValidity
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCRSType', AbstractCRSType)


# Complex type GeographicCRSType with content type ELEMENT_ONLY
class GeographicCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeographicCRSType')
    # Base type is AbstractCRSType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}usesEllipsoidalCS uses Python identifier usesEllipsoidalCS
    __usesEllipsoidalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'usesEllipsoidalCS'), 'usesEllipsoidalCS', '__httpwww_opengis_netgml3_2_GeographicCRSType_httpwww_opengis_netgml3_2usesEllipsoidalCS', False)

    
    usesEllipsoidalCS = property(__usesEllipsoidalCS.value, __usesEllipsoidalCS.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}usesGeodeticDatum uses Python identifier usesGeodeticDatum
    __usesGeodeticDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'usesGeodeticDatum'), 'usesGeodeticDatum', '__httpwww_opengis_netgml3_2_GeographicCRSType_httpwww_opengis_netgml3_2usesGeodeticDatum', False)

    
    usesGeodeticDatum = property(__usesGeodeticDatum.value, __usesGeodeticDatum.set, None, u'')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __usesEllipsoidalCS.name() : __usesEllipsoidalCS,
        __usesGeodeticDatum.name() : __usesGeodeticDatum
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'GeographicCRSType', GeographicCRSType)


# Complex type TimeCalendarPropertyType with content type ELEMENT_ONLY
class TimeCalendarPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCalendarPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeCalendar uses Python identifier TimeCalendar
    __TimeCalendar = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCalendar'), 'TimeCalendar', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_opengis_netgml3_2TimeCalendar', False)

    
    TimeCalendar = property(__TimeCalendar.value, __TimeCalendar.set, None, u'A calendar is a discrete temporal reference system that provides a basis for defining temporal position to a resolution of one day.\ngml:TimeCalendar adds one property to those inherited from gml:TimeReferenceSystem. A gml:referenceFrame provides a link to a gml:TimeCalendarEra that it uses. A  gml:TimeCalendar may reference more than one calendar era. \nThe referenceFrame element follows the standard GML property model, allowing the association to be instantiated either using an inline description using the gml:TimeCalendarEra element, or a link to a gml:TimeCalendarEra which is explicit elsewhere.')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeCalendarPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __TimeCalendar.name() : __TimeCalendar
    }
    _AttributeMap = {
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeCalendarPropertyType', TimeCalendarPropertyType)


# Complex type Real_PropertyType with content type ELEMENT_ONLY
class Real_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Real_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Real uses Python identifier Real
    __Real = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Real'), 'Real', '__httpwww_isotc211_org2005gco_Real_PropertyType_httpwww_isotc211_org2005gcoReal', False)

    
    Real = property(__Real.value, __Real.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Real_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Real.name() : __Real
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Real_PropertyType', Real_PropertyType)


# Complex type AbstractGeneralParameterValueType with content type EMPTY
class AbstractGeneralParameterValueType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralParameterValueType')
    # Base type is pyxb.binding.datatypes.anyType

    _ElementMap = {
        
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralParameterValueType', AbstractGeneralParameterValueType)


# Complex type BoundingShapeType with content type ELEMENT_ONLY
class BoundingShapeType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'BoundingShapeType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Null uses Python identifier Null
    __Null = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Null'), 'Null', '__httpwww_opengis_netgml3_2_BoundingShapeType_httpwww_opengis_netgml3_2Null', False)

    
    Null = property(__Null.value, __Null.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}Envelope uses Python identifier Envelope
    __Envelope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Envelope'), 'Envelope', '__httpwww_opengis_netgml3_2_BoundingShapeType_httpwww_opengis_netgml3_2Envelope', False)

    
    Envelope = property(__Envelope.value, __Envelope.set, None, u'Envelope defines an extent using a pair of positions defining opposite corners in arbitrary dimensions. The first direct position is the "lower corner" (a coordinate position consisting of all the minimal ordinates for each dimension for all points within the envelope), the second one the "upper corner" (a coordinate position consisting of all the maximal ordinates for each dimension for all points within the envelope).\nThe use of the properties "coordinates" and "pos" has been deprecated. The explicitly named properties "lowerCorner" and "upperCorner" shall be used instead.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_BoundingShapeType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Null.name() : __Null,
        __Envelope.name() : __Envelope
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'BoundingShapeType', BoundingShapeType)


# Complex type PT_LocaleContainer_Type with content type ELEMENT_ONLY
class PT_LocaleContainer_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_LocaleContainer_Type')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}responsibleParty uses Python identifier responsibleParty
    __responsibleParty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'responsibleParty'), 'responsibleParty', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmdresponsibleParty', True)

    
    responsibleParty = property(__responsibleParty.value, __responsibleParty.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}date uses Python identifier date
    __date = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'date'), 'date', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmddate', True)

    
    date = property(__date.value, __date.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}locale uses Python identifier locale
    __locale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'locale'), 'locale', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmdlocale', False)

    
    locale = property(__locale.value, __locale.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}localisedString uses Python identifier localisedString
    __localisedString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'localisedString'), 'localisedString', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmdlocalisedString', True)

    
    localisedString = property(__localisedString.value, __localisedString.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'description'), 'description', '__httpwww_isotc211_org2005gmd_PT_LocaleContainer_Type_httpwww_isotc211_org2005gmddescription', False)

    
    description = property(__description.value, __description.set, None, None)


    _ElementMap = {
        __responsibleParty.name() : __responsibleParty,
        __date.name() : __date,
        __locale.name() : __locale,
        __localisedString.name() : __localisedString,
        __description.name() : __description
    }
    _AttributeMap = {
        
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_LocaleContainer_Type', PT_LocaleContainer_Type)


# Complex type CodeListValue_Type with content type SIMPLE
class CodeListValue_Type (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'CodeListValue_Type')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)

    
    # Attribute codeListValue uses Python identifier codeListValue
    __codeListValue = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeListValue'), 'codeListValue', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeListValue', pyxb.binding.datatypes.anyURI, required=True)
    
    codeListValue = property(__codeListValue.value, __codeListValue.set, None, None)

    
    # Attribute codeList uses Python identifier codeList
    __codeList = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeList'), 'codeList', '__httpwww_isotc211_org2005gco_CodeListValue_Type_codeList', pyxb.binding.datatypes.anyURI, required=True)
    
    codeList = property(__codeList.value, __codeList.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace,
        __codeListValue.name() : __codeListValue,
        __codeList.name() : __codeList
    }
_Namespace_gco.addCategoryObject('typeBinding', u'CodeListValue_Type', CodeListValue_Type)


# Complex type MemberName_Type with content type ELEMENT_ONLY
class MemberName_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'MemberName_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gco}aName uses Python identifier aName
    __aName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'aName'), 'aName', '__httpwww_isotc211_org2005gco_MemberName_Type_httpwww_isotc211_org2005gcoaName', False)

    
    aName = property(__aName.value, __aName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gco}attributeType uses Python identifier attributeType
    __attributeType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'attributeType'), 'attributeType', '__httpwww_isotc211_org2005gco_MemberName_Type_httpwww_isotc211_org2005gcoattributeType', False)

    
    attributeType = property(__attributeType.value, __attributeType.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __aName.name() : __aName,
        __attributeType.name() : __attributeType
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gco.addCategoryObject('typeBinding', u'MemberName_Type', MemberName_Type)


# Complex type CodeType with content type SIMPLE
class CodeType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeType_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CodeType', CodeType)


# Complex type CodeWithAuthorityType with content type SIMPLE
class CodeWithAuthorityType (CodeType):
    _TypeDefinition = STD_ANON_6
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeWithAuthorityType')
    # Base type is CodeType
    
    # Attribute codeSpace is restricted from parent
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeType_codeSpace', pyxb.binding.datatypes.anyURI, required=True)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = CodeType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = CodeType._AttributeMap.copy()
    _AttributeMap.update({
        __codeSpace.name() : __codeSpace
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CodeWithAuthorityType', CodeWithAuthorityType)


# Complex type Angle_PropertyType with content type ELEMENT_ONLY
class Angle_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Angle_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Angle uses Python identifier Angle
    __Angle = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Angle'), 'Angle', '__httpwww_isotc211_org2005gco_Angle_PropertyType_httpwww_isotc211_org2005gcoAngle', False)

    
    Angle = property(__Angle.value, __Angle.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Angle_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Angle.name() : __Angle
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Angle_PropertyType', Angle_PropertyType)


# Complex type CoordinateOperationPropertyType with content type ELEMENT_ONLY
class CoordinateOperationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateOperationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCoordinateOperation uses Python identifier AbstractCoordinateOperation
    __AbstractCoordinateOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateOperation'), 'AbstractCoordinateOperation', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_opengis_netgml3_2AbstractCoordinateOperation', False)

    
    AbstractCoordinateOperation = property(__AbstractCoordinateOperation.value, __AbstractCoordinateOperation.set, None, u'gml:AbstractCoordinateOperation is a mathematical operation on coordinates that transforms or converts coordinates to another coordinate reference system. Many but not all coordinate operations (from CRS A to CRS B) also uniquely define the inverse operation (from CRS B to CRS A). In some cases, the operation method algorithm for the inverse operation is the same as for the forward algorithm, but the signs of some operation parameter values shall be reversed. In other cases, different algorithms are required for the forward and inverse operations, but the same operation parameter values are used. If (some) entirely different parameter values are needed, a different coordinate operation shall be defined.\nThe optional coordinateOperationAccuracy property elements provide estimates of the impact of this coordinate operation on point position accuracy.')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CoordinateOperationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __AbstractCoordinateOperation.name() : __AbstractCoordinateOperation
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateOperationPropertyType', CoordinateOperationPropertyType)


# Complex type TopoVolumePropertyType with content type ELEMENT_ONLY
class TopoVolumePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoVolumePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoVolume uses Python identifier TopoVolume
    __TopoVolume = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoVolume'), 'TopoVolume', '__httpwww_opengis_netgml3_2_TopoVolumePropertyType_httpwww_opengis_netgml3_2TopoVolume', False)

    
    TopoVolume = property(__TopoVolume.value, __TopoVolume.set, None, u'gml:TopoVolume represents a homogeneous topological expression, a set of directed topologic solids, which if realised are isomorphic to a geometric solid primitive. The intended use of gml:TopoVolume is to appear within a solid feature to express the structural and geometric relationships of this solid feature to other features via the shared solid definitions.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TopoVolumePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __TopoVolume.name() : __TopoVolume
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TopoVolumePropertyType', TopoVolumePropertyType)


# Complex type MD_Metadata_Type with content type ELEMENT_ONLY
class MD_Metadata_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Metadata_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}series uses Python identifier series
    __series = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'series'), 'series', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdseries', True)

    
    series = property(__series.value, __series.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}identificationInfo uses Python identifier identificationInfo
    __identificationInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'identificationInfo'), 'identificationInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdidentificationInfo', True)

    
    identificationInfo = property(__identificationInfo.value, __identificationInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}language uses Python identifier language
    __language = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'language'), 'language', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdlanguage', False)

    
    language = property(__language.value, __language.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}characterSet uses Python identifier characterSet
    __characterSet = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'characterSet'), 'characterSet', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdcharacterSet', False)

    
    characterSet = property(__characterSet.value, __characterSet.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}parentIdentifier uses Python identifier parentIdentifier
    __parentIdentifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'parentIdentifier'), 'parentIdentifier', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdparentIdentifier', False)

    
    parentIdentifier = property(__parentIdentifier.value, __parentIdentifier.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}contentInfo uses Python identifier contentInfo
    __contentInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contentInfo'), 'contentInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdcontentInfo', True)

    
    contentInfo = property(__contentInfo.value, __contentInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}hierarchyLevel uses Python identifier hierarchyLevel
    __hierarchyLevel = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'hierarchyLevel'), 'hierarchyLevel', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdhierarchyLevel', True)

    
    hierarchyLevel = property(__hierarchyLevel.value, __hierarchyLevel.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}hierarchyLevelName uses Python identifier hierarchyLevelName
    __hierarchyLevelName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'hierarchyLevelName'), 'hierarchyLevelName', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdhierarchyLevelName', True)

    
    hierarchyLevelName = property(__hierarchyLevelName.value, __hierarchyLevelName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}metadataStandardName uses Python identifier metadataStandardName
    __metadataStandardName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'metadataStandardName'), 'metadataStandardName', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdmetadataStandardName', False)

    
    metadataStandardName = property(__metadataStandardName.value, __metadataStandardName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}contact uses Python identifier contact
    __contact = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contact'), 'contact', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdcontact', True)

    
    contact = property(__contact.value, __contact.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}metadataStandardVersion uses Python identifier metadataStandardVersion
    __metadataStandardVersion = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'metadataStandardVersion'), 'metadataStandardVersion', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdmetadataStandardVersion', False)

    
    metadataStandardVersion = property(__metadataStandardVersion.value, __metadataStandardVersion.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}metadataExtensionInfo uses Python identifier metadataExtensionInfo
    __metadataExtensionInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'metadataExtensionInfo'), 'metadataExtensionInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdmetadataExtensionInfo', True)

    
    metadataExtensionInfo = property(__metadataExtensionInfo.value, __metadataExtensionInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}fileIdentifier uses Python identifier fileIdentifier
    __fileIdentifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileIdentifier'), 'fileIdentifier', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdfileIdentifier', False)

    
    fileIdentifier = property(__fileIdentifier.value, __fileIdentifier.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}distributionInfo uses Python identifier distributionInfo
    __distributionInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'distributionInfo'), 'distributionInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmddistributionInfo', False)

    
    distributionInfo = property(__distributionInfo.value, __distributionInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dataQualityInfo uses Python identifier dataQualityInfo
    __dataQualityInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dataQualityInfo'), 'dataQualityInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmddataQualityInfo', True)

    
    dataQualityInfo = property(__dataQualityInfo.value, __dataQualityInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}portrayalCatalogueInfo uses Python identifier portrayalCatalogueInfo
    __portrayalCatalogueInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'portrayalCatalogueInfo'), 'portrayalCatalogueInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdportrayalCatalogueInfo', True)

    
    portrayalCatalogueInfo = property(__portrayalCatalogueInfo.value, __portrayalCatalogueInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}metadataConstraints uses Python identifier metadataConstraints
    __metadataConstraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'metadataConstraints'), 'metadataConstraints', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdmetadataConstraints', True)

    
    metadataConstraints = property(__metadataConstraints.value, __metadataConstraints.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}applicationSchemaInfo uses Python identifier applicationSchemaInfo
    __applicationSchemaInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'applicationSchemaInfo'), 'applicationSchemaInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdapplicationSchemaInfo', True)

    
    applicationSchemaInfo = property(__applicationSchemaInfo.value, __applicationSchemaInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dateStamp uses Python identifier dateStamp
    __dateStamp = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dateStamp'), 'dateStamp', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmddateStamp', False)

    
    dateStamp = property(__dateStamp.value, __dateStamp.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}describes uses Python identifier describes
    __describes = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'describes'), 'describes', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmddescribes', True)

    
    describes = property(__describes.value, __describes.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}metadataMaintenance uses Python identifier metadataMaintenance
    __metadataMaintenance = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'metadataMaintenance'), 'metadataMaintenance', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdmetadataMaintenance', False)

    
    metadataMaintenance = property(__metadataMaintenance.value, __metadataMaintenance.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}propertyType uses Python identifier propertyType
    __propertyType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'propertyType'), 'propertyType', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdpropertyType', True)

    
    propertyType = property(__propertyType.value, __propertyType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}featureType uses Python identifier featureType
    __featureType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'featureType'), 'featureType', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdfeatureType', True)

    
    featureType = property(__featureType.value, __featureType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dataSetURI uses Python identifier dataSetURI
    __dataSetURI = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dataSetURI'), 'dataSetURI', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmddataSetURI', False)

    
    dataSetURI = property(__dataSetURI.value, __dataSetURI.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}featureAttribute uses Python identifier featureAttribute
    __featureAttribute = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'featureAttribute'), 'featureAttribute', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdfeatureAttribute', True)

    
    featureAttribute = property(__featureAttribute.value, __featureAttribute.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}locale uses Python identifier locale
    __locale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'locale'), 'locale', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdlocale', True)

    
    locale = property(__locale.value, __locale.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}spatialRepresentationInfo uses Python identifier spatialRepresentationInfo
    __spatialRepresentationInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'spatialRepresentationInfo'), 'spatialRepresentationInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdspatialRepresentationInfo', True)

    
    spatialRepresentationInfo = property(__spatialRepresentationInfo.value, __spatialRepresentationInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}referenceSystemInfo uses Python identifier referenceSystemInfo
    __referenceSystemInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'referenceSystemInfo'), 'referenceSystemInfo', '__httpwww_isotc211_org2005gmd_MD_Metadata_Type_httpwww_isotc211_org2005gmdreferenceSystemInfo', True)

    
    referenceSystemInfo = property(__referenceSystemInfo.value, __referenceSystemInfo.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __series.name() : __series,
        __identificationInfo.name() : __identificationInfo,
        __language.name() : __language,
        __characterSet.name() : __characterSet,
        __parentIdentifier.name() : __parentIdentifier,
        __contentInfo.name() : __contentInfo,
        __hierarchyLevel.name() : __hierarchyLevel,
        __hierarchyLevelName.name() : __hierarchyLevelName,
        __metadataStandardName.name() : __metadataStandardName,
        __contact.name() : __contact,
        __metadataStandardVersion.name() : __metadataStandardVersion,
        __metadataExtensionInfo.name() : __metadataExtensionInfo,
        __fileIdentifier.name() : __fileIdentifier,
        __distributionInfo.name() : __distributionInfo,
        __dataQualityInfo.name() : __dataQualityInfo,
        __portrayalCatalogueInfo.name() : __portrayalCatalogueInfo,
        __metadataConstraints.name() : __metadataConstraints,
        __applicationSchemaInfo.name() : __applicationSchemaInfo,
        __dateStamp.name() : __dateStamp,
        __describes.name() : __describes,
        __metadataMaintenance.name() : __metadataMaintenance,
        __propertyType.name() : __propertyType,
        __featureType.name() : __featureType,
        __dataSetURI.name() : __dataSetURI,
        __featureAttribute.name() : __featureAttribute,
        __locale.name() : __locale,
        __spatialRepresentationInfo.name() : __spatialRepresentationInfo,
        __referenceSystemInfo.name() : __referenceSystemInfo
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Metadata_Type', MD_Metadata_Type)


# Complex type ImageDatumPropertyType with content type ELEMENT_ONLY
class ImageDatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageDatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ImageDatum uses Python identifier ImageDatum
    __ImageDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ImageDatum'), 'ImageDatum', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_opengis_netgml3_2ImageDatum', False)

    
    ImageDatum = property(__ImageDatum.value, __ImageDatum.set, None, u'gml:ImageDatum defines the origin of an image coordinate reference system, and is used in a local context only. For an image datum, the anchor definition is usually either the centre of the image or the corner of the image. For more information, see ISO 19111 B.3.5.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ImageDatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __ImageDatum.name() : __ImageDatum
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __role.name() : __role,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ImageDatumPropertyType', ImageDatumPropertyType)


# Complex type TimeInstantPropertyType with content type ELEMENT_ONLY
class TimeInstantPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeInstantPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeInstant uses Python identifier TimeInstant
    __TimeInstant = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeInstant'), 'TimeInstant', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_opengis_netgml3_2TimeInstant', False)

    
    TimeInstant = property(__TimeInstant.value, __TimeInstant.set, None, u'gml:TimeInstant acts as a zero-dimensional geometric primitive that represents an identifiable position in time.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeInstantPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __TimeInstant.name() : __TimeInstant
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __owns.name() : __owns,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeInstantPropertyType', TimeInstantPropertyType)


# Complex type LocationPropertyType with content type ELEMENT_ONLY
class LocationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}LocationString uses Python identifier LocationString
    __LocationString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationString'), 'LocationString', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2LocationString', False)

    
    LocationString = property(__LocationString.value, __LocationString.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}LocationKeyWord uses Python identifier LocationKeyWord
    __LocationKeyWord = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'LocationKeyWord'), 'LocationKeyWord', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2LocationKeyWord', False)

    
    LocationKeyWord = property(__LocationKeyWord.value, __LocationKeyWord.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}Null uses Python identifier Null
    __Null = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Null'), 'Null', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2Null', False)

    
    Null = property(__Null.value, __Null.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_LocationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_LocationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __LocationString.name() : __LocationString,
        __LocationKeyWord.name() : __LocationKeyWord,
        __Null.name() : __Null,
        __AbstractGeometry.name() : __AbstractGeometry
    }
    _AttributeMap = {
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'LocationPropertyType', LocationPropertyType)


# Complex type UnitDefinitionType with content type ELEMENT_ONLY
class UnitDefinitionType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UnitDefinitionType')
    # Base type is DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}catalogSymbol uses Python identifier catalogSymbol
    __catalogSymbol = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'catalogSymbol'), 'catalogSymbol', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2catalogSymbol', False)

    
    catalogSymbol = property(__catalogSymbol.value, __catalogSymbol.set, None, u'The catalogSymbol is the preferred lexical symbol used for this unit of measure.\nThe codeSpace attribute in gml:CodeType identifies a namespace for the catalog symbol value, and might reference the external catalog. The string value in gml:CodeType contains the value of a symbol that should be unique within this catalog namespace. This symbol often appears explicitly in the catalog, but it could be a combination of symbols using a specified algebra of units.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}quantityTypeReference uses Python identifier quantityTypeReference
    __quantityTypeReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'quantityTypeReference'), 'quantityTypeReference', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2quantityTypeReference', False)

    
    quantityTypeReference = property(__quantityTypeReference.value, __quantityTypeReference.set, None, u'The gml:quantityTypeReference property indicates the phenomenon to which the units apply. The content is a reference to a remote value.')

    
    # Element {http://www.opengis.net/gml/3.2}quantityType uses Python identifier quantityType
    __quantityType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'quantityType'), 'quantityType', '__httpwww_opengis_netgml3_2_UnitDefinitionType_httpwww_opengis_netgml3_2quantityType', False)

    
    quantityType = property(__quantityType.value, __quantityType.set, None, u'The gml:quantityType property indicates the phenomenon to which the units apply. This element contains an informal description of the phenomenon or type of physical quantity that is measured or observed. When the physical quantity is the result of an observation or measurement, this term is known as observable type or measurand.\nThe use of gml:quantityType for references to remote values is deprecated.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        __catalogSymbol.name() : __catalogSymbol,
        __quantityTypeReference.name() : __quantityTypeReference,
        __quantityType.name() : __quantityType
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'UnitDefinitionType', UnitDefinitionType)


# Complex type DirectPositionType with content type SIMPLE
class DirectPositionType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = doubleList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectPositionType')
    # Base type is doubleList
    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_DirectPositionType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_DirectPositionType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_DirectPositionType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_DirectPositionType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __axisLabels.name() : __axisLabels,
        __uomLabels.name() : __uomLabels,
        __srsName.name() : __srsName,
        __srsDimension.name() : __srsDimension
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectPositionType', DirectPositionType)


# Complex type Integer_PropertyType with content type ELEMENT_ONLY
class Integer_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Integer_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Integer uses Python identifier Integer
    __Integer = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Integer'), 'Integer', '__httpwww_isotc211_org2005gco_Integer_PropertyType_httpwww_isotc211_org2005gcoInteger', False)

    
    Integer = property(__Integer.value, __Integer.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Integer_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Integer.name() : __Integer
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Integer_PropertyType', Integer_PropertyType)


# Complex type CompoundCRSType with content type ELEMENT_ONLY
class CompoundCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompoundCRSType')
    # Base type is AbstractCRSType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}componentReferenceSystem uses Python identifier componentReferenceSystem
    __componentReferenceSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'componentReferenceSystem'), 'componentReferenceSystem', '__httpwww_opengis_netgml3_2_CompoundCRSType_httpwww_opengis_netgml3_2componentReferenceSystem', True)

    
    componentReferenceSystem = property(__componentReferenceSystem.value, __componentReferenceSystem.set, None, u'The gml:componentReferenceSystem elements are an ordered sequence of associations to all the component coordinate reference systems included in this compound coordinate reference system. The gml:AggregationAttributeGroup should be used to specify that the gml:componentReferenceSystem properties are ordered.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_CompoundCRSType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __componentReferenceSystem.name() : __componentReferenceSystem
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CompoundCRSType', CompoundCRSType)


# Complex type CoordinateSystemAxisPropertyType with content type ELEMENT_ONLY
class CoordinateSystemAxisPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemAxisPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CoordinateSystemAxis uses Python identifier CoordinateSystemAxis
    __CoordinateSystemAxis = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemAxis'), 'CoordinateSystemAxis', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_opengis_netgml3_2CoordinateSystemAxis', False)

    
    CoordinateSystemAxis = property(__CoordinateSystemAxis.value, __CoordinateSystemAxis.set, None, u'gml:CoordinateSystemAxis is a definition of a coordinate system axis.')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CoordinateSystemAxisPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __CoordinateSystemAxis.name() : __CoordinateSystemAxis
    }
    _AttributeMap = {
        __type.name() : __type,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateSystemAxisPropertyType', CoordinateSystemAxisPropertyType)


# Complex type GeodeticCRSType with content type ELEMENT_ONLY
class GeodeticCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeodeticCRSType')
    # Base type is AbstractCRSType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}ellipsoidalCS uses Python identifier ellipsoidalCS
    __ellipsoidalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ellipsoidalCS'), 'ellipsoidalCS', '__httpwww_opengis_netgml3_2_GeodeticCRSType_httpwww_opengis_netgml3_2ellipsoidalCS', False)

    
    ellipsoidalCS = property(__ellipsoidalCS.value, __ellipsoidalCS.set, None, u'gml:ellipsoidalCS is an association role to the ellipsoidal coordinate system used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}cartesianCS uses Python identifier cartesianCS
    __cartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'cartesianCS'), 'cartesianCS', '__httpwww_opengis_netgml3_2_GeodeticCRSType_httpwww_opengis_netgml3_2cartesianCS', False)

    
    cartesianCS = property(__cartesianCS.value, __cartesianCS.set, None, u'gml:cartesianCS is an association role to the Cartesian coordinate system used by this CRS.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}geodeticDatum uses Python identifier geodeticDatum
    __geodeticDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'geodeticDatum'), 'geodeticDatum', '__httpwww_opengis_netgml3_2_GeodeticCRSType_httpwww_opengis_netgml3_2geodeticDatum', False)

    
    geodeticDatum = property(__geodeticDatum.value, __geodeticDatum.set, None, u'gml:geodeticDatum is an association role to the geodetic datum used by this CRS.\n')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}sphericalCS uses Python identifier sphericalCS
    __sphericalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sphericalCS'), 'sphericalCS', '__httpwww_opengis_netgml3_2_GeodeticCRSType_httpwww_opengis_netgml3_2sphericalCS', False)

    
    sphericalCS = property(__sphericalCS.value, __sphericalCS.set, None, u'gml:sphericalCS is an association role to the spherical coordinate system used by this CRS.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __ellipsoidalCS.name() : __ellipsoidalCS,
        __cartesianCS.name() : __cartesianCS,
        __geodeticDatum.name() : __geodeticDatum,
        __sphericalCS.name() : __sphericalCS
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'GeodeticCRSType', GeodeticCRSType)


# Complex type Record_PropertyType with content type ELEMENT_ONLY
class Record_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Record_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Record uses Python identifier Record
    __Record = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Record'), 'Record', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_isotc211_org2005gcoRecord', False)

    
    Record = property(__Record.value, __Record.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gco_Record_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gco_Record_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)


    _ElementMap = {
        __Record.name() : __Record
    }
    _AttributeMap = {
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __show.name() : __show,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __uuidref.name() : __uuidref
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Record_PropertyType', Record_PropertyType)


# Complex type DirectedFacePropertyType with content type ELEMENT_ONLY
class DirectedFacePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedFacePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Face uses Python identifier Face
    __Face = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Face'), 'Face', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_opengis_netgml3_2Face', False)

    
    Face = property(__Face.value, __Face.set, None, u'gml:Face represents the 2-dimensional topology primitive.\nThe topological boundary of a face (gml:directedEdge) consists of a sequence of directed edges. If provided, the aggregationType attribute shall have the value "sequence".\nThe optional coboundary of a face (gml:directedTopoSolid) is a pair of directed solids which are bounded by this face. A positively directed solid corresponds to a solid which lies in the direction of the negatively directed normal to the face in any geometric realisation. \nA face may optionally be realised by a 2-dimensional geometric primitive (gml:surfaceProperty).')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectedFacePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __Face.name() : __Face
    }
    _AttributeMap = {
        __title.name() : __title,
        __role.name() : __role,
        __owns.name() : __owns,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __remoteSchema.name() : __remoteSchema,
        __orientation.name() : __orientation,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedFacePropertyType', DirectedFacePropertyType)


# Complex type TimeIntervalLengthType with content type SIMPLE
class TimeIntervalLengthType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.decimal
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeIntervalLengthType')
    # Base type is pyxb.binding.datatypes.decimal
    
    # Attribute unit uses Python identifier unit
    __unit = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'unit'), 'unit', '__httpwww_opengis_netgml3_2_TimeIntervalLengthType_unit', TimeUnitType, required=True)
    
    unit = property(__unit.value, __unit.set, None, None)

    
    # Attribute factor uses Python identifier factor
    __factor = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'factor'), 'factor', '__httpwww_opengis_netgml3_2_TimeIntervalLengthType_factor', pyxb.binding.datatypes.integer)
    
    factor = property(__factor.value, __factor.set, None, None)

    
    # Attribute radix uses Python identifier radix
    __radix = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'radix'), 'radix', '__httpwww_opengis_netgml3_2_TimeIntervalLengthType_radix', pyxb.binding.datatypes.positiveInteger)
    
    radix = property(__radix.value, __radix.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __unit.name() : __unit,
        __factor.name() : __factor,
        __radix.name() : __radix
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeIntervalLengthType', TimeIntervalLengthType)


# Complex type AbstractFeatureType with content type ELEMENT_ONLY
class AbstractFeatureType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeatureType')
    # Base type is AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}location uses Python identifier location
    __location = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'location'), 'location', '__httpwww_opengis_netgml3_2_AbstractFeatureType_httpwww_opengis_netgml3_2location', False)

    
    location = property(__location.value, __location.set, None, u'')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}boundedBy uses Python identifier boundedBy
    __boundedBy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'boundedBy'), 'boundedBy', '__httpwww_opengis_netgml3_2_AbstractFeatureType_httpwww_opengis_netgml3_2boundedBy', False)

    
    boundedBy = property(__boundedBy.value, __boundedBy.set, None, u'This property describes the minimum bounding box or rectangle that encloses the entire feature.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        __location.name() : __location,
        __boundedBy.name() : __boundedBy
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractFeatureType', AbstractFeatureType)


# Complex type ObservationType with content type ELEMENT_ONLY
class ObservationType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ObservationType')
    # Base type is AbstractFeatureType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}using uses Python identifier using
    __using = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'using'), 'using', '__httpwww_opengis_netgml3_2_ObservationType_httpwww_opengis_netgml3_2using', False)

    
    using = property(__using.value, __using.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}validTime uses Python identifier validTime
    __validTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'validTime'), 'validTime', '__httpwww_opengis_netgml3_2_ObservationType_httpwww_opengis_netgml3_2validTime', False)

    
    validTime = property(__validTime.value, __validTime.set, None, u'gml:validTime is a convenience property element.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element {http://www.opengis.net/gml/3.2}target uses Python identifier target
    __target = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'target'), 'target', '__httpwww_opengis_netgml3_2_ObservationType_httpwww_opengis_netgml3_2target', False)

    
    target = property(__target.value, __target.set, None, None)

    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}resultOf uses Python identifier resultOf
    __resultOf = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'resultOf'), 'resultOf', '__httpwww_opengis_netgml3_2_ObservationType_httpwww_opengis_netgml3_2resultOf', False)

    
    resultOf = property(__resultOf.value, __resultOf.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        __using.name() : __using,
        __validTime.name() : __validTime,
        __target.name() : __target,
        __resultOf.name() : __resultOf
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ObservationType', ObservationType)


# Complex type TM_Primitive_PropertyType with content type ELEMENT_ONLY
class TM_Primitive_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gts, u'TM_Primitive_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractTimePrimitive uses Python identifier AbstractTimePrimitive
    __AbstractTimePrimitive = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimePrimitive'), 'AbstractTimePrimitive', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_opengis_netgml3_2AbstractTimePrimitive', False)

    
    AbstractTimePrimitive = property(__AbstractTimePrimitive.value, __AbstractTimePrimitive.set, None, u'gml:AbstractTimePrimitive acts as the head of a substitution group for geometric and topological temporal primitives.')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gts_TM_Primitive_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractTimePrimitive.name() : __AbstractTimePrimitive
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __show.name() : __show
    }
_Namespace_gts.addCategoryObject('typeBinding', u'TM_Primitive_PropertyType', TM_Primitive_PropertyType)


# Complex type MeasureOrNilReasonListType with content type SIMPLE
class MeasureOrNilReasonListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = doubleOrNilReasonList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MeasureOrNilReasonListType')
    # Base type is doubleOrNilReasonList
    
    # Attribute uom uses Python identifier uom
    __uom = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uom'), 'uom', '__httpwww_opengis_netgml3_2_MeasureOrNilReasonListType_uom', UomIdentifier, required=True)
    
    uom = property(__uom.value, __uom.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uom.name() : __uom
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MeasureOrNilReasonListType', MeasureOrNilReasonListType)


# Complex type DQ_PositionalAccuracy_PropertyType with content type ELEMENT_ONLY
class DQ_PositionalAccuracy_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_PositionalAccuracy_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractDQ_PositionalAccuracy uses Python identifier AbstractDQ_PositionalAccuracy
    __AbstractDQ_PositionalAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_PositionalAccuracy'), 'AbstractDQ_PositionalAccuracy', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_isotc211_org2005gmdAbstractDQ_PositionalAccuracy', False)

    
    AbstractDQ_PositionalAccuracy = property(__AbstractDQ_PositionalAccuracy.value, __AbstractDQ_PositionalAccuracy.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_PositionalAccuracy_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __AbstractDQ_PositionalAccuracy.name() : __AbstractDQ_PositionalAccuracy
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_PositionalAccuracy_PropertyType', DQ_PositionalAccuracy_PropertyType)


# Complex type CTD_ANON_1 with content type ELEMENT_ONLY
class CTD_ANON_1 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_CTD_ANON_1_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')


    _ElementMap = {
        __pos.name() : __pos,
        __posList.name() : __posList,
        __pointProperty.name() : __pointProperty
    }
    _AttributeMap = {
        
    }



# Complex type MD_MaintenanceInformation_Type with content type ELEMENT_ONLY
class MD_MaintenanceInformation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_MaintenanceInformation_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}updateScope uses Python identifier updateScope
    __updateScope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'updateScope'), 'updateScope', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_Type_httpwww_isotc211_org2005gmdupdateScope', True)

    
    updateScope = property(__updateScope.value, __updateScope.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}userDefinedMaintenanceFrequency uses Python identifier userDefinedMaintenanceFrequency
    __userDefinedMaintenanceFrequency = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'userDefinedMaintenanceFrequency'), 'userDefinedMaintenanceFrequency', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_Type_httpwww_isotc211_org2005gmduserDefinedMaintenanceFrequency', False)

    
    userDefinedMaintenanceFrequency = property(__userDefinedMaintenanceFrequency.value, __userDefinedMaintenanceFrequency.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}updateScopeDescription uses Python identifier updateScopeDescription
    __updateScopeDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'updateScopeDescription'), 'updateScopeDescription', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_Type_httpwww_isotc211_org2005gmdupdateScopeDescription', True)

    
    updateScopeDescription = property(__updateScopeDescription.value, __updateScopeDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}maintenanceNote uses Python identifier maintenanceNote
    __maintenanceNote = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'maintenanceNote'), 'maintenanceNote', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_Type_httpwww_isotc211_org2005gmdmaintenanceNote', True)

    
    maintenanceNote = property(__maintenanceNote.value, __maintenanceNote.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}contact uses Python identifier contact
    __contact = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contact'), 'contact', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_Type_httpwww_isotc211_org2005gmdcontact', True)

    
    contact = property(__contact.value, __contact.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}maintenanceAndUpdateFrequency uses Python identifier maintenanceAndUpdateFrequency
    __maintenanceAndUpdateFrequency = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'maintenanceAndUpdateFrequency'), 'maintenanceAndUpdateFrequency', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_Type_httpwww_isotc211_org2005gmdmaintenanceAndUpdateFrequency', False)

    
    maintenanceAndUpdateFrequency = property(__maintenanceAndUpdateFrequency.value, __maintenanceAndUpdateFrequency.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dateOfNextUpdate uses Python identifier dateOfNextUpdate
    __dateOfNextUpdate = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dateOfNextUpdate'), 'dateOfNextUpdate', '__httpwww_isotc211_org2005gmd_MD_MaintenanceInformation_Type_httpwww_isotc211_org2005gmddateOfNextUpdate', False)

    
    dateOfNextUpdate = property(__dateOfNextUpdate.value, __dateOfNextUpdate.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __updateScope.name() : __updateScope,
        __userDefinedMaintenanceFrequency.name() : __userDefinedMaintenanceFrequency,
        __updateScopeDescription.name() : __updateScopeDescription,
        __maintenanceNote.name() : __maintenanceNote,
        __contact.name() : __contact,
        __maintenanceAndUpdateFrequency.name() : __maintenanceAndUpdateFrequency,
        __dateOfNextUpdate.name() : __dateOfNextUpdate
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_MaintenanceInformation_Type', MD_MaintenanceInformation_Type)


# Complex type CI_Citation_PropertyType with content type ELEMENT_ONLY
class CI_Citation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Citation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_Citation uses Python identifier CI_Citation
    __CI_Citation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Citation'), 'CI_Citation', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_isotc211_org2005gmdCI_Citation', False)

    
    CI_Citation = property(__CI_Citation.value, __CI_Citation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_Citation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)


    _ElementMap = {
        __CI_Citation.name() : __CI_Citation
    }
    _AttributeMap = {
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __uuidref.name() : __uuidref
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_Citation_PropertyType', CI_Citation_PropertyType)


# Complex type MD_ExtendedElementInformation_Type with content type ELEMENT_ONLY
class MD_ExtendedElementInformation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ExtendedElementInformation_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}domainCode uses Python identifier domainCode
    __domainCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'domainCode'), 'domainCode', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmddomainCode', False)

    
    domainCode = property(__domainCode.value, __domainCode.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}source uses Python identifier source
    __source = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'source'), 'source', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdsource', True)

    
    source = property(__source.value, __source.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}definition uses Python identifier definition
    __definition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'definition'), 'definition', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmddefinition', False)

    
    definition = property(__definition.value, __definition.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}obligation uses Python identifier obligation
    __obligation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'obligation'), 'obligation', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdobligation', False)

    
    obligation = property(__obligation.value, __obligation.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dataType uses Python identifier dataType
    __dataType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dataType'), 'dataType', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmddataType', False)

    
    dataType = property(__dataType.value, __dataType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}condition uses Python identifier condition
    __condition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'condition'), 'condition', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdcondition', False)

    
    condition = property(__condition.value, __condition.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}maximumOccurrence uses Python identifier maximumOccurrence
    __maximumOccurrence = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'maximumOccurrence'), 'maximumOccurrence', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdmaximumOccurrence', False)

    
    maximumOccurrence = property(__maximumOccurrence.value, __maximumOccurrence.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'name'), 'name', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdname', False)

    
    name = property(__name.value, __name.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}parentEntity uses Python identifier parentEntity
    __parentEntity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'parentEntity'), 'parentEntity', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdparentEntity', True)

    
    parentEntity = property(__parentEntity.value, __parentEntity.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}rationale uses Python identifier rationale
    __rationale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'rationale'), 'rationale', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdrationale', True)

    
    rationale = property(__rationale.value, __rationale.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}shortName uses Python identifier shortName
    __shortName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'shortName'), 'shortName', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdshortName', False)

    
    shortName = property(__shortName.value, __shortName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}rule uses Python identifier rule
    __rule = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'rule'), 'rule', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmdrule', False)

    
    rule = property(__rule.value, __rule.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}domainValue uses Python identifier domainValue
    __domainValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'domainValue'), 'domainValue', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_Type_httpwww_isotc211_org2005gmddomainValue', False)

    
    domainValue = property(__domainValue.value, __domainValue.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __domainCode.name() : __domainCode,
        __source.name() : __source,
        __definition.name() : __definition,
        __obligation.name() : __obligation,
        __dataType.name() : __dataType,
        __condition.name() : __condition,
        __maximumOccurrence.name() : __maximumOccurrence,
        __name.name() : __name,
        __parentEntity.name() : __parentEntity,
        __rationale.name() : __rationale,
        __shortName.name() : __shortName,
        __rule.name() : __rule,
        __domainValue.name() : __domainValue
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ExtendedElementInformation_Type', MD_ExtendedElementInformation_Type)


# Complex type MeasureType with content type SIMPLE
class MeasureType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MeasureType')
    # Base type is pyxb.binding.datatypes.double
    
    # Attribute uom uses Python identifier uom
    __uom = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uom'), 'uom', '__httpwww_opengis_netgml3_2_MeasureType_uom', UomIdentifier, required=True)
    
    uom = property(__uom.value, __uom.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uom.name() : __uom
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MeasureType', MeasureType)


# Complex type ScaleType with content type SIMPLE
class ScaleType (MeasureType):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ScaleType')
    # Base type is MeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}MeasureType

    _ElementMap = MeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = MeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ScaleType', ScaleType)


# Complex type MD_RangeDimension_Type with content type ELEMENT_ONLY
class MD_RangeDimension_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_RangeDimension_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}sequenceIdentifier uses Python identifier sequenceIdentifier
    __sequenceIdentifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sequenceIdentifier'), 'sequenceIdentifier', '__httpwww_isotc211_org2005gmd_MD_RangeDimension_Type_httpwww_isotc211_org2005gmdsequenceIdentifier', False)

    
    sequenceIdentifier = property(__sequenceIdentifier.value, __sequenceIdentifier.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}descriptor uses Python identifier descriptor
    __descriptor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'descriptor'), 'descriptor', '__httpwww_isotc211_org2005gmd_MD_RangeDimension_Type_httpwww_isotc211_org2005gmddescriptor', False)

    
    descriptor = property(__descriptor.value, __descriptor.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __sequenceIdentifier.name() : __sequenceIdentifier,
        __descriptor.name() : __descriptor
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_RangeDimension_Type', MD_RangeDimension_Type)


# Complex type MD_Band_Type with content type ELEMENT_ONLY
class MD_Band_Type (MD_RangeDimension_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Band_Type')
    # Base type is MD_RangeDimension_Type
    
    # Element {http://www.isotc211.org/2005/gmd}scaleFactor uses Python identifier scaleFactor
    __scaleFactor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'scaleFactor'), 'scaleFactor', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdscaleFactor', False)

    
    scaleFactor = property(__scaleFactor.value, __scaleFactor.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}offset uses Python identifier offset
    __offset = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'offset'), 'offset', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdoffset', False)

    
    offset = property(__offset.value, __offset.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}maxValue uses Python identifier maxValue
    __maxValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'maxValue'), 'maxValue', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdmaxValue', False)

    
    maxValue = property(__maxValue.value, __maxValue.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}minValue uses Python identifier minValue
    __minValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'minValue'), 'minValue', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdminValue', False)

    
    minValue = property(__minValue.value, __minValue.set, None, None)

    
    # Element sequenceIdentifier ({http://www.isotc211.org/2005/gmd}sequenceIdentifier) inherited from {http://www.isotc211.org/2005/gmd}MD_RangeDimension_Type
    
    # Element {http://www.isotc211.org/2005/gmd}units uses Python identifier units
    __units = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'units'), 'units', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdunits', False)

    
    units = property(__units.value, __units.set, None, None)

    
    # Element descriptor ({http://www.isotc211.org/2005/gmd}descriptor) inherited from {http://www.isotc211.org/2005/gmd}MD_RangeDimension_Type
    
    # Element {http://www.isotc211.org/2005/gmd}peakResponse uses Python identifier peakResponse
    __peakResponse = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'peakResponse'), 'peakResponse', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdpeakResponse', False)

    
    peakResponse = property(__peakResponse.value, __peakResponse.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}bitsPerValue uses Python identifier bitsPerValue
    __bitsPerValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'bitsPerValue'), 'bitsPerValue', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdbitsPerValue', False)

    
    bitsPerValue = property(__bitsPerValue.value, __bitsPerValue.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}toneGradation uses Python identifier toneGradation
    __toneGradation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'toneGradation'), 'toneGradation', '__httpwww_isotc211_org2005gmd_MD_Band_Type_httpwww_isotc211_org2005gmdtoneGradation', False)

    
    toneGradation = property(__toneGradation.value, __toneGradation.set, None, None)

    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = MD_RangeDimension_Type._ElementMap.copy()
    _ElementMap.update({
        __scaleFactor.name() : __scaleFactor,
        __offset.name() : __offset,
        __maxValue.name() : __maxValue,
        __minValue.name() : __minValue,
        __units.name() : __units,
        __peakResponse.name() : __peakResponse,
        __bitsPerValue.name() : __bitsPerValue,
        __toneGradation.name() : __toneGradation
    })
    _AttributeMap = MD_RangeDimension_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Band_Type', MD_Band_Type)


# Complex type MultiSurfacePropertyType with content type ELEMENT_ONLY
class MultiSurfacePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiSurfacePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}MultiSurface uses Python identifier MultiSurface
    __MultiSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiSurface'), 'MultiSurface', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_opengis_netgml3_2MultiSurface', False)

    
    MultiSurface = property(__MultiSurface.value, __MultiSurface.set, None, u'A gml:MultiSurface is defined by one or more gml:AbstractSurfaces.\nThe members of the geometric aggregate may be specified either using the "standard" property (gml:surfaceMember) or the array property (gml:surfaceMembers). It is also valid to use both the "standard" and the array properties in the same collection.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_MultiSurfacePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __MultiSurface.name() : __MultiSurface
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MultiSurfacePropertyType', MultiSurfacePropertyType)


# Complex type CTD_ANON_2 with content type SIMPLE
class CTD_ANON_2 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.boolean
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.boolean
    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_2_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }



# Complex type OperationPropertyType with content type ELEMENT_ONLY
class OperationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractOperation uses Python identifier AbstractOperation
    __AbstractOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractOperation'), 'AbstractOperation', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_opengis_netgml3_2AbstractOperation', False)

    
    AbstractOperation = property(__AbstractOperation.value, __AbstractOperation.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_OperationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_OperationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __AbstractOperation.name() : __AbstractOperation
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'OperationPropertyType', OperationPropertyType)


# Complex type TimePositionType with content type SIMPLE
class TimePositionType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = TimePositionUnion
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePositionType')
    # Base type is TimePositionUnion
    
    # Attribute indeterminatePosition uses Python identifier indeterminatePosition
    __indeterminatePosition = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'indeterminatePosition'), 'indeterminatePosition', '__httpwww_opengis_netgml3_2_TimePositionType_indeterminatePosition', TimeIndeterminateValueType)
    
    indeterminatePosition = property(__indeterminatePosition.value, __indeterminatePosition.set, None, None)

    
    # Attribute frame uses Python identifier frame
    __frame = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'frame'), 'frame', '__httpwww_opengis_netgml3_2_TimePositionType_frame', pyxb.binding.datatypes.anyURI, unicode_default=u'#ISO-8601')
    
    frame = property(__frame.value, __frame.set, None, None)

    
    # Attribute calendarEraName uses Python identifier calendarEraName
    __calendarEraName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'calendarEraName'), 'calendarEraName', '__httpwww_opengis_netgml3_2_TimePositionType_calendarEraName', pyxb.binding.datatypes.string)
    
    calendarEraName = property(__calendarEraName.value, __calendarEraName.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __indeterminatePosition.name() : __indeterminatePosition,
        __frame.name() : __frame,
        __calendarEraName.name() : __calendarEraName
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimePositionType', TimePositionType)


# Complex type AbstractTopologyType with content type ELEMENT_ONLY
class AbstractTopologyType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTopologyType')
    # Base type is AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTopologyType', AbstractTopologyType)


# Complex type AbstractTopoPrimitiveType with content type ELEMENT_ONLY
class AbstractTopoPrimitiveType (AbstractTopologyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTopoPrimitiveType')
    # Base type is AbstractTopologyType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopologyType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractTopologyType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTopoPrimitiveType', AbstractTopoPrimitiveType)


# Complex type NodeType with content type ELEMENT_ONLY
class NodeType (AbstractTopoPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'NodeType')
    # Base type is AbstractTopoPrimitiveType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}container uses Python identifier container
    __container = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'container'), 'container', '__httpwww_opengis_netgml3_2_NodeType_httpwww_opengis_netgml3_2container', False)

    
    container = property(__container.value, __container.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}directedEdge uses Python identifier directedEdge
    __directedEdge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedEdge'), 'directedEdge', '__httpwww_opengis_netgml3_2_NodeType_httpwww_opengis_netgml3_2directedEdge', True)

    
    directedEdge = property(__directedEdge.value, __directedEdge.set, None, u'A gml:directedEdge property element describes the boundary of topology faces, the coBoundary of topology nodes and is used in the support of topological line features via the gml:TopoCurve expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included edge is used, i.e. forward or reverse.')

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_NodeType_httpwww_opengis_netgml3_2pointProperty', False)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_NodeType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopoPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __container.name() : __container,
        __directedEdge.name() : __directedEdge,
        __pointProperty.name() : __pointProperty
    })
    _AttributeMap = AbstractTopoPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'NodeType', NodeType)


# Complex type AngleType with content type SIMPLE
class AngleType (MeasureType):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AngleType')
    # Base type is MeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}MeasureType

    _ElementMap = MeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = MeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AngleType', AngleType)


# Complex type MD_ReferenceSystem_Type with content type ELEMENT_ONLY
class MD_ReferenceSystem_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ReferenceSystem_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}referenceSystemIdentifier uses Python identifier referenceSystemIdentifier
    __referenceSystemIdentifier = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'referenceSystemIdentifier'), 'referenceSystemIdentifier', '__httpwww_isotc211_org2005gmd_MD_ReferenceSystem_Type_httpwww_isotc211_org2005gmdreferenceSystemIdentifier', False)

    
    referenceSystemIdentifier = property(__referenceSystemIdentifier.value, __referenceSystemIdentifier.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __referenceSystemIdentifier.name() : __referenceSystemIdentifier
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ReferenceSystem_Type', MD_ReferenceSystem_Type)


# Complex type CurveSegmentArrayPropertyType with content type ELEMENT_ONLY
class CurveSegmentArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurveSegmentArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCurveSegment uses Python identifier AbstractCurveSegment
    __AbstractCurveSegment = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurveSegment'), 'AbstractCurveSegment', '__httpwww_opengis_netgml3_2_CurveSegmentArrayPropertyType_httpwww_opengis_netgml3_2AbstractCurveSegment', True)

    
    AbstractCurveSegment = property(__AbstractCurveSegment.value, __AbstractCurveSegment.set, None, u'A curve segment defines a homogeneous segment of a curve.\nThe attributes numDerivativesAtStart, numDerivativesAtEnd and numDerivativesInterior specify the type of continuity as specified in ISO 19107:2003, 6.4.9.3.\nThe AbstractCurveSegment element is the abstract head of the substituition group for all curve segment elements, i.e. continuous segments of the same interpolation mechanism.\nAll curve segments shall have an attribute interpolation with type gml:CurveInterpolationType specifying the curve interpolation mechanism used for this segment. This mechanism uses the control points and control parameters to determine the position of this curve segment.')


    _ElementMap = {
        __AbstractCurveSegment.name() : __AbstractCurveSegment
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CurveSegmentArrayPropertyType', CurveSegmentArrayPropertyType)


# Complex type CharacterString_PropertyType with content type ELEMENT_ONLY
class CharacterString_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'CharacterString_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}CharacterString uses Python identifier CharacterString
    __CharacterString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'CharacterString'), 'CharacterString', '__httpwww_isotc211_org2005gco_CharacterString_PropertyType_httpwww_isotc211_org2005gcoCharacterString', False)

    
    CharacterString = property(__CharacterString.value, __CharacterString.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_CharacterString_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CharacterString.name() : __CharacterString
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'CharacterString_PropertyType', CharacterString_PropertyType)


# Complex type AssociationRoleType with content type ELEMENT_ONLY
class AssociationRoleType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AssociationRoleType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_AssociationRoleType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_AssociationRoleType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_AssociationRoleType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    _HasWildcardElement = True

    _ElementMap = {
        
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __role.name() : __role,
        __title.name() : __title,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AssociationRoleType', AssociationRoleType)


# Complex type Scale_PropertyType with content type ELEMENT_ONLY
class Scale_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Scale_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Scale uses Python identifier Scale
    __Scale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Scale'), 'Scale', '__httpwww_isotc211_org2005gco_Scale_PropertyType_httpwww_isotc211_org2005gcoScale', False)

    
    Scale = property(__Scale.value, __Scale.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Scale_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Scale.name() : __Scale
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Scale_PropertyType', Scale_PropertyType)


# Complex type CurvePropertyType with content type ELEMENT_ONLY
class CurvePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurvePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCurve uses Python identifier AbstractCurve
    __AbstractCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurve'), 'AbstractCurve', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_opengis_netgml3_2AbstractCurve', False)

    
    AbstractCurve = property(__AbstractCurve.value, __AbstractCurve.set, None, u'The AbstractCurve element is the abstract head of the substitution group for all (continuous) curve elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_CurvePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CurvePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CurvePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __AbstractCurve.name() : __AbstractCurve
    }
    _AttributeMap = {
        __show.name() : __show,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __owns.name() : __owns,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CurvePropertyType', CurvePropertyType)


# Complex type GeocentricCRSType with content type ELEMENT_ONLY
class GeocentricCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeocentricCRSType')
    # Base type is AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}usesGeodeticDatum uses Python identifier usesGeodeticDatum
    __usesGeodeticDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'usesGeodeticDatum'), 'usesGeodeticDatum', '__httpwww_opengis_netgml3_2_GeocentricCRSType_httpwww_opengis_netgml3_2usesGeodeticDatum', False)

    
    usesGeodeticDatum = property(__usesGeodeticDatum.value, __usesGeodeticDatum.set, None, u'')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}usesCartesianCS uses Python identifier usesCartesianCS
    __usesCartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'usesCartesianCS'), 'usesCartesianCS', '__httpwww_opengis_netgml3_2_GeocentricCRSType_httpwww_opengis_netgml3_2usesCartesianCS', False)

    
    usesCartesianCS = property(__usesCartesianCS.value, __usesCartesianCS.set, None, u'')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}usesSphericalCS uses Python identifier usesSphericalCS
    __usesSphericalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'usesSphericalCS'), 'usesSphericalCS', '__httpwww_opengis_netgml3_2_GeocentricCRSType_httpwww_opengis_netgml3_2usesSphericalCS', False)

    
    usesSphericalCS = property(__usesSphericalCS.value, __usesSphericalCS.set, None, u'')

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __usesGeodeticDatum.name() : __usesGeodeticDatum,
        __usesCartesianCS.name() : __usesCartesianCS,
        __usesSphericalCS.name() : __usesSphericalCS
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'GeocentricCRSType', GeocentricCRSType)


# Complex type TemporalCSPropertyType with content type ELEMENT_ONLY
class TemporalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TemporalCS uses Python identifier TemporalCS
    __TemporalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalCS'), 'TemporalCS', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_opengis_netgml3_2TemporalCS', False)

    
    TemporalCS = property(__TemporalCS.value, __TemporalCS.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TemporalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __TemporalCS.name() : __TemporalCS
    }
    _AttributeMap = {
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalCSPropertyType', TemporalCSPropertyType)


# Complex type MD_Usage_Type with content type ELEMENT_ONLY
class MD_Usage_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Usage_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}specificUsage uses Python identifier specificUsage
    __specificUsage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'specificUsage'), 'specificUsage', '__httpwww_isotc211_org2005gmd_MD_Usage_Type_httpwww_isotc211_org2005gmdspecificUsage', False)

    
    specificUsage = property(__specificUsage.value, __specificUsage.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}userContactInfo uses Python identifier userContactInfo
    __userContactInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'userContactInfo'), 'userContactInfo', '__httpwww_isotc211_org2005gmd_MD_Usage_Type_httpwww_isotc211_org2005gmduserContactInfo', True)

    
    userContactInfo = property(__userContactInfo.value, __userContactInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}userDeterminedLimitations uses Python identifier userDeterminedLimitations
    __userDeterminedLimitations = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'userDeterminedLimitations'), 'userDeterminedLimitations', '__httpwww_isotc211_org2005gmd_MD_Usage_Type_httpwww_isotc211_org2005gmduserDeterminedLimitations', False)

    
    userDeterminedLimitations = property(__userDeterminedLimitations.value, __userDeterminedLimitations.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}usageDateTime uses Python identifier usageDateTime
    __usageDateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'usageDateTime'), 'usageDateTime', '__httpwww_isotc211_org2005gmd_MD_Usage_Type_httpwww_isotc211_org2005gmdusageDateTime', False)

    
    usageDateTime = property(__usageDateTime.value, __usageDateTime.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __specificUsage.name() : __specificUsage,
        __userContactInfo.name() : __userContactInfo,
        __userDeterminedLimitations.name() : __userDeterminedLimitations,
        __usageDateTime.name() : __usageDateTime
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Usage_Type', MD_Usage_Type)


# Complex type ProjectedCRSPropertyType with content type ELEMENT_ONLY
class ProjectedCRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ProjectedCRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ProjectedCRS uses Python identifier ProjectedCRS
    __ProjectedCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ProjectedCRS'), 'ProjectedCRS', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_opengis_netgml3_2ProjectedCRS', False)

    
    ProjectedCRS = property(__ProjectedCRS.value, __ProjectedCRS.set, None, u'gml:ProjectedCRS is a 2D coordinate reference system used to approximate the shape of the earth on a planar surface, but in such a way that the distortion that is inherent to the approximation is carefully controlled and known. Distortion correction is commonly applied to calculated bearings and distances to produce values that are a close match to actual field values.')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ProjectedCRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __ProjectedCRS.name() : __ProjectedCRS
    }
    _AttributeMap = {
        __type.name() : __type,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ProjectedCRSPropertyType', ProjectedCRSPropertyType)


# Complex type ReferenceType with content type EMPTY
class ReferenceType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ReferenceType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ReferenceType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ReferenceType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ReferenceType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __role.name() : __role,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ReferenceType', ReferenceType)


# Complex type DQ_ThematicClassificationCorrectness_PropertyType with content type ELEMENT_ONLY
class DQ_ThematicClassificationCorrectness_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ThematicClassificationCorrectness_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_ThematicClassificationCorrectness uses Python identifier DQ_ThematicClassificationCorrectness
    __DQ_ThematicClassificationCorrectness = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ThematicClassificationCorrectness'), 'DQ_ThematicClassificationCorrectness', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_isotc211_org2005gmdDQ_ThematicClassificationCorrectness', False)

    
    DQ_ThematicClassificationCorrectness = property(__DQ_ThematicClassificationCorrectness.value, __DQ_ThematicClassificationCorrectness.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_ThematicClassificationCorrectness_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __DQ_ThematicClassificationCorrectness.name() : __DQ_ThematicClassificationCorrectness
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ThematicClassificationCorrectness_PropertyType', DQ_ThematicClassificationCorrectness_PropertyType)


# Complex type AbstractCoordinateSystemType with content type ELEMENT_ONLY
class AbstractCoordinateSystemType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateSystemType')
    # Base type is IdentifiedObjectType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}axis uses Python identifier axis
    __axis = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'axis'), 'axis', '__httpwww_opengis_netgml3_2_AbstractCoordinateSystemType_httpwww_opengis_netgml3_2axis', True)

    
    axis = property(__axis.value, __axis.set, None, u'The gml:axis property is an association role (ordered sequence) to the coordinate system axes included in this coordinate system. The coordinate values in a coordinate tuple shall be recorded in the order in which the coordinate system axes associations are recorded, whenever those coordinates use a coordinate reference system that uses this coordinate system. The gml:AggregationAttributeGroup should be used to specify that the axis objects are ordered.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_AbstractCoordinateSystemType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __axis.name() : __axis
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoordinateSystemType', AbstractCoordinateSystemType)


# Complex type UserDefinedCSType with content type ELEMENT_ONLY
class UserDefinedCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UserDefinedCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'UserDefinedCSType', UserDefinedCSType)


# Complex type SingleCRSPropertyType with content type ELEMENT_ONLY
class SingleCRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SingleCRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSingleCRS uses Python identifier AbstractSingleCRS
    __AbstractSingleCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSingleCRS'), 'AbstractSingleCRS', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_opengis_netgml3_2AbstractSingleCRS', False)

    
    AbstractSingleCRS = property(__AbstractSingleCRS.value, __AbstractSingleCRS.set, None, u'gml:AbstractSingleCRS implements a coordinate reference system consisting of one coordinate system and one datum (as opposed to a Compound CRS).')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SingleCRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __AbstractSingleCRS.name() : __AbstractSingleCRS
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __href.name() : __href,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SingleCRSPropertyType', SingleCRSPropertyType)


# Complex type TimeOrdinalEraType with content type ELEMENT_ONLY
class TimeOrdinalEraType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeOrdinalEraType')
    # Base type is DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}start uses Python identifier start
    __start = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'start'), 'start', '__httpwww_opengis_netgml3_2_TimeOrdinalEraType_httpwww_opengis_netgml3_2start', False)

    
    start = property(__start.value, __start.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}end uses Python identifier end
    __end = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'end'), 'end', '__httpwww_opengis_netgml3_2_TimeOrdinalEraType_httpwww_opengis_netgml3_2end', False)

    
    end = property(__end.value, __end.set, None, None)

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}extent uses Python identifier extent
    __extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'extent'), 'extent', '__httpwww_opengis_netgml3_2_TimeOrdinalEraType_httpwww_opengis_netgml3_2extent', False)

    
    extent = property(__extent.value, __extent.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}member uses Python identifier member
    __member = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'member'), 'member', '__httpwww_opengis_netgml3_2_TimeOrdinalEraType_httpwww_opengis_netgml3_2member', True)

    
    member = property(__member.value, __member.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}group uses Python identifier group
    __group = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'group'), 'group', '__httpwww_opengis_netgml3_2_TimeOrdinalEraType_httpwww_opengis_netgml3_2group', False)

    
    group = property(__group.value, __group.set, None, None)

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}relatedTime uses Python identifier relatedTime
    __relatedTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'relatedTime'), 'relatedTime', '__httpwww_opengis_netgml3_2_TimeOrdinalEraType_httpwww_opengis_netgml3_2relatedTime', True)

    
    relatedTime = property(__relatedTime.value, __relatedTime.set, None, None)

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        __start.name() : __start,
        __end.name() : __end,
        __extent.name() : __extent,
        __member.name() : __member,
        __group.name() : __group,
        __relatedTime.name() : __relatedTime
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeOrdinalEraType', TimeOrdinalEraType)


# Complex type SphericalCSPropertyType with content type ELEMENT_ONLY
class SphericalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SphericalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}SphericalCS uses Python identifier SphericalCS
    __SphericalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'SphericalCS'), 'SphericalCS', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_opengis_netgml3_2SphericalCS', False)

    
    SphericalCS = property(__SphericalCS.value, __SphericalCS.set, None, u'gml:SphericalCS is a three-dimensional coordinate system with one distance measured from the origin and two angular coordinates. A SphericalCS shall have three gml:axis property elements.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_SphericalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __SphericalCS.name() : __SphericalCS
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SphericalCSPropertyType', SphericalCSPropertyType)


# Complex type LI_ProcessStep_Type with content type ELEMENT_ONLY
class LI_ProcessStep_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_ProcessStep_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}dateTime uses Python identifier dateTime
    __dateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dateTime'), 'dateTime', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_Type_httpwww_isotc211_org2005gmddateTime', False)

    
    dateTime = property(__dateTime.value, __dateTime.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}source uses Python identifier source
    __source = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'source'), 'source', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_Type_httpwww_isotc211_org2005gmdsource', True)

    
    source = property(__source.value, __source.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}processor uses Python identifier processor
    __processor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'processor'), 'processor', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_Type_httpwww_isotc211_org2005gmdprocessor', True)

    
    processor = property(__processor.value, __processor.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'description'), 'description', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_Type_httpwww_isotc211_org2005gmddescription', False)

    
    description = property(__description.value, __description.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}rationale uses Python identifier rationale
    __rationale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'rationale'), 'rationale', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_Type_httpwww_isotc211_org2005gmdrationale', False)

    
    rationale = property(__rationale.value, __rationale.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __dateTime.name() : __dateTime,
        __source.name() : __source,
        __processor.name() : __processor,
        __description.name() : __description,
        __rationale.name() : __rationale
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_ProcessStep_Type', LI_ProcessStep_Type)


# Complex type AbstractCoverageType with content type ELEMENT_ONLY
class AbstractCoverageType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoverageType')
    # Base type is AbstractFeatureType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}rangeSet uses Python identifier rangeSet
    __rangeSet = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'rangeSet'), 'rangeSet', '__httpwww_opengis_netgml3_2_AbstractCoverageType_httpwww_opengis_netgml3_2rangeSet', False)

    
    rangeSet = property(__rangeSet.value, __rangeSet.set, None, u'The gml:rangeSet property element contains the values of the coverage (sometimes called the attribute values).  Its content model is given by gml:RangeSetType.\nThis content model supports a structural description of the range.  The semantic information describing the range set is embedded using a uniform method, as part of the explicit values, or as a template value accompanying the representation using gml:DataBlock and gml:File.\nThe values from each component (or "band") in the range may be encoded within a gml:ValueArray element or a concrete member of the gml:AbstractScalarValueList substitution group . Use of these elements satisfies the value-type homogeneity requirement.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}domainSet uses Python identifier domainSet
    __domainSet = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainSet'), 'domainSet', '__httpwww_opengis_netgml3_2_AbstractCoverageType_httpwww_opengis_netgml3_2domainSet', False)

    
    domainSet = property(__domainSet.value, __domainSet.set, None, u'The gml:domainSet property element describes the spatio-temporal region of interest, within which the coverage is defined. Its content model is given by gml:DomainSetType.\nThe value of the domain is thus a choice between a gml:AbstractGeometry and a gml:AbstractTimeObject.  In the instance these abstract elements will normally be substituted by a geometry complex or temporal complex, to represent spatial coverages and time-series, respectively.  \nThe presence of the gml:AssociationAttributeGroup means that domainSet follows the usual GML property model and may use the xlink:href attribute to point to the domain, as an alternative to describing the domain inline. Ownership semantics may be provided using the gml:OwnershipAttributeGroup.\n')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        __rangeSet.name() : __rangeSet,
        __domainSet.name() : __domainSet
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoverageType', AbstractCoverageType)


# Complex type DiscreteCoverageType with content type ELEMENT_ONLY
class DiscreteCoverageType (AbstractCoverageType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DiscreteCoverageType')
    # Base type is AbstractCoverageType
    
    # Element rangeSet ({http://www.opengis.net/gml/3.2}rangeSet) inherited from {http://www.opengis.net/gml/3.2}AbstractCoverageType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}coverageFunction uses Python identifier coverageFunction
    __coverageFunction = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coverageFunction'), 'coverageFunction', '__httpwww_opengis_netgml3_2_DiscreteCoverageType_httpwww_opengis_netgml3_2coverageFunction', False)

    
    coverageFunction = property(__coverageFunction.value, __coverageFunction.set, None, u'The gml:coverageFunction property describes the mapping function from the domain to the range of the coverage.\nThe value of the CoverageFunction is one of gml:CoverageMappingRule and gml:GridFunction.\nIf the gml:coverageFunction property is omitted for a gridded coverage (including rectified gridded coverages) the gml:startPoint is assumed to be the value of the gml:low property in the gml:Grid geometry, and the gml:sequenceRule is assumed to be linear and the gml:axisOrder property is assumed to be "+1 +2".')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainSet ({http://www.opengis.net/gml/3.2}domainSet) inherited from {http://www.opengis.net/gml/3.2}AbstractCoverageType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractCoverageType._ElementMap.copy()
    _ElementMap.update({
        __coverageFunction.name() : __coverageFunction
    })
    _AttributeMap = AbstractCoverageType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DiscreteCoverageType', DiscreteCoverageType)


# Complex type CI_OnlineResource_PropertyType with content type ELEMENT_ONLY
class CI_OnlineResource_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_OnlineResource_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_OnlineResource uses Python identifier CI_OnlineResource
    __CI_OnlineResource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_OnlineResource'), 'CI_OnlineResource', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_isotc211_org2005gmdCI_OnlineResource', False)

    
    CI_OnlineResource = property(__CI_OnlineResource.value, __CI_OnlineResource.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_OnlineResource_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __CI_OnlineResource.name() : __CI_OnlineResource
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __show.name() : __show
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_OnlineResource_PropertyType', CI_OnlineResource_PropertyType)


# Complex type TemporalDatumPropertyType with content type ELEMENT_ONLY
class TemporalDatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalDatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TemporalDatum uses Python identifier TemporalDatum
    __TemporalDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalDatum'), 'TemporalDatum', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_opengis_netgml3_2TemporalDatum', False)

    
    TemporalDatum = property(__TemporalDatum.value, __TemporalDatum.set, None, u'A gml:TemporalDatum defines the origin of a Temporal Reference System. This type omits the "anchorDefinition" and "realizationEpoch" elements and adds the "origin" element with the dateTime type.')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TemporalDatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __TemporalDatum.name() : __TemporalDatum
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __role.name() : __role,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalDatumPropertyType', TemporalDatumPropertyType)


# Complex type Binary_PropertyType with content type ELEMENT_ONLY
class Binary_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Binary_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Binary uses Python identifier Binary
    __Binary = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Binary'), 'Binary', '__httpwww_isotc211_org2005gco_Binary_PropertyType_httpwww_isotc211_org2005gcoBinary', False)

    
    Binary = property(__Binary.value, __Binary.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Binary_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Binary.name() : __Binary
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Binary_PropertyType', Binary_PropertyType)


# Complex type DirectPositionListType with content type SIMPLE
class DirectPositionListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = doubleList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectPositionListType')
    # Base type is doubleList
    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_DirectPositionListType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_DirectPositionListType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)

    
    # Attribute count uses Python identifier count
    __count = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'count'), 'count', '__httpwww_opengis_netgml3_2_DirectPositionListType_count', pyxb.binding.datatypes.positiveInteger)
    
    count = property(__count.value, __count.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_DirectPositionListType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_DirectPositionListType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __srsName.name() : __srsName,
        __srsDimension.name() : __srsDimension,
        __count.name() : __count,
        __uomLabels.name() : __uomLabels,
        __axisLabels.name() : __axisLabels
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectPositionListType', DirectPositionListType)


# Complex type AbstractTimeObjectType with content type ELEMENT_ONLY
class AbstractTimeObjectType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeObjectType')
    # Base type is AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeObjectType', AbstractTimeObjectType)


# Complex type AbstractTimePrimitiveType with content type ELEMENT_ONLY
class AbstractTimePrimitiveType (AbstractTimeObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimePrimitiveType')
    # Base type is AbstractTimeObjectType
    
    # Element {http://www.opengis.net/gml/3.2}relatedTime uses Python identifier relatedTime
    __relatedTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'relatedTime'), 'relatedTime', '__httpwww_opengis_netgml3_2_AbstractTimePrimitiveType_httpwww_opengis_netgml3_2relatedTime', True)

    
    relatedTime = property(__relatedTime.value, __relatedTime.set, None, None)

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeObjectType._ElementMap.copy()
    _ElementMap.update({
        __relatedTime.name() : __relatedTime
    })
    _AttributeMap = AbstractTimeObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimePrimitiveType', AbstractTimePrimitiveType)


# Complex type AbstractTimeGeometricPrimitiveType with content type ELEMENT_ONLY
class AbstractTimeGeometricPrimitiveType (AbstractTimePrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeGeometricPrimitiveType')
    # Base type is AbstractTimePrimitiveType
    
    # Element relatedTime ({http://www.opengis.net/gml/3.2}relatedTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimePrimitiveType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute frame uses Python identifier frame
    __frame = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'frame'), 'frame', '__httpwww_opengis_netgml3_2_AbstractTimeGeometricPrimitiveType_frame', pyxb.binding.datatypes.anyURI, unicode_default=u'#ISO-8601')
    
    frame = property(__frame.value, __frame.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimePrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractTimePrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __frame.name() : __frame
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractTimeGeometricPrimitiveType', AbstractTimeGeometricPrimitiveType)


# Complex type TimeInstantType with content type ELEMENT_ONLY
class TimeInstantType (AbstractTimeGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeInstantType')
    # Base type is AbstractTimeGeometricPrimitiveType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element relatedTime ({http://www.opengis.net/gml/3.2}relatedTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimePrimitiveType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}timePosition uses Python identifier timePosition
    __timePosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'timePosition'), 'timePosition', '__httpwww_opengis_netgml3_2_TimeInstantType_httpwww_opengis_netgml3_2timePosition', False)

    
    timePosition = property(__timePosition.value, __timePosition.set, None, u'This element is used directly as a property of gml:TimeInstant (see 15.2.2.3), and may also be used in application schemas.')

    
    # Attribute frame inherited from {http://www.opengis.net/gml/3.2}AbstractTimeGeometricPrimitiveType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __timePosition.name() : __timePosition
    })
    _AttributeMap = AbstractTimeGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeInstantType', TimeInstantType)


# Complex type AbstractRingType with content type EMPTY
class AbstractRingType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractRingType')
    # Base type is pyxb.binding.datatypes.anyType

    _ElementMap = {
        
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractRingType', AbstractRingType)


# Complex type LinearRingType with content type ELEMENT_ONLY
class LinearRingType (AbstractRingType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LinearRingType')
    # Base type is AbstractRingType
    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_LinearRingType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')


    _ElementMap = AbstractRingType._ElementMap.copy()
    _ElementMap.update({
        __pointRep.name() : __pointRep,
        __pos.name() : __pos,
        __posList.name() : __posList,
        __pointProperty.name() : __pointProperty,
        __coordinates.name() : __coordinates
    })
    _AttributeMap = AbstractRingType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'LinearRingType', LinearRingType)


# Complex type CTD_ANON_3 with content type SIMPLE
class CTD_ANON_3 (CodeType):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = None
    # Base type is CodeType
    
    # Attribute codeSpace inherited from {http://www.opengis.net/gml/3.2}CodeType
    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_3_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = CodeType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = CodeType._AttributeMap.copy()
    _AttributeMap.update({
        __nilReason.name() : __nilReason
    })



# Complex type MD_GeometricObjectTypeCode_PropertyType with content type ELEMENT_ONLY
class MD_GeometricObjectTypeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GeometricObjectTypeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_GeometricObjectTypeCode uses Python identifier MD_GeometricObjectTypeCode
    __MD_GeometricObjectTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GeometricObjectTypeCode'), 'MD_GeometricObjectTypeCode', '__httpwww_isotc211_org2005gmd_MD_GeometricObjectTypeCode_PropertyType_httpwww_isotc211_org2005gmdMD_GeometricObjectTypeCode', False)

    
    MD_GeometricObjectTypeCode = property(__MD_GeometricObjectTypeCode.value, __MD_GeometricObjectTypeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_GeometricObjectTypeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_GeometricObjectTypeCode.name() : __MD_GeometricObjectTypeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_GeometricObjectTypeCode_PropertyType', MD_GeometricObjectTypeCode_PropertyType)


# Complex type AbstractGeneralOperationParameterType with content type ELEMENT_ONLY
class AbstractGeneralOperationParameterType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralOperationParameterType')
    # Base type is IdentifiedObjectType
    
    # Element {http://www.opengis.net/gml/3.2}minimumOccurs uses Python identifier minimumOccurs
    __minimumOccurs = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'minimumOccurs'), 'minimumOccurs', '__httpwww_opengis_netgml3_2_AbstractGeneralOperationParameterType_httpwww_opengis_netgml3_2minimumOccurs', False)

    
    minimumOccurs = property(__minimumOccurs.value, __minimumOccurs.set, None, u'gml:minimumOccurs is the minimum number of times that values for this parameter group or parameter are required. If this attribute is omitted, the minimum number shall be one.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __minimumOccurs.name() : __minimumOccurs
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralOperationParameterType', AbstractGeneralOperationParameterType)


# Complex type OperationParameterGroupType with content type ELEMENT_ONLY
class OperationParameterGroupType (AbstractGeneralOperationParameterType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterGroupType')
    # Base type is AbstractGeneralOperationParameterType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}parameter uses Python identifier parameter
    __parameter = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'parameter'), 'parameter', '__httpwww_opengis_netgml3_2_OperationParameterGroupType_httpwww_opengis_netgml3_2parameter', True)

    
    parameter = property(__parameter.value, __parameter.set, None, u'gml:parameter is an association to an operation parameter or parameter group.')

    
    # Element minimumOccurs ({http://www.opengis.net/gml/3.2}minimumOccurs) inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralOperationParameterType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}maximumOccurs uses Python identifier maximumOccurs
    __maximumOccurs = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'maximumOccurs'), 'maximumOccurs', '__httpwww_opengis_netgml3_2_OperationParameterGroupType_httpwww_opengis_netgml3_2maximumOccurs', False)

    
    maximumOccurs = property(__maximumOccurs.value, __maximumOccurs.set, None, u'gml:maximumOccurs is the maximum number of times that values for this parameter group may be included. If this attribute is omitted, the maximum number shall be one.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractGeneralOperationParameterType._ElementMap.copy()
    _ElementMap.update({
        __parameter.name() : __parameter,
        __maximumOccurs.name() : __maximumOccurs
    })
    _AttributeMap = AbstractGeneralOperationParameterType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OperationParameterGroupType', OperationParameterGroupType)


# Complex type CRSPropertyType with content type ELEMENT_ONLY
class CRSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CRSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCRS uses Python identifier AbstractCRS
    __AbstractCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCRS'), 'AbstractCRS', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_opengis_netgml3_2AbstractCRS', False)

    
    AbstractCRS = property(__AbstractCRS.value, __AbstractCRS.set, None, u'gml:AbstractCRS specifies a coordinate reference system which is usually single but may be compound. This abstract complex type shall not be used, extended, or restricted, in a GML Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CRSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CRSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __AbstractCRS.name() : __AbstractCRS
    }
    _AttributeMap = {
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __remoteSchema.name() : __remoteSchema,
        __href.name() : __href,
        __type.name() : __type,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CRSPropertyType', CRSPropertyType)


# Complex type LI_ProcessStep_PropertyType with content type ELEMENT_ONLY
class LI_ProcessStep_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_ProcessStep_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}LI_ProcessStep uses Python identifier LI_ProcessStep
    __LI_ProcessStep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_ProcessStep'), 'LI_ProcessStep', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_isotc211_org2005gmdLI_ProcessStep', False)

    
    LI_ProcessStep = property(__LI_ProcessStep.value, __LI_ProcessStep.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_LI_ProcessStep_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __LI_ProcessStep.name() : __LI_ProcessStep
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_ProcessStep_PropertyType', LI_ProcessStep_PropertyType)


# Complex type ObjectReference_PropertyType with content type EMPTY
class ObjectReference_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'ObjectReference_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gco_ObjectReference_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __href.name() : __href
    }
_Namespace_gco.addCategoryObject('typeBinding', u'ObjectReference_PropertyType', ObjectReference_PropertyType)


# Complex type DatumPropertyType with content type ELEMENT_ONLY
class DatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractDatum uses Python identifier AbstractDatum
    __AbstractDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractDatum'), 'AbstractDatum', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_opengis_netgml3_2AbstractDatum', False)

    
    AbstractDatum = property(__AbstractDatum.value, __AbstractDatum.set, None, u'A gml:AbstractDatum specifies the relationship of a coordinate system to the earth, thus creating a coordinate reference system. A datum uses a parameter or set of parameters that determine the location of the origin of the coordinate reference system. Each datum subtype may be associated with only specific types of coordinate systems. This abstract complex type shall not be used, extended, or restricted, in a GML Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __AbstractDatum.name() : __AbstractDatum
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DatumPropertyType', DatumPropertyType)


# Complex type MD_Medium_Type with content type ELEMENT_ONLY
class MD_Medium_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Medium_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}densityUnits uses Python identifier densityUnits
    __densityUnits = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'densityUnits'), 'densityUnits', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmddensityUnits', False)

    
    densityUnits = property(__densityUnits.value, __densityUnits.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}volumes uses Python identifier volumes
    __volumes = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'volumes'), 'volumes', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmdvolumes', False)

    
    volumes = property(__volumes.value, __volumes.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}mediumFormat uses Python identifier mediumFormat
    __mediumFormat = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'mediumFormat'), 'mediumFormat', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmdmediumFormat', True)

    
    mediumFormat = property(__mediumFormat.value, __mediumFormat.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}name uses Python identifier name
    __name = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'name'), 'name', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmdname', False)

    
    name = property(__name.value, __name.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}mediumNote uses Python identifier mediumNote
    __mediumNote = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'mediumNote'), 'mediumNote', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmdmediumNote', False)

    
    mediumNote = property(__mediumNote.value, __mediumNote.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}density uses Python identifier density
    __density = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'density'), 'density', '__httpwww_isotc211_org2005gmd_MD_Medium_Type_httpwww_isotc211_org2005gmddensity', True)

    
    density = property(__density.value, __density.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __densityUnits.name() : __densityUnits,
        __volumes.name() : __volumes,
        __mediumFormat.name() : __mediumFormat,
        __name.name() : __name,
        __mediumNote.name() : __mediumNote,
        __density.name() : __density
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Medium_Type', MD_Medium_Type)


# Complex type TopoSolidPropertyType with content type ELEMENT_ONLY
class TopoSolidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSolidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoSolid uses Python identifier TopoSolid
    __TopoSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSolid'), 'TopoSolid', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_opengis_netgml3_2TopoSolid', False)

    
    TopoSolid = property(__TopoSolid.value, __TopoSolid.set, None, u'gml:TopoSolid represents the 3-dimensional topology primitive. \nThe topological boundary of a solid (gml:directedFace) consists of a set of directed faces.\nA solid may optionally be realised by a 3-dimensional geometric primitive (gml:solidProperty).')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TopoSolidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __TopoSolid.name() : __TopoSolid
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __owns.name() : __owns,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TopoSolidPropertyType', TopoSolidPropertyType)


# Complex type DS_Sensor_PropertyType with content type ELEMENT_ONLY
class DS_Sensor_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Sensor_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DS_Sensor uses Python identifier DS_Sensor
    __DS_Sensor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Sensor'), 'DS_Sensor', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_isotc211_org2005gmdDS_Sensor', False)

    
    DS_Sensor = property(__DS_Sensor.value, __DS_Sensor.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DS_Sensor_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __DS_Sensor.name() : __DS_Sensor
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __href.name() : __href,
        __show.name() : __show
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_Sensor_PropertyType', DS_Sensor_PropertyType)


# Complex type OperationParameterGroupPropertyType with content type ELEMENT_ONLY
class OperationParameterGroupPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterGroupPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}OperationParameterGroup uses Python identifier OperationParameterGroup
    __OperationParameterGroup = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterGroup'), 'OperationParameterGroup', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_opengis_netgml3_2OperationParameterGroup', False)

    
    OperationParameterGroup = property(__OperationParameterGroup.value, __OperationParameterGroup.set, None, u'gml:OperationParameterGroup is the definition of a group of parameters used by an operation method. This complex type is expected to be used or extended for all applicable operation methods, without defining operation-method-specialized element names.\nThe generalOperationParameter elements are an unordered list of associations to the set of operation parameters that are members of this group.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_OperationParameterGroupPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __OperationParameterGroup.name() : __OperationParameterGroup
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __type.name() : __type,
        __role.name() : __role,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __title.name() : __title,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'OperationParameterGroupPropertyType', OperationParameterGroupPropertyType)


# Complex type CurveArrayPropertyType with content type ELEMENT_ONLY
class CurveArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CurveArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCurve uses Python identifier AbstractCurve
    __AbstractCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurve'), 'AbstractCurve', '__httpwww_opengis_netgml3_2_CurveArrayPropertyType_httpwww_opengis_netgml3_2AbstractCurve', True)

    
    AbstractCurve = property(__AbstractCurve.value, __AbstractCurve.set, None, u'The AbstractCurve element is the abstract head of the substitution group for all (continuous) curve elements.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_CurveArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractCurve.name() : __AbstractCurve
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CurveArrayPropertyType', CurveArrayPropertyType)


# Complex type MD_Distributor_Type with content type ELEMENT_ONLY
class MD_Distributor_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Distributor_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}distributionOrderProcess uses Python identifier distributionOrderProcess
    __distributionOrderProcess = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'distributionOrderProcess'), 'distributionOrderProcess', '__httpwww_isotc211_org2005gmd_MD_Distributor_Type_httpwww_isotc211_org2005gmddistributionOrderProcess', True)

    
    distributionOrderProcess = property(__distributionOrderProcess.value, __distributionOrderProcess.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}distributorContact uses Python identifier distributorContact
    __distributorContact = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'distributorContact'), 'distributorContact', '__httpwww_isotc211_org2005gmd_MD_Distributor_Type_httpwww_isotc211_org2005gmddistributorContact', False)

    
    distributorContact = property(__distributorContact.value, __distributorContact.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}distributorFormat uses Python identifier distributorFormat
    __distributorFormat = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'distributorFormat'), 'distributorFormat', '__httpwww_isotc211_org2005gmd_MD_Distributor_Type_httpwww_isotc211_org2005gmddistributorFormat', True)

    
    distributorFormat = property(__distributorFormat.value, __distributorFormat.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}distributorTransferOptions uses Python identifier distributorTransferOptions
    __distributorTransferOptions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'distributorTransferOptions'), 'distributorTransferOptions', '__httpwww_isotc211_org2005gmd_MD_Distributor_Type_httpwww_isotc211_org2005gmddistributorTransferOptions', True)

    
    distributorTransferOptions = property(__distributorTransferOptions.value, __distributorTransferOptions.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __distributionOrderProcess.name() : __distributionOrderProcess,
        __distributorContact.name() : __distributorContact,
        __distributorFormat.name() : __distributorFormat,
        __distributorTransferOptions.name() : __distributorTransferOptions
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Distributor_Type', MD_Distributor_Type)


# Complex type AbstractGeometryType with content type ELEMENT_ONLY
class AbstractGeometryType (AbstractGMLType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometryType')
    # Base type is AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels uses Python identifier axisLabels
    __axisLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisLabels'), 'axisLabels', '__httpwww_opengis_netgml3_2_AbstractGeometryType_axisLabels', NCNameList)
    
    axisLabels = property(__axisLabels.value, __axisLabels.set, None, None)

    
    # Attribute uomLabels uses Python identifier uomLabels
    __uomLabels = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uomLabels'), 'uomLabels', '__httpwww_opengis_netgml3_2_AbstractGeometryType_uomLabels', NCNameList)
    
    uomLabels = property(__uomLabels.value, __uomLabels.set, None, None)

    
    # Attribute srsDimension uses Python identifier srsDimension
    __srsDimension = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsDimension'), 'srsDimension', '__httpwww_opengis_netgml3_2_AbstractGeometryType_srsDimension', pyxb.binding.datatypes.positiveInteger)
    
    srsDimension = property(__srsDimension.value, __srsDimension.set, None, None)

    
    # Attribute srsName uses Python identifier srsName
    __srsName = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'srsName'), 'srsName', '__httpwww_opengis_netgml3_2_AbstractGeometryType_srsName', pyxb.binding.datatypes.anyURI)
    
    srsName = property(__srsName.value, __srsName.set, None, None)


    _ElementMap = AbstractGMLType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGMLType._AttributeMap.copy()
    _AttributeMap.update({
        __axisLabels.name() : __axisLabels,
        __uomLabels.name() : __uomLabels,
        __srsDimension.name() : __srsDimension,
        __srsName.name() : __srsName
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometryType', AbstractGeometryType)


# Complex type GeometricComplexType with content type ELEMENT_ONLY
class GeometricComplexType (AbstractGeometryType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeometricComplexType')
    # Base type is AbstractGeometryType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}element uses Python identifier element
    __element = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'element'), 'element', '__httpwww_opengis_netgml3_2_GeometricComplexType_httpwww_opengis_netgml3_2element', True)

    
    element = property(__element.value, __element.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_GeometricComplexType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)


    _ElementMap = AbstractGeometryType._ElementMap.copy()
    _ElementMap.update({
        __element.name() : __element
    })
    _AttributeMap = AbstractGeometryType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'GeometricComplexType', GeometricComplexType)


# Complex type AbstractGeneralDerivedCRSType with content type ELEMENT_ONLY
class AbstractGeneralDerivedCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralDerivedCRSType')
    # Base type is AbstractCRSType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}conversion uses Python identifier conversion
    __conversion = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'conversion'), 'conversion', '__httpwww_opengis_netgml3_2_AbstractGeneralDerivedCRSType_httpwww_opengis_netgml3_2conversion', False)

    
    conversion = property(__conversion.value, __conversion.set, None, u'gml:conversion is an association role to the coordinate conversion used to define the derived CRS.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __conversion.name() : __conversion
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralDerivedCRSType', AbstractGeneralDerivedCRSType)


# Complex type DerivedCRSType with content type ELEMENT_ONLY
class DerivedCRSType (AbstractGeneralDerivedCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DerivedCRSType')
    # Base type is AbstractGeneralDerivedCRSType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}derivedCRSType uses Python identifier derivedCRSType
    __derivedCRSType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'derivedCRSType'), 'derivedCRSType', '__httpwww_opengis_netgml3_2_DerivedCRSType_httpwww_opengis_netgml3_2derivedCRSType', False)

    
    derivedCRSType = property(__derivedCRSType.value, __derivedCRSType.set, None, u'The gml:derivedCRSType property describes the type of a derived coordinate reference system. The required codeSpace attribute shall reference a source of information specifying the values and meanings of all the allowed string values for this property.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}coordinateSystem uses Python identifier coordinateSystem
    __coordinateSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinateSystem'), 'coordinateSystem', '__httpwww_opengis_netgml3_2_DerivedCRSType_httpwww_opengis_netgml3_2coordinateSystem', False)

    
    coordinateSystem = property(__coordinateSystem.value, __coordinateSystem.set, None, u'An association role to the coordinate system used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}baseCRS uses Python identifier baseCRS
    __baseCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseCRS'), 'baseCRS', '__httpwww_opengis_netgml3_2_DerivedCRSType_httpwww_opengis_netgml3_2baseCRS', False)

    
    baseCRS = property(__baseCRS.value, __baseCRS.set, None, u'gml:baseCRS is an association role to the coordinate reference system used by this derived CRS.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element conversion ({http://www.opengis.net/gml/3.2}conversion) inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralDerivedCRSType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractGeneralDerivedCRSType._ElementMap.copy()
    _ElementMap.update({
        __derivedCRSType.name() : __derivedCRSType,
        __coordinateSystem.name() : __coordinateSystem,
        __baseCRS.name() : __baseCRS
    })
    _AttributeMap = AbstractGeneralDerivedCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DerivedCRSType', DerivedCRSType)


# Complex type MD_Distributor_PropertyType with content type ELEMENT_ONLY
class MD_Distributor_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Distributor_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Distributor uses Python identifier MD_Distributor
    __MD_Distributor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Distributor'), 'MD_Distributor', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_isotc211_org2005gmdMD_Distributor', False)

    
    MD_Distributor = property(__MD_Distributor.value, __MD_Distributor.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Distributor_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __MD_Distributor.name() : __MD_Distributor
    }
    _AttributeMap = {
        __role.name() : __role,
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __show.name() : __show
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Distributor_PropertyType', MD_Distributor_PropertyType)


# Complex type CylindricalCSType with content type ELEMENT_ONLY
class CylindricalCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CylindricalCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CylindricalCSType', CylindricalCSType)


# Complex type LI_Source_PropertyType with content type ELEMENT_ONLY
class LI_Source_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Source_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}LI_Source uses Python identifier LI_Source
    __LI_Source = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Source'), 'LI_Source', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_isotc211_org2005gmdLI_Source', False)

    
    LI_Source = property(__LI_Source.value, __LI_Source.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_LI_Source_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __LI_Source.name() : __LI_Source
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_Source_PropertyType', LI_Source_PropertyType)


# Complex type EX_GeographicExtent_PropertyType with content type ELEMENT_ONLY
class EX_GeographicExtent_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_GeographicExtent_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractEX_GeographicExtent uses Python identifier AbstractEX_GeographicExtent
    __AbstractEX_GeographicExtent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractEX_GeographicExtent'), 'AbstractEX_GeographicExtent', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_isotc211_org2005gmdAbstractEX_GeographicExtent', False)

    
    AbstractEX_GeographicExtent = property(__AbstractEX_GeographicExtent.value, __AbstractEX_GeographicExtent.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_EX_GeographicExtent_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __AbstractEX_GeographicExtent.name() : __AbstractEX_GeographicExtent
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __title.name() : __title,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_GeographicExtent_PropertyType', EX_GeographicExtent_PropertyType)


# Complex type OperationMethodType with content type ELEMENT_ONLY
class OperationMethodType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationMethodType')
    # Base type is IdentifiedObjectType
    
    # Element {http://www.opengis.net/gml/3.2}formulaCitation uses Python identifier formulaCitation
    __formulaCitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'formulaCitation'), 'formulaCitation', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2formulaCitation', False)

    
    formulaCitation = property(__formulaCitation.value, __formulaCitation.set, None, u'gml:formulaCitation provides a reference to a publication giving the formula(s) or procedure used by an coordinate operation method.')

    
    # Element {http://www.opengis.net/gml/3.2}formula uses Python identifier formula
    __formula = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'formula'), 'formula', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2formula', False)

    
    formula = property(__formula.value, __formula.set, None, u'gml:formula Formula(s) or procedure used by an operation method. The use of the codespace attribite has been deprecated. The property value shall be a character string.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}targetDimensions uses Python identifier targetDimensions
    __targetDimensions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'targetDimensions'), 'targetDimensions', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2targetDimensions', False)

    
    targetDimensions = property(__targetDimensions.value, __targetDimensions.set, None, u'gml:targetDimensions is the number of dimensions in the target CRS of this operation method.')

    
    # Element {http://www.opengis.net/gml/3.2}sourceDimensions uses Python identifier sourceDimensions
    __sourceDimensions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sourceDimensions'), 'sourceDimensions', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2sourceDimensions', False)

    
    sourceDimensions = property(__sourceDimensions.value, __sourceDimensions.set, None, u'gml:sourceDimensions is the number of dimensions in the source CRS of this operation method.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}parameter uses Python identifier parameter
    __parameter = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'parameter'), 'parameter', '__httpwww_opengis_netgml3_2_OperationMethodType_httpwww_opengis_netgml3_2parameter', True)

    
    parameter = property(__parameter.value, __parameter.set, None, u'gml:parameter is an association to an operation parameter or parameter group.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __formulaCitation.name() : __formulaCitation,
        __formula.name() : __formula,
        __targetDimensions.name() : __targetDimensions,
        __sourceDimensions.name() : __sourceDimensions,
        __parameter.name() : __parameter
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OperationMethodType', OperationMethodType)


# Complex type DQ_FormatConsistency_PropertyType with content type ELEMENT_ONLY
class DQ_FormatConsistency_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_FormatConsistency_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_FormatConsistency uses Python identifier DQ_FormatConsistency
    __DQ_FormatConsistency = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_FormatConsistency'), 'DQ_FormatConsistency', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_isotc211_org2005gmdDQ_FormatConsistency', False)

    
    DQ_FormatConsistency = property(__DQ_FormatConsistency.value, __DQ_FormatConsistency.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_FormatConsistency_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)


    _ElementMap = {
        __DQ_FormatConsistency.name() : __DQ_FormatConsistency
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __role.name() : __role
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_FormatConsistency_PropertyType', DQ_FormatConsistency_PropertyType)


# Complex type AbstractCoordinateOperationType with content type ELEMENT_ONLY
class AbstractCoordinateOperationType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateOperationType')
    # Base type is IdentifiedObjectType
    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2domainOfValidity', False)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element {http://www.opengis.net/gml/3.2}operationVersion uses Python identifier operationVersion
    __operationVersion = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'operationVersion'), 'operationVersion', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2operationVersion', False)

    
    operationVersion = property(__operationVersion.value, __operationVersion.set, None, u'gml:operationVersion is the version of the coordinate transformation (i.e., instantiation due to the stochastic nature of the parameters). Mandatory when describing a transformation, and should not be supplied for a conversion.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}coordinateOperationAccuracy uses Python identifier coordinateOperationAccuracy
    __coordinateOperationAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinateOperationAccuracy'), 'coordinateOperationAccuracy', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2coordinateOperationAccuracy', True)

    
    coordinateOperationAccuracy = property(__coordinateOperationAccuracy.value, __coordinateOperationAccuracy.set, None, u'gml:coordinateOperationAccuracy is an association role to a DQ_PositionalAccuracy object as encoded in ISO/TS 19139, either referencing or containing the definition of that positional accuracy. That object contains an estimate of the impact of this coordinate operation on point accuracy. That is, it gives position error estimates for the target coordinates of this coordinate operation, assuming no errors in the source coordinates.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}targetCRS uses Python identifier targetCRS
    __targetCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'targetCRS'), 'targetCRS', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2targetCRS', False)

    
    targetCRS = property(__targetCRS.value, __targetCRS.set, None, u'gml:targetCRS is an association role to the target CRS (coordinate reference system) of this coordinate operation.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}sourceCRS uses Python identifier sourceCRS
    __sourceCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sourceCRS'), 'sourceCRS', '__httpwww_opengis_netgml3_2_AbstractCoordinateOperationType_httpwww_opengis_netgml3_2sourceCRS', False)

    
    sourceCRS = property(__sourceCRS.value, __sourceCRS.set, None, u'gml:sourceCRS is an association role to the source CRS (coordinate reference system) of this coordinate operation.')

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __domainOfValidity.name() : __domainOfValidity,
        __scope.name() : __scope,
        __operationVersion.name() : __operationVersion,
        __coordinateOperationAccuracy.name() : __coordinateOperationAccuracy,
        __targetCRS.name() : __targetCRS,
        __sourceCRS.name() : __sourceCRS
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCoordinateOperationType', AbstractCoordinateOperationType)


# Complex type PassThroughOperationType with content type ELEMENT_ONLY
class PassThroughOperationType (AbstractCoordinateOperationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PassThroughOperationType')
    # Base type is AbstractCoordinateOperationType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}modifiedCoordinate uses Python identifier modifiedCoordinate
    __modifiedCoordinate = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'modifiedCoordinate'), 'modifiedCoordinate', '__httpwww_opengis_netgml3_2_PassThroughOperationType_httpwww_opengis_netgml3_2modifiedCoordinate', True)

    
    modifiedCoordinate = property(__modifiedCoordinate.value, __modifiedCoordinate.set, None, u'gml:modifiedCoordinate is a positive integer defining a position in a coordinate tuple.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element {http://www.opengis.net/gml/3.2}coordOperation uses Python identifier coordOperation
    __coordOperation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordOperation'), 'coordOperation', '__httpwww_opengis_netgml3_2_PassThroughOperationType_httpwww_opengis_netgml3_2coordOperation', False)

    
    coordOperation = property(__coordOperation.value, __coordOperation.set, None, u'gml:coordOperation is an association role to a coordinate operation.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element targetCRS ({http://www.opengis.net/gml/3.2}targetCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element sourceCRS ({http://www.opengis.net/gml/3.2}sourceCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element operationVersion ({http://www.opengis.net/gml/3.2}operationVersion) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_PassThroughOperationType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateOperationType._ElementMap.copy()
    _ElementMap.update({
        __modifiedCoordinate.name() : __modifiedCoordinate,
        __coordOperation.name() : __coordOperation
    })
    _AttributeMap = AbstractCoordinateOperationType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PassThroughOperationType', PassThroughOperationType)


# Complex type AbstractFeatureMemberType with content type EMPTY
class AbstractFeatureMemberType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeatureMemberType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_AbstractFeatureMemberType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractFeatureMemberType', AbstractFeatureMemberType)


# Complex type DynamicFeatureMemberType with content type ELEMENT_ONLY
class DynamicFeatureMemberType (AbstractFeatureMemberType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeatureMemberType')
    # Base type is AbstractFeatureMemberType
    
    # Element {http://www.opengis.net/gml/3.2}DynamicFeature uses Python identifier DynamicFeature
    __DynamicFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeature'), 'DynamicFeature', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_opengis_netgml3_2DynamicFeature', True)

    
    DynamicFeature = property(__DynamicFeature.value, __DynamicFeature.set, None, u"States are captured by time-stamped instances of a feature. The content model extends the standard gml:AbstractFeatureType with the gml:dynamicProperties model group.\nEach time-stamped instance represents a 'snapshot' of a feature. The dynamic feature classes will normally be extended to suit particular applications.  A dynamic feature bears either a time stamp or a history.")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute owns inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureMemberType
    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DynamicFeatureMemberType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = AbstractFeatureMemberType._ElementMap.copy()
    _ElementMap.update({
        __DynamicFeature.name() : __DynamicFeature
    })
    _AttributeMap = AbstractFeatureMemberType._AttributeMap.copy()
    _AttributeMap.update({
        __href.name() : __href,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DynamicFeatureMemberType', DynamicFeatureMemberType)


# Complex type EngineeringDatumPropertyType with content type ELEMENT_ONLY
class EngineeringDatumPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EngineeringDatumPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}EngineeringDatum uses Python identifier EngineeringDatum
    __EngineeringDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'EngineeringDatum'), 'EngineeringDatum', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_opengis_netgml3_2EngineeringDatum', False)

    
    EngineeringDatum = property(__EngineeringDatum.value, __EngineeringDatum.set, None, u'gml:EngineeringDatum defines the origin of an engineering coordinate reference system, and is used in a region around that origin. This origin may be fixed with respect to the earth (such as a defined point at a construction site), or be a defined point on a moving vehicle (such as on a ship or satellite).')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_EngineeringDatumPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __EngineeringDatum.name() : __EngineeringDatum
    }
    _AttributeMap = {
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type,
        __show.name() : __show,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'EngineeringDatumPropertyType', EngineeringDatumPropertyType)


# Complex type EdgeType with content type ELEMENT_ONLY
class EdgeType (AbstractTopoPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EdgeType')
    # Base type is AbstractTopoPrimitiveType
    
    # Element {http://www.opengis.net/gml/3.2}directedFace uses Python identifier directedFace
    __directedFace = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedFace'), 'directedFace', '__httpwww_opengis_netgml3_2_EdgeType_httpwww_opengis_netgml3_2directedFace', True)

    
    directedFace = property(__directedFace.value, __directedFace.set, None, u'The gml:directedFace property element describes the boundary of topology solids, in the coBoundary of topology edges and is used in the support of surface features via the gml:TopoSurface expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included face is used i.e. inward or outward with respect to the surface normal in any geometric realisation.')

    
    # Element {http://www.opengis.net/gml/3.2}curveProperty uses Python identifier curveProperty
    __curveProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'curveProperty'), 'curveProperty', '__httpwww_opengis_netgml3_2_EdgeType_httpwww_opengis_netgml3_2curveProperty', False)

    
    curveProperty = property(__curveProperty.value, __curveProperty.set, None, u'This property element either references a curve via the XLink-attributes or contains the curve element. curveProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for AbstractCurve.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}container uses Python identifier container
    __container = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'container'), 'container', '__httpwww_opengis_netgml3_2_EdgeType_httpwww_opengis_netgml3_2container', False)

    
    container = property(__container.value, __container.set, None, None)

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}directedNode uses Python identifier directedNode
    __directedNode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedNode'), 'directedNode', '__httpwww_opengis_netgml3_2_EdgeType_httpwww_opengis_netgml3_2directedNode', True)

    
    directedNode = property(__directedNode.value, __directedNode.set, None, u'A gml:directedNode property element describes the boundary of topology edges and is used in the support of topological point features via the gml:TopoPoint expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included node is used: start ("-") or end ("+") node.')

    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_EdgeType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopoPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __directedFace.name() : __directedFace,
        __curveProperty.name() : __curveProperty,
        __container.name() : __container,
        __directedNode.name() : __directedNode
    })
    _AttributeMap = AbstractTopoPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'EdgeType', EdgeType)


# Complex type MultiCurvePropertyType with content type ELEMENT_ONLY
class MultiCurvePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiCurvePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}MultiCurve uses Python identifier MultiCurve
    __MultiCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiCurve'), 'MultiCurve', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_opengis_netgml3_2MultiCurve', False)

    
    MultiCurve = property(__MultiCurve.value, __MultiCurve.set, None, u'A gml:MultiCurve is defined by one or more gml:AbstractCurves.\nThe members of the geometric aggregate may be specified either using the "standard" property (gml:curveMember) or the array property (gml:curveMembers). It is also valid to use both the "standard" and the array properties in the same collection.')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MultiCurvePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MultiCurve.name() : __MultiCurve
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MultiCurvePropertyType', MultiCurvePropertyType)


# Complex type AbstractSurfacePatchType with content type EMPTY
class AbstractSurfacePatchType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurfacePatchType')
    # Base type is pyxb.binding.datatypes.anyType

    _ElementMap = {
        
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractSurfacePatchType', AbstractSurfacePatchType)


# Complex type AbstractParametricCurveSurfaceType with content type EMPTY
class AbstractParametricCurveSurfaceType (AbstractSurfacePatchType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractParametricCurveSurfaceType')
    # Base type is AbstractSurfacePatchType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_AbstractParametricCurveSurfaceType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)


    _ElementMap = AbstractSurfacePatchType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractSurfacePatchType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractParametricCurveSurfaceType', AbstractParametricCurveSurfaceType)


# Complex type AbstractGriddedSurfaceType with content type ELEMENT_ONLY
class AbstractGriddedSurfaceType (AbstractParametricCurveSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGriddedSurfaceType')
    # Base type is AbstractParametricCurveSurfaceType
    
    # Element {http://www.opengis.net/gml/3.2}rows uses Python identifier rows
    __rows = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'rows'), 'rows', '__httpwww_opengis_netgml3_2_AbstractGriddedSurfaceType_httpwww_opengis_netgml3_2rows', False)

    
    rows = property(__rows.value, __rows.set, None, None)

    
    # Attribute rows uses Python identifier rows_
    __rows_ = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'rows'), 'rows_', '__httpwww_opengis_netgml3_2_AbstractGriddedSurfaceType_rows', pyxb.binding.datatypes.integer)
    
    rows_ = property(__rows_.value, __rows_.set, None, None)

    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractParametricCurveSurfaceType
    
    # Attribute columns uses Python identifier columns
    __columns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'columns'), 'columns', '__httpwww_opengis_netgml3_2_AbstractGriddedSurfaceType_columns', pyxb.binding.datatypes.integer)
    
    columns = property(__columns.value, __columns.set, None, None)


    _ElementMap = AbstractParametricCurveSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __rows.name() : __rows
    })
    _AttributeMap = AbstractParametricCurveSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __rows_.name() : __rows_,
        __columns.name() : __columns
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGriddedSurfaceType', AbstractGriddedSurfaceType)


# Complex type SphereType with content type ELEMENT_ONLY
class SphereType (AbstractGriddedSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SphereType')
    # Base type is AbstractGriddedSurfaceType
    
    # Element rows ({http://www.opengis.net/gml/3.2}rows) inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType
    
    # Attribute horizontalCurveType uses Python identifier horizontalCurveType
    __horizontalCurveType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'horizontalCurveType'), 'horizontalCurveType', '__httpwww_opengis_netgml3_2_SphereType_horizontalCurveType', CurveInterpolationType, fixed=True, unicode_default=u'circularArc3Points')
    
    horizontalCurveType = property(__horizontalCurveType.value, __horizontalCurveType.set, None, None)

    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractParametricCurveSurfaceType
    
    # Attribute columns inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType
    
    # Attribute verticalCurveType uses Python identifier verticalCurveType
    __verticalCurveType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'verticalCurveType'), 'verticalCurveType', '__httpwww_opengis_netgml3_2_SphereType_verticalCurveType', CurveInterpolationType, fixed=True, unicode_default=u'circularArc3Points')
    
    verticalCurveType = property(__verticalCurveType.value, __verticalCurveType.set, None, None)

    
    # Attribute rows_ inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType

    _ElementMap = AbstractGriddedSurfaceType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGriddedSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __horizontalCurveType.name() : __horizontalCurveType,
        __verticalCurveType.name() : __verticalCurveType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'SphereType', SphereType)


# Complex type LinearCSPropertyType with content type ELEMENT_ONLY
class LinearCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LinearCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}LinearCS uses Python identifier LinearCS
    __LinearCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'LinearCS'), 'LinearCS', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_opengis_netgml3_2LinearCS', False)

    
    LinearCS = property(__LinearCS.value, __LinearCS.set, None, u'gml:LinearCS is a one-dimensional coordinate system that consists of the points that lie on the single axis described. The associated coordinate is the distance \u2013 with or without offset \u2013 from the specified datum to the point along the axis. A LinearCS shall have one gml:axis property element.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_LinearCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __LinearCS.name() : __LinearCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'LinearCSPropertyType', LinearCSPropertyType)


# Complex type MD_MetadataExtensionInformation_Type with content type ELEMENT_ONLY
class MD_MetadataExtensionInformation_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_MetadataExtensionInformation_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}extensionOnLineResource uses Python identifier extensionOnLineResource
    __extensionOnLineResource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'extensionOnLineResource'), 'extensionOnLineResource', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_Type_httpwww_isotc211_org2005gmdextensionOnLineResource', False)

    
    extensionOnLineResource = property(__extensionOnLineResource.value, __extensionOnLineResource.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}extendedElementInformation uses Python identifier extendedElementInformation
    __extendedElementInformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'extendedElementInformation'), 'extendedElementInformation', '__httpwww_isotc211_org2005gmd_MD_MetadataExtensionInformation_Type_httpwww_isotc211_org2005gmdextendedElementInformation', True)

    
    extendedElementInformation = property(__extendedElementInformation.value, __extendedElementInformation.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __extensionOnLineResource.name() : __extensionOnLineResource,
        __extendedElementInformation.name() : __extendedElementInformation
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_MetadataExtensionInformation_Type', MD_MetadataExtensionInformation_Type)


# Complex type CountPropertyType with content type ELEMENT_ONLY
class CountPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CountPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Count uses Python identifier Count
    __Count = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Count'), 'Count', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_opengis_netgml3_2Count', False)

    
    Count = property(__Count.value, __Count.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CountPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CountPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __Count.name() : __Count
    }
    _AttributeMap = {
        __role.name() : __role,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CountPropertyType', CountPropertyType)


# Complex type UnitOfMeasureType with content type EMPTY
class UnitOfMeasureType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UnitOfMeasureType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute uom uses Python identifier uom
    __uom = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uom'), 'uom', '__httpwww_opengis_netgml3_2_UnitOfMeasureType_uom', UomIdentifier, required=True)
    
    uom = property(__uom.value, __uom.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __uom.name() : __uom
    }
_Namespace_gml.addCategoryObject('typeBinding', u'UnitOfMeasureType', UnitOfMeasureType)


# Complex type ConversionToPreferredUnitType with content type ELEMENT_ONLY
class ConversionToPreferredUnitType (UnitOfMeasureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ConversionToPreferredUnitType')
    # Base type is UnitOfMeasureType
    
    # Element {http://www.opengis.net/gml/3.2}formula uses Python identifier formula
    __formula = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'formula'), 'formula', '__httpwww_opengis_netgml3_2_ConversionToPreferredUnitType_httpwww_opengis_netgml3_2formula', False)

    
    formula = property(__formula.value, __formula.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}factor uses Python identifier factor
    __factor = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'factor'), 'factor', '__httpwww_opengis_netgml3_2_ConversionToPreferredUnitType_httpwww_opengis_netgml3_2factor', False)

    
    factor = property(__factor.value, __factor.set, None, None)

    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}UnitOfMeasureType

    _ElementMap = UnitOfMeasureType._ElementMap.copy()
    _ElementMap.update({
        __formula.name() : __formula,
        __factor.name() : __factor
    })
    _AttributeMap = UnitOfMeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ConversionToPreferredUnitType', ConversionToPreferredUnitType)


# Complex type DirectionPropertyType with content type ELEMENT_ONLY
class DirectionPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}DirectionString uses Python identifier DirectionString
    __DirectionString = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionString'), 'DirectionString', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionString', False)

    
    DirectionString = property(__DirectionString.value, __DirectionString.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionDescription uses Python identifier DirectionDescription
    __DirectionDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionDescription'), 'DirectionDescription', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionDescription', False)

    
    DirectionDescription = property(__DirectionDescription.value, __DirectionDescription.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}CompassPoint uses Python identifier CompassPoint
    __CompassPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CompassPoint'), 'CompassPoint', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2CompassPoint', False)

    
    CompassPoint = property(__CompassPoint.value, __CompassPoint.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionVector uses Python identifier DirectionVector
    __DirectionVector = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionVector'), 'DirectionVector', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionVector', False)

    
    DirectionVector = property(__DirectionVector.value, __DirectionVector.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}DirectionKeyword uses Python identifier DirectionKeyword
    __DirectionKeyword = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectionKeyword'), 'DirectionKeyword', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2DirectionKeyword', False)

    
    DirectionKeyword = property(__DirectionKeyword.value, __DirectionKeyword.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectionPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectionPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectionPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __DirectionString.name() : __DirectionString,
        __DirectionDescription.name() : __DirectionDescription,
        __CompassPoint.name() : __CompassPoint,
        __DirectionVector.name() : __DirectionVector,
        __DirectionKeyword.name() : __DirectionKeyword
    }
    _AttributeMap = {
        __role.name() : __role,
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __owns.name() : __owns,
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectionPropertyType', DirectionPropertyType)


# Complex type DQ_ConformanceResult_PropertyType with content type ELEMENT_ONLY
class DQ_ConformanceResult_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConformanceResult_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_ConformanceResult uses Python identifier DQ_ConformanceResult
    __DQ_ConformanceResult = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_ConformanceResult'), 'DQ_ConformanceResult', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_isotc211_org2005gmdDQ_ConformanceResult', False)

    
    DQ_ConformanceResult = property(__DQ_ConformanceResult.value, __DQ_ConformanceResult.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_ConformanceResult_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __DQ_ConformanceResult.name() : __DQ_ConformanceResult
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_ConformanceResult_PropertyType', DQ_ConformanceResult_PropertyType)


# Complex type Boolean_PropertyType with content type ELEMENT_ONLY
class Boolean_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Boolean_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}Boolean uses Python identifier Boolean
    __Boolean = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Boolean'), 'Boolean', '__httpwww_isotc211_org2005gco_Boolean_PropertyType_httpwww_isotc211_org2005gcoBoolean', False)

    
    Boolean = property(__Boolean.value, __Boolean.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Boolean_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Boolean.name() : __Boolean
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Boolean_PropertyType', Boolean_PropertyType)


# Complex type FeatureArrayPropertyType with content type ELEMENT_ONLY
class FeatureArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'FeatureArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractFeature uses Python identifier AbstractFeature
    __AbstractFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeature'), 'AbstractFeature', '__httpwww_opengis_netgml3_2_FeatureArrayPropertyType_httpwww_opengis_netgml3_2AbstractFeature', True)

    
    AbstractFeature = property(__AbstractFeature.value, __AbstractFeature.set, None, u'This abstract element serves as the head of a substitution group which may contain any elements whose content model is derived from gml:AbstractFeatureType.  This may be used as a variable in the construction of content models.  \ngml:AbstractFeature may be thought of as "anything that is a GML feature" and may be used to define variables or templates in which the value of a GML property is "any feature". This occurs in particular in a GML feature collection where the feature member properties contain one or multiple copies of gml:AbstractFeature respectively.')


    _ElementMap = {
        __AbstractFeature.name() : __AbstractFeature
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'FeatureArrayPropertyType', FeatureArrayPropertyType)


# Complex type MD_Constraints_Type with content type ELEMENT_ONLY
class MD_Constraints_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Constraints_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}useLimitation uses Python identifier useLimitation
    __useLimitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'useLimitation'), 'useLimitation', '__httpwww_isotc211_org2005gmd_MD_Constraints_Type_httpwww_isotc211_org2005gmduseLimitation', True)

    
    useLimitation = property(__useLimitation.value, __useLimitation.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __useLimitation.name() : __useLimitation
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Constraints_Type', MD_Constraints_Type)


# Complex type AbstractDQ_Element_Type with content type ELEMENT_ONLY
class AbstractDQ_Element_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_Element_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}evaluationMethodDescription uses Python identifier evaluationMethodDescription
    __evaluationMethodDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationMethodDescription'), 'evaluationMethodDescription', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationMethodDescription', False)

    
    evaluationMethodDescription = property(__evaluationMethodDescription.value, __evaluationMethodDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}measureDescription uses Python identifier measureDescription
    __measureDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'measureDescription'), 'measureDescription', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdmeasureDescription', False)

    
    measureDescription = property(__measureDescription.value, __measureDescription.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}measureIdentification uses Python identifier measureIdentification
    __measureIdentification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'measureIdentification'), 'measureIdentification', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdmeasureIdentification', False)

    
    measureIdentification = property(__measureIdentification.value, __measureIdentification.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}evaluationMethodType uses Python identifier evaluationMethodType
    __evaluationMethodType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationMethodType'), 'evaluationMethodType', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationMethodType', False)

    
    evaluationMethodType = property(__evaluationMethodType.value, __evaluationMethodType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}evaluationProcedure uses Python identifier evaluationProcedure
    __evaluationProcedure = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'evaluationProcedure'), 'evaluationProcedure', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdevaluationProcedure', False)

    
    evaluationProcedure = property(__evaluationProcedure.value, __evaluationProcedure.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}dateTime uses Python identifier dateTime
    __dateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'dateTime'), 'dateTime', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmddateTime', True)

    
    dateTime = property(__dateTime.value, __dateTime.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}result uses Python identifier result
    __result = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'result'), 'result', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdresult', True)

    
    result = property(__result.value, __result.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}nameOfMeasure uses Python identifier nameOfMeasure
    __nameOfMeasure = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'nameOfMeasure'), 'nameOfMeasure', '__httpwww_isotc211_org2005gmd_AbstractDQ_Element_Type_httpwww_isotc211_org2005gmdnameOfMeasure', True)

    
    nameOfMeasure = property(__nameOfMeasure.value, __nameOfMeasure.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __evaluationMethodDescription.name() : __evaluationMethodDescription,
        __measureDescription.name() : __measureDescription,
        __measureIdentification.name() : __measureIdentification,
        __evaluationMethodType.name() : __evaluationMethodType,
        __evaluationProcedure.name() : __evaluationProcedure,
        __dateTime.name() : __dateTime,
        __result.name() : __result,
        __nameOfMeasure.name() : __nameOfMeasure
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_Element_Type', AbstractDQ_Element_Type)


# Complex type AbstractDQ_PositionalAccuracy_Type with content type ELEMENT_ONLY
class AbstractDQ_PositionalAccuracy_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_PositionalAccuracy_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_PositionalAccuracy_Type', AbstractDQ_PositionalAccuracy_Type)


# Complex type DQ_RelativeInternalPositionalAccuracy_Type with content type ELEMENT_ONLY
class DQ_RelativeInternalPositionalAccuracy_Type (AbstractDQ_PositionalAccuracy_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_RelativeInternalPositionalAccuracy_Type')
    # Base type is AbstractDQ_PositionalAccuracy_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_PositionalAccuracy_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_PositionalAccuracy_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_RelativeInternalPositionalAccuracy_Type', DQ_RelativeInternalPositionalAccuracy_Type)


# Complex type CI_DateTypeCode_PropertyType with content type ELEMENT_ONLY
class CI_DateTypeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_DateTypeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_DateTypeCode uses Python identifier CI_DateTypeCode
    __CI_DateTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_DateTypeCode'), 'CI_DateTypeCode', '__httpwww_isotc211_org2005gmd_CI_DateTypeCode_PropertyType_httpwww_isotc211_org2005gmdCI_DateTypeCode', False)

    
    CI_DateTypeCode = property(__CI_DateTypeCode.value, __CI_DateTypeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_DateTypeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __CI_DateTypeCode.name() : __CI_DateTypeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_DateTypeCode_PropertyType', CI_DateTypeCode_PropertyType)


# Complex type CI_ResponsibleParty_Type with content type ELEMENT_ONLY
class CI_ResponsibleParty_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}contactInfo uses Python identifier contactInfo
    __contactInfo = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'contactInfo'), 'contactInfo', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdcontactInfo', False)

    
    contactInfo = property(__contactInfo.value, __contactInfo.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}role uses Python identifier role
    __role = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdrole', False)

    
    role = property(__role.value, __role.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}positionName uses Python identifier positionName
    __positionName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'positionName'), 'positionName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdpositionName', False)

    
    positionName = property(__positionName.value, __positionName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}organisationName uses Python identifier organisationName
    __organisationName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'organisationName'), 'organisationName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdorganisationName', False)

    
    organisationName = property(__organisationName.value, __organisationName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}individualName uses Python identifier individualName
    __individualName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'individualName'), 'individualName', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_Type_httpwww_isotc211_org2005gmdindividualName', False)

    
    individualName = property(__individualName.value, __individualName.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __contactInfo.name() : __contactInfo,
        __role.name() : __role,
        __positionName.name() : __positionName,
        __organisationName.name() : __organisationName,
        __individualName.name() : __individualName
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_ResponsibleParty_Type', CI_ResponsibleParty_Type)


# Complex type CoordinatesType with content type SIMPLE
class CoordinatesType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = pyxb.binding.datatypes.string
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinatesType')
    # Base type is pyxb.binding.datatypes.string
    
    # Attribute decimal uses Python identifier decimal
    __decimal = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'decimal'), 'decimal', '__httpwww_opengis_netgml3_2_CoordinatesType_decimal', pyxb.binding.datatypes.string, unicode_default=u'.')
    
    decimal = property(__decimal.value, __decimal.set, None, None)

    
    # Attribute ts uses Python identifier ts
    __ts = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'ts'), 'ts', '__httpwww_opengis_netgml3_2_CoordinatesType_ts', pyxb.binding.datatypes.string, unicode_default=u' ')
    
    ts = property(__ts.value, __ts.set, None, None)

    
    # Attribute cs uses Python identifier cs
    __cs = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'cs'), 'cs', '__httpwww_opengis_netgml3_2_CoordinatesType_cs', pyxb.binding.datatypes.string, unicode_default=u',')
    
    cs = property(__cs.value, __cs.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __decimal.name() : __decimal,
        __ts.name() : __ts,
        __cs.name() : __cs
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinatesType', CoordinatesType)


# Complex type DQ_NonQuantitativeAttributeAccuracy_PropertyType with content type ELEMENT_ONLY
class DQ_NonQuantitativeAttributeAccuracy_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_NonQuantitativeAttributeAccuracy_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_NonQuantitativeAttributeAccuracy uses Python identifier DQ_NonQuantitativeAttributeAccuracy
    __DQ_NonQuantitativeAttributeAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_NonQuantitativeAttributeAccuracy'), 'DQ_NonQuantitativeAttributeAccuracy', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_isotc211_org2005gmdDQ_NonQuantitativeAttributeAccuracy', False)

    
    DQ_NonQuantitativeAttributeAccuracy = property(__DQ_NonQuantitativeAttributeAccuracy.value, __DQ_NonQuantitativeAttributeAccuracy.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_NonQuantitativeAttributeAccuracy_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __DQ_NonQuantitativeAttributeAccuracy.name() : __DQ_NonQuantitativeAttributeAccuracy
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_NonQuantitativeAttributeAccuracy_PropertyType', DQ_NonQuantitativeAttributeAccuracy_PropertyType)


# Complex type AbstractCurveSegmentType with content type EMPTY
class AbstractCurveSegmentType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurveSegmentType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute numDerivativesAtStart uses Python identifier numDerivativesAtStart
    __numDerivativesAtStart = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativesAtStart'), 'numDerivativesAtStart', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativesAtStart', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativesAtStart = property(__numDerivativesAtStart.value, __numDerivativesAtStart.set, None, None)

    
    # Attribute numDerivativeInterior uses Python identifier numDerivativeInterior
    __numDerivativeInterior = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativeInterior'), 'numDerivativeInterior', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativeInterior', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativeInterior = property(__numDerivativeInterior.value, __numDerivativeInterior.set, None, None)

    
    # Attribute numDerivativesAtEnd uses Python identifier numDerivativesAtEnd
    __numDerivativesAtEnd = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'numDerivativesAtEnd'), 'numDerivativesAtEnd', '__httpwww_opengis_netgml3_2_AbstractCurveSegmentType_numDerivativesAtEnd', pyxb.binding.datatypes.integer, unicode_default=u'0')
    
    numDerivativesAtEnd = property(__numDerivativesAtEnd.value, __numDerivativesAtEnd.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __numDerivativesAtStart.name() : __numDerivativesAtStart,
        __numDerivativeInterior.name() : __numDerivativeInterior,
        __numDerivativesAtEnd.name() : __numDerivativesAtEnd
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCurveSegmentType', AbstractCurveSegmentType)


# Complex type OffsetCurveType with content type ELEMENT_ONLY
class OffsetCurveType (AbstractCurveSegmentType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OffsetCurveType')
    # Base type is AbstractCurveSegmentType
    
    # Element {http://www.opengis.net/gml/3.2}refDirection uses Python identifier refDirection
    __refDirection = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'refDirection'), 'refDirection', '__httpwww_opengis_netgml3_2_OffsetCurveType_httpwww_opengis_netgml3_2refDirection', False)

    
    refDirection = property(__refDirection.value, __refDirection.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}offsetBase uses Python identifier offsetBase
    __offsetBase = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'offsetBase'), 'offsetBase', '__httpwww_opengis_netgml3_2_OffsetCurveType_httpwww_opengis_netgml3_2offsetBase', False)

    
    offsetBase = property(__offsetBase.value, __offsetBase.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}distance uses Python identifier distance
    __distance = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'distance'), 'distance', '__httpwww_opengis_netgml3_2_OffsetCurveType_httpwww_opengis_netgml3_2distance', False)

    
    distance = property(__distance.value, __distance.set, None, None)

    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType

    _ElementMap = AbstractCurveSegmentType._ElementMap.copy()
    _ElementMap.update({
        __refDirection.name() : __refDirection,
        __offsetBase.name() : __offsetBase,
        __distance.name() : __distance
    })
    _AttributeMap = AbstractCurveSegmentType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OffsetCurveType', OffsetCurveType)


# Complex type TimeCSPropertyType with content type ELEMENT_ONLY
class TimeCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeCS uses Python identifier TimeCS
    __TimeCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCS'), 'TimeCS', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_opengis_netgml3_2TimeCS', False)

    
    TimeCS = property(__TimeCS.value, __TimeCS.set, None, u'gml:TimeCS is a one-dimensional coordinate system containing a time axis, used to describe the temporal position of a point in the specified time units from a specified time origin. A TimeCS shall have one gml:axis property element.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __TimeCS.name() : __TimeCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __type.name() : __type,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeCSPropertyType', TimeCSPropertyType)


# Complex type TemporalCSType with content type ELEMENT_ONLY
class TemporalCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalCSType', TemporalCSType)


# Complex type MD_BrowseGraphic_Type with content type ELEMENT_ONLY
class MD_BrowseGraphic_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_BrowseGraphic_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}fileType uses Python identifier fileType
    __fileType = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileType'), 'fileType', '__httpwww_isotc211_org2005gmd_MD_BrowseGraphic_Type_httpwww_isotc211_org2005gmdfileType', False)

    
    fileType = property(__fileType.value, __fileType.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}fileName uses Python identifier fileName
    __fileName = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileName'), 'fileName', '__httpwww_isotc211_org2005gmd_MD_BrowseGraphic_Type_httpwww_isotc211_org2005gmdfileName', False)

    
    fileName = property(__fileName.value, __fileName.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}fileDescription uses Python identifier fileDescription
    __fileDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'fileDescription'), 'fileDescription', '__httpwww_isotc211_org2005gmd_MD_BrowseGraphic_Type_httpwww_isotc211_org2005gmdfileDescription', False)

    
    fileDescription = property(__fileDescription.value, __fileDescription.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __fileType.name() : __fileType,
        __fileName.name() : __fileName,
        __fileDescription.name() : __fileDescription
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_BrowseGraphic_Type', MD_BrowseGraphic_Type)


# Complex type DerivationUnitTermType with content type EMPTY
class DerivationUnitTermType (UnitOfMeasureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_EMPTY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DerivationUnitTermType')
    # Base type is UnitOfMeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}UnitOfMeasureType
    
    # Attribute exponent uses Python identifier exponent
    __exponent = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'exponent'), 'exponent', '__httpwww_opengis_netgml3_2_DerivationUnitTermType_exponent', pyxb.binding.datatypes.integer)
    
    exponent = property(__exponent.value, __exponent.set, None, None)


    _ElementMap = UnitOfMeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = UnitOfMeasureType._AttributeMap.copy()
    _AttributeMap.update({
        __exponent.name() : __exponent
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DerivationUnitTermType', DerivationUnitTermType)


# Complex type CylindricalCSPropertyType with content type ELEMENT_ONLY
class CylindricalCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CylindricalCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CylindricalCS uses Python identifier CylindricalCS
    __CylindricalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CylindricalCS'), 'CylindricalCS', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_opengis_netgml3_2CylindricalCS', False)

    
    CylindricalCS = property(__CylindricalCS.value, __CylindricalCS.set, None, u'gml:CylindricalCS is a three-dimensional coordinate system consisting of a polar coordinate system extended by a straight coordinate axis perpendicular to the plane spanned by the polar coordinate system. A CylindricalCS shall have three gml:axis property elements.')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CylindricalCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __CylindricalCS.name() : __CylindricalCS
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CylindricalCSPropertyType', CylindricalCSPropertyType)


# Complex type AbstractEX_GeographicExtent_Type with content type ELEMENT_ONLY
class AbstractEX_GeographicExtent_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractEX_GeographicExtent_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}extentTypeCode uses Python identifier extentTypeCode
    __extentTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'extentTypeCode'), 'extentTypeCode', '__httpwww_isotc211_org2005gmd_AbstractEX_GeographicExtent_Type_httpwww_isotc211_org2005gmdextentTypeCode', False)

    
    extentTypeCode = property(__extentTypeCode.value, __extentTypeCode.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __extentTypeCode.name() : __extentTypeCode
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractEX_GeographicExtent_Type', AbstractEX_GeographicExtent_Type)


# Complex type EX_BoundingPolygon_Type with content type ELEMENT_ONLY
class EX_BoundingPolygon_Type (AbstractEX_GeographicExtent_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_BoundingPolygon_Type')
    # Base type is AbstractEX_GeographicExtent_Type
    
    # Element extentTypeCode ({http://www.isotc211.org/2005/gmd}extentTypeCode) inherited from {http://www.isotc211.org/2005/gmd}AbstractEX_GeographicExtent_Type
    
    # Element {http://www.isotc211.org/2005/gmd}polygon uses Python identifier polygon
    __polygon = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'polygon'), 'polygon', '__httpwww_isotc211_org2005gmd_EX_BoundingPolygon_Type_httpwww_isotc211_org2005gmdpolygon', True)

    
    polygon = property(__polygon.value, __polygon.set, None, None)

    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractEX_GeographicExtent_Type._ElementMap.copy()
    _ElementMap.update({
        __polygon.name() : __polygon
    })
    _AttributeMap = AbstractEX_GeographicExtent_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_BoundingPolygon_Type', EX_BoundingPolygon_Type)


# Complex type MD_GridSpatialRepresentation_PropertyType with content type ELEMENT_ONLY
class MD_GridSpatialRepresentation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GridSpatialRepresentation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_GridSpatialRepresentation uses Python identifier MD_GridSpatialRepresentation
    __MD_GridSpatialRepresentation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_GridSpatialRepresentation'), 'MD_GridSpatialRepresentation', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_isotc211_org2005gmdMD_GridSpatialRepresentation', False)

    
    MD_GridSpatialRepresentation = property(__MD_GridSpatialRepresentation.value, __MD_GridSpatialRepresentation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_GridSpatialRepresentation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __MD_GridSpatialRepresentation.name() : __MD_GridSpatialRepresentation
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_GridSpatialRepresentation_PropertyType', MD_GridSpatialRepresentation_PropertyType)


# Complex type ValuePropertyType with content type ELEMENT_ONLY
class ValuePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ValuePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Null uses Python identifier Null
    __Null = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Null'), 'Null', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2Null', False)

    
    Null = property(__Null.value, __Null.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractValue uses Python identifier AbstractValue
    __AbstractValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractValue'), 'AbstractValue', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2AbstractValue', False)

    
    AbstractValue = property(__AbstractValue.value, __AbstractValue.set, None, u'gml:AbstractValue is an abstract element which acts as the head of a substitution group which contains gml:AbstractScalarValue, gml:AbstractScalarValueList, gml:CompositeValue and gml:ValueExtent, and (transitively) the elements in their substitution groups.\nThese elements may be used in an application schema as variables, so that in an XML instance document any member of its substitution group may occur.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractTimeObject uses Python identifier AbstractTimeObject
    __AbstractTimeObject = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeObject'), 'AbstractTimeObject', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2AbstractTimeObject', False)

    
    AbstractTimeObject = property(__AbstractTimeObject.value, __AbstractTimeObject.set, None, u'gml:AbstractTimeObject acts as the head of a substitution group for all temporal primitives and complexes.')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ValuePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ValuePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ValuePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __Null.name() : __Null,
        __AbstractGeometry.name() : __AbstractGeometry,
        __AbstractValue.name() : __AbstractValue,
        __AbstractTimeObject.name() : __AbstractTimeObject
    }
    _AttributeMap = {
        __title.name() : __title,
        __owns.name() : __owns,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ValuePropertyType', ValuePropertyType)


# Complex type AbstractGeometricPrimitiveType with content type ELEMENT_ONLY
class AbstractGeometricPrimitiveType (AbstractGeometryType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometricPrimitiveType')
    # Base type is AbstractGeometryType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometryType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometryType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometricPrimitiveType', AbstractGeometricPrimitiveType)


# Complex type PointType with content type ELEMENT_ONLY
class PointType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PointType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_PointType_httpwww_opengis_netgml3_2pos', False)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_PointType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __pos.name() : __pos,
        __coordinates.name() : __coordinates
    })
    _AttributeMap = AbstractGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PointType', PointType)


# Complex type AbstractSurfaceType with content type ELEMENT_ONLY
class AbstractSurfaceType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurfaceType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractSurfaceType', AbstractSurfaceType)


# Complex type SurfaceType with content type ELEMENT_ONLY
class SurfaceType (AbstractSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfaceType')
    # Base type is AbstractSurfaceType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}patches uses Python identifier patches
    __patches = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'patches'), 'patches', '__httpwww_opengis_netgml3_2_SurfaceType_httpwww_opengis_netgml3_2patches', False)

    
    patches = property(__patches.value, __patches.set, None, u'The patches property element contains the sequence of surface patches. The order of the elements is significant and shall be preserved when processing the array.')

    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __patches.name() : __patches
    })
    _AttributeMap = AbstractSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'SurfaceType', SurfaceType)


# Complex type ProjectedCRSType with content type ELEMENT_ONLY
class ProjectedCRSType (AbstractGeneralDerivedCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ProjectedCRSType')
    # Base type is AbstractGeneralDerivedCRSType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}baseGeographicCRS uses Python identifier baseGeographicCRS
    __baseGeographicCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseGeographicCRS'), 'baseGeographicCRS', '__httpwww_opengis_netgml3_2_ProjectedCRSType_httpwww_opengis_netgml3_2baseGeographicCRS', False)

    
    baseGeographicCRS = property(__baseGeographicCRS.value, __baseGeographicCRS.set, None, u'')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}cartesianCS uses Python identifier cartesianCS
    __cartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'cartesianCS'), 'cartesianCS', '__httpwww_opengis_netgml3_2_ProjectedCRSType_httpwww_opengis_netgml3_2cartesianCS', False)

    
    cartesianCS = property(__cartesianCS.value, __cartesianCS.set, None, u'gml:cartesianCS is an association role to the Cartesian coordinate system used by this CRS.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element conversion ({http://www.opengis.net/gml/3.2}conversion) inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralDerivedCRSType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}baseGeodeticCRS uses Python identifier baseGeodeticCRS
    __baseGeodeticCRS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseGeodeticCRS'), 'baseGeodeticCRS', '__httpwww_opengis_netgml3_2_ProjectedCRSType_httpwww_opengis_netgml3_2baseGeodeticCRS', False)

    
    baseGeodeticCRS = property(__baseGeodeticCRS.value, __baseGeodeticCRS.set, None, u'gml:baseGeodeticCRS is an association role to the geodetic coordinate reference system used by this projected CRS.')

    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractGeneralDerivedCRSType._ElementMap.copy()
    _ElementMap.update({
        __baseGeographicCRS.name() : __baseGeographicCRS,
        __cartesianCS.name() : __cartesianCS,
        __baseGeodeticCRS.name() : __baseGeodeticCRS
    })
    _AttributeMap = AbstractGeneralDerivedCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ProjectedCRSType', ProjectedCRSType)


# Complex type ConeType with content type ELEMENT_ONLY
class ConeType (AbstractGriddedSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ConeType')
    # Base type is AbstractGriddedSurfaceType
    
    # Element rows ({http://www.opengis.net/gml/3.2}rows) inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType
    
    # Attribute horizontalCurveType uses Python identifier horizontalCurveType
    __horizontalCurveType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'horizontalCurveType'), 'horizontalCurveType', '__httpwww_opengis_netgml3_2_ConeType_horizontalCurveType', CurveInterpolationType, fixed=True, unicode_default=u'circularArc3Points')
    
    horizontalCurveType = property(__horizontalCurveType.value, __horizontalCurveType.set, None, None)

    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractParametricCurveSurfaceType
    
    # Attribute columns inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType
    
    # Attribute verticalCurveType uses Python identifier verticalCurveType
    __verticalCurveType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'verticalCurveType'), 'verticalCurveType', '__httpwww_opengis_netgml3_2_ConeType_verticalCurveType', CurveInterpolationType, fixed=True, unicode_default=u'linear')
    
    verticalCurveType = property(__verticalCurveType.value, __verticalCurveType.set, None, None)

    
    # Attribute rows_ inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType

    _ElementMap = AbstractGriddedSurfaceType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGriddedSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __horizontalCurveType.name() : __horizontalCurveType,
        __verticalCurveType.name() : __verticalCurveType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ConeType', ConeType)


# Complex type AbstractRingPropertyType with content type ELEMENT_ONLY
class AbstractRingPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractRingPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractRing uses Python identifier AbstractRing
    __AbstractRing = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractRing'), 'AbstractRing', '__httpwww_opengis_netgml3_2_AbstractRingPropertyType_httpwww_opengis_netgml3_2AbstractRing', False)

    
    AbstractRing = property(__AbstractRing.value, __AbstractRing.set, None, u'An abstraction of a ring to support surface boundaries of different complexity.\nThe AbstractRing element is the abstract head of the substituition group for all closed boundaries of a surface patch.')


    _ElementMap = {
        __AbstractRing.name() : __AbstractRing
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractRingPropertyType', AbstractRingPropertyType)


# Complex type SurfaceArrayPropertyType with content type ELEMENT_ONLY
class SurfaceArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SurfaceArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractSurface uses Python identifier AbstractSurface
    __AbstractSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractSurface'), 'AbstractSurface', '__httpwww_opengis_netgml3_2_SurfaceArrayPropertyType_httpwww_opengis_netgml3_2AbstractSurface', True)

    
    AbstractSurface = property(__AbstractSurface.value, __AbstractSurface.set, None, u'The AbstractSurface element is the abstract head of the substitution group for all (continuous) surface elements.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_SurfaceArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractSurface.name() : __AbstractSurface
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SurfaceArrayPropertyType', SurfaceArrayPropertyType)


# Complex type AbstractDQ_TemporalAccuracy_Type with content type ELEMENT_ONLY
class AbstractDQ_TemporalAccuracy_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_TemporalAccuracy_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_TemporalAccuracy_Type', AbstractDQ_TemporalAccuracy_Type)


# Complex type AbstractDS_Aggregate_Type with content type ELEMENT_ONLY
class AbstractDS_Aggregate_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDS_Aggregate_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}subset uses Python identifier subset
    __subset = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'subset'), 'subset', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdsubset', True)

    
    subset = property(__subset.value, __subset.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}composedOf uses Python identifier composedOf
    __composedOf = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'composedOf'), 'composedOf', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdcomposedOf', True)

    
    composedOf = property(__composedOf.value, __composedOf.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}seriesMetadata uses Python identifier seriesMetadata
    __seriesMetadata = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'seriesMetadata'), 'seriesMetadata', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdseriesMetadata', True)

    
    seriesMetadata = property(__seriesMetadata.value, __seriesMetadata.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}superset uses Python identifier superset
    __superset = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'superset'), 'superset', '__httpwww_isotc211_org2005gmd_AbstractDS_Aggregate_Type_httpwww_isotc211_org2005gmdsuperset', True)

    
    superset = property(__superset.value, __superset.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __subset.name() : __subset,
        __composedOf.name() : __composedOf,
        __seriesMetadata.name() : __seriesMetadata,
        __superset.name() : __superset
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDS_Aggregate_Type', AbstractDS_Aggregate_Type)


# Complex type DS_Series_Type with content type ELEMENT_ONLY
class DS_Series_Type (AbstractDS_Aggregate_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Series_Type')
    # Base type is AbstractDS_Aggregate_Type
    
    # Element subset ({http://www.isotc211.org/2005/gmd}subset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element composedOf ({http://www.isotc211.org/2005/gmd}composedOf) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element seriesMetadata ({http://www.isotc211.org/2005/gmd}seriesMetadata) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element superset ({http://www.isotc211.org/2005/gmd}superset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDS_Aggregate_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDS_Aggregate_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_Series_Type', DS_Series_Type)


# Complex type DS_ProductionSeries_Type with content type ELEMENT_ONLY
class DS_ProductionSeries_Type (DS_Series_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_ProductionSeries_Type')
    # Base type is DS_Series_Type
    
    # Element subset ({http://www.isotc211.org/2005/gmd}subset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element composedOf ({http://www.isotc211.org/2005/gmd}composedOf) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element seriesMetadata ({http://www.isotc211.org/2005/gmd}seriesMetadata) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Element superset ({http://www.isotc211.org/2005/gmd}superset) inherited from {http://www.isotc211.org/2005/gmd}AbstractDS_Aggregate_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = DS_Series_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DS_Series_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_ProductionSeries_Type', DS_ProductionSeries_Type)


# Complex type MD_ExtendedElementInformation_PropertyType with content type ELEMENT_ONLY
class MD_ExtendedElementInformation_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ExtendedElementInformation_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ExtendedElementInformation uses Python identifier MD_ExtendedElementInformation
    __MD_ExtendedElementInformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ExtendedElementInformation'), 'MD_ExtendedElementInformation', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_isotc211_org2005gmdMD_ExtendedElementInformation', False)

    
    MD_ExtendedElementInformation = property(__MD_ExtendedElementInformation.value, __MD_ExtendedElementInformation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_ExtendedElementInformation_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __MD_ExtendedElementInformation.name() : __MD_ExtendedElementInformation
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ExtendedElementInformation_PropertyType', MD_ExtendedElementInformation_PropertyType)


# Complex type DQ_TopologicalConsistency_PropertyType with content type ELEMENT_ONLY
class DQ_TopologicalConsistency_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TopologicalConsistency_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DQ_TopologicalConsistency uses Python identifier DQ_TopologicalConsistency
    __DQ_TopologicalConsistency = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TopologicalConsistency'), 'DQ_TopologicalConsistency', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_isotc211_org2005gmdDQ_TopologicalConsistency', False)

    
    DQ_TopologicalConsistency = property(__DQ_TopologicalConsistency.value, __DQ_TopologicalConsistency.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_TopologicalConsistency_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)


    _ElementMap = {
        __DQ_TopologicalConsistency.name() : __DQ_TopologicalConsistency
    }
    _AttributeMap = {
        __arcrole.name() : __arcrole,
        __show.name() : __show,
        __role.name() : __role,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __title.name() : __title,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __uuidref.name() : __uuidref
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_TopologicalConsistency_PropertyType', DQ_TopologicalConsistency_PropertyType)


# Complex type EX_GeographicDescription_PropertyType with content type ELEMENT_ONLY
class EX_GeographicDescription_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_GeographicDescription_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_GeographicDescription uses Python identifier EX_GeographicDescription
    __EX_GeographicDescription = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_GeographicDescription'), 'EX_GeographicDescription', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_isotc211_org2005gmdEX_GeographicDescription', False)

    
    EX_GeographicDescription = property(__EX_GeographicDescription.value, __EX_GeographicDescription.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_EX_GeographicDescription_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __EX_GeographicDescription.name() : __EX_GeographicDescription
    }
    _AttributeMap = {
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_GeographicDescription_PropertyType', EX_GeographicDescription_PropertyType)


# Complex type DS_Association_PropertyType with content type ELEMENT_ONLY
class DS_Association_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Association_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DS_Association uses Python identifier DS_Association
    __DS_Association = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Association'), 'DS_Association', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_isotc211_org2005gmdDS_Association', False)

    
    DS_Association = property(__DS_Association.value, __DS_Association.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DS_Association_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __DS_Association.name() : __DS_Association
    }
    _AttributeMap = {
        __role.name() : __role,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_Association_PropertyType', DS_Association_PropertyType)


# Complex type OperationParameterPropertyType with content type ELEMENT_ONLY
class OperationParameterPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameterPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}OperationParameter uses Python identifier OperationParameter
    __OperationParameter = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'OperationParameter'), 'OperationParameter', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_opengis_netgml3_2OperationParameter', False)

    
    OperationParameter = property(__OperationParameter.value, __OperationParameter.set, None, u'gml:OperationParameter is the definition of a parameter used by an operation method. Most parameter values are numeric, but other types of parameter values are possible. This complex type is expected to be used or extended for all operation methods, without defining operation-method-specialized element names.')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_OperationParameterPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __OperationParameter.name() : __OperationParameter
    }
    _AttributeMap = {
        __show.name() : __show,
        __role.name() : __role,
        __title.name() : __title,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'OperationParameterPropertyType', OperationParameterPropertyType)


# Complex type DirectedObservationType with content type ELEMENT_ONLY
class DirectedObservationType (ObservationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedObservationType')
    # Base type is ObservationType
    
    # Element {http://www.opengis.net/gml/3.2}direction uses Python identifier direction
    __direction = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'direction'), 'direction', '__httpwww_opengis_netgml3_2_DirectedObservationType_httpwww_opengis_netgml3_2direction', False)

    
    direction = property(__direction.value, __direction.set, None, u'The property gml:direction is intended as a pre-defined property expressing a direction to be assigned to features defined in a GML application schema.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element using ({http://www.opengis.net/gml/3.2}using) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element validTime ({http://www.opengis.net/gml/3.2}validTime) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element target ({http://www.opengis.net/gml/3.2}target) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element resultOf ({http://www.opengis.net/gml/3.2}resultOf) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = ObservationType._ElementMap.copy()
    _ElementMap.update({
        __direction.name() : __direction
    })
    _AttributeMap = ObservationType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedObservationType', DirectedObservationType)


# Complex type DirectedObservationAtDistanceType with content type ELEMENT_ONLY
class DirectedObservationAtDistanceType (DirectedObservationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedObservationAtDistanceType')
    # Base type is DirectedObservationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element direction ({http://www.opengis.net/gml/3.2}direction) inherited from {http://www.opengis.net/gml/3.2}DirectedObservationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element using ({http://www.opengis.net/gml/3.2}using) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element validTime ({http://www.opengis.net/gml/3.2}validTime) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element target ({http://www.opengis.net/gml/3.2}target) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element resultOf ({http://www.opengis.net/gml/3.2}resultOf) inherited from {http://www.opengis.net/gml/3.2}ObservationType
    
    # Element {http://www.opengis.net/gml/3.2}distance uses Python identifier distance
    __distance = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'distance'), 'distance', '__httpwww_opengis_netgml3_2_DirectedObservationAtDistanceType_httpwww_opengis_netgml3_2distance', False)

    
    distance = property(__distance.value, __distance.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = DirectedObservationType._ElementMap.copy()
    _ElementMap.update({
        __distance.name() : __distance
    })
    _AttributeMap = DirectedObservationType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedObservationAtDistanceType', DirectedObservationAtDistanceType)


# Complex type AffinePlacementType with content type ELEMENT_ONLY
class AffinePlacementType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AffinePlacementType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}inDimension uses Python identifier inDimension
    __inDimension = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'inDimension'), 'inDimension', '__httpwww_opengis_netgml3_2_AffinePlacementType_httpwww_opengis_netgml3_2inDimension', False)

    
    inDimension = property(__inDimension.value, __inDimension.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}outDimension uses Python identifier outDimension
    __outDimension = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'outDimension'), 'outDimension', '__httpwww_opengis_netgml3_2_AffinePlacementType_httpwww_opengis_netgml3_2outDimension', False)

    
    outDimension = property(__outDimension.value, __outDimension.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}location uses Python identifier location
    __location = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'location'), 'location', '__httpwww_opengis_netgml3_2_AffinePlacementType_httpwww_opengis_netgml3_2location', False)

    
    location = property(__location.value, __location.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}refDirection uses Python identifier refDirection
    __refDirection = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'refDirection'), 'refDirection', '__httpwww_opengis_netgml3_2_AffinePlacementType_httpwww_opengis_netgml3_2refDirection', True)

    
    refDirection = property(__refDirection.value, __refDirection.set, None, None)


    _ElementMap = {
        __inDimension.name() : __inDimension,
        __outDimension.name() : __outDimension,
        __location.name() : __location,
        __refDirection.name() : __refDirection
    }
    _AttributeMap = {
        
    }
_Namespace_gml.addCategoryObject('typeBinding', u'AffinePlacementType', AffinePlacementType)


# Complex type AbstractDatumType with content type ELEMENT_ONLY
class AbstractDatumType (IdentifiedObjectType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractDatumType')
    # Base type is IdentifiedObjectType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}scope uses Python identifier scope
    __scope = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'scope'), 'scope', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2scope', True)

    
    scope = property(__scope.value, __scope.set, None, u'The gml:scope property provides a description of the usage, or limitations of usage, for which this CRS-related object is valid. If unknown, enter "not known".')

    
    # Element {http://www.opengis.net/gml/3.2}domainOfValidity uses Python identifier domainOfValidity
    __domainOfValidity = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'domainOfValidity'), 'domainOfValidity', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2domainOfValidity', False)

    
    domainOfValidity = property(__domainOfValidity.value, __domainOfValidity.set, None, u'The gml:domainOfValidity property implements an association role to an EX_Extent object as encoded in ISO/TS 19139, either referencing or containing the definition of that extent.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}anchorDefinition uses Python identifier anchorDefinition
    __anchorDefinition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'anchorDefinition'), 'anchorDefinition', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2anchorDefinition', False)

    
    anchorDefinition = property(__anchorDefinition.value, __anchorDefinition.set, None, u'gml:anchorDefinition is a description, possibly including coordinates, of the definition used to anchor the datum to the Earth. Also known as the "origin", especially for engineering and image datums. The codeSpace attribute may be used to reference a source of more detailed on this point or surface, or on a set of such descriptions.\n-\tFor a geodetic datum, this point is also known as the fundamental point, which is traditionally the point where the relationship between geoid and ellipsoid is defined. In some cases, the "fundamental point" may consist of a number of points. In those cases, the parameters defining the geoid/ellipsoid relationship have been averaged for these points, and the averages adopted as the datum definition.\n-\tFor an engineering datum, the anchor definition may be a physical point, or it may be a point with defined coordinates in another CRS.may\n-\tFor an image datum, the anchor definition is usually either the centre of the image or the corner of the image.\n-\tFor a temporal datum, this attribute is not defined. Instead of the anchor definition, a temporal datum carries a separate time origin of type DateTime.')

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}realizationEpoch uses Python identifier realizationEpoch
    __realizationEpoch = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'realizationEpoch'), 'realizationEpoch', '__httpwww_opengis_netgml3_2_AbstractDatumType_httpwww_opengis_netgml3_2realizationEpoch', False)

    
    realizationEpoch = property(__realizationEpoch.value, __realizationEpoch.set, None, u'gml:realizationEpoch is the time after which this datum definition is valid. See ISO 19111 Table 32 for details.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = IdentifiedObjectType._ElementMap.copy()
    _ElementMap.update({
        __scope.name() : __scope,
        __domainOfValidity.name() : __domainOfValidity,
        __anchorDefinition.name() : __anchorDefinition,
        __realizationEpoch.name() : __realizationEpoch
    })
    _AttributeMap = IdentifiedObjectType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractDatumType', AbstractDatumType)


# Complex type TemporalDatumBaseType with content type ELEMENT_ONLY
class TemporalDatumBaseType (AbstractDatumType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalDatumBaseType')
    # Base type is AbstractDatumType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id_
    __id_ = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id_', '__httpwww_opengis_netgml3_2_DefinitionBaseType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id_ = property(__id_.value, __id_.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractDatumType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDatumType._AttributeMap.copy()
    _AttributeMap.update({
        __id_.name() : __id_
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalDatumBaseType', TemporalDatumBaseType)


# Complex type TemporalDatumType with content type ELEMENT_ONLY
class TemporalDatumType (TemporalDatumBaseType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TemporalDatumType')
    # Base type is TemporalDatumBaseType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractDatumType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}origin uses Python identifier origin
    __origin = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'origin'), 'origin', '__httpwww_opengis_netgml3_2_TemporalDatumType_httpwww_opengis_netgml3_2origin', False)

    
    origin = property(__origin.value, __origin.set, None, u'gml:origin is the date and time origin of this temporal datum.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_2 inherited from {http://www.opengis.net/gml/3.2}TemporalDatumBaseType

    _ElementMap = TemporalDatumBaseType._ElementMap.copy()
    _ElementMap.update({
        __origin.name() : __origin
    })
    _AttributeMap = TemporalDatumBaseType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TemporalDatumType', TemporalDatumType)


# Complex type CI_ResponsibleParty_PropertyType with content type ELEMENT_ONLY
class CI_ResponsibleParty_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_ResponsibleParty uses Python identifier CI_ResponsibleParty
    __CI_ResponsibleParty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_ResponsibleParty'), 'CI_ResponsibleParty', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_isotc211_org2005gmdCI_ResponsibleParty', False)

    
    CI_ResponsibleParty = property(__CI_ResponsibleParty.value, __CI_ResponsibleParty.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_CI_ResponsibleParty_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __CI_ResponsibleParty.name() : __CI_ResponsibleParty
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __href.name() : __href,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'CI_ResponsibleParty_PropertyType', CI_ResponsibleParty_PropertyType)


# Complex type TopoCurveType with content type ELEMENT_ONLY
class TopoCurveType (AbstractTopologyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoCurveType')
    # Base type is AbstractTopologyType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}directedEdge uses Python identifier directedEdge
    __directedEdge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'directedEdge'), 'directedEdge', '__httpwww_opengis_netgml3_2_TopoCurveType_httpwww_opengis_netgml3_2directedEdge', True)

    
    directedEdge = property(__directedEdge.value, __directedEdge.set, None, u'A gml:directedEdge property element describes the boundary of topology faces, the coBoundary of topology nodes and is used in the support of topological line features via the gml:TopoCurve expression, see below. The orientation attribute of type gml:SignType expresses the sense in which the included edge is used, i.e. forward or reverse.')

    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_TopoCurveType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTopologyType._ElementMap.copy()
    _ElementMap.update({
        __directedEdge.name() : __directedEdge
    })
    _AttributeMap = AbstractTopologyType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TopoCurveType', TopoCurveType)


# Complex type GeometricComplexPropertyType with content type ELEMENT_ONLY
class GeometricComplexPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'GeometricComplexPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}CompositeCurve uses Python identifier CompositeCurve
    __CompositeCurve = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CompositeCurve'), 'CompositeCurve', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_opengis_netgml3_2CompositeCurve', False)

    
    CompositeCurve = property(__CompositeCurve.value, __CompositeCurve.set, None, u'A gml:CompositeCurve is represented by a sequence of (orientable) curves such that each curve in the sequence terminates at the start point of the subsequent curve in the list. \ncurveMember references or contains inline one curve in the composite curve. \nThe curves are contiguous, the collection of curves is ordered. Therefore, if provided, the aggregationType attribute shall have the value "sequence".')

    
    # Element {http://www.opengis.net/gml/3.2}GeometricComplex uses Python identifier GeometricComplex
    __GeometricComplex = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'GeometricComplex'), 'GeometricComplex', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_opengis_netgml3_2GeometricComplex', False)

    
    GeometricComplex = property(__GeometricComplex.value, __GeometricComplex.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}CompositeSurface uses Python identifier CompositeSurface
    __CompositeSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CompositeSurface'), 'CompositeSurface', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_opengis_netgml3_2CompositeSurface', False)

    
    CompositeSurface = property(__CompositeSurface.value, __CompositeSurface.set, None, u'A gml:CompositeSurface is represented by a set of orientable surfaces. It is geometry type with all the geometric properties of a (primitive) surface. Essentially, a composite surface is a collection of surfaces that join in pairs on common boundary curves and which, when considered as a whole, form a single surface.\nsurfaceMember references or contains inline one surface in the composite surface. \nThe surfaces are contiguous.')

    
    # Element {http://www.opengis.net/gml/3.2}CompositeSolid uses Python identifier CompositeSolid
    __CompositeSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'CompositeSolid'), 'CompositeSolid', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_opengis_netgml3_2CompositeSolid', False)

    
    CompositeSolid = property(__CompositeSolid.value, __CompositeSolid.set, None, u'gml:CompositeSolid implements ISO 19107 GM_CompositeSolid (see ISO 19107:2003, 6.6.7) as specified in D.2.3.6. \nA gml:CompositeSolid is represented by a set of orientable surfaces. It is a geometry type with all the geometric properties of a (primitive) solid. Essentially, a composite solid is a collection of solids that join in pairs on common boundary surfaces and which, when considered as a whole, form a single solid. \nsolidMember references or contains one solid in the composite solid. The solids are contiguous.')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_GeometricComplexPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __CompositeCurve.name() : __CompositeCurve,
        __GeometricComplex.name() : __GeometricComplex,
        __CompositeSurface.name() : __CompositeSurface,
        __CompositeSolid.name() : __CompositeSolid
    }
    _AttributeMap = {
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'GeometricComplexPropertyType', GeometricComplexPropertyType)


# Complex type Date_PropertyType with content type ELEMENT_ONLY
class Date_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Date_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gco}DateTime uses Python identifier DateTime
    __DateTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'DateTime'), 'DateTime', '__httpwww_isotc211_org2005gco_Date_PropertyType_httpwww_isotc211_org2005gcoDateTime', False)

    
    DateTime = property(__DateTime.value, __DateTime.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gco}Date uses Python identifier Date
    __Date = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'Date'), 'Date', '__httpwww_isotc211_org2005gco_Date_PropertyType_httpwww_isotc211_org2005gcoDate', False)

    
    Date = property(__Date.value, __Date.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gco_Date_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __DateTime.name() : __DateTime,
        __Date.name() : __Date
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gco.addCategoryObject('typeBinding', u'Date_PropertyType', Date_PropertyType)


# Complex type TimeType with content type SIMPLE
class TimeType (MeasureType):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeType')
    # Base type is MeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}MeasureType

    _ElementMap = MeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = MeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeType', TimeType)


# Complex type OrientableSurfaceType with content type ELEMENT_ONLY
class OrientableSurfaceType (AbstractSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'OrientableSurfaceType')
    # Base type is AbstractSurfaceType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}baseSurface uses Python identifier baseSurface
    __baseSurface = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'baseSurface'), 'baseSurface', '__httpwww_opengis_netgml3_2_OrientableSurfaceType_httpwww_opengis_netgml3_2baseSurface', False)

    
    baseSurface = property(__baseSurface.value, __baseSurface.set, None, u'The property baseSurface references or contains the base surface. The property baseSurface either references the base surface via the XLink-attributes or contains the surface element. A surface element is any element which is substitutable for gml:AbstractSurface. The base surface has positive orientation.')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_OrientableSurfaceType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __baseSurface.name() : __baseSurface
    })
    _AttributeMap = AbstractSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __orientation.name() : __orientation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'OrientableSurfaceType', OrientableSurfaceType)


# Complex type AbstractDQ_LogicalConsistency_Type with content type ELEMENT_ONLY
class AbstractDQ_LogicalConsistency_Type (AbstractDQ_Element_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_LogicalConsistency_Type')
    # Base type is AbstractDQ_Element_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_Element_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_Element_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'AbstractDQ_LogicalConsistency_Type', AbstractDQ_LogicalConsistency_Type)


# Complex type DQ_DomainConsistency_Type with content type ELEMENT_ONLY
class DQ_DomainConsistency_Type (AbstractDQ_LogicalConsistency_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_DomainConsistency_Type')
    # Base type is AbstractDQ_LogicalConsistency_Type
    
    # Element evaluationMethodDescription ({http://www.isotc211.org/2005/gmd}evaluationMethodDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureDescription ({http://www.isotc211.org/2005/gmd}measureDescription) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element measureIdentification ({http://www.isotc211.org/2005/gmd}measureIdentification) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationMethodType ({http://www.isotc211.org/2005/gmd}evaluationMethodType) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element evaluationProcedure ({http://www.isotc211.org/2005/gmd}evaluationProcedure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element dateTime ({http://www.isotc211.org/2005/gmd}dateTime) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element result ({http://www.isotc211.org/2005/gmd}result) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Element nameOfMeasure ({http://www.isotc211.org/2005/gmd}nameOfMeasure) inherited from {http://www.isotc211.org/2005/gmd}AbstractDQ_Element_Type
    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractDQ_LogicalConsistency_Type._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractDQ_LogicalConsistency_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_DomainConsistency_Type', DQ_DomainConsistency_Type)


# Complex type MD_ImagingConditionCode_PropertyType with content type ELEMENT_ONLY
class MD_ImagingConditionCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ImagingConditionCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ImagingConditionCode uses Python identifier MD_ImagingConditionCode
    __MD_ImagingConditionCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ImagingConditionCode'), 'MD_ImagingConditionCode', '__httpwww_isotc211_org2005gmd_MD_ImagingConditionCode_PropertyType_httpwww_isotc211_org2005gmdMD_ImagingConditionCode', False)

    
    MD_ImagingConditionCode = property(__MD_ImagingConditionCode.value, __MD_ImagingConditionCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ImagingConditionCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_ImagingConditionCode.name() : __MD_ImagingConditionCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ImagingConditionCode_PropertyType', MD_ImagingConditionCode_PropertyType)


# Complex type DQ_TemporalAccuracy_PropertyType with content type ELEMENT_ONLY
class DQ_TemporalAccuracy_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_TemporalAccuracy_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractDQ_TemporalAccuracy uses Python identifier AbstractDQ_TemporalAccuracy
    __AbstractDQ_TemporalAccuracy = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_TemporalAccuracy'), 'AbstractDQ_TemporalAccuracy', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_isotc211_org2005gmdAbstractDQ_TemporalAccuracy', False)

    
    AbstractDQ_TemporalAccuracy = property(__AbstractDQ_TemporalAccuracy.value, __AbstractDQ_TemporalAccuracy.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_TemporalAccuracy_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __AbstractDQ_TemporalAccuracy.name() : __AbstractDQ_TemporalAccuracy
    }
    _AttributeMap = {
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __title.name() : __title
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_TemporalAccuracy_PropertyType', DQ_TemporalAccuracy_PropertyType)


# Complex type PT_Locale_PropertyType with content type ELEMENT_ONLY
class PT_Locale_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_Locale_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}PT_Locale uses Python identifier PT_Locale
    __PT_Locale = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'PT_Locale'), 'PT_Locale', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_isotc211_org2005gmdPT_Locale', False)

    
    PT_Locale = property(__PT_Locale.value, __PT_Locale.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_PT_Locale_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __PT_Locale.name() : __PT_Locale
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'PT_Locale_PropertyType', PT_Locale_PropertyType)


# Complex type LI_Source_Type with content type ELEMENT_ONLY
class LI_Source_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LI_Source_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}sourceCitation uses Python identifier sourceCitation
    __sourceCitation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sourceCitation'), 'sourceCitation', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdsourceCitation', False)

    
    sourceCitation = property(__sourceCitation.value, __sourceCitation.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}sourceExtent uses Python identifier sourceExtent
    __sourceExtent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sourceExtent'), 'sourceExtent', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdsourceExtent', True)

    
    sourceExtent = property(__sourceExtent.value, __sourceExtent.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}description uses Python identifier description
    __description = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'description'), 'description', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmddescription', False)

    
    description = property(__description.value, __description.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}sourceStep uses Python identifier sourceStep
    __sourceStep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sourceStep'), 'sourceStep', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdsourceStep', True)

    
    sourceStep = property(__sourceStep.value, __sourceStep.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}scaleDenominator uses Python identifier scaleDenominator
    __scaleDenominator = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'scaleDenominator'), 'scaleDenominator', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdscaleDenominator', False)

    
    scaleDenominator = property(__scaleDenominator.value, __scaleDenominator.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}sourceReferenceSystem uses Python identifier sourceReferenceSystem
    __sourceReferenceSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'sourceReferenceSystem'), 'sourceReferenceSystem', '__httpwww_isotc211_org2005gmd_LI_Source_Type_httpwww_isotc211_org2005gmdsourceReferenceSystem', False)

    
    sourceReferenceSystem = property(__sourceReferenceSystem.value, __sourceReferenceSystem.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __sourceCitation.name() : __sourceCitation,
        __sourceExtent.name() : __sourceExtent,
        __description.name() : __description,
        __sourceStep.name() : __sourceStep,
        __scaleDenominator.name() : __scaleDenominator,
        __sourceReferenceSystem.name() : __sourceReferenceSystem
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'LI_Source_Type', LI_Source_Type)


# Complex type AbstractGeneralConversionType with content type ELEMENT_ONLY
class AbstractGeneralConversionType (AbstractCoordinateOperationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralConversionType')
    # Base type is AbstractCoordinateOperationType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id_
    __id_ = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id_', '__httpwww_opengis_netgml3_2_DefinitionBaseType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id_ = property(__id_.value, __id_.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractCoordinateOperationType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateOperationType._AttributeMap.copy()
    _AttributeMap.update({
        __id_.name() : __id_
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralConversionType', AbstractGeneralConversionType)


# Complex type MD_DigitalTransferOptions_PropertyType with content type ELEMENT_ONLY
class MD_DigitalTransferOptions_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DigitalTransferOptions_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_DigitalTransferOptions uses Python identifier MD_DigitalTransferOptions
    __MD_DigitalTransferOptions = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_DigitalTransferOptions'), 'MD_DigitalTransferOptions', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_isotc211_org2005gmdMD_DigitalTransferOptions', False)

    
    MD_DigitalTransferOptions = property(__MD_DigitalTransferOptions.value, __MD_DigitalTransferOptions.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_DigitalTransferOptions_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __MD_DigitalTransferOptions.name() : __MD_DigitalTransferOptions
    }
    _AttributeMap = {
        __show.name() : __show,
        __title.name() : __title,
        __nilReason.name() : __nilReason,
        __uuidref.name() : __uuidref,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_DigitalTransferOptions_PropertyType', MD_DigitalTransferOptions_PropertyType)


# Complex type TimeNodePropertyType with content type ELEMENT_ONLY
class TimeNodePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeNodePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimeNode uses Python identifier TimeNode
    __TimeNode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeNode'), 'TimeNode', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_opengis_netgml3_2TimeNode', False)

    
    TimeNode = property(__TimeNode.value, __TimeNode.set, None, u'A time node is a zero-dimensional topological primitive that represents an identifiable node in time (it is equivalent to a point in space). A node may act as the termination or initiation of any number of time edges. A time node may be realised as a geometry, its position, whose value is a time instant.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeNodePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __TimeNode.name() : __TimeNode
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __owns.name() : __owns,
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeNodePropertyType', TimeNodePropertyType)


# Complex type CoordinateSystemPropertyType with content type ELEMENT_ONLY
class CoordinateSystemPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CoordinateSystemPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractCoordinateSystem uses Python identifier AbstractCoordinateSystem
    __AbstractCoordinateSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCoordinateSystem'), 'AbstractCoordinateSystem', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_opengis_netgml3_2AbstractCoordinateSystem', False)

    
    AbstractCoordinateSystem = property(__AbstractCoordinateSystem.value, __AbstractCoordinateSystem.set, None, u'gml:AbstractCoordinateSystem is a coordinate system (CS) is the non-repeating sequence of coordinate system axes that spans a given coordinate space. A CS is derived from a set of mathematical rules for specifying how coordinates in a given space are to be assigned to points. The coordinate values in a coordinate tuple shall be recorded in the order in which the coordinate system axes associations are recorded. This abstract complex type shall not be used, extended, or restricted, in an Application Schema, to define a concrete subtype with a meaning equivalent to a concrete subtype specified in this document.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CoordinateSystemPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __AbstractCoordinateSystem.name() : __AbstractCoordinateSystem
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CoordinateSystemPropertyType', CoordinateSystemPropertyType)


# Complex type MultiPointPropertyType with content type ELEMENT_ONLY
class MultiPointPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiPointPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}MultiPoint uses Python identifier MultiPoint
    __MultiPoint = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiPoint'), 'MultiPoint', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_opengis_netgml3_2MultiPoint', False)

    
    MultiPoint = property(__MultiPoint.value, __MultiPoint.set, None, u'A gml:MultiPoint consists of one or more gml:Points.\nThe members of the geometric aggregate may be specified either using the "standard" property (gml:pointMember) or the array property (gml:pointMembers). It is also valid to use both the "standard" and the array properties in the same collection.')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_MultiPointPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')


    _ElementMap = {
        __MultiPoint.name() : __MultiPoint
    }
    _AttributeMap = {
        __show.name() : __show,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __href.name() : __href,
        __title.name() : __title,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __remoteSchema.name() : __remoteSchema
    }
_Namespace_gml.addCategoryObject('typeBinding', u'MultiPointPropertyType', MultiPointPropertyType)


# Complex type TimeTopologyPrimitivePropertyType with content type ELEMENT_ONLY
class TimeTopologyPrimitivePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeTopologyPrimitivePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractTimeTopologyPrimitive uses Python identifier AbstractTimeTopologyPrimitive
    __AbstractTimeTopologyPrimitive = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractTimeTopologyPrimitive'), 'AbstractTimeTopologyPrimitive', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_opengis_netgml3_2AbstractTimeTopologyPrimitive', False)

    
    AbstractTimeTopologyPrimitive = property(__AbstractTimeTopologyPrimitive.value, __AbstractTimeTopologyPrimitive.set, None, u'gml:TimeTopologyPrimitive acts as the head of a substitution group for topological temporal primitives.\nTemporal topology primitives shall imply the ordering information between features or feature properties. The temporal connection of features can be examined if they have temporal topology primitives as values of their properties. Usually, an instantaneous feature associates with a time node, and a static feature associates with a time edge.  A feature with both modes associates with the temporal topology primitive: a supertype of time nodes and time edges.\nA topological primitive is always connected to one or more other topological primitives, and is, therefore, always a member of a topological complex. In a GML instance, this will often be indicated by the primitives being described by elements that are descendents of an element describing a complex. However, in order to support the case where a temporal topological primitive is described in another context, the optional complex property is provided, which carries a reference to the parent temporal topological complex.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimeTopologyPrimitivePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)


    _ElementMap = {
        __AbstractTimeTopologyPrimitive.name() : __AbstractTimeTopologyPrimitive
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __type.name() : __type,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __role.name() : __role,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimeTopologyPrimitivePropertyType', TimeTopologyPrimitivePropertyType)


# Complex type MD_Identifier_Type with content type ELEMENT_ONLY
class MD_Identifier_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Identifier_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}authority uses Python identifier authority
    __authority = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'authority'), 'authority', '__httpwww_isotc211_org2005gmd_MD_Identifier_Type_httpwww_isotc211_org2005gmdauthority', False)

    
    authority = property(__authority.value, __authority.set, None, None)

    
    # Element {http://www.isotc211.org/2005/gmd}code uses Python identifier code
    __code = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'code'), 'code', '__httpwww_isotc211_org2005gmd_MD_Identifier_Type_httpwww_isotc211_org2005gmdcode', False)

    
    code = property(__code.value, __code.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __authority.name() : __authority,
        __code.name() : __code
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Identifier_Type', MD_Identifier_Type)


# Complex type Multiplicity_Type with content type ELEMENT_ONLY
class Multiplicity_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gco, u'Multiplicity_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gco}range uses Python identifier range
    __range = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'range'), 'range', '__httpwww_isotc211_org2005gco_Multiplicity_Type_httpwww_isotc211_org2005gcorange', True)

    
    range = property(__range.value, __range.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __range.name() : __range
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gco.addCategoryObject('typeBinding', u'Multiplicity_Type', Multiplicity_Type)


# Complex type AbstractCurveType with content type ELEMENT_ONLY
class AbstractCurveType (AbstractGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractCurveType')
    # Base type is AbstractGeometricPrimitiveType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractCurveType', AbstractCurveType)


# Complex type CompositeCurveType with content type ELEMENT_ONLY
class CompositeCurveType (AbstractCurveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompositeCurveType')
    # Base type is AbstractCurveType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}curveMember uses Python identifier curveMember
    __curveMember = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'curveMember'), 'curveMember', '__httpwww_opengis_netgml3_2_CompositeCurveType_httpwww_opengis_netgml3_2curveMember', True)

    
    curveMember = property(__curveMember.value, __curveMember.set, None, None)

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_CompositeCurveType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractCurveType._ElementMap.copy()
    _ElementMap.update({
        __curveMember.name() : __curveMember
    })
    _AttributeMap = AbstractCurveType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CompositeCurveType', CompositeCurveType)


# Complex type TargetPropertyType with content type ELEMENT_ONLY
class TargetPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TargetPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractGeometry uses Python identifier AbstractGeometry
    __AbstractGeometry = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometry'), 'AbstractGeometry', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2AbstractGeometry', False)

    
    AbstractGeometry = property(__AbstractGeometry.value, __AbstractGeometry.set, None, u'The AbstractGeometry element is the abstract head of the substitution group for all geometry elements of GML. This includes pre-defined and user-defined geometry elements. Any geometry element shall be a direct or indirect extension/restriction of AbstractGeometryType and shall be directly or indirectly in the substitution group of AbstractGeometry.')

    
    # Element {http://www.opengis.net/gml/3.2}AbstractFeature uses Python identifier AbstractFeature
    __AbstractFeature = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractFeature'), 'AbstractFeature', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2AbstractFeature', False)

    
    AbstractFeature = property(__AbstractFeature.value, __AbstractFeature.set, None, u'This abstract element serves as the head of a substitution group which may contain any elements whose content model is derived from gml:AbstractFeatureType.  This may be used as a variable in the construction of content models.  \ngml:AbstractFeature may be thought of as "anything that is a GML feature" and may be used to define variables or templates in which the value of a GML property is "any feature". This occurs in particular in a GML feature collection where the feature member properties contain one or multiple copies of gml:AbstractFeature respectively.')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TargetPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TargetPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TargetPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractGeometry.name() : __AbstractGeometry,
        __AbstractFeature.name() : __AbstractFeature
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TargetPropertyType', TargetPropertyType)


# Complex type MD_Usage_PropertyType with content type ELEMENT_ONLY
class MD_Usage_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Usage_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_Usage uses Python identifier MD_Usage
    __MD_Usage = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_Usage'), 'MD_Usage', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_isotc211_org2005gmdMD_Usage', False)

    
    MD_Usage = property(__MD_Usage.value, __MD_Usage.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_Usage_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)


    _ElementMap = {
        __MD_Usage.name() : __MD_Usage
    }
    _AttributeMap = {
        __href.name() : __href,
        __uuidref.name() : __uuidref,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __title.name() : __title,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __role.name() : __role
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_Usage_PropertyType', MD_Usage_PropertyType)


# Complex type TopoComplexPropertyType with content type ELEMENT_ONLY
class TopoComplexPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoComplexPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoComplex uses Python identifier TopoComplex
    __TopoComplex = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoComplex'), 'TopoComplex', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_opengis_netgml3_2TopoComplex', False)

    
    TopoComplex = property(__TopoComplex.value, __TopoComplex.set, None, u'gml:TopoComplex is a collection of topological primitives.\nEach complex holds a reference to its maximal complex (gml:maximalComplex) and optionally to sub- or super-complexes (gml:subComplex, gml:superComplex). \nA topology complex contains its primitive and sub-complex members.\n')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TopoComplexPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __TopoComplex.name() : __TopoComplex
    }
    _AttributeMap = {
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __href.name() : __href,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TopoComplexPropertyType', TopoComplexPropertyType)


# Complex type ArrayAssociationType with content type ELEMENT_ONLY
class ArrayAssociationType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ArrayAssociationType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}AbstractObject uses Python identifier AbstractObject
    __AbstractObject = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractObject'), 'AbstractObject', '__httpwww_opengis_netgml3_2_ArrayAssociationType_httpwww_opengis_netgml3_2AbstractObject', True)

    
    AbstractObject = property(__AbstractObject.value, __AbstractObject.set, None, u'This element has no type defined, and is therefore implicitly (according to the rules of W3C XML Schema) an XML Schema anyType. It is used as the head of an XML Schema substitution group which unifies complex content and certain simple content elements used for datatypes in GML, including the gml:AbstractGML substitution group.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ArrayAssociationType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __AbstractObject.name() : __AbstractObject
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ArrayAssociationType', ArrayAssociationType)


# Complex type CTD_ANON_4 with content type ELEMENT_ONLY
class CTD_ANON_4 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_CTD_ANON_4_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')


    _ElementMap = {
        __pos.name() : __pos,
        __posList.name() : __posList,
        __pointProperty.name() : __pointProperty
    }
    _AttributeMap = {
        
    }



# Complex type TimeCalendarEraType with content type ELEMENT_ONLY
class TimeCalendarEraType (DefinitionType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimeCalendarEraType')
    # Base type is DefinitionType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}referenceEvent uses Python identifier referenceEvent
    __referenceEvent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'referenceEvent'), 'referenceEvent', '__httpwww_opengis_netgml3_2_TimeCalendarEraType_httpwww_opengis_netgml3_2referenceEvent', False)

    
    referenceEvent = property(__referenceEvent.value, __referenceEvent.set, None, None)

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}referenceDate uses Python identifier referenceDate
    __referenceDate = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'referenceDate'), 'referenceDate', '__httpwww_opengis_netgml3_2_TimeCalendarEraType_httpwww_opengis_netgml3_2referenceDate', False)

    
    referenceDate = property(__referenceDate.value, __referenceDate.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}julianReference uses Python identifier julianReference
    __julianReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'julianReference'), 'julianReference', '__httpwww_opengis_netgml3_2_TimeCalendarEraType_httpwww_opengis_netgml3_2julianReference', False)

    
    julianReference = property(__julianReference.value, __julianReference.set, None, None)

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}epochOfUse uses Python identifier epochOfUse
    __epochOfUse = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'epochOfUse'), 'epochOfUse', '__httpwww_opengis_netgml3_2_TimeCalendarEraType_httpwww_opengis_netgml3_2epochOfUse', False)

    
    epochOfUse = property(__epochOfUse.value, __epochOfUse.set, None, None)

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = DefinitionType._ElementMap.copy()
    _ElementMap.update({
        __referenceEvent.name() : __referenceEvent,
        __referenceDate.name() : __referenceDate,
        __julianReference.name() : __julianReference,
        __epochOfUse.name() : __epochOfUse
    })
    _AttributeMap = DefinitionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimeCalendarEraType', TimeCalendarEraType)


# Complex type CodeListType with content type SIMPLE
class CodeListType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = NameList
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CodeListType')
    # Base type is NameList
    
    # Attribute codeSpace uses Python identifier codeSpace
    __codeSpace = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'codeSpace'), 'codeSpace', '__httpwww_opengis_netgml3_2_CodeListType_codeSpace', pyxb.binding.datatypes.anyURI)
    
    codeSpace = property(__codeSpace.value, __codeSpace.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __codeSpace.name() : __codeSpace
    }
_Namespace_gml.addCategoryObject('typeBinding', u'CodeListType', CodeListType)


# Complex type SequenceRuleType with content type SIMPLE
class SequenceRuleType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = SequenceRuleEnumeration
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'SequenceRuleType')
    # Base type is SequenceRuleEnumeration
    
    # Attribute order uses Python identifier order
    __order = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'order'), 'order', '__httpwww_opengis_netgml3_2_SequenceRuleType_order', IncrementOrder)
    
    order = property(__order.value, __order.set, None, u'')

    
    # Attribute axisOrder uses Python identifier axisOrder
    __axisOrder = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'axisOrder'), 'axisOrder', '__httpwww_opengis_netgml3_2_SequenceRuleType_axisOrder', AxisDirectionList)
    
    axisOrder = property(__axisOrder.value, __axisOrder.set, None, None)


    _ElementMap = {
        
    }
    _AttributeMap = {
        __order.name() : __order,
        __axisOrder.name() : __axisOrder
    }
_Namespace_gml.addCategoryObject('typeBinding', u'SequenceRuleType', SequenceRuleType)


# Complex type CTD_ANON_5 with content type ELEMENT_ONLY
class CTD_ANON_5 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_Extent uses Python identifier EX_Extent
    __EX_Extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent'), 'EX_Extent', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_isotc211_org2005gmdEX_Extent', False)

    
    EX_Extent = property(__EX_Extent.value, __EX_Extent.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_5_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CTD_ANON_5_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __EX_Extent.name() : __EX_Extent
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title,
        __role.name() : __role,
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __type.name() : __type
    }



# Complex type EX_Extent_PropertyType with content type ELEMENT_ONLY
class EX_Extent_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}EX_Extent uses Python identifier EX_Extent
    __EX_Extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_Extent'), 'EX_Extent', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_isotc211_org2005gmdEX_Extent', False)

    
    EX_Extent = property(__EX_Extent.value, __EX_Extent.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_EX_Extent_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __EX_Extent.name() : __EX_Extent
    }
    _AttributeMap = {
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __uuidref.name() : __uuidref,
        __show.name() : __show,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __href.name() : __href,
        __type.name() : __type
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_Extent_PropertyType', EX_Extent_PropertyType)


# Complex type ResultType with content type ELEMENT_ONLY
class ResultType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ResultType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ResultType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ResultType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ResultType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ResultType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ResultType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ResultType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ResultType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_ResultType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ResultType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ResultType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    _HasWildcardElement = True

    _ElementMap = {
        
    }
    _AttributeMap = {
        __href.name() : __href,
        __type.name() : __type,
        __remoteSchema.name() : __remoteSchema,
        __role.name() : __role,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __show.name() : __show,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ResultType', ResultType)


# Complex type PriorityLocationPropertyType with content type ELEMENT_ONLY
class PriorityLocationPropertyType (LocationPropertyType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PriorityLocationPropertyType')
    # Base type is LocationPropertyType
    
    # Element LocationString ({http://www.opengis.net/gml/3.2}LocationString) inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Element LocationKeyWord ({http://www.opengis.net/gml/3.2}LocationKeyWord) inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Element Null ({http://www.opengis.net/gml/3.2}Null) inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Element AbstractGeometry ({http://www.opengis.net/gml/3.2}AbstractGeometry) inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute priority uses Python identifier priority
    __priority = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'priority'), 'priority', '__httpwww_opengis_netgml3_2_PriorityLocationPropertyType_priority', pyxb.binding.datatypes.string)
    
    priority = property(__priority.value, __priority.set, None, None)

    
    # Attribute arcrole inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute title inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute role inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute nilReason inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute href inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute type inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute remoteSchema inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute actuate inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType
    
    # Attribute show inherited from {http://www.opengis.net/gml/3.2}LocationPropertyType

    _ElementMap = LocationPropertyType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = LocationPropertyType._AttributeMap.copy()
    _AttributeMap.update({
        __priority.name() : __priority
    })
_Namespace_gml.addCategoryObject('typeBinding', u'PriorityLocationPropertyType', PriorityLocationPropertyType)


# Complex type FaceOrTopoSolidPropertyType with content type ELEMENT_ONLY
class FaceOrTopoSolidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'FaceOrTopoSolidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoSolid uses Python identifier TopoSolid
    __TopoSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSolid'), 'TopoSolid', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_opengis_netgml3_2TopoSolid', False)

    
    TopoSolid = property(__TopoSolid.value, __TopoSolid.set, None, u'gml:TopoSolid represents the 3-dimensional topology primitive. \nThe topological boundary of a solid (gml:directedFace) consists of a set of directed faces.\nA solid may optionally be realised by a 3-dimensional geometric primitive (gml:solidProperty).')

    
    # Element {http://www.opengis.net/gml/3.2}Face uses Python identifier Face
    __Face = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Face'), 'Face', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_opengis_netgml3_2Face', False)

    
    Face = property(__Face.value, __Face.set, None, u'gml:Face represents the 2-dimensional topology primitive.\nThe topological boundary of a face (gml:directedEdge) consists of a sequence of directed edges. If provided, the aggregationType attribute shall have the value "sequence".\nThe optional coboundary of a face (gml:directedTopoSolid) is a pair of directed solids which are bounded by this face. A positively directed solid corresponds to a solid which lies in the direction of the negatively directed normal to the face in any geometric realisation. \nA face may optionally be realised by a 2-dimensional geometric primitive (gml:surfaceProperty).')

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_FaceOrTopoSolidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __TopoSolid.name() : __TopoSolid,
        __Face.name() : __Face
    }
    _AttributeMap = {
        __actuate.name() : __actuate,
        __href.name() : __href,
        __role.name() : __role,
        __type.name() : __type,
        __title.name() : __title,
        __show.name() : __show,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'FaceOrTopoSolidPropertyType', FaceOrTopoSolidPropertyType)


# Complex type DynamicFeatureType with content type ELEMENT_ONLY
class DynamicFeatureType (AbstractFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeatureType')
    # Base type is AbstractFeatureType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}validTime uses Python identifier validTime
    __validTime = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'validTime'), 'validTime', '__httpwww_opengis_netgml3_2_DynamicFeatureType_httpwww_opengis_netgml3_2validTime', False)

    
    validTime = property(__validTime.value, __validTime.set, None, u'gml:validTime is a convenience property element.')

    
    # Element {http://www.opengis.net/gml/3.2}history uses Python identifier history
    __history = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'history'), 'history', '__httpwww_opengis_netgml3_2_DynamicFeatureType_httpwww_opengis_netgml3_2history', False)

    
    history = property(__history.value, __history.set, None, u'A generic sequence of events constitute a gml:history of an object.\nThe gml:history element contains a set of elements in the substitution group headed by the abstract element gml:AbstractTimeSlice, representing the time-varying properties of interest. The history property of a dynamic feature associates a feature instance with a sequence of time slices (i.e. change events) that encapsulate the evolution of the feature.')

    
    # Element {http://www.opengis.net/gml/3.2}dataSource uses Python identifier dataSource
    __dataSource = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dataSource'), 'dataSource', '__httpwww_opengis_netgml3_2_DynamicFeatureType_httpwww_opengis_netgml3_2dataSource', False)

    
    dataSource = property(__dataSource.value, __dataSource.set, None, u'Evidence is represented by a simple gml:dataSource or gml:dataSourceReference property that indicates the source of the temporal data. The remote link attributes of the gml:dataSource element have been deprecated along with its current type.')

    
    # Element {http://www.opengis.net/gml/3.2}dataSourceReference uses Python identifier dataSourceReference
    __dataSourceReference = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dataSourceReference'), 'dataSourceReference', '__httpwww_opengis_netgml3_2_DynamicFeatureType_httpwww_opengis_netgml3_2dataSourceReference', False)

    
    dataSourceReference = property(__dataSourceReference.value, __dataSourceReference.set, None, u'Evidence is represented by a simple gml:dataSource or gml:dataSourceReference property that indicates the source of the temporal data.')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractFeatureType._ElementMap.copy()
    _ElementMap.update({
        __validTime.name() : __validTime,
        __history.name() : __history,
        __dataSource.name() : __dataSource,
        __dataSourceReference.name() : __dataSourceReference
    })
    _AttributeMap = AbstractFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DynamicFeatureType', DynamicFeatureType)


# Complex type DynamicFeatureCollectionType with content type ELEMENT_ONLY
class DynamicFeatureCollectionType (DynamicFeatureType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DynamicFeatureCollectionType')
    # Base type is DynamicFeatureType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}dynamicMembers uses Python identifier dynamicMembers
    __dynamicMembers = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'dynamicMembers'), 'dynamicMembers', '__httpwww_opengis_netgml3_2_DynamicFeatureCollectionType_httpwww_opengis_netgml3_2dynamicMembers', False)

    
    dynamicMembers = property(__dynamicMembers.value, __dynamicMembers.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element boundedBy ({http://www.opengis.net/gml/3.2}boundedBy) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element location ({http://www.opengis.net/gml/3.2}location) inherited from {http://www.opengis.net/gml/3.2}AbstractFeatureType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element validTime ({http://www.opengis.net/gml/3.2}validTime) inherited from {http://www.opengis.net/gml/3.2}DynamicFeatureType
    
    # Element history ({http://www.opengis.net/gml/3.2}history) inherited from {http://www.opengis.net/gml/3.2}DynamicFeatureType
    
    # Element dataSource ({http://www.opengis.net/gml/3.2}dataSource) inherited from {http://www.opengis.net/gml/3.2}DynamicFeatureType
    
    # Element dataSourceReference ({http://www.opengis.net/gml/3.2}dataSourceReference) inherited from {http://www.opengis.net/gml/3.2}DynamicFeatureType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = DynamicFeatureType._ElementMap.copy()
    _ElementMap.update({
        __dynamicMembers.name() : __dynamicMembers
    })
    _AttributeMap = DynamicFeatureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'DynamicFeatureCollectionType', DynamicFeatureCollectionType)


# Complex type MD_LegalConstraints_PropertyType with content type ELEMENT_ONLY
class MD_LegalConstraints_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_LegalConstraints_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_LegalConstraints uses Python identifier MD_LegalConstraints
    __MD_LegalConstraints = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_LegalConstraints'), 'MD_LegalConstraints', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_isotc211_org2005gmdMD_LegalConstraints', False)

    
    MD_LegalConstraints = property(__MD_LegalConstraints.value, __MD_LegalConstraints.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_LegalConstraints_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __MD_LegalConstraints.name() : __MD_LegalConstraints
    }
    _AttributeMap = {
        __role.name() : __role,
        __type.name() : __type,
        __href.name() : __href,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __uuidref.name() : __uuidref,
        __show.name() : __show
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_LegalConstraints_PropertyType', MD_LegalConstraints_PropertyType)


# Complex type ObliqueCartesianCSType with content type ELEMENT_ONLY
class ObliqueCartesianCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ObliqueCartesianCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'ObliqueCartesianCSType', ObliqueCartesianCSType)


# Complex type DQ_Element_PropertyType with content type ELEMENT_ONLY
class DQ_Element_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DQ_Element_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}AbstractDQ_Element uses Python identifier AbstractDQ_Element
    __AbstractDQ_Element = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'AbstractDQ_Element'), 'AbstractDQ_Element', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_isotc211_org2005gmdAbstractDQ_Element', False)

    
    AbstractDQ_Element = property(__AbstractDQ_Element.value, __AbstractDQ_Element.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_DQ_Element_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __AbstractDQ_Element.name() : __AbstractDQ_Element
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DQ_Element_PropertyType', DQ_Element_PropertyType)


# Complex type MD_ServiceIdentification_PropertyType with content type ELEMENT_ONLY
class MD_ServiceIdentification_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ServiceIdentification_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ServiceIdentification uses Python identifier MD_ServiceIdentification
    __MD_ServiceIdentification = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ServiceIdentification'), 'MD_ServiceIdentification', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_isotc211_org2005gmdMD_ServiceIdentification', False)

    
    MD_ServiceIdentification = property(__MD_ServiceIdentification.value, __MD_ServiceIdentification.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_ServiceIdentification_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __MD_ServiceIdentification.name() : __MD_ServiceIdentification
    }
    _AttributeMap = {
        __type.name() : __type,
        __nilReason.name() : __nilReason,
        __actuate.name() : __actuate,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __arcrole.name() : __arcrole,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ServiceIdentification_PropertyType', MD_ServiceIdentification_PropertyType)


# Complex type LineStringSegmentType with content type ELEMENT_ONLY
class LineStringSegmentType (AbstractCurveSegmentType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LineStringSegmentType')
    # Base type is AbstractCurveSegmentType
    
    # Element {http://www.opengis.net/gml/3.2}pointRep uses Python identifier pointRep
    __pointRep = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointRep'), 'pointRep', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2pointRep', True)

    
    pointRep = property(__pointRep.value, __pointRep.set, None, u'')

    
    # Element {http://www.opengis.net/gml/3.2}posList uses Python identifier posList
    __posList = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'posList'), 'posList', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2posList', False)

    
    posList = property(__posList.value, __posList.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}pointProperty uses Python identifier pointProperty
    __pointProperty = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pointProperty'), 'pointProperty', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2pointProperty', True)

    
    pointProperty = property(__pointProperty.value, __pointProperty.set, None, u'This property element either references a point via the XLink-attributes or contains the point element. pointProperty is the predefined property which may be used by GML Application Schemas whenever a GML feature has a property with a value that is substitutable for Point.')

    
    # Element {http://www.opengis.net/gml/3.2}pos uses Python identifier pos
    __pos = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'pos'), 'pos', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2pos', True)

    
    pos = property(__pos.value, __pos.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}coordinates uses Python identifier coordinates
    __coordinates = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinates'), 'coordinates', '__httpwww_opengis_netgml3_2_LineStringSegmentType_httpwww_opengis_netgml3_2coordinates', False)

    
    coordinates = property(__coordinates.value, __coordinates.set, None, u'')

    
    # Attribute numDerivativesAtStart inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativeInterior inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute numDerivativesAtEnd inherited from {http://www.opengis.net/gml/3.2}AbstractCurveSegmentType
    
    # Attribute interpolation uses Python identifier interpolation
    __interpolation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'interpolation'), 'interpolation', '__httpwww_opengis_netgml3_2_LineStringSegmentType_interpolation', CurveInterpolationType, fixed=True, unicode_default=u'linear')
    
    interpolation = property(__interpolation.value, __interpolation.set, None, None)


    _ElementMap = AbstractCurveSegmentType._ElementMap.copy()
    _ElementMap.update({
        __pointRep.name() : __pointRep,
        __posList.name() : __posList,
        __pointProperty.name() : __pointProperty,
        __pos.name() : __pos,
        __coordinates.name() : __coordinates
    })
    _AttributeMap = AbstractCurveSegmentType._AttributeMap.copy()
    _AttributeMap.update({
        __interpolation.name() : __interpolation
    })
_Namespace_gml.addCategoryObject('typeBinding', u'LineStringSegmentType', LineStringSegmentType)


# Complex type DirectedTopoSolidPropertyType with content type ELEMENT_ONLY
class DirectedTopoSolidPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedTopoSolidPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TopoSolid uses Python identifier TopoSolid
    __TopoSolid = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TopoSolid'), 'TopoSolid', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_opengis_netgml3_2TopoSolid', False)

    
    TopoSolid = property(__TopoSolid.value, __TopoSolid.set, None, u'gml:TopoSolid represents the 3-dimensional topology primitive. \nThe topological boundary of a solid (gml:directedFace) consists of a set of directed faces.\nA solid may optionally be realised by a 3-dimensional geometric primitive (gml:solidProperty).')

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectedTopoSolidPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __TopoSolid.name() : __TopoSolid
    }
    _AttributeMap = {
        __href.name() : __href,
        __actuate.name() : __actuate,
        __orientation.name() : __orientation,
        __nilReason.name() : __nilReason,
        __role.name() : __role,
        __type.name() : __type,
        __arcrole.name() : __arcrole,
        __remoteSchema.name() : __remoteSchema,
        __show.name() : __show,
        __title.name() : __title,
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedTopoSolidPropertyType', DirectedTopoSolidPropertyType)


# Complex type EngineeringCRSType with content type ELEMENT_ONLY
class EngineeringCRSType (AbstractCRSType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EngineeringCRSType')
    # Base type is AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}coordinateSystem uses Python identifier coordinateSystem
    __coordinateSystem = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'coordinateSystem'), 'coordinateSystem', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2coordinateSystem', False)

    
    coordinateSystem = property(__coordinateSystem.value, __coordinateSystem.set, None, u'An association role to the coordinate system used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}cartesianCS uses Python identifier cartesianCS
    __cartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'cartesianCS'), 'cartesianCS', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2cartesianCS', False)

    
    cartesianCS = property(__cartesianCS.value, __cartesianCS.set, None, u'gml:cartesianCS is an association role to the Cartesian coordinate system used by this CRS.')

    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Element {http://www.opengis.net/gml/3.2}cylindricalCS uses Python identifier cylindricalCS
    __cylindricalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'cylindricalCS'), 'cylindricalCS', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2cylindricalCS', False)

    
    cylindricalCS = property(__cylindricalCS.value, __cylindricalCS.set, None, u'gml:cylindricalCS is an association role to the cylindrical coordinate system used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}affineCS uses Python identifier affineCS
    __affineCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'affineCS'), 'affineCS', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2affineCS', False)

    
    affineCS = property(__affineCS.value, __affineCS.set, None, u'gml:affineCS is an association role to the affine coordinate system used by this CRS.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}linearCS uses Python identifier linearCS
    __linearCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'linearCS'), 'linearCS', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2linearCS', False)

    
    linearCS = property(__linearCS.value, __linearCS.set, None, u'gml:linearCS is an association role to the linear coordinate system used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}engineeringDatum uses Python identifier engineeringDatum
    __engineeringDatum = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'engineeringDatum'), 'engineeringDatum', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2engineeringDatum', False)

    
    engineeringDatum = property(__engineeringDatum.value, __engineeringDatum.set, None, u'gml:engineeringDatum is an association role to the engineering datum used by this CRS.')

    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}polarCS uses Python identifier polarCS
    __polarCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'polarCS'), 'polarCS', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2polarCS', False)

    
    polarCS = property(__polarCS.value, __polarCS.set, None, u'gml:polarCS is an association role to the polar coordinate system used by this CRS.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}sphericalCS uses Python identifier sphericalCS
    __sphericalCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'sphericalCS'), 'sphericalCS', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2sphericalCS', False)

    
    sphericalCS = property(__sphericalCS.value, __sphericalCS.set, None, u'gml:sphericalCS is an association role to the spherical coordinate system used by this CRS.')

    
    # Element {http://www.opengis.net/gml/3.2}userDefinedCS uses Python identifier userDefinedCS
    __userDefinedCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'userDefinedCS'), 'userDefinedCS', '__httpwww_opengis_netgml3_2_EngineeringCRSType_httpwww_opengis_netgml3_2userDefinedCS', False)

    
    userDefinedCS = property(__userDefinedCS.value, __userDefinedCS.set, None, u'gml:userDefinedCS is an association role to the user defined coordinate system used by this CRS.')

    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCRSType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCRSType._ElementMap.copy()
    _ElementMap.update({
        __coordinateSystem.name() : __coordinateSystem,
        __cartesianCS.name() : __cartesianCS,
        __cylindricalCS.name() : __cylindricalCS,
        __affineCS.name() : __affineCS,
        __linearCS.name() : __linearCS,
        __engineeringDatum.name() : __engineeringDatum,
        __polarCS.name() : __polarCS,
        __sphericalCS.name() : __sphericalCS,
        __userDefinedCS.name() : __userDefinedCS
    })
    _AttributeMap = AbstractCRSType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'EngineeringCRSType', EngineeringCRSType)


# Complex type ObliqueCartesianCSPropertyType with content type ELEMENT_ONLY
class ObliqueCartesianCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ObliqueCartesianCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}ObliqueCartesianCS uses Python identifier ObliqueCartesianCS
    __ObliqueCartesianCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'ObliqueCartesianCS'), 'ObliqueCartesianCS', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_opengis_netgml3_2ObliqueCartesianCS', False)

    
    ObliqueCartesianCS = property(__ObliqueCartesianCS.value, __ObliqueCartesianCS.set, None, u'')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_ObliqueCartesianCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __ObliqueCartesianCS.name() : __ObliqueCartesianCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __role.name() : __role,
        __type.name() : __type,
        __href.name() : __href,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ObliqueCartesianCSPropertyType', ObliqueCartesianCSPropertyType)


# Complex type EX_TemporalExtent_Type with content type ELEMENT_ONLY
class EX_TemporalExtent_Type (AbstractObject_Type):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'EX_TemporalExtent_Type')
    # Base type is AbstractObject_Type
    
    # Element {http://www.isotc211.org/2005/gmd}extent uses Python identifier extent
    __extent = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'extent'), 'extent', '__httpwww_isotc211_org2005gmd_EX_TemporalExtent_Type_httpwww_isotc211_org2005gmdextent', False)

    
    extent = property(__extent.value, __extent.set, None, None)

    
    # Attribute id inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type
    
    # Attribute uuid inherited from {http://www.isotc211.org/2005/gco}AbstractObject_Type

    _ElementMap = AbstractObject_Type._ElementMap.copy()
    _ElementMap.update({
        __extent.name() : __extent
    })
    _AttributeMap = AbstractObject_Type._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gmd.addCategoryObject('typeBinding', u'EX_TemporalExtent_Type', EX_TemporalExtent_Type)


# Complex type MD_CellGeometryCode_PropertyType with content type ELEMENT_ONLY
class MD_CellGeometryCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_CellGeometryCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_CellGeometryCode uses Python identifier MD_CellGeometryCode
    __MD_CellGeometryCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_CellGeometryCode'), 'MD_CellGeometryCode', '__httpwww_isotc211_org2005gmd_MD_CellGeometryCode_PropertyType_httpwww_isotc211_org2005gmdMD_CellGeometryCode', False)

    
    MD_CellGeometryCode = property(__MD_CellGeometryCode.value, __MD_CellGeometryCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_CellGeometryCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_CellGeometryCode.name() : __MD_CellGeometryCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_CellGeometryCode_PropertyType', MD_CellGeometryCode_PropertyType)


# Complex type CylinderType with content type ELEMENT_ONLY
class CylinderType (AbstractGriddedSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CylinderType')
    # Base type is AbstractGriddedSurfaceType
    
    # Element rows ({http://www.opengis.net/gml/3.2}rows) inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType
    
    # Attribute horizontalCurveType uses Python identifier horizontalCurveType
    __horizontalCurveType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'horizontalCurveType'), 'horizontalCurveType', '__httpwww_opengis_netgml3_2_CylinderType_horizontalCurveType', CurveInterpolationType, fixed=True, unicode_default=u'circularArc3Points')
    
    horizontalCurveType = property(__horizontalCurveType.value, __horizontalCurveType.set, None, None)

    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractParametricCurveSurfaceType
    
    # Attribute columns inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType
    
    # Attribute verticalCurveType uses Python identifier verticalCurveType
    __verticalCurveType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'verticalCurveType'), 'verticalCurveType', '__httpwww_opengis_netgml3_2_CylinderType_verticalCurveType', CurveInterpolationType, fixed=True, unicode_default=u'linear')
    
    verticalCurveType = property(__verticalCurveType.value, __verticalCurveType.set, None, None)

    
    # Attribute rows_ inherited from {http://www.opengis.net/gml/3.2}AbstractGriddedSurfaceType

    _ElementMap = AbstractGriddedSurfaceType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGriddedSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __horizontalCurveType.name() : __horizontalCurveType,
        __verticalCurveType.name() : __verticalCurveType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CylinderType', CylinderType)


# Complex type LengthType with content type SIMPLE
class LengthType (MeasureType):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'LengthType')
    # Base type is MeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}MeasureType

    _ElementMap = MeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = MeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'LengthType', LengthType)


# Complex type PointArrayPropertyType with content type ELEMENT_ONLY
class PointArrayPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'PointArrayPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Point uses Python identifier Point
    __Point = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Point'), 'Point', '__httpwww_opengis_netgml3_2_PointArrayPropertyType_httpwww_opengis_netgml3_2Point', True)

    
    Point = property(__Point.value, __Point.set, None, u'A Point is defined by a single coordinate tuple. The direct position of a point is specified by the pos element which is of type DirectPositionType.')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_PointArrayPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)


    _ElementMap = {
        __Point.name() : __Point
    }
    _AttributeMap = {
        __owns.name() : __owns
    }
_Namespace_gml.addCategoryObject('typeBinding', u'PointArrayPropertyType', PointArrayPropertyType)


# Complex type LanguageCode_PropertyType with content type ELEMENT_ONLY
class LanguageCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'LanguageCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}LanguageCode uses Python identifier LanguageCode
    __LanguageCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'LanguageCode'), 'LanguageCode', '__httpwww_isotc211_org2005gmd_LanguageCode_PropertyType_httpwww_isotc211_org2005gmdLanguageCode', False)

    
    LanguageCode = property(__LanguageCode.value, __LanguageCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_LanguageCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __LanguageCode.name() : __LanguageCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'LanguageCode_PropertyType', LanguageCode_PropertyType)


# Complex type DS_InitiativeTypeCode_PropertyType with content type ELEMENT_ONLY
class DS_InitiativeTypeCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_InitiativeTypeCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DS_InitiativeTypeCode uses Python identifier DS_InitiativeTypeCode
    __DS_InitiativeTypeCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_InitiativeTypeCode'), 'DS_InitiativeTypeCode', '__httpwww_isotc211_org2005gmd_DS_InitiativeTypeCode_PropertyType_httpwww_isotc211_org2005gmdDS_InitiativeTypeCode', False)

    
    DS_InitiativeTypeCode = property(__DS_InitiativeTypeCode.value, __DS_InitiativeTypeCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DS_InitiativeTypeCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __DS_InitiativeTypeCode.name() : __DS_InitiativeTypeCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'DS_InitiativeTypeCode_PropertyType', DS_InitiativeTypeCode_PropertyType)


# Complex type TimePeriodType with content type ELEMENT_ONLY
class TimePeriodType (AbstractTimeGeometricPrimitiveType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePeriodType')
    # Base type is AbstractTimeGeometricPrimitiveType
    
    # Element {http://www.opengis.net/gml/3.2}begin uses Python identifier begin
    __begin = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'begin'), 'begin', '__httpwww_opengis_netgml3_2_TimePeriodType_httpwww_opengis_netgml3_2begin', False)

    
    begin = property(__begin.value, __begin.set, None, None)

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}beginPosition uses Python identifier beginPosition
    __beginPosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'beginPosition'), 'beginPosition', '__httpwww_opengis_netgml3_2_TimePeriodType_httpwww_opengis_netgml3_2beginPosition', False)

    
    beginPosition = property(__beginPosition.value, __beginPosition.set, None, None)

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element relatedTime ({http://www.opengis.net/gml/3.2}relatedTime) inherited from {http://www.opengis.net/gml/3.2}AbstractTimePrimitiveType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}end uses Python identifier end
    __end = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'end'), 'end', '__httpwww_opengis_netgml3_2_TimePeriodType_httpwww_opengis_netgml3_2end', False)

    
    end = property(__end.value, __end.set, None, None)

    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}endPosition uses Python identifier endPosition
    __endPosition = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'endPosition'), 'endPosition', '__httpwww_opengis_netgml3_2_TimePeriodType_httpwww_opengis_netgml3_2endPosition', False)

    
    endPosition = property(__endPosition.value, __endPosition.set, None, None)

    
    # Element {http://www.opengis.net/gml/3.2}duration uses Python identifier duration
    __duration = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'duration'), 'duration', '__httpwww_opengis_netgml3_2_TimePeriodType_httpwww_opengis_netgml3_2duration', False)

    
    duration = property(__duration.value, __duration.set, None, u'gml:duration conforms to the ISO 8601 syntax for temporal length as implemented by the XML Schema duration type.')

    
    # Element {http://www.opengis.net/gml/3.2}timeInterval uses Python identifier timeInterval
    __timeInterval = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'timeInterval'), 'timeInterval', '__httpwww_opengis_netgml3_2_TimePeriodType_httpwww_opengis_netgml3_2timeInterval', False)

    
    timeInterval = property(__timeInterval.value, __timeInterval.set, None, u' gml:timeInterval conforms to ISO 11404 which is based on floating point values for temporal length.\nISO 11404 syntax specifies the use of a positiveInteger together with appropriate values for radix and factor. The resolution of the time interval is to one radix ^(-factor) of the specified time unit.\nThe value of the unit is either selected from the units for time intervals from ISO 31-1:1992, or is another suitable unit.  The encoding is defined for GML in gml:TimeUnitType. The second component of this union type provides a method for indicating time units other than the six standard units given in the enumeration.')

    
    # Attribute frame inherited from {http://www.opengis.net/gml/3.2}AbstractTimeGeometricPrimitiveType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType

    _ElementMap = AbstractTimeGeometricPrimitiveType._ElementMap.copy()
    _ElementMap.update({
        __begin.name() : __begin,
        __beginPosition.name() : __beginPosition,
        __end.name() : __end,
        __endPosition.name() : __endPosition,
        __duration.name() : __duration,
        __timeInterval.name() : __timeInterval
    })
    _AttributeMap = AbstractTimeGeometricPrimitiveType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TimePeriodType', TimePeriodType)


# Complex type VectorType with content type SIMPLE
class VectorType (DirectPositionType):
    _TypeDefinition = STD_ANON_10
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'VectorType')
    # Base type is DirectPositionType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}DirectPositionType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}DirectPositionType

    _ElementMap = DirectPositionType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = DirectPositionType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'VectorType', VectorType)


# Complex type DirectedEdgePropertyType with content type ELEMENT_ONLY
class DirectedEdgePropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'DirectedEdgePropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Edge uses Python identifier Edge
    __Edge = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Edge'), 'Edge', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_opengis_netgml3_2Edge', False)

    
    Edge = property(__Edge.value, __Edge.set, None, u'gml:Edge represents the 1-dimensional primitive.\nThe topological boundary of an Edge (gml:directedNode) consists of a negatively directed start Node and a positively directed end Node.   \nThe optional coboundary of an edge (gml:directedFace) is a circular sequence of directed faces which are incident on this edge in document order. In the 2D case, the orientation of the face on the left of the edge is "+"; the orientation of the face on the right on its right is "-". \nIf provided, the aggregationType attribute shall have the value "sequence".\nAn edge may optionally be realised by a 1-dimensional geometric primitive (gml:curveProperty).')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute orientation uses Python identifier orientation
    __orientation = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'orientation'), 'orientation', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_orientation', SignType, unicode_default=u'+')
    
    orientation = property(__orientation.value, __orientation.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_DirectedEdgePropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __Edge.name() : __Edge
    }
    _AttributeMap = {
        __type.name() : __type,
        __show.name() : __show,
        __actuate.name() : __actuate,
        __role.name() : __role,
        __title.name() : __title,
        __remoteSchema.name() : __remoteSchema,
        __owns.name() : __owns,
        __orientation.name() : __orientation,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __nilReason.name() : __nilReason
    }
_Namespace_gml.addCategoryObject('typeBinding', u'DirectedEdgePropertyType', DirectedEdgePropertyType)


# Complex type UserDefinedCSPropertyType with content type ELEMENT_ONLY
class UserDefinedCSPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'UserDefinedCSPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}UserDefinedCS uses Python identifier UserDefinedCS
    __UserDefinedCS = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'UserDefinedCS'), 'UserDefinedCS', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_opengis_netgml3_2UserDefinedCS', False)

    
    UserDefinedCS = property(__UserDefinedCS.value, __UserDefinedCS.set, None, u'gml:UserDefinedCS is a two- or three-dimensional coordinate system that consists of any combination of coordinate axes not covered by any other coordinate system type. A UserDefinedCS shall have two or three gml:axis property elements; the number of property elements shall equal the dimension of the CS.')

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_UserDefinedCSPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)


    _ElementMap = {
        __UserDefinedCS.name() : __UserDefinedCS
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __nilReason.name() : __nilReason,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __role.name() : __role,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show,
        __title.name() : __title
    }
_Namespace_gml.addCategoryObject('typeBinding', u'UserDefinedCSPropertyType', UserDefinedCSPropertyType)


# Complex type AbstractGeneralTransformationType with content type ELEMENT_ONLY
class AbstractGeneralTransformationType (AbstractCoordinateOperationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeneralTransformationType')
    # Base type is AbstractCoordinateOperationType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element operationVersion ({http://www.opengis.net/gml/3.2}operationVersion) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element targetCRS ({http://www.opengis.net/gml/3.2}targetCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element sourceCRS ({http://www.opengis.net/gml/3.2}sourceCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Attribute id_ is restricted from parent
    
    # Attribute {http://www.opengis.net/gml/3.2}id uses Python identifier id_
    __id_ = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'id'), 'id_', '__httpwww_opengis_netgml3_2_DefinitionBaseType_httpwww_opengis_netgml3_2id', pyxb.binding.datatypes.ID, required=True)
    
    id_ = property(__id_.value, __id_.set, None, u'The attribute gml:id supports provision of a handle for the XML element representing a GML Object. Its use is mandatory for all GML objects. It is of XML type ID, so is constrained to be unique in the XML document within which it occurs.')


    _ElementMap = AbstractCoordinateOperationType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateOperationType._AttributeMap.copy()
    _AttributeMap.update({
        __id_.name() : __id_
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeneralTransformationType', AbstractGeneralTransformationType)


# Complex type TransformationType with content type ELEMENT_ONLY
class TransformationType (AbstractGeneralTransformationType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TransformationType')
    # Base type is AbstractGeneralTransformationType
    
    # Element {http://www.opengis.net/gml/3.2}parameterValue uses Python identifier parameterValue
    __parameterValue = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'parameterValue'), 'parameterValue', '__httpwww_opengis_netgml3_2_TransformationType_httpwww_opengis_netgml3_2parameterValue', True)

    
    parameterValue = property(__parameterValue.value, __parameterValue.set, None, u'gml:parameterValue is a composition association to a parameter value or group of parameter values used by a coordinate operation.')

    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element domainOfValidity ({http://www.opengis.net/gml/3.2}domainOfValidity) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element scope ({http://www.opengis.net/gml/3.2}scope) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element coordinateOperationAccuracy ({http://www.opengis.net/gml/3.2}coordinateOperationAccuracy) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element targetCRS ({http://www.opengis.net/gml/3.2}targetCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element {http://www.opengis.net/gml/3.2}method uses Python identifier method
    __method = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'method'), 'method', '__httpwww_opengis_netgml3_2_TransformationType_httpwww_opengis_netgml3_2method', False)

    
    method = property(__method.value, __method.set, None, u'gml:method is an association role to the operation method used by a coordinate operation.')

    
    # Element sourceCRS ({http://www.opengis.net/gml/3.2}sourceCRS) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Element operationVersion ({http://www.opengis.net/gml/3.2}operationVersion) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateOperationType
    
    # Attribute id_2 inherited from {http://www.opengis.net/gml/3.2}AbstractGeneralTransformationType

    _ElementMap = AbstractGeneralTransformationType._ElementMap.copy()
    _ElementMap.update({
        __parameterValue.name() : __parameterValue,
        __method.name() : __method
    })
    _AttributeMap = AbstractGeneralTransformationType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'TransformationType', TransformationType)


# Complex type EllipsoidalCSType with content type ELEMENT_ONLY
class EllipsoidalCSType (AbstractCoordinateSystemType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'EllipsoidalCSType')
    # Base type is AbstractCoordinateSystemType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element axis ({http://www.opengis.net/gml/3.2}axis) inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element remarks ({http://www.opengis.net/gml/3.2}remarks) inherited from {http://www.opengis.net/gml/3.2}DefinitionType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractCoordinateSystemType
    
    # Attribute id_ inherited from {http://www.opengis.net/gml/3.2}DefinitionBaseType

    _ElementMap = AbstractCoordinateSystemType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractCoordinateSystemType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'EllipsoidalCSType', EllipsoidalCSType)


# Complex type CompositeSurfaceType with content type ELEMENT_ONLY
class CompositeSurfaceType (AbstractSurfaceType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'CompositeSurfaceType')
    # Base type is AbstractSurfaceType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}surfaceMember uses Python identifier surfaceMember
    __surfaceMember = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'surfaceMember'), 'surfaceMember', '__httpwww_opengis_netgml3_2_CompositeSurfaceType_httpwww_opengis_netgml3_2surfaceMember', True)

    
    surfaceMember = property(__surfaceMember.value, __surfaceMember.set, None, u'This property element either references a surface via the XLink-attributes or contains the surface element. A surface element is any element, which is substitutable for gml:AbstractSurface.')

    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_CompositeSurfaceType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)

    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType

    _ElementMap = AbstractSurfaceType._ElementMap.copy()
    _ElementMap.update({
        __surfaceMember.name() : __surfaceMember
    })
    _AttributeMap = AbstractSurfaceType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'CompositeSurfaceType', CompositeSurfaceType)


# Complex type CTD_ANON_6 with content type ELEMENT_ONLY
class CTD_ANON_6 (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = None
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}CI_Citation uses Python identifier CI_Citation
    __CI_Citation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'CI_Citation'), 'CI_Citation', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_isotc211_org2005gmdCI_Citation', False)

    
    CI_Citation = property(__CI_Citation.value, __CI_Citation.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_CTD_ANON_6_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_CTD_ANON_6_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")


    _ElementMap = {
        __CI_Citation.name() : __CI_Citation
    }
    _AttributeMap = {
        __remoteSchema.name() : __remoteSchema,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __href.name() : __href,
        __role.name() : __role,
        __type.name() : __type,
        __actuate.name() : __actuate,
        __show.name() : __show
    }



# Complex type VolumeType with content type SIMPLE
class VolumeType (MeasureType):
    _TypeDefinition = pyxb.binding.datatypes.double
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_SIMPLE
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'VolumeType')
    # Base type is MeasureType
    
    # Attribute uom inherited from {http://www.opengis.net/gml/3.2}MeasureType

    _ElementMap = MeasureType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = MeasureType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'VolumeType', VolumeType)


# Complex type TransformationPropertyType with content type ELEMENT_ONLY
class TransformationPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TransformationPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}Transformation uses Python identifier Transformation
    __Transformation = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'Transformation'), 'Transformation', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_opengis_netgml3_2Transformation', False)

    
    Transformation = property(__Transformation.value, __Transformation.set, None, u'gml:Transformation is a concrete object element derived from gml:GeneralTransformation (13.6.2.13).\nThis concrete object can be used for all operation methods, without using a GML Application Schema that defines operation-method-specialized element names and contents, especially for methods with only one Transformation instance.\nThe parameterValue elements are an unordered list of composition associations to the set of parameter values used by this conversion operation.')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TransformationPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TransformationPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")


    _ElementMap = {
        __Transformation.name() : __Transformation
    }
    _AttributeMap = {
        __show.name() : __show,
        __role.name() : __role,
        __title.name() : __title,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __href.name() : __href,
        __remoteSchema.name() : __remoteSchema,
        __type.name() : __type,
        __actuate.name() : __actuate
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TransformationPropertyType', TransformationPropertyType)


# Complex type AbstractGeometricAggregateType with content type ELEMENT_ONLY
class AbstractGeometricAggregateType (AbstractGeometryType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = True
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'AbstractGeometricAggregateType')
    # Base type is AbstractGeometryType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_AbstractGeometricAggregateType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)


    _ElementMap = AbstractGeometryType._ElementMap.copy()
    _ElementMap.update({
        
    })
    _AttributeMap = AbstractGeometryType._AttributeMap.copy()
    _AttributeMap.update({
        __aggregationType.name() : __aggregationType
    })
_Namespace_gml.addCategoryObject('typeBinding', u'AbstractGeometricAggregateType', AbstractGeometricAggregateType)


# Complex type MultiSurfaceType with content type ELEMENT_ONLY
class MultiSurfaceType (AbstractGeometricAggregateType):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'MultiSurfaceType')
    # Base type is AbstractGeometricAggregateType
    
    # Element metaDataProperty ({http://www.opengis.net/gml/3.2}metaDataProperty) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}surfaceMembers uses Python identifier surfaceMembers
    __surfaceMembers = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'surfaceMembers'), 'surfaceMembers', '__httpwww_opengis_netgml3_2_MultiSurfaceType_httpwww_opengis_netgml3_2surfaceMembers', False)

    
    surfaceMembers = property(__surfaceMembers.value, __surfaceMembers.set, None, u'This property element contains a list of surfaces. The order of the elements is significant and shall be preserved when processing the array.')

    
    # Element description ({http://www.opengis.net/gml/3.2}description) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element identifier ({http://www.opengis.net/gml/3.2}identifier) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element descriptionReference ({http://www.opengis.net/gml/3.2}descriptionReference) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Element {http://www.opengis.net/gml/3.2}surfaceMember uses Python identifier surfaceMember
    __surfaceMember = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'surfaceMember'), 'surfaceMember', '__httpwww_opengis_netgml3_2_MultiSurfaceType_httpwww_opengis_netgml3_2surfaceMember', True)

    
    surfaceMember = property(__surfaceMember.value, __surfaceMember.set, None, u'This property element either references a surface via the XLink-attributes or contains the surface element. A surface element is any element, which is substitutable for gml:AbstractSurface.')

    
    # Element name ({http://www.opengis.net/gml/3.2}name) inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute id inherited from {http://www.opengis.net/gml/3.2}AbstractGMLType
    
    # Attribute axisLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute uomLabels inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsDimension inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute srsName inherited from {http://www.opengis.net/gml/3.2}AbstractGeometryType
    
    # Attribute aggregationType inherited from {http://www.opengis.net/gml/3.2}AbstractGeometricAggregateType

    _ElementMap = AbstractGeometricAggregateType._ElementMap.copy()
    _ElementMap.update({
        __surfaceMembers.name() : __surfaceMembers,
        __surfaceMember.name() : __surfaceMember
    })
    _AttributeMap = AbstractGeometricAggregateType._AttributeMap.copy()
    _AttributeMap.update({
        
    })
_Namespace_gml.addCategoryObject('typeBinding', u'MultiSurfaceType', MultiSurfaceType)


# Complex type MD_ProgressCode_PropertyType with content type ELEMENT_ONLY
class MD_ProgressCode_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ProgressCode_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_ProgressCode uses Python identifier MD_ProgressCode
    __MD_ProgressCode = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_ProgressCode'), 'MD_ProgressCode', '__httpwww_isotc211_org2005gmd_MD_ProgressCode_PropertyType_httpwww_isotc211_org2005gmdMD_ProgressCode', False)

    
    MD_ProgressCode = property(__MD_ProgressCode.value, __MD_ProgressCode.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_ProgressCode_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)


    _ElementMap = {
        __MD_ProgressCode.name() : __MD_ProgressCode
    }
    _AttributeMap = {
        __nilReason.name() : __nilReason
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_ProgressCode_PropertyType', MD_ProgressCode_PropertyType)


# Complex type ShellType with content type ELEMENT_ONLY
class ShellType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'ShellType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}surfaceMember uses Python identifier surfaceMember
    __surfaceMember = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'surfaceMember'), 'surfaceMember', '__httpwww_opengis_netgml3_2_ShellType_httpwww_opengis_netgml3_2surfaceMember', True)

    
    surfaceMember = property(__surfaceMember.value, __surfaceMember.set, None, u'This property element either references a surface via the XLink-attributes or contains the surface element. A surface element is any element, which is substitutable for gml:AbstractSurface.')

    
    # Attribute aggregationType uses Python identifier aggregationType
    __aggregationType = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'aggregationType'), 'aggregationType', '__httpwww_opengis_netgml3_2_ShellType_aggregationType', AggregationType)
    
    aggregationType = property(__aggregationType.value, __aggregationType.set, None, None)


    _ElementMap = {
        __surfaceMember.name() : __surfaceMember
    }
    _AttributeMap = {
        __aggregationType.name() : __aggregationType
    }
_Namespace_gml.addCategoryObject('typeBinding', u'ShellType', ShellType)


# Complex type TimePeriodPropertyType with content type ELEMENT_ONLY
class TimePeriodPropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePeriodPropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.opengis.net/gml/3.2}TimePeriod uses Python identifier TimePeriod
    __TimePeriod = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'TimePeriod'), 'TimePeriod', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_opengis_netgml3_2TimePeriod', False)

    
    TimePeriod = property(__TimePeriod.value, __TimePeriod.set, None, u'gml:TimePeriod acts as a one-dimensional geometric primitive that represents an identifiable extent in time.\nThe location in of a gml:TimePeriod is described by the temporal positions of the instants at which it begins and ends. The length of the period is equal to the temporal distance between the two bounding temporal positions. \nBoth beginning and end may be described in terms of their direct position using gml:TimePositionType which is an XML Schema simple content type, or by reference to an indentifiable time instant using gml:TimeInstantPropertyType.\nAlternatively a limit of a gml:TimePeriod may use the conventional GML property model to make a reference to a time instant described elsewhere, or a limit may be indicated as a direct position.')

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute {http://www.opengis.net/gml/3.2}remoteSchema uses Python identifier remoteSchema
    __remoteSchema = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gml, u'remoteSchema'), 'remoteSchema', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_opengis_netgml3_2remoteSchema', pyxb.binding.datatypes.anyURI)
    
    remoteSchema = property(__remoteSchema.value, __remoteSchema.set, None, u'')

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute owns uses Python identifier owns
    __owns = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'owns'), 'owns', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_owns', pyxb.binding.datatypes.boolean, unicode_default=u'false')
    
    owns = property(__owns.value, __owns.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)

    
    # Attribute nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'nilReason'), 'nilReason', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_nilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_opengis_netgml3_2_TimePeriodPropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)


    _ElementMap = {
        __TimePeriod.name() : __TimePeriod
    }
    _AttributeMap = {
        __show.name() : __show,
        __remoteSchema.name() : __remoteSchema,
        __title.name() : __title,
        __role.name() : __role,
        __owns.name() : __owns,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole,
        __href.name() : __href,
        __nilReason.name() : __nilReason,
        __type.name() : __type
    }
_Namespace_gml.addCategoryObject('typeBinding', u'TimePeriodPropertyType', TimePeriodPropertyType)


# Complex type MD_StandardOrderProcess_PropertyType with content type ELEMENT_ONLY
class MD_StandardOrderProcess_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_StandardOrderProcess_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}MD_StandardOrderProcess uses Python identifier MD_StandardOrderProcess
    __MD_StandardOrderProcess = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'MD_StandardOrderProcess'), 'MD_StandardOrderProcess', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_isotc211_org2005gmdMD_StandardOrderProcess', False)

    
    MD_StandardOrderProcess = property(__MD_StandardOrderProcess.value, __MD_StandardOrderProcess.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}arcrole uses Python identifier arcrole
    __arcrole = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'arcrole'), 'arcrole', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_w3_org1999xlinkarcrole', pyxb.binding.datatypes.anyURI)
    
    arcrole = property(__arcrole.value, __arcrole.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation \n        of the ending resource on traversal from the starting resource; it's \n        value should be treated as follows: \n        new - load ending resource in a new window, frame, pane, or other \n              presentation context\n        replace - load the resource in the same window, frame, pane, or \n                  other presentation context\n        embed - load ending resource in place of the presentation of the \n                starting resource\n        other - behavior is unconstrained; examine other markup in the \n                link for hints \n        none - behavior is unconstrained \n      ")

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}role uses Python identifier role
    __role = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'role'), 'role', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_w3_org1999xlinkrole', pyxb.binding.datatypes.anyURI)
    
    role = property(__role.value, __role.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}href uses Python identifier href
    __href = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'href'), 'href', '__httpwww_isotc211_org2005gmd_MD_StandardOrderProcess_PropertyType_httpwww_w3_org1999xlinkhref', pyxb.binding.datatypes.anyURI)
    
    href = property(__href.value, __href.set, None, None)


    _ElementMap = {
        __MD_StandardOrderProcess.name() : __MD_StandardOrderProcess
    }
    _AttributeMap = {
        __type.name() : __type,
        __actuate.name() : __actuate,
        __arcrole.name() : __arcrole,
        __nilReason.name() : __nilReason,
        __title.name() : __title,
        __show.name() : __show,
        __uuidref.name() : __uuidref,
        __role.name() : __role,
        __href.name() : __href
    }
_Namespace_gmd.addCategoryObject('typeBinding', u'MD_StandardOrderProcess_PropertyType', MD_StandardOrderProcess_PropertyType)


# Complex type DS_Series_PropertyType with content type ELEMENT_ONLY
class DS_Series_PropertyType (pyxb.binding.basis.complexTypeDefinition):
    _TypeDefinition = None
    _ContentTypeTag = pyxb.binding.basis.complexTypeDefinition._CT_ELEMENT_ONLY
    _Abstract = False
    _ExpandedName = pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Series_PropertyType')
    # Base type is pyxb.binding.datatypes.anyType
    
    # Element {http://www.isotc211.org/2005/gmd}DS_Series uses Python identifier DS_Series
    __DS_Series = pyxb.binding.content.ElementUse(pyxb.namespace.ExpandedName(_Namespace_gmd, u'DS_Series'), 'DS_Series', '__httpwww_isotc211_org2005gmd_DS_Series_PropertyType_httpwww_isotc211_org2005gmdDS_Series', False)

    
    DS_Series = property(__DS_Series.value, __DS_Series.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}type uses Python identifier type
    __type = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'type'), 'type', '__httpwww_isotc211_org2005gmd_DS_Series_PropertyType_httpwww_w3_org1999xlinktype', pyxb.binding.datatypes.string, fixed=True, unicode_default=u'simple')
    
    type = property(__type.value, __type.set, None, None)

    
    # Attribute {http://www.isotc211.org/2005/gco}nilReason uses Python identifier nilReason
    __nilReason = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_gco, u'nilReason'), 'nilReason', '__httpwww_isotc211_org2005gmd_DS_Series_PropertyType_httpwww_isotc211_org2005gconilReason', NilReasonType)
    
    nilReason = property(__nilReason.value, __nilReason.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}actuate uses Python identifier actuate
    __actuate = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'actuate'), 'actuate', '__httpwww_isotc211_org2005gmd_DS_Series_PropertyType_httpwww_w3_org1999xlinkactuate', pyxb.bundles.opengis.misc.xlinks.STD_ANON_1)
    
    actuate = property(__actuate.value, __actuate.set, None, u"\n        The 'actuate' attribute is used to communicate the desired timing \n        of traversal from the starting resource to the ending resource; \n        it's value should be treated as follows:\n        onLoad - traverse to the ending resource immediately on loading \n                 the starting resource \n        onRequest - traverse from the starting resource to the ending \n                    resource only on a post-loading event triggered for \n                    this purpose \n        other - behavior is unconstrained; examine other markup in link \n                for hints \n        none - behavior is unconstrained\n      ")

    
    # Attribute {http://www.w3.org/1999/xlink}title uses Python identifier title
    __title = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'title'), 'title', '__httpwww_isotc211_org2005gmd_DS_Series_PropertyType_httpwww_w3_org1999xlinktitle', pyxb.binding.datatypes.string)
    
    title = property(__title.value, __title.set, None, None)

    
    # Attribute uuidref uses Python identifier uuidref
    __uuidref = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(None, u'uuidref'), 'uuidref', '__httpwww_isotc211_org2005gmd_DS_Series_PropertyType_uuidref', pyxb.binding.datatypes.string)
    
    uuidref = property(__uuidref.value, __uuidref.set, None, None)

    
    # Attribute {http://www.w3.org/1999/xlink}show uses Python identifier show
    __show = pyxb.binding.content.AttributeUse(pyxb.namespace.ExpandedName(_Namespace_xlink, u'show'), 'show', '__httpwww_isotc211_org2005gmd_DS_Series_PropertyType_httpwww_w3_org1999xlinkshow', pyxb.bundles.opengis.misc.xlinks.STD_ANON_2)
    
    show = property(__show.value, __show.set, None, u"\n        The 'show' attribute is used to communicate the desired presentation 