/******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: lcubootVxWorks.c,v 1.2 2008/10/27 14:53:57 bjeram Exp $"
*
* who       when      what
* --------  --------  ----------------------------------------------
* bgustafs 2000-07-06 created
*/

/************************************************************************
*   NAME
*	lcubootNfsMount,
*	- Wrappers for VxWorks function for boot script
*
*   SYNOPSIS
*	int lcubootNfsMount(char *host, char *fileSystem, char *localName)
*
*   DESCRIPTION
*	These functions wraps VxWorks functions to support the boot script
*
*	The script is aborted when ancondition occurs, which
*	is signalled as a log message in the form:
*
*	<tid> (tShell): lcuboot: <message>: <faulty item>:<errno | faulty item>
*	<tid> (tShell): --- SCRIPT ABORTED ---
*
*	lcubootNfsMount - NFS mounts disks from the specified host.
*               See also nfsMount.
*               If the disk can't be mounted the shell script aborts.
*               In particular it can't mount the same disk twice.
*
*   FILES
*
*   ENVIRONMENT
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS 
*
*   EXAMPLES
*
*   SEE ALSO
*     hostAdd, nfsMount
*
*   BUGS   
* 
*------------------------------------------------------------------------
*/

#include "lcubootPrivate.h"
#include "nfsDrv.h"


int lcubootNfsMount(char *host, char *fileSystem, char *localName)

{
    char *locName = (localName == NULL) ? fileSystem : localName;
    
    if (nfsMount(host, fileSystem, locName) == ERROR)
	RETURN_ABORT("Can't NFS mount file system: ", fileSystem);


    return lcubootOK;
}


/*___oOo___*/
