/******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: lcubootFile.c,v 1.2 2008/10/27 14:53:57 bjeram Exp $"
*
* who        when       what
* ---------  ---------- ---------------------------------------------------
* S.Sandrock 30.09.1995 New
* bgustafs   18/07/97   adapted to Tornado
*/

/************************************************************************
*   NAME
*	lcubootFile,
*	lcubootFileOpen - find and open a file
* 
*   SYNOPSIS
*	int lcubootFileOpen(const char *searchPath,
*			    const char *fileName, 
*			    int openMode)
*
*   DESCRIPTION
*	Search for a file with a given search path and open it.
*
*	searchPath - colon-separated list of directories
*	fileName - relative filename
*	openMode - mode passed as second parameter to `open'
*
*   RETURN VALUES
*	a file-descriptor (> 0) if the file is found and opened
*	lcubootERROR if the file is not found or cannot be opened
*
*   ENVIRONMENT
*
*   EXAMPLE
*	fd = lcubootFileOpen(getenv("BINPATH"), "lcc", O_RDONLY);
*	if (fd < 0) ...
*	...
*	close(fd);
*
*   CAUTIONS
*	The returned file-descriptor should be closed after operation.
*
*   SEE ALSO
*	open(2), close(2)
*
*   BUGS   
* 
*------------------------------------------------------------------------
*/

static const char *rcsId="@(#) $Id: lcubootFile.c,v 1.2 2008/10/27 14:53:57 bjeram Exp $"; 

#include "lcubootPrivate.h"


int lcubootFileOpen(const char *searchPath,
		    const char *fileName, 
		    int openMode)
{
    char absName[256];
    const char *pathp1, *pathp2;
    int dirLen, fileLen;
    int fd = lcubootERROR;

    /*
     * Check params:
     */
    if (searchPath == NULL || fileName == NULL)
	return lcubootERROR;
    if ((fileLen = strlen(fileName)) >= (int)sizeof(absName))
	return lcubootERROR;

    /*
     * Search for the file in the search path and open it for reading:
     */
    pathp1 = searchPath;
    while (pathp1 != NULL)
	{
	while (*pathp1 == ':') pathp1++;	/* skip leading colons */
	pathp2 = strchr(pathp1, ':');		/* locate end by colon */
	dirLen = (pathp2 != NULL) ? (pathp2 - pathp1) : strlen(pathp1);
	if (dirLen + 1 + fileLen + 1 >= (int)sizeof(absName))
	    return lcubootERROR;		/* buffer overflow     */

	strncpy(absName, pathp1, dirLen);
	absName[dirLen] = '/';
	strncpy(absName + dirLen + 1, fileName, fileLen + 1);

	fd = open(absName, openMode, 0);
	if (fd >= 0)
	    {
	    printf("lcuboot: open \"%s\"\n", absName);
	    lcubootLogMsg("lcuboot: open \"%s\"\n", (int)absName,
			  0,0,0,0,0);
	    break;
	    }

	pathp1 = pathp2;
	}

    return fd;
}


/*___oOo___*/
