/******************************************************************************
* E.S.O. - VLT project
*
* "@(#) $Id: lcuboot.c,v 1.2 2008/10/27 14:53:57 bjeram Exp $"
*
* who        when       what
* ---------  ---------- ---------------------------------------------------
* S.Sandrock 23.04.1995 New
* bgustafs   18/07/97   adapted to Tornado
* mkiekebu   14/06/98   customized for PPC. Fixed for the new convention of 
*                       in the system-table
* bgustafs  2002-01-18  Added support for D16 and D32 addresses
*/

/************************************************************************
*   NAME
*	lcuboot - Automatic LCU Boot and Installation Facility
*
*   SYNOPSIS
*
*   DESCRIPTION
*	These functions support the automatic installation of LCU modules,
*	especially for drivers and devices. All functions are intended to be
*	used directly from the VxWorks shell in a boot-script.
*
*	The script is aborted when a fatal error condition occurs, which
*	is signalled as a log message in the form:
*
*	<tid> (tShell): lcuboot: <message>: <faulty item>:<errno | faulty item>
*	<tid> (tShell): --- SCRIPT ABORTED ---
*
*
*   VARIABLES
*
*   FILES
*
*   ENVIRONMENT
*	VLTROOT - path to the VLT root area
*	INTROOT - path to the integration root area (optional)
*
*	Both shell variables must be set before calling any of the functions
*	using for instance putenv("xxxROOT=/diskc/...").
*
*   COMMANDS
*
*   RETURN VALUES
*
*   CAUTIONS 
*	Most functions are not reentrant and should therefore only be used
*	from LCU boot-scripts, where reentrancy is not important!
*
*   EXAMPLES
*
*   SEE ALSO
*	lcubootAutoEnv(1), lcubootAutoGen(1), 
*	lcubootAutoDrv(1), lcubootAutoLcc(1), 
*	lcubootFile(1), lcubootVersion(1),
*	lcuboot(5),
*	loadLib(1), symLib(1),
*	ld(2)
*
*   BUGS   
* 
*------------------------------------------------------------------------
*/

static const char *rcsId="@(#) $Id: lcuboot.c,v 1.2 2008/10/27 14:53:57 bjeram Exp $"; 

#include "lcubootPrivate.h"

/*
 * PRIVATE FUNCTIONS:
 */


/************************************************************************
*   NAME
*	lcubootProbeAddress - find a function (local)
* 
*   SYNOPSIS
*	int lcubootProbeAddress(void * address)
* 
*   DESCRIPTION
*	Checks if an address is valid.
*
*   RETURN VALUES
*	lcubootOK if the address is valid
*	lcubootERROR if the address is invalid
*
*   CAUTIONS
*
*------------------------------------------------------------------------
*/
int lcubootProbeAddress(void * address)
{
    int probe;

    /* D8 memory address */
    if (vxMemProbe((char *)address, VX_READ, 1, (char *)&probe) == OK)
        {
        return(lcubootOK);
        }
    /* D16 memory address */
    else if (vxMemProbe((char *)address, VX_READ, 2, (char *)&probe) == OK)
        {
        return(lcubootOK);
        }
    /* D32 memory address */
    else if (vxMemProbe((char *)address, VX_READ, 4, (char *)&probe) == OK)
        {
        return(lcubootOK);
        }
    else
        {
        return(lcubootERROR);
        }
}


/*___oOo___*/
